/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.blocks;

import com.google.common.collect.Maps;
import com.superdextor.adinferos.config.NetherConfig;
import com.superdextor.adinferos.entity.NetherMob;
import com.superdextor.adinferos.entity.monster.EntitySummoner;
import com.superdextor.adinferos.init.NetherBlocks;
import com.superdextor.adinferos.init.NetherItems;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDarkFire
extends BlockFire {
    private final Map<Block, Integer> encouragements = Maps.newIdentityHashMap();
    private final Map<Block, Integer> flammabilities = Maps.newIdentityHashMap();

    public BlockDarkFire() {
        this.func_149663_c("dark_fire");
        this.func_149672_a(SoundType.field_185855_h);
    }

    public static void init() {
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_DOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_DOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_DOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_DOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PLANKS, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo((Block)NetherBlocks.DOUBLE_WOODEN_SLAB, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo((Block)NetherBlocks.WOODEN_SLAB, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.SOUL_TNT, 15, 100, true);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.LOG, 5, 5, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.LEAVES, 30, 60, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_STAIRS, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_STAIRS, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_STAIRS, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_STAIRS, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.SAPLING, 60, 100, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_FENCE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_FENCE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_FENCE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_FENCE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_FENCE_GATE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_FENCE_GATE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_FENCE_GATE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_FENCE_GATE, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_TRAPDOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_TRAPDOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_TRAPDOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_TRAPDOOR, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_TRAPDOOR_HIDDEN, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_TRAPDOOR_HIDDEN, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_TRAPDOOR_HIDDEN, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_TRAPDOOR_HIDDEN, 5, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.INFERNO_PRESSURE_PLATE, 60, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.MAGMA_PRESSURE_PLATE, 60, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.PHANTOM_PRESSURE_PLATE, 60, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.ASH_PRESSURE_PLATE, 60, 20, false);
        NetherBlocks.DARK_FIRE.setFireInfo(NetherBlocks.CRAFTING_TABLE, 5, 20, false);
    }

    @Deprecated
    public void func_180686_a(Block blockIn, int encouragement, int flammability) {
    }

    public void setFireInfo(Block blockIn, int encouragement, int flammability, boolean clasicBurnable) {
        if (blockIn == Blocks.field_150350_a) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        if (clasicBurnable) {
            super.func_180686_a(blockIn, encouragement, flammability);
        }
        this.encouragements.put(blockIn, encouragement);
        this.flammabilities.put(blockIn, flammability);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (!worldIn.field_72995_K) {
            NetherMob nethermob;
            boolean flag = true;
            if (entity instanceof NetherMob && (nethermob = (NetherMob)entity).isDarkfireResistant()) {
                flag = false;
            }
            if (flag) {
                if (entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 1));
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40, 0));
                }
                entity.func_70097_a(DamageSource.field_82727_n, 1.0f);
            }
        }
    }

    public boolean func_149703_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    pos.func_184134_a((double)((float)state.func_177958_n() + 0.5f), (double)((float)state.func_177956_o() + 0.5f), (double)((float)state.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                if (pos.func_180495_p(state.func_177977_b()).isSideSolid((IBlockAccess)pos, state.func_177977_b(), EnumFacing.UP) || NetherBlocks.DARK_FIRE.canCatchFire((IBlockAccess)pos, state.func_177977_b(), EnumFacing.UP)) break block11;
                if (NetherBlocks.DARK_FIRE.canCatchFire((IBlockAccess)pos, state.func_177976_e(), EnumFacing.EAST)) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)state.func_177958_n() + rand.nextDouble() * (double)0.1f;
                        double d8 = (double)state.func_177956_o() + rand.nextDouble();
                        double d13 = (double)state.func_177952_p() + rand.nextDouble();
                        pos.func_175688_a(EnumParticleTypes.SPELL_MOB, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (NetherBlocks.DARK_FIRE.canCatchFire((IBlockAccess)pos, state.func_177974_f(), EnumFacing.WEST)) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(state.func_177958_n() + 1) - rand.nextDouble() * (double)0.1f;
                        double d9 = (double)state.func_177956_o() + rand.nextDouble();
                        double d14 = (double)state.func_177952_p() + rand.nextDouble();
                        pos.func_175688_a(EnumParticleTypes.SPELL_MOB, d4, d9, d14, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (NetherBlocks.DARK_FIRE.canCatchFire((IBlockAccess)pos, state.func_177978_c(), EnumFacing.SOUTH)) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)state.func_177958_n() + rand.nextDouble();
                        double d10 = (double)state.func_177956_o() + rand.nextDouble();
                        double d15 = (double)state.func_177952_p() + rand.nextDouble() * (double)0.1f;
                        pos.func_175688_a(EnumParticleTypes.SPELL_MOB, d5, d10, d15, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (NetherBlocks.DARK_FIRE.canCatchFire((IBlockAccess)pos, state.func_177968_d(), EnumFacing.NORTH)) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)state.func_177958_n() + rand.nextDouble();
                        double d11 = (double)state.func_177956_o() + rand.nextDouble();
                        double d16 = (double)(state.func_177952_p() + 1) - rand.nextDouble() * (double)0.1f;
                        pos.func_175688_a(EnumParticleTypes.SPELL_MOB, d6, d11, d16, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (!NetherBlocks.DARK_FIRE.canCatchFire((IBlockAccess)pos, state.func_177984_a(), EnumFacing.DOWN)) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)state.func_177958_n() + rand.nextDouble();
                    double d12 = (double)(state.func_177956_o() + 1) - rand.nextDouble() * (double)0.1f;
                    double d17 = (double)state.func_177952_p() + rand.nextDouble();
                    pos.func_175688_a(EnumParticleTypes.SPELL_MOB, d7, d12, d17, 0.0, 0.0, 0.0, new int[0]);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)state.func_177958_n() + rand.nextDouble();
                double d1 = (double)state.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)state.func_177952_p() + rand.nextDouble();
                pos.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (NetherConfig.abyssPortalBuild && (world.field_73011_w.getDimension() != 0 && world.field_73011_w.getDimension() != NetherConfig.dimensionIdAbyss || !NetherBlocks.ABYSS_PORTAL.func_176548_d(world, pos)) && !world.func_180495_p(pos.func_177977_b()).func_185913_b()) {
            world.func_175698_g(pos);
        }
        if ((NetherConfig.buildSummoner && world.field_73011_w.getDimension() == -1 || world.field_73011_w.getDimension() == NetherConfig.dimensionIdAbyss) && world.func_180495_p(pos.func_177982_a(0, -1, 0)).func_177230_c() == NetherBlocks.WITHER_BLOCK && world.func_180495_p(pos.func_177982_a(1, -1, 0)).func_177230_c() == Blocks.field_150340_R && world.func_180495_p(pos.func_177982_a(-1, -1, 0)).func_177230_c() == Blocks.field_150340_R && world.func_180495_p(pos.func_177982_a(0, -1, 1)).func_177230_c() == Blocks.field_150340_R && world.func_180495_p(pos.func_177982_a(0, -1, -1)).func_177230_c() == Blocks.field_150340_R && world.func_180495_p(pos.func_177982_a(1, -1, 1)).func_177230_c() == Blocks.field_150343_Z && world.func_180495_p(pos.func_177982_a(-1, -1, 1)).func_177230_c() == Blocks.field_150343_Z && world.func_180495_p(pos.func_177982_a(-1, -1, -1)).func_177230_c() == Blocks.field_150343_Z && world.func_180495_p(pos.func_177982_a(1, -1, -1)).func_177230_c() == Blocks.field_150343_Z && world.func_180495_p(pos.func_177982_a(2, 0, 0)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(-2, 0, 0)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(0, 0, 2)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(0, 0, -2)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(2, 0, 1)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(2, 0, -1)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(-2, 0, 1)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(-2, 0, -1)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(1, 0, 2)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(-1, 0, 2)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(1, 0, -2)).func_177230_c() == Blocks.field_150480_ab && world.func_180495_p(pos.func_177982_a(-1, 0, -2)).func_177230_c() == Blocks.field_150480_ab) {
            if (!world.field_72995_K) {
                EntitySummoner entity = new EntitySummoner(world);
                entity.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 3, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)entity);
                entity.func_184185_a(SoundEvents.field_187853_gC, 3.0f, 0.5f);
            }
            world.func_175698_g(pos);
            world.func_175656_a(pos, NetherBlocks.CHISELED_OBSIDIAN.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, 1, 0), NetherBlocks.CHISELED_OBSIDIAN.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, -1, 0), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(1, -1, 0), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, -1, 0), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, -1, 1), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, -1, -1), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(1, -1, 1), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, -1, 1), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, -1, -1), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(1, -1, -1), NetherBlocks.SMOOTH_NETHERRACK.func_176223_P());
            world.func_175656_a(pos.func_177982_a(2, 0, 0), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-2, 0, 0), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, 0, 2), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(0, 0, -2), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(2, 0, 1), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(2, 0, -1), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-2, 0, 1), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-2, 0, -1), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(1, 0, 2), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, 0, 2), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(1, 0, -2), NetherBlocks.DARK_FIRE.func_176223_P());
            world.func_175656_a(pos.func_177982_a(-1, 0, -2), NetherBlocks.DARK_FIRE.func_176223_P());
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150899_d((int)Item.func_150891_b((Item)NetherItems.WITHER_DUST)));
    }

    public MapColor func_180659_g(IBlockState state) {
        return MapColor.field_151646_E;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_82736_K().func_82766_b("doFireTick")) {
            Block block;
            if (!this.func_176196_c(worldIn, pos)) {
                worldIn.func_175698_g(pos);
            }
            boolean flag = (block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c()).equals(NetherBlocks.DARKSTONE) || block.equals(NetherBlocks.DIMENSIONAL_ORE) || block.equals(NetherBlocks.WITHER_ORE) || block.equals(NetherBlocks.NETHERITE_ORE);
            int i = (Integer)state.func_177229_b((IProperty)field_176543_a);
            if (!flag && worldIn.func_72896_J() && this.func_176537_d(worldIn, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                worldIn.func_175698_g(pos);
            } else {
                if (i < 15) {
                    state = state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(i + rand.nextInt(3) / 2));
                    worldIn.func_180501_a(pos, state, 4);
                }
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
                if (!flag) {
                    if (!this.canNeighborCatchFire(worldIn, pos)) {
                        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || i > 3) {
                            worldIn.func_175698_g(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && i == 15 && rand.nextInt(4) == 0) {
                        worldIn.func_175698_g(pos);
                        return;
                    }
                }
                boolean flag1 = worldIn.func_180502_D(pos);
                int j = 0;
                if (flag1) {
                    j = -50;
                }
                this.tryCatchFire(worldIn, pos.func_177974_f(), 300 + j, rand, i, EnumFacing.WEST);
                this.tryCatchFire(worldIn, pos.func_177976_e(), 300 + j, rand, i, EnumFacing.EAST);
                this.tryCatchFire(worldIn, pos.func_177977_b(), 250 + j, rand, i, EnumFacing.UP);
                this.tryCatchFire(worldIn, pos.func_177984_a(), 250 + j, rand, i, EnumFacing.DOWN);
                this.tryCatchFire(worldIn, pos.func_177978_c(), 300 + j, rand, i, EnumFacing.SOUTH);
                this.tryCatchFire(worldIn, pos.func_177968_d(), 300 + j, rand, i, EnumFacing.NORTH);
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 4; ++i1) {
                            BlockPos blockpos;
                            int k1;
                            if (k == 0 && i1 == 0 && l == 0) continue;
                            int j1 = 100;
                            if (i1 > 1) {
                                j1 += (i1 - 1) * 100;
                            }
                            if ((k1 = this.getNeighborEncouragement(worldIn, blockpos = pos.func_177982_a(k, i1, l))) <= 0) continue;
                            int l1 = (k1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (i + 30);
                            if (flag1) {
                                l1 /= 2;
                            }
                            if (l1 <= 0 || rand.nextInt(j1) > l1 || worldIn.func_72896_J() && this.func_176537_d(worldIn, blockpos)) continue;
                            int i2 = i + rand.nextInt(5) / 4;
                            if (i2 > 15) {
                                i2 = 15;
                            }
                            worldIn.func_180501_a(blockpos, state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(i2)), 3);
                        }
                    }
                }
            }
        }
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = this.getFlammability((IBlockAccess)worldIn, worldIn.func_180495_p(pos), pos, face);
        if (random.nextInt(chance) < i) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !worldIn.func_175727_C(pos)) {
                int j = age + random.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(j)), 3);
            } else {
                worldIn.func_175698_g(pos);
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(this.getFlammability((IBlockAccess)worldIn, worldIn.func_180495_p(pos), pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    public boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getFlammability(world, world.func_180495_p(pos), pos, face) > 0;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() || this.canNeighborCatchFire(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !this.canNeighborCatchFire(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    public int func_149738_a(World worldIn) {
        return 15;
    }

    public int getFlammability(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        Integer integer = this.flammabilities.get(state.func_177230_c());
        return integer == null ? state.func_177230_c().getFlammability(world, pos, face) : integer.intValue();
    }

    public int getEncouragement(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        Integer integer = this.encouragements.get(state.func_177230_c());
        return integer == null ? state.func_177230_c().getFlammability(world, pos, face) : integer.intValue();
    }

    public int func_176532_c(Block blockIn) {
        Integer integer = this.flammabilities.get(blockIn);
        return integer == null ? 0 : integer;
    }

    @Deprecated
    public int func_176534_d(Block blockIn) {
        Integer integer = this.encouragements.get(blockIn);
        return integer == null ? 0 : integer;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }
}

