/*
 * Decompiled with CFR 0.152.
 */
package com.superdextor.adinferos.blocks;

import com.superdextor.adinferos.NetherDamageSource;
import com.superdextor.adinferos.enchantments.AdInferosEnchantments;
import com.superdextor.adinferos.entity.NetherMob;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCurse
extends BlockBreakable {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB CURSE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0825, 1.0);

    public BlockCurse(Material material) {
        super(material, false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.CONFUSION)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185855_h);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CURSE_AABB;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).func_185896_q()) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        ItemStack stack;
        boolean flag = true;
        if (entity instanceof NetherMob && ((NetherMob)entity).isCurseResistant()) {
            flag = false;
        }
        if (entity instanceof EntityLivingBase && (stack = EnchantmentHelper.func_92099_a((Enchantment)AdInferosEnchantments.curseProtection, (EntityLivingBase)((EntityLivingBase)entity))) != null && worldIn.field_73012_v.nextInt(1 + EnchantmentHelper.func_77506_a((Enchantment)AdInferosEnchantments.curseProtection, (ItemStack)stack)) > 1) {
            flag = false;
        }
        if (entity instanceof EntityItem || entity instanceof EntityXPOrb) {
            flag = false;
        }
        if (flag) {
            switch (state.func_177230_c().func_176201_c(state)) {
                case 1: {
                    entity.func_70015_d(4);
                    break;
                }
                case 2: {
                    if (!(entity instanceof EntityLivingBase)) break;
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 160, 0));
                    break;
                }
                case 3: {
                    if (!(entity instanceof EntityLivingBase)) break;
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 120, 0));
                    break;
                }
                default: {
                    if (!(entity instanceof EntityLivingBase)) break;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)entity;
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 120, 0));
                    entitylivingbase.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 120, 0));
                }
            }
            if (entity.field_70173_aa % 8 == 0) {
                entity.func_70097_a(NetherDamageSource.CURSE, 1.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        switch (state.func_177230_c().func_176201_c(state)) {
            case 1: {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + 0.1f;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 2: {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + 0.1f;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case 3: {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + 0.1f;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.1, 0.5, 0.0, new int[0]);
                break;
            }
            default: {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + 0.1f;
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, 0.5, 0.0, 1.0, new int[0]);
                break;
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        worldIn.func_175698_g(pos);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMapColor();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public static enum EnumType implements IStringSerializable
    {
        CONFUSION(0, "confusion", MapColor.field_151678_z),
        FIRE(1, "fire", MapColor.field_151656_f),
        WITHER(2, "wither", MapColor.field_151670_w),
        POISON(3, "poison", MapColor.field_151651_C);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor color;

        private EnumType(int metaIn, String nameIn, MapColor colorIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.color = colorIn;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public MapColor getMapColor() {
            return this.color;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockplanks$enumtype;
                EnumType.META_LOOKUP[blockplanks$enumtype.getMetadata()] = blockplanks$enumtype = enumTypeArray[i];
            }
        }
    }
}

