/*
 * Decompiled with CFR 0.152.
 */
package com.ebonheart.EbonArtsMod.common.world;

import com.ebonheart.EbonArtsMod.common.world.WorldGenSingleMinable;
import com.ebonheart.EbonArtsMod.configs.EbonArtsConfiguration;
import com.ebonheart.EbonArtsMod.init.InitBlocksEA;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGeneratorEA
implements IWorldGenerator {
    private WorldGenerator gen_draconium_ore = new WorldGenMinable(InitBlocksEA.draconium_ore.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator gen_velious_ore = new WorldGenMinable(InitBlocksEA.velious_ore.func_176223_P(), 6, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator gen_arcanite_ore = new WorldGenMinable(InitBlocksEA.arcanite_ore.func_176223_P(), 5, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator gen_katcheen_ore = new WorldGenMinable(InitBlocksEA.katcheen_ore.func_176223_P(), 4, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator gen_ebon_ore;
    private WorldGenerator gen_necrocite_ore = new WorldGenMinable(InitBlocksEA.necrocite_ore.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_soularite_ore = new WorldGenMinable(InitBlocksEA.soularite_ore.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_ebonheart_ore = new WorldGenMinable(InitBlocksEA.ebonheart_ore.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator gen_ebon_ore_nether;
    private WorldGenerator gen_ebon_ore_end;
    private WorldGenerator gen_necrocite_ore_end = new WorldGenMinable(InitBlocksEA.necrocite_ore_end.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator gen_soularite_ore_end = new WorldGenMinable(InitBlocksEA.soularite_ore_end.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    private WorldGenerator gen_ebonheart_ore_end = new WorldGenMinable(InitBlocksEA.ebonheart_ore_end.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));

    public WorldGeneratorEA() {
        this.gen_ebon_ore = new WorldGenSingleMinable(InitBlocksEA.ebon_ore.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.gen_ebon_ore_nether = new WorldGenSingleMinable(InitBlocksEA.ebon_ore_nether.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.gen_ebon_ore_end = new WorldGenSingleMinable(InitBlocksEA.ebon_ore_end.func_176223_P(), (Predicate<IBlockState>)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.runGenerator(this.gen_draconium_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.draconiumValueChunk, 32, 128);
                this.runGenerator(this.gen_velious_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.veliousValueChunk, 24, 128);
                this.runGenerator(this.gen_arcanite_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.arcaniteValueChunk, 5, 48);
                this.runGenerator(this.gen_katcheen_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.katcheenValueChunk, 5, 16);
                this.runGenerator(this.gen_ebon_ore, world, random, chunkX, chunkZ, 1, 5, 16);
                break;
            }
            case -1: {
                this.runGenerator(this.gen_necrocite_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.necrociteValueChunk, 15, 125);
                this.runGenerator(this.gen_soularite_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.soulariteValueChunk, 15, 125);
                this.runGenerator(this.gen_ebonheart_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.ebonheartValueChunk, 15, 125);
                this.runGenerator(this.gen_ebon_ore_nether, world, random, chunkX, chunkZ, 8, 15, 125);
                break;
            }
            case 1: {
                this.runGenerator(this.gen_necrocite_ore_end, world, random, chunkX, chunkZ, EbonArtsConfiguration.necrociteEndValueChunk, 5, 125);
                this.runGenerator(this.gen_soularite_ore_end, world, random, chunkX, chunkZ, EbonArtsConfiguration.soulariteEndValueChunk, 5, 125);
                this.runGenerator(this.gen_ebonheart_ore_end, world, random, chunkX, chunkZ, EbonArtsConfiguration.ebonheartEndValueChunk, 5, 125);
                this.runGenerator(this.gen_ebon_ore_end, world, random, chunkX, chunkZ, 8, 15, 125);
                break;
            }
            default: {
                this.runGenerator(this.gen_draconium_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.draconiumValueChunk, 32, 128);
                this.runGenerator(this.gen_velious_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.veliousValueChunk, 24, 128);
                this.runGenerator(this.gen_arcanite_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.arcaniteValueChunk, 5, 48);
                this.runGenerator(this.gen_katcheen_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.katcheenValueChunk, 5, 16);
                this.runGenerator(this.gen_necrocite_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.necrociteValueChunk, 15, 125);
                this.runGenerator(this.gen_soularite_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.soulariteValueChunk, 15, 125);
                this.runGenerator(this.gen_ebonheart_ore, world, random, chunkX, chunkZ, EbonArtsConfiguration.ebonheartValueChunk, 15, 125);
                this.runGenerator(this.gen_ebon_ore, world, random, chunkX, chunkZ, 1, 5, 16);
                this.runGenerator(this.gen_ebon_ore_nether, world, random, chunkX, chunkZ, 8, 15, 125);
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator, so says Viesis.");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

