/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.irishluck.util;

import com.mramericanmike.irishluck.configuration.ConfigValues;
import com.mramericanmike.irishluck.util.MAMBuilder;
import java.util.Calendar;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Stuff {
    public static Entity getRandomEntity(World world) {
        EntityBlaze entityX1;
        int rand = Stuff.randInt(0, 15);
        switch (rand) {
            case 0: {
                entityX1 = new EntityBlaze(world);
                break;
            }
            case 1: {
                entityX1 = new EntityCaveSpider(world);
                break;
            }
            case 2: {
                entityX1 = new EntityCreeper(world);
                break;
            }
            case 3: {
                entityX1 = new EntityEnderman(world);
                break;
            }
            case 4: {
                entityX1 = new EntityGhast(world);
                break;
            }
            case 5: {
                int doGolem = Stuff.randInt(1, 10);
                if (doGolem == 1) {
                    entityX1 = new EntityIronGolem(world);
                    break;
                }
                entityX1 = new EntityBlaze(world);
                break;
            }
            case 6: {
                entityX1 = new EntityPigZombie(world);
                break;
            }
            case 7: {
                entityX1 = new EntitySilverfish(world);
                break;
            }
            case 8: {
                entityX1 = new EntitySkeleton(world);
                break;
            }
            case 9: {
                entityX1 = new EntitySnowman(world);
                break;
            }
            case 10: {
                entityX1 = new EntitySpider(world);
                break;
            }
            case 11: {
                entityX1 = new EntityWitch(world);
                break;
            }
            case 12: {
                entityX1 = new EntityZombie(world);
                break;
            }
            case 13: {
                entityX1 = new EntityEndermite(world);
                break;
            }
            case 14: {
                entityX1 = new EntityGuardian(world);
                break;
            }
            case 15: {
                int doShulker = Stuff.randInt(1, 10);
                if (doShulker == 1) {
                    entityX1 = new EntityShulker(world);
                    break;
                }
                entityX1 = new EntityEndermite(world);
                break;
            }
            default: {
                entityX1 = new EntityBlaze(world);
            }
        }
        return entityX1;
    }

    public static boolean isHalloween() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        if (day == 31 && month == 10) {
            return true;
        }
        return day == 30 && month == 10 && ConfigValues.enableHalloweenOn30;
    }

    public static void placePlayer(EntityPlayer player, double playerX, double playerY, double playerZ) {
        player.func_70634_a(playerX + 0.5, playerY, playerZ + 0.5);
    }

    @Nullable
    public static <T> T getTileEntity(IBlockAccess world, BlockPos blockPos, Class<T> tClass) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        return (T)(!tClass.isInstance(tileEntity) ? null : tileEntity);
    }

    public static void makeSign(World world, BlockPos pos, ITextComponent[] signText, int facing, EntityPlayer player) {
        MAMBuilder.placeBlockCheckLucky(world, pos, Blocks.field_150472_an.func_176203_a(facing), player);
        TileEntitySign signEntity = new TileEntitySign();
        for (int a = 0; a < 4; ++a) {
            signEntity.field_145915_a[a] = signText[a];
        }
        world.func_175690_a(pos, (TileEntity)signEntity);
    }

    public static int getPlayerFacing(EntityPlayer player, int snap) {
        int yaw = (int)player.field_70177_z;
        snap = 360 / snap;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += snap / 2;
        int facing = (yaw %= 360) / snap;
        return facing;
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    public static void setEntityPosition(EntityLiving entity, double x, double y, double z) {
        double doubleX = Math.random() * 2.0 - 1.0;
        double doubleZ = Math.random() * 2.0 - 1.0;
        entity.func_70107_b(x + 0.5 + doubleX, y + 0.5, z + 0.5 + doubleZ);
    }

    public static void setEntityPos(Entity entity, double x, double y, double z) {
        double doubleX = Math.random() * 2.0 - 1.0;
        double doubleZ = Math.random() * 2.0 - 1.0;
        entity.func_70107_b(x + 0.5 + doubleX, y + 0.5, z + 0.5 + doubleZ);
    }

    public static IBlockState randomOre() {
        IBlockState returnBlock;
        int rand = (int)(Math.random() * 7.0);
        switch (rand) {
            case 0: {
                returnBlock = Blocks.field_150365_q.func_176223_P();
                break;
            }
            case 1: {
                returnBlock = Blocks.field_150366_p.func_176223_P();
                break;
            }
            case 2: {
                returnBlock = Blocks.field_150352_o.func_176223_P();
                break;
            }
            case 3: {
                returnBlock = Blocks.field_150369_x.func_176223_P();
                break;
            }
            case 4: {
                returnBlock = Blocks.field_150482_ag.func_176223_P();
                break;
            }
            case 5: {
                returnBlock = Blocks.field_150450_ax.func_176223_P();
                break;
            }
            case 6: {
                returnBlock = Blocks.field_150412_bA.func_176223_P();
                break;
            }
            default: {
                returnBlock = Blocks.field_150365_q.func_176223_P();
            }
        }
        return returnBlock;
    }

    public static IBlockState randomWool() {
        IBlockState returnBlock;
        int rand = (int)(Math.random() * 16.0);
        switch (rand) {
            case 0: {
                returnBlock = Blocks.field_150325_L.func_176203_a(0);
                break;
            }
            case 1: {
                returnBlock = Blocks.field_150325_L.func_176203_a(1);
                break;
            }
            case 2: {
                returnBlock = Blocks.field_150325_L.func_176203_a(2);
                break;
            }
            case 3: {
                returnBlock = Blocks.field_150325_L.func_176203_a(3);
                break;
            }
            case 4: {
                returnBlock = Blocks.field_150325_L.func_176203_a(4);
                break;
            }
            case 5: {
                returnBlock = Blocks.field_150325_L.func_176203_a(5);
                break;
            }
            case 6: {
                returnBlock = Blocks.field_150325_L.func_176203_a(6);
                break;
            }
            case 7: {
                returnBlock = Blocks.field_150325_L.func_176203_a(7);
                break;
            }
            case 8: {
                returnBlock = Blocks.field_150325_L.func_176203_a(8);
                break;
            }
            case 9: {
                returnBlock = Blocks.field_150325_L.func_176203_a(9);
                break;
            }
            case 10: {
                returnBlock = Blocks.field_150325_L.func_176203_a(10);
                break;
            }
            case 11: {
                returnBlock = Blocks.field_150325_L.func_176203_a(11);
                break;
            }
            case 12: {
                returnBlock = Blocks.field_150325_L.func_176203_a(12);
                break;
            }
            case 13: {
                returnBlock = Blocks.field_150325_L.func_176203_a(13);
                break;
            }
            case 14: {
                returnBlock = Blocks.field_150325_L.func_176203_a(14);
                break;
            }
            case 15: {
                returnBlock = Blocks.field_150325_L.func_176203_a(15);
                break;
            }
            default: {
                returnBlock = Blocks.field_150325_L.func_176203_a(0);
            }
        }
        return returnBlock;
    }

    public static IBlockState randomClay() {
        int rand = (int)(Math.random() * 16.0);
        return Blocks.field_150406_ce.func_176203_a(rand);
    }

    public static IBlockState randomGlass() {
        int rand = (int)(Math.random() * 16.0);
        return Blocks.field_150399_cn.func_176203_a(rand);
    }

    public static IBlockState randomBlock() {
        IBlockState returnBlock;
        int rand = (int)(Math.random() * 31.0);
        switch (rand) {
            case 0: {
                returnBlock = Blocks.field_150346_d.func_176223_P();
                break;
            }
            case 1: {
                returnBlock = Blocks.field_150402_ci.func_176223_P();
                break;
            }
            case 2: {
                returnBlock = Blocks.field_150365_q.func_176223_P();
                break;
            }
            case 3: {
                returnBlock = Blocks.field_150366_p.func_176223_P();
                break;
            }
            case 4: {
                returnBlock = Blocks.field_150339_S.func_176223_P();
                break;
            }
            case 5: {
                returnBlock = Blocks.field_150352_o.func_176223_P();
                break;
            }
            case 6: {
                returnBlock = Blocks.field_150340_R.func_176223_P();
                break;
            }
            case 7: {
                returnBlock = Blocks.field_150482_ag.func_176223_P();
                break;
            }
            case 8: {
                returnBlock = Blocks.field_150484_ah.func_176223_P();
                break;
            }
            case 9: {
                returnBlock = Blocks.field_150412_bA.func_176223_P();
                break;
            }
            case 10: {
                returnBlock = Blocks.field_150475_bE.func_176223_P();
                break;
            }
            case 11: {
                returnBlock = Blocks.field_150450_ax.func_176223_P();
                break;
            }
            case 12: {
                returnBlock = Blocks.field_150451_bX.func_176223_P();
                break;
            }
            case 13: {
                returnBlock = Blocks.field_150369_x.func_176223_P();
                break;
            }
            case 14: {
                returnBlock = Blocks.field_150368_y.func_176223_P();
                break;
            }
            case 15: {
                returnBlock = Blocks.field_150379_bu.func_176223_P();
                break;
            }
            case 16: {
                returnBlock = Blocks.field_150420_aW.func_176223_P();
                break;
            }
            case 17: {
                returnBlock = Blocks.field_150419_aX.func_176223_P();
                break;
            }
            case 18: {
                returnBlock = Blocks.field_150344_f.func_176203_a(0);
                break;
            }
            case 19: {
                returnBlock = Blocks.field_150344_f.func_176203_a(1);
                break;
            }
            case 20: {
                returnBlock = Blocks.field_150344_f.func_176203_a(2);
                break;
            }
            case 21: {
                returnBlock = Blocks.field_150344_f.func_176203_a(3);
                break;
            }
            case 22: {
                returnBlock = Blocks.field_150344_f.func_176203_a(4);
                break;
            }
            case 23: {
                returnBlock = Blocks.field_150344_f.func_176203_a(5);
                break;
            }
            case 24: {
                returnBlock = Blocks.field_150424_aL.func_176223_P();
                break;
            }
            case 25: {
                returnBlock = Blocks.field_150343_Z.func_176223_P();
                break;
            }
            case 26: {
                returnBlock = Blocks.field_180397_cI.func_176223_P();
                break;
            }
            case 27: {
                returnBlock = Blocks.field_185772_cY.func_176223_P();
                break;
            }
            case 28: {
                returnBlock = Blocks.field_150407_cf.func_176223_P();
                break;
            }
            case 29: {
                returnBlock = Blocks.field_180398_cJ.func_176223_P();
                break;
            }
            case 30: {
                returnBlock = Blocks.field_150426_aN.func_176223_P();
                break;
            }
            default: {
                returnBlock = Blocks.field_150347_e.func_176223_P();
            }
        }
        return returnBlock;
    }

    public static EnumDyeColor randomEnumDyeColor() {
        int random = Stuff.randInt(0, 15);
        switch (random) {
            case 0: {
                return EnumDyeColor.BLACK;
            }
            case 1: {
                return EnumDyeColor.BLUE;
            }
            case 2: {
                return EnumDyeColor.BROWN;
            }
            case 3: {
                return EnumDyeColor.CYAN;
            }
            case 4: {
                return EnumDyeColor.GRAY;
            }
            case 5: {
                return EnumDyeColor.GREEN;
            }
            case 6: {
                return EnumDyeColor.LIGHT_BLUE;
            }
            case 7: {
                return EnumDyeColor.LIME;
            }
            case 8: {
                return EnumDyeColor.MAGENTA;
            }
            case 9: {
                return EnumDyeColor.ORANGE;
            }
            case 10: {
                return EnumDyeColor.PINK;
            }
            case 11: {
                return EnumDyeColor.PURPLE;
            }
            case 12: {
                return EnumDyeColor.RED;
            }
            case 13: {
                return EnumDyeColor.SILVER;
            }
            case 14: {
                return EnumDyeColor.WHITE;
            }
            case 15: {
                return EnumDyeColor.YELLOW;
            }
        }
        return EnumDyeColor.WHITE;
    }

    public static int randomRabbitType() {
        int random = Stuff.randInt(0, 36);
        if (random >= 0 && random <= 4) {
            return 0;
        }
        if (random >= 5 && random <= 9) {
            return 1;
        }
        if (random >= 10 && random <= 14) {
            return 2;
        }
        if (random >= 15 && random <= 19) {
            return 3;
        }
        if (random >= 20 && random <= 24) {
            return 4;
        }
        if (random >= 25 && random <= 29) {
            return 5;
        }
        if (random >= 30 && random <= 34) {
            return 6;
        }
        return 99;
    }

    public static IBlockState randomTriItem() {
        IBlockState returnBlock;
        int rand = (int)(Math.random() * 48.0);
        switch (rand) {
            case 0: {
                returnBlock = Blocks.field_150325_L.func_176203_a(0);
                break;
            }
            case 1: {
                returnBlock = Blocks.field_150325_L.func_176203_a(1);
                break;
            }
            case 2: {
                returnBlock = Blocks.field_150325_L.func_176203_a(2);
                break;
            }
            case 3: {
                returnBlock = Blocks.field_150325_L.func_176203_a(3);
                break;
            }
            case 4: {
                returnBlock = Blocks.field_150325_L.func_176203_a(4);
                break;
            }
            case 5: {
                returnBlock = Blocks.field_150325_L.func_176203_a(5);
                break;
            }
            case 6: {
                returnBlock = Blocks.field_150325_L.func_176203_a(6);
                break;
            }
            case 7: {
                returnBlock = Blocks.field_150325_L.func_176203_a(7);
                break;
            }
            case 8: {
                returnBlock = Blocks.field_150325_L.func_176203_a(8);
                break;
            }
            case 9: {
                returnBlock = Blocks.field_150325_L.func_176203_a(9);
                break;
            }
            case 10: {
                returnBlock = Blocks.field_150325_L.func_176203_a(10);
                break;
            }
            case 11: {
                returnBlock = Blocks.field_150325_L.func_176203_a(11);
                break;
            }
            case 12: {
                returnBlock = Blocks.field_150325_L.func_176203_a(12);
                break;
            }
            case 13: {
                returnBlock = Blocks.field_150325_L.func_176203_a(13);
                break;
            }
            case 14: {
                returnBlock = Blocks.field_150325_L.func_176203_a(14);
                break;
            }
            case 15: {
                returnBlock = Blocks.field_150325_L.func_176203_a(15);
                break;
            }
            case 16: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(0);
                break;
            }
            case 17: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(1);
                break;
            }
            case 18: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(2);
                break;
            }
            case 19: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(3);
                break;
            }
            case 20: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(4);
                break;
            }
            case 21: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(5);
                break;
            }
            case 22: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(6);
                break;
            }
            case 23: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(7);
                break;
            }
            case 24: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(8);
                break;
            }
            case 25: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(9);
                break;
            }
            case 26: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(10);
                break;
            }
            case 27: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(11);
                break;
            }
            case 28: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(12);
                break;
            }
            case 29: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(13);
                break;
            }
            case 30: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(14);
                break;
            }
            case 31: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(15);
                break;
            }
            case 32: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(0);
                break;
            }
            case 33: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(1);
                break;
            }
            case 34: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(2);
                break;
            }
            case 35: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(3);
                break;
            }
            case 36: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(4);
                break;
            }
            case 37: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(5);
                break;
            }
            case 38: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(6);
                break;
            }
            case 39: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(7);
                break;
            }
            case 40: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(8);
                break;
            }
            case 41: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(9);
                break;
            }
            case 42: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(10);
                break;
            }
            case 43: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(11);
                break;
            }
            case 44: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(12);
                break;
            }
            case 45: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(13);
                break;
            }
            case 46: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(14);
                break;
            }
            case 47: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(15);
                break;
            }
            default: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(15);
            }
        }
        return returnBlock;
    }

    public static IBlockState randomBlockForWorldChanger() {
        IBlockState returnBlock;
        int rand = (int)(Math.random() * 96.0);
        switch (rand) {
            case 0: {
                returnBlock = Blocks.field_150346_d.func_176223_P();
                break;
            }
            case 1: {
                returnBlock = Blocks.field_150402_ci.func_176223_P();
                break;
            }
            case 2: {
                returnBlock = Blocks.field_150365_q.func_176223_P();
                break;
            }
            case 3: {
                returnBlock = Blocks.field_150366_p.func_176223_P();
                break;
            }
            case 4: {
                returnBlock = Blocks.field_150339_S.func_176223_P();
                break;
            }
            case 5: {
                returnBlock = Blocks.field_150352_o.func_176223_P();
                break;
            }
            case 6: {
                returnBlock = Blocks.field_150340_R.func_176223_P();
                break;
            }
            case 7: {
                returnBlock = Blocks.field_150482_ag.func_176223_P();
                break;
            }
            case 8: {
                returnBlock = Blocks.field_150484_ah.func_176223_P();
                break;
            }
            case 9: {
                returnBlock = Blocks.field_150412_bA.func_176223_P();
                break;
            }
            case 10: {
                returnBlock = Blocks.field_150475_bE.func_176223_P();
                break;
            }
            case 11: {
                returnBlock = Blocks.field_150450_ax.func_176223_P();
                break;
            }
            case 12: {
                returnBlock = Blocks.field_150451_bX.func_176223_P();
                break;
            }
            case 13: {
                returnBlock = Blocks.field_150369_x.func_176223_P();
                break;
            }
            case 14: {
                returnBlock = Blocks.field_150368_y.func_176223_P();
                break;
            }
            case 15: {
                returnBlock = Blocks.field_150379_bu.func_176223_P();
                break;
            }
            case 16: {
                returnBlock = Blocks.field_150420_aW.func_176223_P();
                break;
            }
            case 17: {
                returnBlock = Blocks.field_150419_aX.func_176223_P();
                break;
            }
            case 18: {
                returnBlock = Blocks.field_150344_f.func_176203_a(0);
                break;
            }
            case 19: {
                returnBlock = Blocks.field_150344_f.func_176203_a(1);
                break;
            }
            case 20: {
                returnBlock = Blocks.field_150344_f.func_176203_a(2);
                break;
            }
            case 21: {
                returnBlock = Blocks.field_150344_f.func_176203_a(3);
                break;
            }
            case 22: {
                returnBlock = Blocks.field_150344_f.func_176203_a(4);
                break;
            }
            case 23: {
                returnBlock = Blocks.field_150344_f.func_176203_a(5);
                break;
            }
            case 24: {
                returnBlock = Blocks.field_150424_aL.func_176223_P();
                break;
            }
            case 25: {
                returnBlock = Blocks.field_150343_Z.func_176223_P();
                break;
            }
            case 26: {
                returnBlock = Blocks.field_180397_cI.func_176223_P();
                break;
            }
            case 27: {
                returnBlock = Blocks.field_185772_cY.func_176223_P();
                break;
            }
            case 28: {
                returnBlock = Blocks.field_150407_cf.func_176223_P();
                break;
            }
            case 29: {
                returnBlock = Blocks.field_180398_cJ.func_176223_P();
                break;
            }
            case 30: {
                returnBlock = Blocks.field_150426_aN.func_176223_P();
                break;
            }
            case 31: {
                returnBlock = Blocks.field_150325_L.func_176203_a(0);
                break;
            }
            case 32: {
                returnBlock = Blocks.field_150325_L.func_176203_a(1);
                break;
            }
            case 33: {
                returnBlock = Blocks.field_150325_L.func_176203_a(2);
                break;
            }
            case 34: {
                returnBlock = Blocks.field_150325_L.func_176203_a(3);
                break;
            }
            case 35: {
                returnBlock = Blocks.field_150325_L.func_176203_a(4);
                break;
            }
            case 36: {
                returnBlock = Blocks.field_150325_L.func_176203_a(5);
                break;
            }
            case 37: {
                returnBlock = Blocks.field_150325_L.func_176203_a(6);
                break;
            }
            case 38: {
                returnBlock = Blocks.field_150325_L.func_176203_a(7);
                break;
            }
            case 39: {
                returnBlock = Blocks.field_150325_L.func_176203_a(8);
                break;
            }
            case 40: {
                returnBlock = Blocks.field_150325_L.func_176203_a(9);
                break;
            }
            case 41: {
                returnBlock = Blocks.field_150325_L.func_176203_a(10);
                break;
            }
            case 42: {
                returnBlock = Blocks.field_150325_L.func_176203_a(11);
                break;
            }
            case 43: {
                returnBlock = Blocks.field_150325_L.func_176203_a(12);
                break;
            }
            case 44: {
                returnBlock = Blocks.field_150325_L.func_176203_a(13);
                break;
            }
            case 45: {
                returnBlock = Blocks.field_150325_L.func_176203_a(14);
                break;
            }
            case 46: {
                returnBlock = Blocks.field_150325_L.func_176203_a(15);
                break;
            }
            case 47: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(0);
                break;
            }
            case 48: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(1);
                break;
            }
            case 49: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(2);
                break;
            }
            case 50: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(3);
                break;
            }
            case 51: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(4);
                break;
            }
            case 52: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(5);
                break;
            }
            case 53: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(6);
                break;
            }
            case 54: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(7);
                break;
            }
            case 55: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(8);
                break;
            }
            case 56: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(9);
                break;
            }
            case 57: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(10);
                break;
            }
            case 58: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(11);
                break;
            }
            case 59: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(12);
                break;
            }
            case 60: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(13);
                break;
            }
            case 61: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(14);
                break;
            }
            case 62: {
                returnBlock = Blocks.field_150406_ce.func_176203_a(15);
                break;
            }
            case 63: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(0);
                break;
            }
            case 64: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(1);
                break;
            }
            case 65: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(2);
                break;
            }
            case 66: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(3);
                break;
            }
            case 67: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(4);
                break;
            }
            case 68: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(5);
                break;
            }
            case 69: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(6);
                break;
            }
            case 70: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(7);
                break;
            }
            case 71: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(8);
                break;
            }
            case 72: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(9);
                break;
            }
            case 73: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(10);
                break;
            }
            case 74: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(11);
                break;
            }
            case 75: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(12);
                break;
            }
            case 76: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(13);
                break;
            }
            case 77: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(14);
                break;
            }
            case 78: {
                returnBlock = Blocks.field_150399_cn.func_176203_a(15);
                break;
            }
            case 79: {
                returnBlock = Blocks.field_150397_co.func_176203_a(0);
                break;
            }
            case 80: {
                returnBlock = Blocks.field_150397_co.func_176203_a(1);
                break;
            }
            case 81: {
                returnBlock = Blocks.field_150397_co.func_176203_a(2);
                break;
            }
            case 82: {
                returnBlock = Blocks.field_150397_co.func_176203_a(3);
                break;
            }
            case 83: {
                returnBlock = Blocks.field_150397_co.func_176203_a(4);
                break;
            }
            case 84: {
                returnBlock = Blocks.field_150397_co.func_176203_a(5);
                break;
            }
            case 85: {
                returnBlock = Blocks.field_150397_co.func_176203_a(6);
                break;
            }
            case 86: {
                returnBlock = Blocks.field_150397_co.func_176203_a(7);
                break;
            }
            case 87: {
                returnBlock = Blocks.field_150397_co.func_176203_a(8);
                break;
            }
            case 88: {
                returnBlock = Blocks.field_150397_co.func_176203_a(9);
                break;
            }
            case 89: {
                returnBlock = Blocks.field_150397_co.func_176203_a(10);
                break;
            }
            case 90: {
                returnBlock = Blocks.field_150397_co.func_176203_a(11);
                break;
            }
            case 91: {
                returnBlock = Blocks.field_150397_co.func_176203_a(12);
                break;
            }
            case 92: {
                returnBlock = Blocks.field_150397_co.func_176203_a(13);
                break;
            }
            case 93: {
                returnBlock = Blocks.field_150397_co.func_176203_a(14);
                break;
            }
            case 94: {
                returnBlock = Blocks.field_150397_co.func_176203_a(15);
                break;
            }
            case 95: {
                returnBlock = Blocks.field_150335_W.func_176223_P();
                break;
            }
            default: {
                returnBlock = Blocks.field_150347_e.func_176223_P();
            }
        }
        return returnBlock;
    }

    public static IBlockState lavaOrWater() {
        IBlockState returnBlock;
        int rand = (int)(Math.random() * 2.0);
        switch (rand) {
            case 0: {
                returnBlock = Blocks.field_150356_k.func_176223_P();
                break;
            }
            case 1: {
                returnBlock = Blocks.field_150358_i.func_176223_P();
                break;
            }
            default: {
                returnBlock = Blocks.field_150358_i.func_176223_P();
            }
        }
        return returnBlock;
    }

    public static BlockPos getRandomBlockPosWithYToSky(BlockPos origin, World world) {
        BlockPos newBlockPos = null;
        boolean isAir = true;
        int offsetOneX = Stuff.randInt(-75, 75);
        int offsetOneZ = Stuff.randInt(-75, 75);
        newBlockPos = new BlockPos(origin.func_177958_n() + offsetOneX, 0, origin.func_177952_p() + offsetOneZ);
        for (int i = 255; i >= 1; --i) {
            if (!isAir) continue;
            newBlockPos = new BlockPos(newBlockPos.func_177958_n(), i, newBlockPos.func_177952_p());
            isAir = world.func_175623_d(newBlockPos);
        }
        return newBlockPos.func_177982_a(0, 1, 0);
    }

    public static IBlockState randomSapling() {
        IBlockState returnBlock;
        int rand = Stuff.randInt(1, 6);
        switch (rand) {
            case 1: {
                returnBlock = Blocks.field_150345_g.func_176203_a(0);
                break;
            }
            case 2: {
                returnBlock = Blocks.field_150345_g.func_176203_a(1);
                break;
            }
            case 3: {
                returnBlock = Blocks.field_150345_g.func_176203_a(2);
                break;
            }
            case 4: {
                returnBlock = Blocks.field_150345_g.func_176203_a(3);
                break;
            }
            case 5: {
                returnBlock = Blocks.field_150345_g.func_176203_a(4);
                break;
            }
            case 6: {
                returnBlock = Blocks.field_150345_g.func_176203_a(5);
                break;
            }
            default: {
                returnBlock = Blocks.field_150345_g.func_176203_a(0);
            }
        }
        return returnBlock;
    }
}

