/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.irishluck.util;

import com.google.common.collect.Sets;
import com.mramericanmike.irishluck.init.ModBlocks;
import com.mramericanmike.irishluck.util.CheckLucky;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MAMBuilder {
    private static final Set<Block> SAFE_DELETE = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150432_aD, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_150322_A, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_150458_ak, Blocks.field_150349_c, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_150433_aE, Blocks.field_150431_aC, Blocks.field_150425_aM, Blocks.field_185774_da});

    public static void placeBlockCheckLucky(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        MAMBuilder.deleteOrDestroy(world, pos, player);
        Block checkBlock = world.func_180495_p(pos).func_177230_c();
        float hardness1 = checkBlock.func_176195_g(world.func_180495_p(pos), world, pos);
        if (!(checkBlock.equals(Blocks.field_150357_h) || hardness1 <= -0.001f || hardness1 >= 100.001f)) {
            CheckLucky.init(world, player, pos);
            world.func_180501_a(pos, state, 11);
        }
    }

    public static void placeBlockCheckLuckyNoPlayer(World world, BlockPos pos, IBlockState state) {
        MAMBuilder.deleteOrDestroyNoPlayer(world, pos);
        Block checkBlock = world.func_180495_p(pos).func_177230_c();
        float hardness1 = checkBlock.func_176195_g(world.func_180495_p(pos), world, pos);
        if (!(checkBlock.equals(Blocks.field_150357_h) || hardness1 <= -0.001f || hardness1 >= 100.001f)) {
            CheckLucky.noPlayer(world, pos);
            world.func_180501_a(pos, state, 11);
        }
    }

    public static void placeBlock(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state, 11);
    }

    public static void destroyBlock(World world, BlockPos pos, IBlockState state) {
        world.func_175655_b(pos, true);
        world.func_180501_a(pos, state, 11);
    }

    public static void cleanAreaFromBlock(World world, EntityPlayer player, BlockPos pos, int width, int large, int height, int offset) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < large; ++j) {
                for (int k = 0; k < height; ++k) {
                    double doubleX = pos.func_177958_n() + width / 2 - i;
                    double doubleY = pos.func_177956_o() + offset + k;
                    double doubleZ = pos.func_177952_p() + large / 2 - j;
                    int posX = pos.func_177958_n() + width / 2 - i;
                    int posY = pos.func_177956_o() + offset + k;
                    int posZ = pos.func_177952_p() + large / 2 - j;
                    MAMBuilder.deleteOrDestroy(world, pos.func_177982_a(width / 2 - i, offset + k, large / 2 - j), player);
                }
            }
        }
    }

    public static void cleanAreaFromBlockBis(World world, BlockPos pos, int width, int large, int height, int offset) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < large; ++j) {
                for (int k = 0; k < height; ++k) {
                    double doubleX = pos.func_177958_n() + width / 2 - i;
                    double doubleY = pos.func_177956_o() + offset + k;
                    double doubleZ = pos.func_177952_p() + large / 2 - j;
                    int posX = pos.func_177958_n() + width / 2 - i;
                    int posY = pos.func_177956_o() + offset + k;
                    int posZ = pos.func_177952_p() + large / 2 - j;
                    MAMBuilder.deleteOrDestroyNoPlayer(world, pos.func_177982_a(width / 2 - i, offset + k, large / 2 - j));
                }
            }
        }
    }

    public static void cleanAreaFromPlayer(World world, EntityPlayer player, BlockPos checkPos, int width, int large, int height, int offset) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < large; ++j) {
                for (int k = 0; k < height; ++k) {
                    double doubleX = checkPos.func_177958_n() + width / 2 - i;
                    double doubleY = checkPos.func_177956_o() + offset + k;
                    double doubleZ = checkPos.func_177952_p() + large / 2 - j;
                    int posX = checkPos.func_177958_n() + width / 2 - i;
                    int posY = checkPos.func_177956_o() + offset + k;
                    int posZ = checkPos.func_177952_p() + large / 2 - j;
                    MAMBuilder.deleteOrDestroy(world, checkPos.func_177982_a(width / 2 - i, offset + k, large / 2 - j), player);
                }
            }
        }
    }

    public static void fillAreaFromBlock(World world, EntityPlayer player, BlockPos checkPos, int width, int large, int height, int offset, IBlockState blockState) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < large; ++j) {
                for (int k = 0; k < height; ++k) {
                    double doubleX = checkPos.func_177958_n() + width / 2 - i;
                    double doubleY = checkPos.func_177956_o() + offset + k;
                    double doubleZ = checkPos.func_177952_p() + large / 2 - j;
                    int posX = checkPos.func_177958_n() + width / 2 - i;
                    int posY = checkPos.func_177956_o() + offset + k;
                    int posZ = checkPos.func_177952_p() + large / 2 - j;
                    MAMBuilder.deleteOrDestroy(world, checkPos.func_177982_a(width / 2 - i, offset + k, large / 2 - j), player);
                    MAMBuilder.placeBlockCheckLucky(world, checkPos.func_177982_a(width / 2 - i, offset + k, large / 2 - j), blockState, player);
                }
            }
        }
    }

    public static boolean deleteOrDestroy(World world, BlockPos checkPos, EntityPlayer player) {
        Block checkBlock = world.func_180495_p(checkPos).func_177230_c();
        float hardness1 = checkBlock.func_176195_g(world.func_180495_p(checkPos), world, checkPos);
        if (checkBlock.equals(Blocks.field_150357_h) || hardness1 <= -0.001f || hardness1 >= 100.001f) {
            return false;
        }
        if (SAFE_DELETE.contains(checkBlock)) {
            MAMBuilder.placeBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (checkBlock.equals(ModBlocks.block_irishluck)) {
            ItemStack dropX = new ItemStack(ModBlocks.block_irishluck, 1, 0);
            EntityItem itemDropX = new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, dropX);
            world.func_72838_d((Entity)itemDropX);
            MAMBuilder.placeBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (checkBlock.equals(ModBlocks.block_irishluck_halloween)) {
            ItemStack dropX = new ItemStack(ModBlocks.block_irishluck_halloween, 1, 0);
            EntityItem itemDropX = new EntityItem(world, player.field_70165_t + 0.5, player.field_70163_u + 0.5, player.field_70161_v + 0.5, dropX);
            world.func_72838_d((Entity)itemDropX);
            MAMBuilder.placeBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        MAMBuilder.destroyBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
        return true;
    }

    public static boolean deleteOrDestroyNoPlayer(World world, BlockPos checkPos) {
        Block checkBlock = world.func_180495_p(checkPos).func_177230_c();
        float hardness1 = checkBlock.func_176195_g(world.func_180495_p(checkPos), world, checkPos);
        if (checkBlock.equals(Blocks.field_150357_h) || hardness1 <= -0.001f || hardness1 >= 100.001f) {
            return false;
        }
        if (SAFE_DELETE.contains(checkBlock)) {
            MAMBuilder.placeBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (checkBlock.equals(ModBlocks.block_irishluck)) {
            ItemStack dropX = new ItemStack(ModBlocks.block_irishluck, 1, 0);
            EntityItem itemDropX = new EntityItem(world, (double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o() + 0.5, (double)checkPos.func_177952_p() + 0.5, dropX);
            world.func_72838_d((Entity)itemDropX);
            MAMBuilder.placeBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        if (checkBlock.equals(ModBlocks.block_irishluck_halloween)) {
            ItemStack dropX = new ItemStack(ModBlocks.block_irishluck_halloween, 1, 0);
            EntityItem itemDropX = new EntityItem(world, (double)checkPos.func_177958_n() + 0.5, (double)checkPos.func_177956_o() + 0.5, (double)checkPos.func_177952_p() + 0.5, dropX);
            world.func_72838_d((Entity)itemDropX);
            MAMBuilder.placeBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
            return true;
        }
        MAMBuilder.destroyBlock(world, checkPos, Blocks.field_150350_a.func_176223_P());
        return true;
    }
}

