/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.irishluck.configuration;

import com.mramericanmike.irishluck.configuration.ConfigValues;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static final String CATEGORY_GENERAL = "general";

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    public static void loadConfiguration() {
        ConfigValues.debugMode = configuration.getBoolean("debugMode", CATEGORY_GENERAL, ConfigValues.debugMode, "Sets Debug Mode (Show messages on console)");
        ConfigValues.infoMode = configuration.getBoolean("infoMode", CATEGORY_GENERAL, ConfigValues.infoMode, "Sets Info Mode (Show messages on console)");
        ConfigValues.rainBlock = configuration.getBoolean("rainBlock", CATEGORY_GENERAL, ConfigValues.rainBlock, "Allow rain to be triggered by Irish Luck Blocks");
        ConfigValues.cleanAreaForMobs = configuration.getBoolean("cleanAreaForMobs", CATEGORY_GENERAL, ConfigValues.cleanAreaForMobs, "Clear the area around the block when spawning mobs. To prevent cheaters trying to suffocate them");
        ConfigValues.removeFiveInOne = configuration.getBoolean("removeFiveInOne", CATEGORY_GENERAL, ConfigValues.removeFiveInOne, "Removes the 5 in 1 Output (JonBams asked for this)");
        ConfigValues.spawnBlocksAsChestLoots = configuration.getBoolean("spawnBlocksAsChestLoots", CATEGORY_GENERAL, ConfigValues.spawnBlocksAsChestLoots, "Spawn Irish Blocks as ChestLoots");
        ConfigValues.chancesOfBlock404 = configuration.getInt("chancesOfBlock404", CATEGORY_GENERAL, ConfigValues.chancesOfBlock404, 10, 100, "1 in X Chances of a placed block becoming a 404 Block Not Found [enableBlock404 must be true for this to do anything]");
        ConfigValues.enableBlock404 = configuration.getBoolean("enableBlock404", CATEGORY_GENERAL, ConfigValues.enableBlock404, "Enables the 404 Block Not Found Blocks");
        ConfigValues.enableIrishDragon = configuration.getBoolean("enableIrishDragon", CATEGORY_GENERAL, ConfigValues.enableIrishDragon, "Enables the Irish Dragon as an outcome");
        ConfigValues.enableHalloweenOn30 = configuration.getBoolean("enableHalloweenOn30", CATEGORY_GENERAL, ConfigValues.enableHalloweenOn30, "Enables Halloween blocks to happen on day 30 also");
        ConfigValues.enableJonBamsFeatures = configuration.getBoolean("enableJonBamsFeatures", CATEGORY_GENERAL, ConfigValues.enableJonBamsFeatures, "Enables some outcomes related to JonBams (Twitch Streamer)");
        ConfigValues.irishDragonEggSounds = configuration.getBoolean("irishDragonEggSounds", CATEGORY_GENERAL, ConfigValues.irishDragonEggSounds, "Enables troll sounds on the Irish Dragon Egg");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("irishluck")) {
            ConfigurationHandler.loadConfiguration();
        }
    }
}

