/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.irishluck.blocks;

import com.mramericanmike.irishluck.configuration.ConfigValues;
import com.mramericanmike.irishluck.sounds.ModSounds;
import com.mramericanmike.irishluck.util.Stuff;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIrishDragon
extends Block {
    protected static final AxisAlignedBB DRAGON_EGG_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockIrishDragon(String name) {
        super(Material.field_151566_D, MapColor.field_151651_C);
        this.func_149663_c("irishluck:" + name);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DRAGON_EGG_AABB;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int chance;
        this.checkFall(worldIn, pos);
        if (!worldIn.field_72995_K && (chance = Stuff.randInt(0, 50)) == 1) {
            this.doSound(worldIn, pos);
        }
    }

    private void doSound(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            if (ConfigValues.enableJonBamsFeatures) {
                int sound = Stuff.randInt(1, 21);
                switch (sound) {
                    case 1: {
                        worldIn.func_184133_a(null, pos, ModSounds.ASEREJE, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 2: {
                        worldIn.func_184133_a(null, pos, ModSounds.AXELF, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 3: {
                        worldIn.func_184133_a(null, pos, ModSounds.BOOTYSWING, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 4: {
                        worldIn.func_184133_a(null, pos, ModSounds.BRAINPOWER, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 5: {
                        worldIn.func_184133_a(null, pos, ModSounds.DISKOPARTIZANI, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 6: {
                        worldIn.func_184133_a(null, pos, ModSounds.GANGNAMSTYLE, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 7: {
                        worldIn.func_184133_a(null, pos, ModSounds.HAPPY, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 8: {
                        worldIn.func_184133_a(null, pos, ModSounds.HERO, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 9: {
                        worldIn.func_184133_a(null, pos, ModSounds.INFORMER, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 10: {
                        worldIn.func_184133_a(null, pos, ModSounds.LOITUMA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 11: {
                        worldIn.func_184133_a(null, pos, ModSounds.MACARENA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 12: {
                        worldIn.func_184133_a(null, pos, ModSounds.MAHALAGEASCA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 13: {
                        worldIn.func_184133_a(null, pos, ModSounds.MAMBOITALIANO, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 14: {
                        worldIn.func_184133_a(null, pos, ModSounds.PFUDOR, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 15: {
                        worldIn.func_184133_a(null, pos, ModSounds.PORUNACABEZA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 16: {
                        worldIn.func_184133_a(null, pos, ModSounds.PUTTINONTHERITZ, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 17: {
                        worldIn.func_184133_a(null, pos, ModSounds.RICKROLLED, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 18: {
                        worldIn.func_184133_a(null, pos, ModSounds.SCATMAN, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 19: {
                        worldIn.func_184133_a(null, pos, ModSounds.THEDUCKSONG, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 20: {
                        worldIn.func_184133_a(null, pos, ModSounds.TROLOLO, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 21: {
                        worldIn.func_184133_a(null, pos, ModSounds.MANDALIZLOVESBUTTERSTICKS, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    default: {
                        worldIn.func_184133_a(null, pos, ModSounds.ASEREJE, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                }
            } else {
                int sound = Stuff.randInt(1, 20);
                switch (sound) {
                    case 1: {
                        worldIn.func_184133_a(null, pos, ModSounds.ASEREJE, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 2: {
                        worldIn.func_184133_a(null, pos, ModSounds.AXELF, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 3: {
                        worldIn.func_184133_a(null, pos, ModSounds.BOOTYSWING, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 4: {
                        worldIn.func_184133_a(null, pos, ModSounds.BRAINPOWER, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 5: {
                        worldIn.func_184133_a(null, pos, ModSounds.DISKOPARTIZANI, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 6: {
                        worldIn.func_184133_a(null, pos, ModSounds.GANGNAMSTYLE, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 7: {
                        worldIn.func_184133_a(null, pos, ModSounds.HAPPY, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 8: {
                        worldIn.func_184133_a(null, pos, ModSounds.HERO, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 9: {
                        worldIn.func_184133_a(null, pos, ModSounds.INFORMER, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 10: {
                        worldIn.func_184133_a(null, pos, ModSounds.LOITUMA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 11: {
                        worldIn.func_184133_a(null, pos, ModSounds.MACARENA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 12: {
                        worldIn.func_184133_a(null, pos, ModSounds.MAHALAGEASCA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 13: {
                        worldIn.func_184133_a(null, pos, ModSounds.MAMBOITALIANO, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 14: {
                        worldIn.func_184133_a(null, pos, ModSounds.PFUDOR, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 15: {
                        worldIn.func_184133_a(null, pos, ModSounds.PORUNACABEZA, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 16: {
                        worldIn.func_184133_a(null, pos, ModSounds.PUTTINONTHERITZ, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 17: {
                        worldIn.func_184133_a(null, pos, ModSounds.RICKROLLED, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 18: {
                        worldIn.func_184133_a(null, pos, ModSounds.SCATMAN, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 19: {
                        worldIn.func_184133_a(null, pos, ModSounds.THEDUCKSONG, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    case 20: {
                        worldIn.func_184133_a(null, pos, ModSounds.TROLOLO, SoundCategory.MASTER, 0.5f, 1.0f);
                        break;
                    }
                    default: {
                        worldIn.func_184133_a(null, pos, ModSounds.ASEREJE, SoundCategory.MASTER, 0.5f, 1.0f);
                    }
                }
            }
        }
    }

    private void checkFall(World worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos.func_177977_b()) && BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                worldIn.func_72838_d((Entity)new EntityFallingBlock(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), this.func_176223_P()));
            } else {
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos;
                while (worldIn.func_175623_d(blockpos) && BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos)) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_180501_a(blockpos, this.func_176223_P(), 2);
                }
            }
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.teleport(worldIn, pos);
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        Item holding = playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
        if (holding == Items.field_151055_y) {
            this.doSound(worldIn, pos);
            return;
        }
        if (holding == Item.func_150898_a((Block)Blocks.field_150429_aA)) {
            if (!worldIn.field_72995_K) {
                boolean flag = worldIn.func_82736_K().func_82766_b("mobGriefing");
                worldIn.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 9.0f, flag);
            }
            return;
        }
    }

    private void teleport(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this) {
            for (int i = 0; i < 1000; ++i) {
                BlockPos blockpos = pos.func_177982_a(worldIn.field_73012_v.nextInt(16) - worldIn.field_73012_v.nextInt(16), worldIn.field_73012_v.nextInt(8) - worldIn.field_73012_v.nextInt(8), worldIn.field_73012_v.nextInt(16) - worldIn.field_73012_v.nextInt(16));
                if (worldIn.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a) continue;
                if (worldIn.field_72995_K) {
                    for (int j = 0; j < 128; ++j) {
                        double d0 = worldIn.field_73012_v.nextDouble();
                        float f = (worldIn.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                        float f1 = (worldIn.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                        float f2 = (worldIn.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                        double d1 = (double)blockpos.func_177958_n() + (double)(pos.func_177958_n() - blockpos.func_177958_n()) * d0 + (worldIn.field_73012_v.nextDouble() - 0.5) + 0.5;
                        double d2 = (double)blockpos.func_177956_o() + (double)(pos.func_177956_o() - blockpos.func_177956_o()) * d0 + worldIn.field_73012_v.nextDouble() - 0.5;
                        double d3 = (double)blockpos.func_177952_p() + (double)(pos.func_177952_p() - blockpos.func_177952_p()) * d0 + (worldIn.field_73012_v.nextDouble() - 0.5) + 0.5;
                        worldIn.func_175688_a(EnumParticleTypes.PORTAL, d1, d2, d3, (double)f, (double)f1, (double)f2, new int[0]);
                    }
                } else {
                    worldIn.func_180501_a(blockpos, iblockstate, 2);
                    worldIn.func_175698_g(pos);
                }
                return;
            }
        }
    }

    public int func_149738_a(World worldIn) {
        return 5;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }
}

