/*
 * Decompiled with CFR 0.152.
 */
package com.mramericanmike.irishluck;

import com.mramericanmike.irishluck.configuration.ConfigValues;
import com.mramericanmike.irishluck.configuration.ConfigurationHandler;
import com.mramericanmike.irishluck.events.BlockError404Handler;
import com.mramericanmike.irishluck.init.ModBlocks;
import com.mramericanmike.irishluck.init.ModEntities;
import com.mramericanmike.irishluck.init.ModItems;
import com.mramericanmike.irishluck.init.Recipes;
import com.mramericanmike.irishluck.proxy.IProxy;
import com.mramericanmike.irishluck.sounds.ModSounds;
import com.mramericanmike.irishluck.util.ChestLoot;
import com.mramericanmike.irishluck.util.FileChecker;
import com.mramericanmike.irishluck.util.ReferenceFileChecker;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="irishluck", name="IrishLuck", version="0.3.5", guiFactory="com.mramericanmike.irishluck.client.gui.ModGuiFactory", acceptedMinecraftVersions="1.11")
public class IrishLuck {
    @Mod.Instance(value="irishluck")
    public static IrishLuck instance;
    @SidedProxy(clientSide="com.mramericanmike.irishluck.proxy.ClientProxy", serverSide="com.mramericanmike.irishluck.proxy.ServerProxy")
    public static IProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (ConfigValues.spawnBlocksAsChestLoots) {
            MinecraftForge.EVENT_BUS.register((Object)new ChestLoot());
        }
        try {
            FileChecker.CheckForDirectories();
            FileChecker.CheckForFileRiding();
            FileChecker.CheckForFileMobsGroups();
            FileChecker.CheckForFileEnchantedItems();
            FileChecker.CheckForFileEnchantedBlocks();
            ReferenceFileChecker.CheckForFileReadMe();
            ReferenceFileChecker.CheckForFilePassiveMobs();
            ReferenceFileChecker.CheckForFileAggressiveMobs();
            ReferenceFileChecker.CheckForFileEnchantments();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "IrishLuck.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new ConfigurationHandler());
        ModItems.init();
        ModBlocks.init();
        Recipes.init();
        ModEntities.init();
        ModSounds.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRender();
        if (ConfigValues.enableBlock404) {
            MinecraftForge.EVENT_BUS.register((Object)new BlockError404Handler());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }
}

