/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenSnow;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.biome.BiomeGenCorrodedSteppe;
import tragicneko.tragicmc.worldgen.biome.BiomeGenFrozenTundra;
import tragicneko.tragicmc.worldgen.biome.BiomeGenScorchedWasteland;
import tragicneko.tragicmc.worldgen.schematic.SchematicDesertTower;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class StructureTower
extends Structure {
    public StructureTower(int id, String name) {
        super(new SchematicDesertTower(), id, name);
    }

    @Override
    public int getVariantSize() {
        return 5;
    }

    @Override
    public boolean isSurfaceStructure() {
        return true;
    }

    @Override
    public boolean isValidDimension(int dim) {
        return dim != -1 && dim != TragicConfig.synapseID;
    }

    @Override
    public boolean areCoordsValidForGeneration(World world, int x, int y, int z, Random rand) {
        return super.areCoordsValidForGeneration(world, x, y, z, rand) && this.getRarity(200) && rand.nextInt(4) == 0;
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        return this.generateStructureWithVariant(this.getVariantFromBiome(world.func_72807_a(x, z)), world, rand, x, y, z);
    }

    @Override
    public boolean generateStructureWithVariant(int variant, World world, Random rand, int x, int y, int z) {
        if (!super.generateStructureWithVariant(variant, world, rand, x, y, z)) {
            return false;
        }
        return this.schematic.generateStructure(variant, world, rand, x, y, z);
    }

    public int getVariantFromBiome(BiomeGenBase biome) {
        if (biome instanceof BiomeGenMesa) {
            return 1;
        }
        if (biome instanceof BiomeGenDesert) {
            return 0;
        }
        if (biome instanceof BiomeGenHell || biome instanceof BiomeGenScorchedWasteland || biome instanceof BiomeGenCorrodedSteppe) {
            return 3;
        }
        if (biome == BiomeGenBase.field_150584_S || biome == BiomeGenBase.field_150579_T || biome == BiomeGenBase.field_150577_O || biome instanceof BiomeGenSnow || biome instanceof BiomeGenFrozenTundra) {
            return 4;
        }
        return 2;
    }

    @Override
    public int getStructureColor() {
        return 12838809;
    }
}

