/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.structure;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.StructureApisTemple;
import tragicneko.tragicmc.worldgen.structure.StructureCelestialTemple;
import tragicneko.tragicmc.worldgen.structure.StructureClaymationRuin;
import tragicneko.tragicmc.worldgen.structure.StructureCorruptedSpire;
import tragicneko.tragicmc.worldgen.structure.StructureCubeMaze;
import tragicneko.tragicmc.worldgen.structure.StructureDarkHut;
import tragicneko.tragicmc.worldgen.structure.StructureDeathCircle;
import tragicneko.tragicmc.worldgen.structure.StructureEmpariahCave;
import tragicneko.tragicmc.worldgen.structure.StructureHackerNet;
import tragicneko.tragicmc.worldgen.structure.StructureKitsuneDen;
import tragicneko.tragicmc.worldgen.structure.StructureLightSpire;
import tragicneko.tragicmc.worldgen.structure.StructureMemoryCache;
import tragicneko.tragicmc.worldgen.structure.StructureObsidianCavern;
import tragicneko.tragicmc.worldgen.structure.StructureOutlook;
import tragicneko.tragicmc.worldgen.structure.StructureSoulTomb;
import tragicneko.tragicmc.worldgen.structure.StructureSpiderNest;
import tragicneko.tragicmc.worldgen.structure.StructureTimeAltar;
import tragicneko.tragicmc.worldgen.structure.StructureTower;

public class Structure
extends WorldGenerator {
    protected final Schematic schematic;
    public final int structureId;
    private final String structureName;
    protected final int height;
    public static Structure[] structureList = new Structure[24];
    public static Structure apisTemple = new StructureApisTemple(0, "apisTemple");
    public static Structure towerStructure = new StructureTower(1, "tower");
    public static Structure deathCircle = new StructureDeathCircle(2, "deathCircle");
    public static Structure obsidianCavern = new StructureObsidianCavern(3, "obsidianCavern");
    public static Structure kitsuneDen = new StructureKitsuneDen(4, "kitsuneDen");
    public static Structure celestialTemple = new StructureCelestialTemple(5, "celestialTemple");
    public static Structure timeAltar = new StructureTimeAltar(6, "timeAltar");
    public static Structure soulTomb = new StructureSoulTomb(7, "soulTomb");
    public static Structure corruptedSpire = new StructureCorruptedSpire(8, "corruptedSpire");
    public static Structure empariahCave = new StructureEmpariahCave(9, "empariahCave");
    public static Structure claymationRuin = new StructureClaymationRuin(10, "claymationRuin");
    public static Structure darkHut = new StructureDarkHut(11, "darkHut");
    public static Structure spiderNest = new StructureSpiderNest(12, "spiderNest");
    public static Structure memoryCache = new StructureMemoryCache(13, "memoryCache");
    public static Structure lightSpire = new StructureLightSpire(14, "lightSpire");
    public static Structure hackerNet = new StructureHackerNet(15, "hackerNet");
    public static Structure cubeMaze = new StructureCubeMaze(16, "cubeMaze");
    public static Structure outlook = new StructureOutlook(17, "outlook");
    public static final Set validBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150329_H, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150398_cm, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150348_b, Blocks.field_150354_m, Blocks.field_150350_a, Blocks.field_150424_aL, TragicBlocks.Quicksand, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150405_ch, TragicBlocks.DarkStone, TragicBlocks.DarkSand, TragicBlocks.DeadDirt, Blocks.field_150362_t, Blocks.field_150403_cj, TragicBlocks.AshenGrass, TragicBlocks.BrushedGrass, TragicBlocks.AshenLeaves, TragicBlocks.AshenTallGrass, TragicBlocks.DeadBush, TragicBlocks.AshenBush, TragicBlocks.BleachedLeaves, TragicBlocks.PaintedLeaves, TragicBlocks.Glowvine, TragicBlocks.DriedGrass, TragicBlocks.PaintedTallGrass, TragicBlocks.StarlitGrass, TragicBlocks.StarlitTallGrass, TragicBlocks.StarCrystal, TragicBlocks.ErodedStone, TragicBlocks.DarkCobblestone, TragicBlocks.HallowedGrass, TragicBlocks.HallowedLeaves, TragicBlocks.HallowedLeafTrim, TragicBlocks.MoltenRock, TragicBlocks.ScorchedRock, TragicBlocks.StructureSeed, TragicBlocks.Luminescence, TragicBlocks.ExplosiveGas, TragicBlocks.RadiatedGas, TragicBlocks.CorruptedGas, TragicBlocks.WitheringGas, TragicBlocks.WickedVine, TragicBlocks.Permafrost, TragicBlocks.IcedDirt, TragicBlocks.IceSpike, TragicBlocks.IceSpikeHanging, TragicBlocks.Light, TragicBlocks.FragileLight, TragicBlocks.FragileLightInvis, TragicBlocks.Crystal, TragicBlocks.DarkGrass, TragicBlocks.Lichen, TragicBlocks.Moss, TragicBlocks.TragicFlower, TragicBlocks.TragicFlower2});

    public Structure(Schematic sch, int id, String s) {
        this.schematic = sch;
        if (structureList[id] != null) {
            throw new IllegalArgumentException("There is a structure using that ID (" + id + ") already!");
        }
        Structure.structureList[id] = this;
        this.structureId = id;
        this.height = sch.structureHeight;
        this.structureName = s;
    }

    public int getVariantSize() {
        return 1;
    }

    public boolean isSurfaceStructure() {
        return false;
    }

    public boolean isValidDimension(int dim) {
        return true;
    }

    public boolean areCoordsValidForGeneration(World world, int x, int y, int z, Random rand) {
        if (!validBlocks.contains(world.func_147439_a(x, y, z)) || y + this.height >= world.field_73011_w.getActualHeight()) {
            return false;
        }
        if (this.isSurfaceStructure()) {
            if (!(y > 50 && World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z) && world.func_147439_a(x, y - 1, z).func_149662_c() && world.func_72937_j(x, y, z))) {
                return false;
            }
            for (int y1 = 0; y1 < this.height; ++y1) {
                if (validBlocks.contains(world.func_147439_a(x, y + y1 + 1, z))) continue;
                return false;
            }
        } else {
            for (int y1 = 0; y1 < this.height; ++y1) {
                if (validBlocks.contains(world.func_147439_a(x, y - y1, z)) && validBlocks.contains(world.func_147439_a(x - y1, y, z)) && validBlocks.contains(world.func_147439_a(x + y1, y, z)) && validBlocks.contains(world.func_147439_a(x, y, z + y1)) && validBlocks.contains(world.func_147439_a(x, y, z - y1))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canGenerate() {
        return TragicConfig.structureAllow[this.structureId];
    }

    public boolean getRarity(int compare) {
        return TragicMC.rand.nextInt(compare) <= TragicConfig.structureRarity[this.structureId];
    }

    public int getHeight() {
        return this.height;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        return this.generateStructureWithVariant(rand.nextInt(this.getVariantSize()), world, rand, x, y, z);
    }

    public boolean generateStructureWithVariant(int variant, World world, Random rand, int x, int y, int z) {
        return !world.field_72995_K && this.canGenerate();
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("tile.tragicmc.structureSeed." + this.structureName + ".name"));
    }

    public String getUnlocalizedName() {
        return this.structureName;
    }

    public int getStructureColor() {
        return 0;
    }
}

