/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.schematic.SchematicDesertTower;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicObsidianCavern
extends Schematic {
    private static Block obs = Blocks.field_150343_Z;
    private static Block bedrock = Blocks.field_150357_h;
    private static Block ladder = Blocks.field_150468_ap;
    private static Block summon = TragicBlocks.SummonBlock;
    private static Block chest = Blocks.field_150486_ae;
    private static Block glowstone = Blocks.field_150426_aN;
    private static Block spawner = Blocks.field_150474_ac;

    public SchematicObsidianCavern() {
        super(8, 12, 12);
    }

    @Override
    public boolean generateStructure(int variant, World world, Random rand, int x, int y, int z) {
        int variant2 = rand.nextInt(10);
        this.generateTube(world, rand, x, y, z);
        this.generateCavernOfferings(variant2, world, rand, x, y, z);
        this.generateCaveOpening(variant, world, rand, x, y, z);
        return true;
    }

    public void generateTube(World world, Random rand, int x, int y, int z) {
        int x1;
        int wuh;
        int wah;
        int who;
        int wuh2;
        int wah2;
        int starty = y;
        y = 0;
        for (wah2 = 0; wah2 < 19; ++wah2) {
            for (wuh2 = 0; wuh2 < 19; ++wuh2) {
                world.func_147449_b(x + wah2 - 9, y, z + wuh2 - 9, bedrock);
            }
        }
        y = 1;
        for (who = 0; who < 7; ++who) {
            for (wah = 0; wah < 19; ++wah) {
                for (wuh = 0; wuh < 19; ++wuh) {
                    world.func_147468_f(x + wah - 9, y + who, z + wuh - 9);
                }
            }
            for (x1 = 0; x1 < 19; ++x1) {
                world.func_147449_b(x + x1 - 9, y + who, z - 9, bedrock);
                world.func_147449_b(x - 9, y + who, z + x1 - 9, bedrock);
                world.func_147449_b(x + 18 - 9, y + who, z + x1 - 9, bedrock);
                world.func_147449_b(x + x1 - 9, y + who, z + 18 - 9, bedrock);
            }
        }
        y = 7;
        for (who = 0; who < 5; ++who) {
            for (wah = 0; wah < 11; ++wah) {
                for (wuh = 0; wuh < 11; ++wuh) {
                    world.func_147468_f(x + wah - 5, y + who, z + wuh - 5);
                }
            }
            for (x1 = 0; x1 < 13; ++x1) {
                world.func_147449_b(x + x1 - 6, y + who, z - 6, bedrock);
                world.func_147449_b(x - 6, y + who, z + x1 - 6, bedrock);
                world.func_147449_b(x + 12 - 6, y + who, z + x1 - 6, bedrock);
                world.func_147449_b(x + x1 - 6, y + who, z + 12 - 6, bedrock);
            }
            for (x1 = 0; x1 < 15; ++x1) {
                world.func_147449_b(x + x1 - 7, y + who, z - 7, bedrock);
                world.func_147449_b(x - 7, y + who, z + x1 - 7, bedrock);
                world.func_147449_b(x + 14 - 7, y + who, z + x1 - 7, bedrock);
                world.func_147449_b(x + x1 - 7, y + who, z + 14 - 7, bedrock);
            }
            for (x1 = 0; x1 < 17; ++x1) {
                world.func_147449_b(x + x1 - 8, y + who, z - 8, bedrock);
                world.func_147449_b(x - 8, y + who, z + x1 - 8, bedrock);
                world.func_147449_b(x + 16 - 8, y + who, z + x1 - 8, bedrock);
                world.func_147449_b(x + x1 - 8, y + who, z + 16 - 8, bedrock);
            }
        }
        y = 12;
        for (who = 0; who < 2; ++who) {
            for (wah = 0; wah < 7; ++wah) {
                for (wuh = 0; wuh < 7; ++wuh) {
                    world.func_147468_f(x + wah - 3, y + who, z + wuh - 3);
                }
            }
            for (x1 = 0; x1 < 9; ++x1) {
                world.func_147449_b(x + x1 - 4, y + who, z - 4, bedrock);
                world.func_147449_b(x - 4, y + who, z + x1 - 4, bedrock);
                world.func_147449_b(x + 8 - 4, y + who, z + x1 - 4, bedrock);
                world.func_147449_b(x + x1 - 4, y + who, z + 8 - 4, bedrock);
            }
            for (x1 = 0; x1 < 11; ++x1) {
                world.func_147449_b(x + x1 - 5, y + who, z - 5, bedrock);
                world.func_147449_b(x - 5, y + who, z + x1 - 5, bedrock);
                world.func_147449_b(x + 10 - 5, y + who, z + x1 - 5, bedrock);
                world.func_147449_b(x + x1 - 5, y + who, z + 10 - 5, bedrock);
            }
        }
        y = 13;
        for (wah2 = 0; wah2 < 5; ++wah2) {
            for (wuh2 = 0; wuh2 < 7; ++wuh2) {
                world.func_147468_f(x + wah2 - 2, y, z + wuh2 - 2);
            }
        }
        for (int x12 = 0; x12 < 7; ++x12) {
            world.func_147449_b(x + x12 - 3, y, z - 3, bedrock);
            world.func_147449_b(x - 3, y, z + x12 - 3, bedrock);
            world.func_147449_b(x + 6 - 3, y, z + x12 - 3, bedrock);
            world.func_147449_b(x + x12 - 3, y, z + 6 - 3, bedrock);
        }
        y = 14;
        for (who = 0; who < 2; ++who) {
            for (wah = 0; wah < 3; ++wah) {
                for (wuh = 0; wuh < 3; ++wuh) {
                    world.func_147468_f(x + wah - 1, y + who, z + wuh - 1);
                }
            }
            for (x1 = 0; x1 < 5; ++x1) {
                world.func_147449_b(x + x1 - 2, y + who, z - 2, bedrock);
                world.func_147449_b(x - 2, y + who, z + x1 - 2, bedrock);
                world.func_147449_b(x + 4 - 2, y + who, z + x1 - 2, bedrock);
                world.func_147449_b(x + x1 - 2, y + who, z + 4 - 2, bedrock);
            }
        }
        y = 16;
        who = 0;
        while (y + who <= starty) {
            for (wah = 0; wah < 3; ++wah) {
                for (wuh = 0; wuh < 3; ++wuh) {
                    world.func_147468_f(x + wah - 1, y + who, z + wuh - 1);
                }
            }
            for (x1 = 0; x1 < 3; ++x1) {
                if ((y + who) % 12 == 0 && y + who != starty) {
                    world.func_147449_b(x + x1 - 1, y + who, z - 1, glowstone);
                    world.func_147449_b(x - 1, y + who, z + x1 - 1, glowstone);
                    world.func_147449_b(x + 2 - 1, y + who, z + x1 - 1, glowstone);
                    world.func_147449_b(x + x1 - 1, y + who, z + 2 - 1, glowstone);
                    continue;
                }
                world.func_147449_b(x + x1 - 1, y + who, z - 1, obs);
                world.func_147449_b(x - 1, y + who, z + x1 - 1, obs);
                world.func_147449_b(x + 2 - 1, y + who, z + x1 - 1, obs);
                world.func_147449_b(x + x1 - 1, y + who, z + 2 - 1, obs);
            }
            ++who;
        }
        int i = 0;
        while (y + i <= starty) {
            world.func_147465_d(x, y + i, z, ladder, 3, 2);
            ++i;
        }
        world.func_147449_b(x + 8, 6, z + 8, glowstone);
        world.func_147449_b(x + 8, 6, z - 8, glowstone);
        world.func_147449_b(x - 8, 6, z + 8, glowstone);
        world.func_147449_b(x - 8, 6, z - 8, glowstone);
        world.func_147449_b(x + 5, 11, z + 5, glowstone);
        world.func_147449_b(x + 5, 11, z - 5, glowstone);
        world.func_147449_b(x - 5, 11, z + 5, glowstone);
        world.func_147449_b(x - 5, 11, z - 5, glowstone);
    }

    public void generateCaveOpening(int variant, World world, Random rand, int x, int y, int z) {
        Set set = Structure.validBlocks;
        Block luxury = SchematicDesertTower.luxuryBlocks[rand.nextInt(SchematicDesertTower.luxuryBlocks.length)];
        int meta = 0;
        if (luxury == TragicBlocks.CompactOre) {
            meta = rand.nextInt(5);
        }
        switch (variant) {
            case 0: {
                int y1;
                for (y1 = 0; y1 < 4; ++y1) {
                    for (int x1 = -1; x1 < 2; ++x1) {
                        for (int z1 = -1; z1 < 2; ++z1) {
                            world.func_147449_b(x + x1, y + y1, z + z1, obs);
                        }
                    }
                }
                for (y1 = 1; y1 < 3; ++y1) {
                    world.func_147468_f(x + 1, y + y1, z);
                    world.func_147468_f(x - 1, y + y1, z);
                    world.func_147468_f(x, y + y1, z + 1);
                    world.func_147468_f(x, y + y1, z - 1);
                    world.func_147468_f(x, y + y1, z);
                }
                for (int x1 = -1; x1 < 2; ++x1) {
                    world.func_147449_b(x + x1, y + 4, z, obs);
                    world.func_147449_b(x, y + 4, z + x1, obs);
                    world.func_147449_b(x + 2, y, z + x1, obs);
                    world.func_147449_b(x - 2, y, z + x1, obs);
                    world.func_147449_b(x + x1, y, z - 2, obs);
                    world.func_147449_b(x + x1, y, z + 2, obs);
                }
                world.func_147465_d(x, y + 4, z, luxury, meta, 2);
                world.func_147449_b(x, y + 5, z, obs);
                world.func_147449_b(x, y + 6, z, obs);
                break;
            }
            case 1: {
                int x1;
                int y1;
                for (y1 = 0; y1 < 8; ++y1) {
                    for (x1 = -1; x1 < 1; ++x1) {
                        for (int z1 = -1; z1 < 2; ++z1) {
                            world.func_147449_b(x + x1, y + y1, z + z1, obs);
                        }
                    }
                }
                world.func_147468_f(x, y + 4, z);
                world.func_147468_f(x, y + 5, z + 1);
                world.func_147468_f(x, y + 5, z - 1);
                world.func_147465_d(x - 1, y + 5, z + 1, luxury, meta, 2);
                world.func_147465_d(x - 1, y + 5, z - 1, luxury, meta, 2);
                for (int x12 = -1; x12 < 2; ++x12) {
                    world.func_147449_b(x + x12, y, z - 2, obs);
                    world.func_147449_b(x + x12, y, z + 2, obs);
                    if (x12 == 0) {
                        world.func_147449_b(x + x12, y + 1, z - 2, obs);
                        world.func_147449_b(x + x12, y + 1, z + 2, obs);
                    }
                    if (x12 != -1) continue;
                    world.func_147449_b(x + x12, y + 2, z - 2, obs);
                    world.func_147449_b(x + x12, y + 2, z + 2, obs);
                    world.func_147449_b(x + x12, y + 1, z - 2, obs);
                    world.func_147449_b(x + x12, y + 1, z + 2, obs);
                }
                for (y1 = 3; y1 < 7; ++y1) {
                    for (x1 = -1; x1 < 1; ++x1) {
                        world.func_147449_b(x + x1, y + y1, z - 2, obs);
                        world.func_147449_b(x + x1, y + y1, z + 2, obs);
                    }
                }
                for (y1 = 0; y1 < 8; ++y1) {
                    world.func_147449_b(x - 2, y + y1, z + 1, obs);
                    world.func_147449_b(x - 2, y + y1, z, obs);
                    world.func_147449_b(x - 2, y + y1, z - 1, obs);
                }
                world.func_147449_b(x - 2, y + 5, z - 2, obs);
                world.func_147449_b(x - 2, y + 5, z + 2, obs);
                world.func_147468_f(x - 2, y + 7, z - 1);
                world.func_147468_f(x - 2, y + 7, z + 1);
                world.func_147449_b(x - 2, y + 7, z, obs);
                world.func_147468_f(x, y + 1, z);
                world.func_147468_f(x, y + 1, z - 1);
                world.func_147468_f(x, y + 1, z + 1);
                world.func_147468_f(x, y + 2, z);
                world.func_147468_f(x, y + 2, z - 1);
                world.func_147468_f(x, y + 2, z + 1);
                world.func_147468_f(x, y + 3, z + 2);
                world.func_147468_f(x, y + 3, z - 2);
                for (y1 = 0; y1 < 3; ++y1) {
                    for (int z1 = -2; z1 < 3; ++z1) {
                        if (y1 != 0) {
                            if (z1 == 0) continue;
                            world.func_147449_b(x + 2, y + y1, z + z1, obs);
                            continue;
                        }
                        world.func_147449_b(x + 2, y + y1, z + z1, obs);
                    }
                }
                break;
            }
            case 2: {
                int y1;
                for (y1 = 0; y1 < 6; ++y1) {
                    for (int x1 = -1; x1 < 1; ++x1) {
                        for (int z1 = -1; z1 < 2; ++z1) {
                            world.func_147449_b(x + x1, y + y1, z + z1, obs);
                        }
                    }
                }
                world.func_147468_f(x, y + 1, z);
                world.func_147468_f(x, y + 2, z);
                world.func_147465_d(x, y + 4, z, luxury, meta, 2);
                world.func_147449_b(x + 1, y + 3, z, obs);
                world.func_147449_b(x + 1, y + 4, z - 1, obs);
                world.func_147449_b(x + 1, y + 4, z + 1, obs);
                world.func_147449_b(x + 1, y + 5, z, obs);
                world.func_147449_b(x, y + 4, z - 2, obs);
                world.func_147449_b(x, y + 4, z + 2, obs);
                world.func_147449_b(x - 1, y + 4, z - 2, obs);
                world.func_147449_b(x - 1, y + 4, z + 2, obs);
                world.func_147449_b(x, y + 6, z, obs);
                world.func_147449_b(x - 1, y + 6, z, obs);
                for (y1 = 2; y1 < 6; ++y1) {
                    world.func_147449_b(x - 2, y + y1, z, obs);
                }
                world.func_147449_b(x - 2, y + 4, z - 1, obs);
                world.func_147449_b(x - 2, y + 4, z + 1, obs);
                world.func_147449_b(x + 1, y + 1, z - 1, obs);
                world.func_147449_b(x + 1, y + 1, z + 1, obs);
                break;
            }
            case 3: {
                int x1;
                for (int z1 = -1; z1 < 2; ++z1) {
                    world.func_147449_b(x - 1, y, z + z1, obs);
                    world.func_147449_b(x + 1, y, z + z1, obs);
                    world.func_147449_b(x + 2, y, z + z1, obs);
                    for (int x13 = -2; x13 < 5; ++x13) {
                        world.func_147449_b(x + x13, y + 3, z + z1, obs);
                    }
                }
                for (int y1 = 0; y1 < 5; ++y1) {
                    for (int z1 = -1; z1 < 2; ++z1) {
                        if (y1 > 0 && z1 != 0) {
                            world.func_147449_b(x, y + y1, z + z1, obs);
                        }
                        world.func_147449_b(x - 1, y + y1, z + z1, obs);
                    }
                }
                world.func_147449_b(x + 2, y + 1, z + 1, obs);
                world.func_147449_b(x + 2, y + 1, z - 1, obs);
                world.func_147449_b(x + 4, y + 2, z + 1, obs);
                world.func_147449_b(x + 4, y + 2, z - 1, obs);
                for (x1 = -3; x1 < 5; ++x1) {
                    world.func_147449_b(x + x1, y + 4, z, obs);
                }
                world.func_147449_b(x - 3, y + 5, z, obs);
                world.func_147449_b(x, y + 6, z, obs);
                world.func_147449_b(x + 4, y + 4, z + 1, obs);
                world.func_147449_b(x + 4, y + 4, z - 1, obs);
                world.func_147465_d(x + 1, y + 4, z + 1, luxury, meta, 2);
                world.func_147465_d(x + 1, y + 4, z - 1, luxury, meta, 2);
                world.func_147449_b(x + 1, y + 4, z - 2, obs);
                world.func_147449_b(x + 1, y + 4, z + 2, obs);
                world.func_147449_b(x + 1, y + 5, z + 1, obs);
                world.func_147449_b(x + 1, y + 5, z - 1, obs);
                for (x1 = -1; x1 < 1; ++x1) {
                    world.func_147449_b(x + x1, y + 4, z + 1, obs);
                    world.func_147449_b(x + x1, y + 4, z - 1, obs);
                }
                for (x1 = -1; x1 < 3; ++x1) {
                    world.func_147449_b(x + x1, y + 5, z, obs);
                    if (x1 >= 2) continue;
                    world.func_147449_b(x + x1, y + 3, z - 2, obs);
                    world.func_147449_b(x + x1, y + 3, z + 2, obs);
                }
                for (x1 = -4; x1 < -1; ++x1) {
                    world.func_147449_b(x + x1, y + 1, z, obs);
                    if (x1 <= -4) continue;
                    world.func_147449_b(x + x1, y + 2, z, obs);
                    world.func_147449_b(x + x1, y, z, obs);
                }
                break;
            }
            case 4: {
                int y1;
                for (y1 = 1; y1 < 6; ++y1) {
                    for (int z1 = -1; z1 < 2; ++z1) {
                        int x1;
                        world.func_147449_b(x - 1, y + y1, z + z1, obs);
                        if (z1 != 0) {
                            if (y1 == 1 || y1 == 2) {
                                world.func_147449_b(x + 1, y + y1, z + z1, obs);
                            }
                            if (y1 == 1) {
                                world.func_147449_b(x + 2, y + y1, z + z1, obs);
                            }
                        }
                        if (y1 > 3) {
                            world.func_147449_b(x, y + y1, z + z1, obs);
                        } else if (z1 != 0) {
                            world.func_147449_b(x, y + y1, z + z1, obs);
                        }
                        if (y1 == 3) {
                            for (x1 = 0; x1 < 4; ++x1) {
                                world.func_147449_b(x + x1, y + y1, z + z1, obs);
                            }
                        }
                        if (y1 != 4 || z1 != 0) continue;
                        for (x1 = 0; x1 < 3; ++x1) {
                            world.func_147449_b(x + x1, y + y1, z, obs);
                        }
                    }
                }
                world.func_147465_d(x, y + 4, z - 1, luxury, meta, 2);
                world.func_147465_d(x, y + 4, z + 1, luxury, meta, 2);
                world.func_147449_b(x, y + 4, z - 2, obs);
                world.func_147449_b(x, y + 4, z + 2, obs);
                world.func_147449_b(x - 1, y + 4, z - 2, obs);
                world.func_147449_b(x + 1, y + 4, z - 2, obs);
                world.func_147449_b(x - 1, y + 4, z + 2, obs);
                world.func_147449_b(x + 1, y + 4, z + 2, obs);
                world.func_147449_b(x, y + 5, z - 2, obs);
                world.func_147449_b(x, y + 5, z + 2, obs);
                world.func_147449_b(x, y + 3, z - 2, obs);
                world.func_147449_b(x, y + 3, z + 2, obs);
                for (int z1 = -1; z1 < 2; ++z1) {
                    world.func_147449_b(x + 1, y + 5, z + z1, obs);
                    world.func_147449_b(x + 2, y, z + z1, obs);
                }
                world.func_147468_f(x - 1, y + 5, z);
                world.func_147449_b(x - 1, y + 5, z - 2, obs);
                world.func_147449_b(x - 1, y + 5, z + 2, obs);
                world.func_147449_b(x - 1, y + 6, z - 2, obs);
                world.func_147449_b(x - 1, y + 6, z + 2, obs);
                for (y1 = 5; y1 < 8; ++y1) {
                    world.func_147449_b(x - 1, y + y1, z - 3, obs);
                    world.func_147449_b(x - 1, y + y1, z + 3, obs);
                }
                world.func_147449_b(x - 2, y + 6, z - 3, obs);
                world.func_147449_b(x - 2, y + 6, z + 3, obs);
                world.func_147449_b(x - 2, y + 7, z - 3, obs);
                world.func_147449_b(x - 2, y + 7, z + 3, obs);
                world.func_147449_b(x - 2, y + 7, z - 4, obs);
                world.func_147449_b(x - 2, y + 7, z + 4, obs);
                world.func_147449_b(x - 2, y + 8, z + 4, obs);
                world.func_147449_b(x - 2, y + 8, z - 4, obs);
                world.func_147449_b(x - 3, y + 8, z + 4, obs);
                world.func_147449_b(x - 3, y + 8, z - 4, obs);
                break;
            }
            default: {
                int y1;
                block44: for (y1 = 0; y1 < 3; ++y1) {
                    switch (y1) {
                        case 0: {
                            int z1;
                            int x1;
                            for (x1 = -3; x1 < 4; ++x1) {
                                for (z1 = -3; z1 < 4; ++z1) {
                                    if (!set.contains(world.func_147439_a(x + x1, y + y1, z + z1))) continue;
                                    world.func_147449_b(x + x1, y + y1, z + z1, obs);
                                }
                            }
                            continue block44;
                        }
                        case 1: {
                            int z1;
                            int x1;
                            for (x1 = -2; x1 < 3; ++x1) {
                                for (z1 = -2; z1 < 3; ++z1) {
                                    if (!set.contains(world.func_147439_a(x + x1, y + y1, z + z1))) continue;
                                    world.func_147449_b(x + x1, y + y1, z + z1, obs);
                                }
                            }
                            continue block44;
                        }
                        case 2: {
                            int z1;
                            int x1;
                            for (x1 = -1; x1 < 2; ++x1) {
                                for (z1 = -1; z1 < 2; ++z1) {
                                    if (!set.contains(world.func_147439_a(x + x1, y + y1, z + z1)) || x1 == 0 || z1 == 0) continue;
                                    world.func_147449_b(x + x1, y + y1, z + z1, obs);
                                }
                            }
                            continue block44;
                        }
                    }
                }
                for (y1 = 0; y1 < 3; ++y1) {
                    world.func_147449_b(x + 1, y + y1, z, obs);
                    world.func_147449_b(x - 1, y + y1, z, obs);
                    world.func_147449_b(x, y + y1, z + 1, obs);
                    world.func_147449_b(x, y + y1, z - 1, obs);
                    world.func_147465_d(x, y + y1, z, ladder, 3, 2);
                }
            }
        }
        if (world.func_147439_a(x, y, z) != Blocks.field_150468_ap && world.func_147439_a(x, y, z) != Blocks.field_150350_a) {
            world.func_147468_f(x, y, z);
        }
    }

    public void generateCavernOfferings(int variant, World world, Random rand, int x, int y, int z) {
        switch (variant) {
            case 0: {
                ArrayList<int[]> list = WorldHelper.getBlocksInCircularRange(world, 3.0, x, 0.0, z);
                for (int i = 0; i < list.size(); ++i) {
                    int[] coords = list.get(i);
                    world.func_147468_f(coords[0], coords[1], coords[2]);
                }
                world.func_147449_b(x, 0, z, bedrock);
                world.func_147449_b(x, 1, z, chest);
                this.generateChestGoodies(world, rand, x, 1, z, 1);
                break;
            }
            case 1: {
                world.func_147449_b(x, 1, z, bedrock);
                world.func_147449_b(x + 1, 1, z, chest);
                world.func_147449_b(x - 1, 1, z, chest);
                world.func_147449_b(x, 1, z + 1, chest);
                world.func_147449_b(x, 1, z - 1, chest);
                this.generateChestGoodies(world, rand, x + 1, 1, z, 0);
                this.generateChestGoodies(world, rand, x - 1, 1, z, 0);
                this.generateChestGoodies(world, rand, x, 1, z + 1, 0);
                this.generateChestGoodies(world, rand, x, 1, z - 1, 0);
                break;
            }
            case 2: {
                world.func_147449_b(x, 1, z, bedrock);
                int wubwub = rand.nextInt(4) + 1;
                int xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                world.func_147465_d(x + 5, 1, z + 5, summon, xerces, 2);
                world.func_147449_b(x + 1, 1, z, chest);
                this.generateChestGoodies(world, rand, x + 1, 1, z, 2);
                if (wubwub <= 1) break;
                xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                world.func_147465_d(x - 5, 1, z + 5, summon, xerces, 2);
                world.func_147449_b(x - 1, 1, z, chest);
                this.generateChestGoodies(world, rand, x - 1, 1, z, 2);
                if (wubwub <= 2) break;
                xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                world.func_147465_d(x - 5, 1, z - 5, summon, xerces, 2);
                world.func_147449_b(x, 1, z + 1, chest);
                this.generateChestGoodies(world, rand, x, 1, z + 1, 2);
                if (wubwub <= 3) break;
                xerces = rand.nextInt(10);
                if (xerces == 1) {
                    xerces = 0;
                }
                if (xerces >= 7) {
                    xerces = 6;
                }
                world.func_147465_d(x + 5, 1, z - 5, summon, xerces, 2);
                world.func_147449_b(x, 1, z - 1, chest);
                this.generateChestGoodies(world, rand, x, 1, z - 1, 2);
                break;
            }
            case 3: {
                int mow = rand.nextInt(10);
                if (mow == 1) {
                    mow = 0;
                }
                if (mow >= 7) {
                    mow = 6;
                }
                world.func_147465_d(x, 1, z, summon, mow, 2);
                break;
            }
            case 4: {
                world.func_147465_d(x, 1, z, spawner, 0, 2);
                this.setSpawnerMob(world, x, 1, z, this.getRandomEntityNameForSpawner(rand.nextInt(10)));
                break;
            }
            case 5: {
                world.func_147449_b(x, 1, z, bedrock);
                int zera = rand.nextInt(4) + 1;
                int oppa = rand.nextInt(10);
                world.func_147465_d(x + 5, 1, z + 5, spawner, 0, 2);
                this.setSpawnerMob(world, x + 5, 1, z + 5, this.getRandomEntityNameForSpawner(oppa));
                world.func_147449_b(x + 1, 1, z, chest);
                this.generateChestGoodies(world, rand, x + 1, 1, z, 0);
                oppa = rand.nextInt(10);
                if (zera <= 1) break;
                world.func_147465_d(x - 5, 1, z + 5, spawner, 0, 2);
                this.setSpawnerMob(world, x - 5, 1, z + 5, this.getRandomEntityNameForSpawner(oppa));
                world.func_147449_b(x - 1, 1, z, chest);
                this.generateChestGoodies(world, rand, x - 1, 1, z, 0);
                oppa = rand.nextInt(10);
                if (zera <= 2) break;
                world.func_147465_d(x - 5, 1, z - 5, spawner, 0, 2);
                this.setSpawnerMob(world, x - 5, 1, z - 5, this.getRandomEntityNameForSpawner(oppa));
                world.func_147449_b(x, 1, z + 1, chest);
                this.generateChestGoodies(world, rand, x, 1, z + 1, 0);
                oppa = rand.nextInt(10);
                if (zera <= 3) break;
                world.func_147465_d(x + 5, 1, z - 5, spawner, 0, 2);
                this.setSpawnerMob(world, x + 5, 1, z - 5, this.getRandomEntityNameForSpawner(oppa));
                world.func_147449_b(x, 1, z - 1, chest);
                this.generateChestGoodies(world, rand, x, 1, z - 1, 0);
                break;
            }
            case 6: {
                world.func_147449_b(x, 1, z, chest);
                this.generateChestGoodies(world, rand, x, 1, z, 1);
                world.func_147465_d(x, 2, z, spawner, 0, 2);
                this.setSpawnerMob(world, x, 2, z, this.getRandomEntityNameForSpawner(rand.nextInt(10)));
                break;
            }
            case 7: {
                int mrow = rand.nextInt(10);
                if (mrow == 1) {
                    mrow = 0;
                }
                if (mrow >= 7) {
                    mrow = 6;
                }
                world.func_147465_d(x, 1, z, chest, 0, 2);
                this.generateChestGoodies(world, rand, x, 1, z, 0);
                world.func_147465_d(x, 2, z, summon, mrow, 2);
                int zera = rand.nextInt(4) + 1;
                int oppa = rand.nextInt(10);
                world.func_147465_d(x + 5, 1, z + 5, spawner, 0, 2);
                this.setSpawnerMob(world, x + 5, 1, z + 5, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 1) break;
                world.func_147465_d(x - 5, 1, z + 5, spawner, 0, 2);
                this.setSpawnerMob(world, x - 5, 1, z + 5, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 2) break;
                world.func_147465_d(x - 5, 1, z - 5, spawner, 0, 2);
                this.setSpawnerMob(world, x - 5, 1, z - 5, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 3) break;
                world.func_147465_d(x + 5, 1, z - 5, spawner, 0, 2);
                this.setSpawnerMob(world, x + 5, 1, z - 5, this.getRandomEntityNameForSpawner(oppa));
                break;
            }
            case 8: {
                int mrow = rand.nextInt(10);
                if (mrow == 1) {
                    mrow = 0;
                }
                if (mrow >= 7) {
                    mrow = 6;
                }
                world.func_147465_d(x, 1, z, chest, 0, 2);
                this.generateChestGoodies(world, rand, x, 1, z, 2);
                Block luxury = SchematicDesertTower.luxuryBlocks[rand.nextInt(SchematicDesertTower.luxuryBlocks.length)];
                int meta = 0;
                if (luxury == TragicBlocks.CompactOre) {
                    meta = rand.nextInt(5);
                }
                world.func_147465_d(x, 2, z, luxury, meta, 2);
                world.func_147465_d(x, 3, z, summon, mrow, 2);
                int zera = rand.nextInt(4) + 1;
                int oppa = rand.nextInt(10);
                world.func_147465_d(x + 5, 1, z + 5, spawner, 0, 2);
                this.setSpawnerMob(world, x + 5, 1, z + 5, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 1) break;
                world.func_147465_d(x - 5, 1, z + 5, spawner, 0, 2);
                this.setSpawnerMob(world, x - 5, 1, z + 5, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 2) break;
                world.func_147465_d(x - 5, 1, z - 5, spawner, 0, 2);
                this.setSpawnerMob(world, x - 5, 1, z - 5, this.getRandomEntityNameForSpawner(oppa));
                oppa = rand.nextInt(10);
                if (zera <= 3) break;
                world.func_147465_d(x + 5, 1, z - 5, spawner, 0, 2);
                this.setSpawnerMob(world, x + 5, 1, z - 5, this.getRandomEntityNameForSpawner(oppa));
                break;
            }
            default: {
                world.func_147449_b(x, 1, z, chest);
                this.generateChestGoodies(world, rand, x, 1, z, 1);
            }
        }
    }

    public void generateChestGoodies(World world, Random rand, int x, int y, int z, int flag) {
        TileEntityChest chest = (TileEntityChest)world.func_147438_o(x, y, z);
        ChestGenHooks hook = null;
        if (chest == null) {
            TragicMC.logWarning("There was an error setting chest contents");
            return;
        }
        hook = flag == 0 ? TragicItems.BossStructureHook : (flag == 1 ? ChestGenHooks.getInfo((String)"mineshaftCorridor") : (flag == 2 ? TragicItems.AwesomeChestHook : TragicItems.LameChestHook));
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])hook.getItems(rand), (IInventory)chest, (int)hook.getCount(rand));
    }

    public String getRandomEntityNameForSpawner(int i) {
        String s = TragicConfig.allowPlague ? "TragicMC.Plague" : "Blaze";
        switch (i) {
            case 0: {
                s = TragicConfig.allowMinotaur ? "TragicMC.Minotaur" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 1: {
                s = TragicConfig.allowInkling ? "TragicMC.Inkling" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 2: {
                s = TragicConfig.allowJabba ? "TragicMC.Jabba" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 3: {
                s = TragicConfig.allowNorVox ? "TragicMC.NorVox" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 4: {
                s = TragicConfig.allowRagr ? "TragicMC.Ragr" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 5: {
                s = TragicConfig.allowTox ? "TragicMC.Tox" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 6: {
                s = TragicConfig.allowGragul ? "TragicMC.Gragul" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 7: {
                s = TragicConfig.allowJarra ? "TragicMC.Jarra" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
            case 8: {
                s = TragicConfig.allowKragul ? "TragicMC.Kragul" : this.getRandomVanillaEntityNameForSpawner(i);
                break;
            }
        }
        return s;
    }

    public String getRandomVanillaEntityNameForSpawner(int i) {
        String s = "Skeleton";
        switch (i) {
            case 0: {
                s = "Zombie";
                break;
            }
            case 1: {
                s = "Enderman";
                break;
            }
            case 2: {
                s = "Slime";
                break;
            }
            case 3: {
                s = "Blaze";
                break;
            }
            case 4: {
                s = "Spider";
                break;
            }
            case 5: {
                s = "Witch";
                break;
            }
        }
        return s;
    }

    public String getRandomBossNameForSpawner(int i) {
        String s = TragicConfig.allowApis ? "TragicMC.Apis" : "Enderman";
        switch (i) {
            case 0: {
                s = TragicConfig.allowEmpariah ? "TragicMC.Yeti" : "Enderman";
                break;
            }
            case 1: {
                s = TragicConfig.allowKitsunakuma ? "TragicMC.Kitsune" : "Enderman";
                break;
            }
            case 2: {
                s = TragicConfig.allowPolaris ? "TragicMC.Polaris" : "Enderman";
                break;
            }
        }
        return s;
    }
}

