/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.worldgen.schematic.Schematic;

public class SchematicCubeMaze
extends Schematic {
    private static final byte[][] values = new byte[][]{{-10, -10}, {-10, -4}, {-10, 3}, {-10, 9}, {-4, -10}, {-4, -4}, {-4, 3}, {-4, 9}, {3, -10}, {3, -4}, {3, 3}, {3, 9}, {9, -10}, {9, -4}, {9, 3}, {9, 9}};

    public SchematicCubeMaze() {
        super(32, 24, 24);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean generateStructure(int variant, World world, Random rand, int x, int y, int z) {
        for (int y1 = 0; y1 < 37; y1 = (int)((byte)(y1 + 1))) {
            int x1;
            for (x1 = -13; x1 < 13; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -13; z1 < 13; z1 = (int)((byte)(z1 + 1))) {
                    if (y1 % 6 == 0) {
                        world.func_147449_b(x + x1, y + y1, z + z1, Blocks.field_150343_Z);
                        continue;
                    }
                    world.func_147468_f(x + x1, y + y1, z + z1);
                }
            }
            for (x1 = -13; x1 < 13; x1 = (int)((byte)(x1 + 1))) {
                world.func_147449_b(x + x1, y + y1, z + 12, Blocks.field_150343_Z);
                world.func_147449_b(x + x1, y + y1, z - 13, Blocks.field_150343_Z);
                world.func_147449_b(x - 13, y + y1, z + x1, Blocks.field_150343_Z);
                world.func_147449_b(x + 12, y + y1, z + x1, Blocks.field_150343_Z);
                world.func_147449_b(x + x1, y + y1, z + 6, Blocks.field_150343_Z);
                world.func_147449_b(x + x1, y + y1, z - 7, Blocks.field_150343_Z);
                world.func_147449_b(x - 7, y + y1, z + x1, Blocks.field_150343_Z);
                world.func_147449_b(x + 6, y + y1, z + x1, Blocks.field_150343_Z);
                world.func_147449_b(x + x1, y + y1, z, Blocks.field_150343_Z);
                world.func_147449_b(x + x1, y + y1, z - 1, Blocks.field_150343_Z);
                world.func_147449_b(x - 1, y + y1, z + x1, Blocks.field_150343_Z);
                world.func_147449_b(x, y + y1, z + x1, Blocks.field_150343_Z);
            }
        }
        int exits = 0;
        boolean invFlag = false;
        byte roomType = 0;
        int t = 0;
        int trap = 0;
        for (byte y1 = 0; y1 < 33; y1 = (byte)((byte)(y1 + 6))) {
            for (int i = 0; i < values.length; i = (int)((byte)(i + 1))) {
                boolean treasure;
                byte x0 = values[i][0];
                byte z0 = values[i][1];
                if ((Math.abs(x0) > 6 || Math.abs(z0) > 6) && exits < 5 && rand.nextInt(16) == 0) {
                    exits = (byte)(exits + 1);
                    invFlag = true;
                } else {
                    invFlag = false;
                }
                if (Math.abs(x0) > 6 || Math.abs(z0) > 6) {
                    boolean flag;
                    if (Math.abs(x0) > 6) {
                        if (Math.abs(z0) > 6) {
                            boolean flag2;
                            flag = x0 > 0;
                            boolean bl = flag2 = z0 > 0;
                            if (Math.abs(x0) > 6) {
                                roomType = flag ? (byte)(flag2 ? 5 : 6) : (byte)(flag2 ? 8 : 7);
                            } else {
                                if (Math.abs(z0) <= 6) return false;
                                roomType = flag2 ? (byte)(flag ? 5 : 8) : (byte)(flag ? 6 : 7);
                            }
                        } else {
                            flag = x0 > 0;
                            roomType = (byte)(flag ? 1 : 2);
                        }
                    } else {
                        if (Math.abs(z0) <= 6) return false;
                        flag = z0 > 0;
                        roomType = (byte)(flag ? 3 : 4);
                    }
                } else {
                    roomType = 0;
                }
                this.generateOpenings(world, rand, x + x0, y + y1, z + z0, roomType, y1, invFlag);
                boolean bl = treasure = roomType == 0 && rand.nextInt(8) == 0 && t == 0 && y1 > 5 && y1 < 28;
                world.func_147465_d(x + x0, y + y1 + 3, z + z0, (Block)(treasure ? Blocks.field_150486_ae : (rand.nextInt(16) == 0 ? Blocks.field_150350_a : Blocks.field_150426_aN)), 0, 2);
                if (treasure) {
                    this.applyChestContents(world, rand, x + x0, y + y1 + 3, z + z0, TragicItems.NetherStructureHook);
                    t = (byte)(t + 1);
                    continue;
                }
                if (trap >= 3 || rand.nextInt(16) != 0) continue;
                if (rand.nextBoolean()) {
                    world.func_147465_d(x + x0, y + y1 + 4, z + z0, Blocks.field_150335_W, 1, 2);
                } else {
                    world.func_147465_d(x + x0, y + y1 + 4, z + z0, Blocks.field_150474_ac, 0, 2);
                    this.setSpawnerMob(world, x + x0, y + y1 + 4, z + z0, TragicConfig.allowInkling ? "TragicMC.Inkling" : "Enderman");
                }
                trap = (byte)(trap + 1);
            }
        }
        return true;
    }

    public void generateOpenings(World world, Random rand, int x, int y, int z, int roomType, byte y0, boolean inverse) {
        boolean[] discrim = new boolean[6];
        Arrays.fill(discrim, true);
        if (roomType == 3 || roomType == 5 || roomType == 8) {
            discrim[0] = false;
        }
        if (roomType == 4 || roomType == 6 || roomType == 7) {
            discrim[1] = false;
        }
        if (roomType == 1 || roomType == 5 || roomType == 6) {
            discrim[2] = false;
        }
        if (roomType == 2 || roomType == 7 || roomType == 8) {
            discrim[3] = false;
        }
        if (y0 < 10) {
            discrim[4] = false;
        }
        if (y0 > 26) {
            discrim[5] = false;
        }
        if (inverse) {
            for (int i = 0; i < discrim.length; ++i) {
                if (discrim[i]) continue;
                discrim[i] = true;
            }
        }
        byte attempts = (byte)(inverse ? 3 : 2);
        for (byte i = 0; i < attempts; i = (byte)(i + 1)) {
            int x1;
            byte j = (byte)rand.nextInt(discrim.length);
            boolean flag = false;
            while (!discrim[j]) {
                j = (byte)rand.nextInt(discrim.length);
            }
            if (!discrim[j]) continue;
            if (j == 0) {
                for (x1 = 2; x1 < 5; ++x1) {
                    world.func_147468_f(x, y + 1, z + x1);
                    world.func_147468_f(x, y + 2, z + x1);
                }
                continue;
            }
            if (j == 1) {
                for (x1 = -2; x1 > -5; --x1) {
                    world.func_147468_f(x, y + 1, z + x1);
                    world.func_147468_f(x, y + 2, z + x1);
                }
                continue;
            }
            if (j == 2) {
                for (x1 = 2; x1 < 5; ++x1) {
                    world.func_147468_f(x + x1, y + 1, z);
                    world.func_147468_f(x + x1, y + 2, z);
                }
                continue;
            }
            if (j == 3) {
                for (x1 = -2; x1 > -5; --x1) {
                    world.func_147468_f(x + x1, y + 1, z);
                    world.func_147468_f(x + x1, y + 2, z);
                }
                continue;
            }
            if (j == 4) {
                for (x1 = 1; x1 > -1; --x1) {
                    world.func_147468_f(x, y + x1, z);
                    world.func_147468_f(x, y + x1, z);
                    world.func_147468_f(x + 1, y + x1, z);
                    world.func_147468_f(x - 1, y + x1, z);
                    world.func_147468_f(x, y + x1, z + 1);
                    world.func_147468_f(x, y + x1, z - 1);
                }
                continue;
            }
            if (j != 5) continue;
            for (x1 = 5; x1 < 7; ++x1) {
                world.func_147468_f(x, y + x1, z);
                world.func_147468_f(x, y + x1, z);
                world.func_147468_f(x + 1, y + x1, z);
                world.func_147468_f(x - 1, y + x1, z);
                world.func_147468_f(x, y + x1, z + 1);
                world.func_147468_f(x, y + x1, z - 1);
            }
        }
    }
}

