/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.schematic.Schematic;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SchematicCelestialTemple
extends Schematic {
    private static Block quartz = TragicBlocks.DarkenedQuartz;
    private static Block obs = TragicBlocks.DarkStone;
    private static Block glow = TragicBlocks.StarCrystal;
    private static Block chest = Blocks.field_150486_ae;
    private static Block stone = TragicBlocks.DarkStone;
    private static Block summon = TragicBlocks.SummonBlock;

    public SchematicCelestialTemple() {
        super(12, 25, 25);
    }

    @Override
    public boolean generateStructure(int variant, World world, Random rand, int x, int y, int z) {
        int i;
        byte relays = (byte)(6 + (rand.nextInt(variant + 1) + 1) * (rand.nextInt(variant + 1) + 1));
        double regression = 0.88977745;
        double cutoff = 0.48943755;
        ArrayList<int[]> cands = new ArrayList<int[]>();
        for (byte buzza = 0; buzza < relays; buzza = (byte)(buzza + 1)) {
            int Ycoord;
            int Zcoord;
            int Xcoord;
            double size;
            if (buzza == 0) {
                size = 15.0;
                Xcoord = x + 4;
                Zcoord = z + 4;
                Ycoord = y;
                cutoff = 0.6278;
                regression = 0.8876;
            } else {
                size = rand.nextDouble() * 5.5 + 4.5;
                Xcoord = x + 4 + rand.nextInt(10) - rand.nextInt(10);
                Zcoord = z + 4 + rand.nextInt(10) - rand.nextInt(10);
                Ycoord = y - rand.nextInt(2);
                regression = 0.88977745;
                cutoff = 0.68943755;
            }
            int yMax = Ycoord;
            for (int y1 = 0; y1 > -32 && !(size < cutoff); y1 = (int)((byte)(y1 - 1))) {
                size *= regression;
                if (rand.nextInt(12) == 0) {
                    Xcoord += rand.nextInt(2) - rand.nextInt(2);
                    Zcoord += rand.nextInt(2) - rand.nextInt(2);
                }
                ArrayList<int[]> list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                for (int[] coords2 : list) {
                    Block block = world.func_147439_a(coords2[0], coords2[1], coords2[2]);
                    if (!Structure.validBlocks.contains(block) || cands.contains(coords2)) continue;
                    if (yMax < coords2[1]) {
                        yMax = coords2[1];
                    }
                    cands.add(coords2);
                }
            }
            byte rnd = (byte)(rand.nextInt(3) + 1);
            for (int[] coords2 : cands) {
                if (coords2[1] >= yMax) {
                    world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.AshenGrass, 0, 2);
                    continue;
                }
                if (coords2[1] >= yMax - rnd - rand.nextInt(2)) {
                    world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.DeadDirt, 0, 2);
                    continue;
                }
                world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.DarkStone, 0, 2);
            }
        }
        for (int y1 = 0; y1 < 10; y1 = (int)((byte)(y1 + 1))) {
            for (int x1 = -8; x1 < 17; x1 = (int)((byte)(x1 + 1))) {
                for (int z1 = -6; z1 < 15; z1 = (int)((byte)(z1 + 1))) {
                    world.func_147468_f(x + x1, y + y1 + 1, z + z1);
                }
            }
        }
        for (i = 2; i < 8; ++i) {
            world.func_147465_d(x - 7, y, z + i, quartz, 0, 2);
        }
        for (i = 1; i < 9; ++i) {
            world.func_147465_d(x - 6, y, z + i, quartz, 0, 2);
        }
        for (i = -1; i < 11; ++i) {
            world.func_147465_d(x - 5, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            world.func_147465_d(x - 4, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            world.func_147465_d(x - 3, y, z + i, quartz, 0, 2);
        }
        for (i = -3; i < 13; ++i) {
            world.func_147465_d(x - 2, y, z + i, quartz, 0, 2);
        }
        for (i = -4; i < 14; ++i) {
            world.func_147465_d(x - 1, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x - 1, y, z, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x, y, z + 4, obs, 0, 2);
        world.func_147465_d(x, y, z + 5, obs, 0, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 1, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 1, y, z, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 3, obs, 0, 2);
        world.func_147465_d(x + 1, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 6, obs, 0, 2);
        world.func_147465_d(x + 1, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 2, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 2, y, z, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 2, obs, 0, 2);
        world.func_147465_d(x + 2, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 7, obs, 0, 2);
        world.func_147465_d(x + 2, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 3, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 3, y, z, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 2, obs, 0, 2);
        world.func_147465_d(x + 3, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 4, obs, 0, 2);
        world.func_147465_d(x + 3, y, z + 5, obs, 0, 2);
        world.func_147465_d(x + 3, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 7, obs, 0, 2);
        world.func_147465_d(x + 3, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 4, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 4, y, z + 1, obs, 0, 2);
        world.func_147465_d(x + 4, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z + 3, glow, 0, 2);
        world.func_147465_d(x + 4, y, z + 4, chest, 0, 2);
        world.func_147465_d(x + 4, y, z + 5, chest, 0, 2);
        world.func_147465_d(x + 4, y, z + 6, glow, 0, 2);
        world.func_147465_d(x + 4, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z + 8, obs, 0, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 5, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 5, y, z, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z + 2, obs, 0, 2);
        world.func_147465_d(x + 5, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z + 4, obs, 0, 2);
        world.func_147465_d(x + 5, y, z + 5, obs, 0, 2);
        world.func_147465_d(x + 5, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z + 7, obs, 0, 2);
        world.func_147465_d(x + 5, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 6, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 6, y, z, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 2, obs, 0, 2);
        world.func_147465_d(x + 6, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 7, obs, 0, 2);
        world.func_147465_d(x + 6, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 7, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 7, y, z, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 3, obs, 0, 2);
        world.func_147465_d(x + 7, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 6, obs, 0, 2);
        world.func_147465_d(x + 7, y, z + 9, quartz, 1, 2);
        for (i = -5; i < 15; ++i) {
            world.func_147465_d(x + 8, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 8, y, z + 4, obs, 0, 2);
        world.func_147465_d(x + 8, y, z + 5, obs, 0, 2);
        for (i = -4; i < 14; ++i) {
            world.func_147465_d(x + 9, y, z + i, quartz, 0, 2);
        }
        world.func_147465_d(x + 9, y, z, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 9, quartz, 1, 2);
        for (i = -3; i < 13; ++i) {
            world.func_147465_d(x + 10, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            world.func_147465_d(x + 11, y, z + i, quartz, 0, 2);
        }
        for (i = -2; i < 12; ++i) {
            world.func_147465_d(x + 12, y, z + i, quartz, 0, 2);
        }
        for (i = -1; i < 11; ++i) {
            world.func_147465_d(x + 13, y, z + i, quartz, 0, 2);
        }
        for (i = 1; i < 9; ++i) {
            world.func_147465_d(x + 14, y, z + i, quartz, 0, 2);
        }
        for (i = 2; i < 8; ++i) {
            world.func_147465_d(x + 15, y, z + i, quartz, 0, 2);
        }
        if (!world.field_72995_K) {
            this.applyChestContents(world, rand, x + 4, y, z + 4, TragicItems.BossStructureHook);
            this.applyChestContents(world, rand, x + 4, y, z + 5, TragicItems.BossStructureHook);
        }
        world.func_147465_d(--x - 6, ++y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 6, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x, y, z, quartz, 1, 2);
        world.func_147465_d(x, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 5, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 14, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z + 4, obs, 0, 2);
        world.func_147465_d(x + 5, y, z + 5, obs, 0, 2);
        world.func_147465_d(x + 7, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z - 5, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 14, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 16, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 16, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 5, ++y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 3, stone, 0, 2);
        world.func_147465_d(x - 5, y, z + 6, stone, 0, 2);
        world.func_147465_d(x - 5, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 3, stone, 0, 2);
        world.func_147465_d(x - 4, y, z + 6, stone, 0, 2);
        world.func_147465_d(x - 4, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x, y, z, quartz, 1, 2);
        world.func_147465_d(x, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 3, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 3, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 3, y, z + 13, stone, 0, 2);
        if (variant == 1) {
            world.func_147465_d(x + 5, y, z + 4, summon, 5, 2);
            world.func_147468_f(x + 5, y, z + 5);
        } else if (variant == 2) {
            world.func_147465_d(x + 5, y, z + 4, summon, 5, 2);
            world.func_147465_d(x + 5, y, z + 5, summon, 5, 2);
        } else {
            world.func_147468_f(x + 5, y, z + 4);
            world.func_147465_d(x + 5, y, z + 5, summon, 5, 2);
        }
        world.func_147465_d(x + 7, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 7, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 7, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 7, y, z + 13, stone, 0, 2);
        world.func_147465_d(x + 8, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 3, stone, 0, 2);
        world.func_147465_d(x + 14, y, z + 6, stone, 0, 2);
        world.func_147465_d(x + 14, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 3, stone, 0, 2);
        world.func_147465_d(x + 15, y, z + 6, stone, 0, 2);
        world.func_147465_d(x + 15, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 5, ++y, z + 3, stone, 0, 2);
        world.func_147465_d(x - 5, y, z + 6, stone, 0, 2);
        world.func_147465_d(x - 4, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 3, stone, 0, 2);
        world.func_147465_d(x - 4, y, z + 6, stone, 0, 2);
        world.func_147465_d(x - 4, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x, y, z, quartz, 1, 2);
        world.func_147465_d(x, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 3, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 3, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 3, y, z + 13, stone, 0, 2);
        world.func_147465_d(x + 7, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 7, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 7, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 7, y, z + 13, stone, 0, 2);
        world.func_147465_d(x + 8, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 3, stone, 0, 2);
        world.func_147465_d(x + 14, y, z + 6, stone, 0, 2);
        world.func_147465_d(x + 14, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 3, stone, 0, 2);
        world.func_147465_d(x + 15, y, z + 6, stone, 0, 2);
        world.func_147465_d(x - 5, ++y, z + 3, quartz, 1, 2);
        world.func_147465_d(x - 5, y, z + 4, stone, 0, 2);
        world.func_147465_d(x - 5, y, z + 5, stone, 0, 2);
        world.func_147465_d(x - 5, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 4, stone, 0, 2);
        world.func_147465_d(x - 4, y, z + 5, stone, 0, 2);
        world.func_147465_d(x - 4, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x, y, z, quartz, 1, 2);
        world.func_147465_d(x, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 4, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 4, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 4, y, z + 13, stone, 0, 2);
        world.func_147465_d(x + 5, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 5, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 5, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 5, y, z + 13, stone, 0, 2);
        world.func_147465_d(x + 6, y, z - 4, stone, 0, 2);
        world.func_147465_d(x + 6, y, z - 3, stone, 0, 2);
        world.func_147465_d(x + 6, y, z + 12, stone, 0, 2);
        world.func_147465_d(x + 6, y, z + 13, stone, 0, 2);
        world.func_147465_d(x + 7, y, z - 4, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 13, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 3, stone, 0, 2);
        world.func_147465_d(x + 14, y, z + 6, stone, 0, 2);
        world.func_147465_d(x + 14, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 15, y, z + 4, stone, 0, 2);
        world.func_147465_d(x + 15, y, z + 5, stone, 0, 2);
        world.func_147465_d(x + 15, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x - 4, ++y, z + 1, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x - 4, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z, quartz, 1, 2);
        world.func_147465_d(x - 3, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 2, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x - 1, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x, y, z, quartz, 1, 2);
        world.func_147465_d(x, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z - 3, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 12, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z - 2, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 11, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 11, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z - 1, quartz, 1, 2);
        world.func_147465_d(x + 12, y, z + 10, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z, quartz, 1, 2);
        world.func_147465_d(x + 13, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 14, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x, ++y, z, quartz, 1, 2);
        world.func_147465_d(x, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z, quartz, 1, 2);
        world.func_147465_d(x + 1, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z, quartz, 1, 2);
        world.func_147465_d(x + 2, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z, quartz, 1, 2);
        world.func_147465_d(x + 3, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z, quartz, 1, 2);
        world.func_147465_d(x + 4, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z, quartz, 1, 2);
        world.func_147465_d(x + 5, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z, quartz, 1, 2);
        world.func_147465_d(x + 6, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z, quartz, 1, 2);
        world.func_147465_d(x + 7, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z, quartz, 1, 2);
        world.func_147465_d(x + 8, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z, quartz, 1, 2);
        world.func_147465_d(x + 9, y, z + 9, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 1, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 2, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 3, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 4, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 5, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 6, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 7, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 8, quartz, 1, 2);
        world.func_147465_d(x + 10, y, z + 9, quartz, 1, 2);
        return true;
    }
}

