/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.schematic;

import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import tragicneko.tragicmc.TragicMC;

public abstract class Schematic {
    public int width;
    public int height;
    public int structureHeight;

    public Schematic(int structureHeight, int w, int h) {
        this.width = w;
        this.height = h;
        this.structureHeight = structureHeight;
    }

    public abstract boolean generateStructure(int var1, World var2, Random var3, int var4, int var5, int var6);

    public boolean generateStructure(World world, Random rand, int x, int y, int z) {
        return this.generateStructure(0, world, rand, x, y, z);
    }

    public boolean generateWithRandomVariant(int variantSize, World world, Random rand, int x, int y, int z) {
        return this.generateStructure(rand.nextInt(variantSize), world, rand, x, y, z);
    }

    public boolean applyChestContents(World world, Random rand, int x, int y, int z, ChestGenHooks hook) {
        if (y <= 0 || y >= 256) {
            return false;
        }
        TileEntityChest tileentity = (TileEntityChest)world.func_147438_o(x, y, z);
        if (tileentity != null) {
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])hook.getItems(rand), (IInventory)tileentity, (int)hook.getCount(rand));
            return true;
        }
        TragicMC.logWarning("Chest generation failed. The tile entity was null.");
        return false;
    }

    public boolean addSignContents(World world, int x, int y, int z, int line, String text) {
        TileEntitySign sign = (TileEntitySign)world.func_147438_o(x, y, z);
        if (sign == null || line > 4) {
            TragicMC.logWarning("Sign text setup failed. The tile entity was null or an improper text line was chosen.");
            return false;
        }
        sign.field_145915_a[line] = text;
        return true;
    }

    public boolean setSpawnerMob(World world, int x, int y, int z, String mobName) {
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
        if (spawner == null || mobName == null) {
            TragicMC.logWarning("Spawner setup failed. The tile entity was null or mobName was null.");
            return false;
        }
        spawner.func_145881_a().func_98272_a(mobName);
        return true;
    }
}

