/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.mob.EntityPsygote;
import tragicneko.tragicmc.entity.mob.EntityStin;
import tragicneko.tragicmc.worldgen.CustomSpikesWorldGen;
import tragicneko.tragicmc.worldgen.InvertedSpikeWorldGen;
import tragicneko.tragicmc.worldgen.IsleWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;

public class BiomeGenTaintedSpikes
extends TragicBiome {
    private final CustomSpikesWorldGen spikeWorldGen;
    private final InvertedSpikeWorldGen scarGen;
    private final RuggedTerrainWorldGen ruggedGen;
    private final IsleWorldGen isleGen;
    public static final float[][] heights = new float[][]{{0.45f, 0.05f}, {0.35f, -0.95f}, {1.85f, 0.45f}, {0.05f, 0.65f}, {0.25f, -0.65f}};

    public BiomeGenTaintedSpikes(int par1, byte par2) {
        super(par1, par2);
        if (TragicConfig.allowPsygote) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPsygote.class, TragicConfig.psygoteSC, TragicConfig.psygoteGS[0], TragicConfig.psygoteGS[1]));
        }
        if (TragicConfig.allowStin) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityStin.class, TragicConfig.stinSC, TragicConfig.stinGS[0], TragicConfig.stinGS[1]));
        }
        if (TragicConfig.allowGreaterStin) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityStin.class, TragicConfig.greaterStinSC, TragicConfig.greaterStinGS[0], TragicConfig.greaterStinGS[1]));
        }
        this.field_76766_R = false;
        this.field_76750_F = 1.8f;
        this.field_76751_G = 2.0f;
        this.field_76760_I.field_76798_D = this.variant == 1 ? 16 : 2;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76753_B = TragicBlocks.DarkStone;
        this.field_76752_A = TragicBlocks.ErodedStone;
        this.spikeWorldGen = new CustomSpikesWorldGen((byte)(this.variant == 0 ? 4 : 1), TragicBlocks.DarkStone, 14, 0.93477745, 0.42943755, 1.5, 1.0);
        this.scarGen = new InvertedSpikeWorldGen(4, 1.5, 2.5, 0.91977745, 0.48943755);
        this.ruggedGen = new RuggedTerrainWorldGen(TragicBlocks.ErodedStone, 2, TragicBlocks.ErodedStone, 3, 2.0, 2.5, true, 8);
        this.isleGen = new IsleWorldGen();
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        super.func_76728_a(world, rand, x, z);
        if (this.variant == 4 && rand.nextInt(3) == 0) {
            this.isleGen.generate(rand, x / 16, z / 16, world);
        }
        if (this.variant < 3 && rand.nextInt(100) >= 3 && rand.nextBoolean()) {
            this.spikeWorldGen.generate(rand, x / 16, z / 16, world);
        }
        if (this.variant == 3) {
            if (rand.nextInt(100) > 5 && rand.nextInt(3) != 0) {
                this.scarGen.generate(rand, x / 16, z / 16, world);
            }
            this.ruggedGen.generate(rand, x / 16, z / 16, world);
        }
    }
}

