/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityKitsune;
import tragicneko.tragicmc.entity.miniboss.EntityMagmox;
import tragicneko.tragicmc.entity.mob.EntityJabba;
import tragicneko.tragicmc.entity.mob.EntityWisp;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.InvertedSpikeWorldGen;
import tragicneko.tragicmc.worldgen.PitWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;

public class BiomeGenScorchedWasteland
extends TragicBiome {
    public final SurfaceWorldGen2 fireGen;
    public final PitWorldGen pitGen;
    public final InvertedSpikeWorldGen scarGen;
    public static final float[][] heights = new float[][]{{0.15f, 0.05f}, {0.05f, -0.45f}, {0.45f, -0.05f}};

    public BiomeGenScorchedWasteland(int par1, byte par2) {
        super(par1, par2);
        this.field_76762_K.clear();
        if (TragicConfig.allowKindlingSpirit) {
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityWisp.class, TragicConfig.kindlingSpiritSC, TragicConfig.kindlingSpiritGS[0], TragicConfig.kindlingSpiritGS[1]));
        }
        if (TragicConfig.allowJabba) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityJabba.class, TragicConfig.jabbaSC, TragicConfig.jabbaGS[0], TragicConfig.jabbaGS[1]));
        }
        if (TragicConfig.allowMagmox) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityMagmox.class, TragicConfig.magmoxSC, TragicConfig.magmoxGS[0], TragicConfig.magmoxGS[1]));
        }
        if (TragicConfig.allowKitsunakuma) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityKitsune.class, TragicConfig.kitsunakumaSC, 0, 0));
        }
        this.field_76766_R = false;
        this.field_76765_S = false;
        this.field_76750_F = 2.0f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76798_D = -999;
        this.field_76753_B = TragicBlocks.ScorchedRock;
        this.field_76752_A = TragicBlocks.MoltenRock;
        this.fireGen = new SurfaceWorldGen2((byte)(this.variant == 2 ? 16 : 4), (Block)Blocks.field_150480_ab, 0, 8, 4);
        this.pitGen = new PitWorldGen((Block)Blocks.field_150356_k, 0, 12, 6, 4.0, 3.0);
        this.scarGen = new InvertedSpikeWorldGen(6, 1.5, 2.5, 0.90977745, 0.48943755);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 2 ? 4 : 0;
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        Block block;
        byte i;
        super.func_76728_a(world, rand, x, z);
        int Xcoord = x * 16 + rand.nextInt(16);
        int Zcoord = z * 16 + rand.nextInt(16);
        int Ycoord = world.func_72825_h(Xcoord, Zcoord) - 1;
        byte mew = (byte)(this.variant == 2 ? 8 : 2);
        ArrayList<int[]> cands = new ArrayList<int[]>();
        for (i = 0; i < mew; i = (byte)(i + 1)) {
            Xcoord = x * 16 + rand.nextInt(16);
            block = world.func_147439_a(Xcoord, Ycoord = world.func_72825_h(Xcoord, Zcoord = z * 16 + rand.nextInt(16)) - 1, Zcoord);
            if (block != TragicBlocks.MoltenRock || rand.nextInt(4) != 0) continue;
            world.func_147449_b(Xcoord, Ycoord, Zcoord, TragicBlocks.Geyser);
            world.func_147449_b(Xcoord, Ycoord - 1, Zcoord, Blocks.field_150353_l);
        }
        mew = (byte)(this.variant == 2 ? 10 : 5);
        for (i = 0; i < mew; i = (byte)(i + 1)) {
            Xcoord = x * 16 + rand.nextInt(16);
            block = world.func_147439_a(Xcoord, Ycoord = world.func_72825_h(Xcoord, Zcoord = z * 16 + rand.nextInt(16)) - 1, Zcoord);
            if (block != TragicBlocks.MoltenRock || rand.nextInt(4) != 0) continue;
            world.func_147449_b(Xcoord, Ycoord, Zcoord, TragicBlocks.SteamVent);
        }
        mew = (byte)(this.variant == 0 ? 8 : 2);
        for (i = 0; i < mew; i = (byte)(i + 1)) {
            Xcoord = x * 16 + rand.nextInt(16);
            block = world.func_147439_a(Xcoord, Ycoord = world.func_72825_h(Xcoord, Zcoord = z * 16 + rand.nextInt(16)) - 1, Zcoord);
            if (block != TragicBlocks.MoltenRock || rand.nextInt(4) != 0) continue;
            cands.clear();
            cands.addAll(WorldHelper.getBlocksInSphericalRange(world, rand.nextDouble() * 2.25 + 1.5, Xcoord, Ycoord - 1, Zcoord));
            for (int[] coords : cands) {
                block = world.func_147439_a(coords[0], coords[1], coords[2]);
                if (!block.isReplaceable((IBlockAccess)world, coords[0], coords[1], coords[2])) continue;
                world.func_147449_b(coords[0], coords[1], coords[2], TragicBlocks.ScorchedRock);
            }
        }
        if (rand.nextInt(8) == 0) {
            this.pitGen.generate(rand, x / 16, z / 16, world);
        }
        this.fireGen.generate(rand, x / 16, z / 16, world);
        if (this.variant == 2 && rand.nextInt(100) > 3 && rand.nextInt(6) != 0) {
            this.scarGen.generate(rand, x / 16, z / 16, world);
        }
    }
}

