/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityYeti;
import tragicneko.tragicmc.entity.mob.EntityAbomination;
import tragicneko.tragicmc.entity.mob.EntityCryse;
import tragicneko.tragicmc.entity.mob.EntityRagr;
import tragicneko.tragicmc.worldgen.CustomSpikesWorldGen;
import tragicneko.tragicmc.worldgen.PitWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.WorldGenCustomVine;

public class BiomeGenFrozenTundra
extends TragicBiome {
    public final RuggedTerrainWorldGen permafrostGen;
    public final SurfaceWorldGen2 iceSpikeGen;
    public final PitWorldGen pitGen;
    public final WorldGenCustomVine vineGen;
    public static final float[][] heights = new float[][]{{0.01f, 0.12f}, {0.35f, 0.22f}, {0.65f, -1.15f}};

    public BiomeGenFrozenTundra(int par1, byte par2) {
        super(par1, par2);
        this.field_76766_R = true;
        this.field_76765_S = false;
        this.field_76750_F = 0.1f;
        this.field_76751_G = 0.1f;
        this.field_76753_B = TragicBlocks.IcedDirt;
        this.field_76752_A = TragicBlocks.Permafrost;
        if (TragicConfig.allowCryse) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCryse.class, TragicConfig.cryseSC, TragicConfig.cryseGS[0], TragicConfig.cryseGS[1]));
        }
        if (TragicConfig.allowRagr) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityRagr.class, TragicConfig.ragrSC, TragicConfig.ragrGS[0], TragicConfig.ragrGS[1]));
        }
        if (TragicConfig.allowAbomination) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityAbomination.class, TragicConfig.abominationSC, TragicConfig.abominationGS[0], TragicConfig.abominationGS[1]));
        }
        if (TragicConfig.allowEmpariah) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityYeti.class, TragicConfig.empariahSC, 0, 0));
        }
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76798_D = 16;
        this.field_76760_I.field_76803_B = this.variant == 1 ? 12 : (this.variant == 2 ? 6 : 2);
        this.permafrostGen = new RuggedTerrainWorldGen(TragicBlocks.Permafrost, 1, TragicBlocks.Permafrost, 2, 2.0, 3.0, false, 8);
        this.iceSpikeGen = new SurfaceWorldGen2((byte)(this.variant == 2 ? 12 : 4), TragicBlocks.IceSpike, 0, 4, 8);
        this.pitGen = new PitWorldGen(TragicBlocks.IceSpike, 0, 12, 6, 4.0, 3.0);
        this.vineGen = new WorldGenCustomVine(TragicBlocks.Moss, 84);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 0 ? 6 : 2;
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        super.func_76728_a(world, rand, x, z);
        byte mew = (byte)(this.variant > 0 ? 18 : 6);
        for (byte a = 0; a < mew; a = (byte)(a + 1)) {
            int k = x + rand.nextInt(16) - 8;
            int l = z + rand.nextInt(16) - 8;
            this.vineGen.func_76484_a(world, rand, k, rand.nextInt(64) + 36, l);
        }
        this.permafrostGen.generate(rand, x / 16, z / 16, world);
        if (this.variant != 1) {
            this.iceSpikeGen.generate(rand, x / 16, z / 16, world);
        }
        new CustomSpikesWorldGen((byte)(this.variant == 2 ? 8 : (this.variant == 0 ? 2 : 4)), Blocks.field_150403_cj, 0, 0.89477735, 0.441114525, 1.0, 0.35, false, false).generate(rand, x / 16, z / 16, world);
        if (rand.nextInt(8) == 0) {
            this.pitGen.generate(rand, x / 16, z / 16, world);
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenTallGrass(TragicBlocks.Lichen, 0);
    }
}

