/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityDeathReaper;
import tragicneko.tragicmc.entity.mob.EntitySirv;
import tragicneko.tragicmc.worldgen.CustomSpikesWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.VoidPitWorldGen;

public class BiomeGenDecayingWasteland
extends TragicBiome {
    public final VoidPitWorldGen voidPitGen;
    public final RuggedTerrainWorldGen mixedDirtGen;
    public static final float[][] heights = new float[][]{{0.35f, 0.22f}, {0.05f, -0.35f}, {0.18f, 0.15f}, {0.75f, 0.35f}};

    public BiomeGenDecayingWasteland(int par1, byte par2) {
        super(par1, par2);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 50, 3, 5));
        if (TragicConfig.allowSirv) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySirv.class, TragicConfig.sirvSC, TragicConfig.sirvGS[0], TragicConfig.sirvGS[1]));
        }
        if (TragicConfig.allowSkultar) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityDeathReaper.class, TragicConfig.skultarSC, 0, 0));
        }
        this.field_76765_S = false;
        this.field_76766_R = false;
        this.field_76750_F = 0.6f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76760_I.field_76798_D = this.variant == 0 || this.variant == 3 ? 2 : 8;
        this.field_76753_B = TragicBlocks.DarkStone;
        this.field_76752_A = TragicBlocks.DeadDirt;
        this.field_76760_I.field_76798_D = 16;
        this.voidPitGen = new VoidPitWorldGen(3.5, 3.5);
        this.mixedDirtGen = new RuggedTerrainWorldGen(TragicBlocks.DeadDirt, 2, TragicBlocks.DeadDirt, 6, 3.0, 4.0, false, 8);
    }

    @Override
    public int getBushesFromBiomeType() {
        return this.variant == 0 ? 8 : 4;
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 1 ? 12 : 4;
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        super.func_76728_a(world, rand, x, z);
        new CustomSpikesWorldGen((byte)(this.variant == 3 ? 8 : 2), TragicBlocks.BoneBlock, (byte)rand.nextInt(2), 0.8977735, 0.441114525, 1.0, 0.35, false, false).generate(rand, x / 16, z / 16, world);
        this.mixedDirtGen.generate(rand, x / 16, z / 16, world);
        if (TragicConfig.allowVoidPitGen && rand.nextInt(200) >= 5 && rand.nextInt(6) == 0) {
            this.voidPitGen.generate(rand, x / 16, z / 16, world);
        }
    }
}

