/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.boss.EntityEnyvil;
import tragicneko.tragicmc.entity.mob.EntityInkling;
import tragicneko.tragicmc.entity.mob.EntityParasmite;
import tragicneko.tragicmc.entity.mob.EntityPlague;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.WorldGenDarkForestTree;

public class BiomeGenDarkForest
extends TragicBiome {
    public final SurfaceWorldGen drudgeGen;
    public final SurfaceWorldGen2 gasGen;
    public static final float[][] heights = new float[][]{{0.05f, 0.15f}, {0.32f, 0.32f}, {0.35f, -0.35f}};

    public BiomeGenDarkForest(int par1, byte par2) {
        super(par1, par2);
        this.field_76761_J.clear();
        if (TragicConfig.allowPlague) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityPlague.class, TragicConfig.plagueSC, TragicConfig.plagueGS[0], TragicConfig.plagueGS[1]));
        }
        if (TragicConfig.allowInkling) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityInkling.class, TragicConfig.inklingSC, TragicConfig.inklingGS[0], TragicConfig.inklingGS[1]));
        }
        if (TragicConfig.allowParasmite) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityParasmite.class, TragicConfig.parasmiteSC, TragicConfig.parasmiteGS[0], TragicConfig.parasmiteGS[1]));
        }
        if (TragicConfig.allowEnyvil) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnyvil.class, TragicConfig.enyvilSC, 0, 0));
        }
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 15, 2, 4));
        this.field_76753_B = TragicBlocks.DeadDirt;
        this.field_76752_A = TragicBlocks.DarkGrass;
        this.field_76750_F = 1.2f;
        this.field_76751_G = 1.5f;
        this.field_76760_I.field_76832_z = this.variant == 1 ? 8 : (this.variant == 2 ? 4 : 12);
        this.field_76760_I.field_76798_D = this.variant == 2 ? 12 : 2;
        this.field_76760_I.field_76803_B = this.variant == 1 ? 4 : 8;
        this.drudgeGen = new SurfaceWorldGen(3.0, 4.0, true, 24, TragicBlocks.Quicksand, 2, TragicBlocks.DarkGrass, true, true);
        this.gasGen = new SurfaceWorldGen2(8, TragicBlocks.DarkGas, 0, 4, 4);
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 2 ? 2 : 8;
    }

    public WorldGenerator func_76730_b(Random p_76730_1_) {
        return new WorldGenTallGrass(TragicBlocks.DarkTallGrass, 0);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return new WorldGenDarkForestTree();
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        super.func_76728_a(world, rand, x, z);
        this.gasGen.generate(rand, x / 16, z / 16, world);
        if (this.variant == 2) {
            this.drudgeGen.generate(rand, x / 16, z / 16, world);
        }
    }
}

