/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.miniboss.EntityJarra;
import tragicneko.tragicmc.entity.mob.EntityFusea;
import tragicneko.tragicmc.entity.mob.EntityTox;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.PitWorldGen;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.SurfacePlantWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen2;
import tragicneko.tragicmc.worldgen.VoidPitWorldGen;
import tragicneko.tragicmc.worldgen.WorldGenCustomVine;

public class BiomeGenCorrodedSteppe
extends TragicBiome {
    public final SurfaceWorldGen sludgeGen;
    public final RuggedTerrainWorldGen toxicCobbleGen;
    public final SurfaceWorldGen2 gasGen;
    public final VoidPitWorldGen voidPitGen;
    public final WorldGenCustomVine vineGen;
    public final SurfacePlantWorldGen deathglowGen;
    public static final float[][] heights = new float[][]{{0.05f, 0.03f}, {0.35f, 0.83f}, {0.01f, -0.53f}, {0.75f, -0.73f}, {0.01f, -1.25f}};

    public BiomeGenCorrodedSteppe(int par1, byte par2) {
        super(par1, par2);
        this.field_76766_R = false;
        this.field_76765_S = false;
        this.field_76750_F = 1.0f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76798_D = 16;
        this.field_76753_B = TragicBlocks.DarkCobblestone;
        this.field_76752_A = TragicBlocks.DarkCobblestone;
        if (TragicConfig.allowJarra) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityJarra.class, TragicConfig.jarraSC, TragicConfig.jarraGS[0], TragicConfig.jarraGS[1]));
        }
        if (TragicConfig.allowTox) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityTox.class, TragicConfig.toxSC, TragicConfig.toxGS[0], TragicConfig.toxGS[1]));
        }
        if (TragicConfig.allowFusea) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityFusea.class, TragicConfig.fuseaSC, TragicConfig.fuseaGS[0], TragicConfig.fuseaGS[1]));
        }
        this.sludgeGen = new SurfaceWorldGen(3.0, 1.5, true, 10, TragicBlocks.Quicksand, 3, TragicBlocks.DarkCobblestone, true, true);
        this.toxicCobbleGen = new RuggedTerrainWorldGen(TragicBlocks.DarkCobblestone, 2, TragicBlocks.DarkCobblestone, 6, 4.0, 3.0, false, 8);
        this.gasGen = new SurfaceWorldGen2((byte)(this.variant == 0 || this.variant == 4 ? 14 : (this.variant >= 3 ? 7 : 2)), TragicBlocks.RadiatedGas, 0, 4, 8);
        this.voidPitGen = new VoidPitWorldGen(2.5, 2.0);
        this.vineGen = new WorldGenCustomVine(TragicBlocks.WickedVine, 84);
        this.deathglowGen = new SurfacePlantWorldGen(2, TragicBlocks.Deathglow, 14, 4, 4, 2);
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        super.func_76728_a(world, rand, x, z);
        byte mew = (byte)(this.variant > 2 ? 4 : (this.variant == 2 ? 16 : 8));
        for (byte a = 0; a < mew; a = (byte)(a + 1)) {
            int k = x + rand.nextInt(16) - 8;
            int l = z + rand.nextInt(16) - 8;
            this.vineGen.func_76484_a(world, rand, k, rand.nextInt(64) + 42, l);
        }
        int Xcoord = x * 16 + rand.nextInt(16);
        int Zcoord = z * 16 + rand.nextInt(16);
        int Ycoord = rand.nextInt(236) + 10;
        ArrayList<int[]> cands = WorldHelper.getBlocksInSphericalRange(world, 3.75, Xcoord, Ycoord, Zcoord);
        boolean flag = true;
        for (int[] coords : cands) {
            Block block = world.func_147439_a(coords[0], coords[1], coords[2]);
            if (block.func_149662_c() && block.func_149688_o() != Material.field_151579_a && !block.func_149688_o().func_76224_d()) continue;
            flag = false;
            break;
        }
        if (flag) {
            cands = WorldHelper.getBlocksInSphericalRange(world, 2.75, Xcoord, Ycoord, Zcoord);
            for (int[] coords : cands) {
                world.func_147465_d(coords[0], coords[1], coords[2], TragicBlocks.ExplosiveGas, 0, 2);
            }
        }
        this.gasGen.generate(rand, x / 16, z / 16, world);
        if (this.variant > 2) {
            this.sludgeGen.generate(rand, x / 16, z / 16, world);
        }
        this.toxicCobbleGen.generate(rand, x / 16, z / 16, world);
        if (rand.nextInt(8) == 0) {
            boolean flag2 = rand.nextBoolean();
            new PitWorldGen(flag2 ? TragicBlocks.Quicksand : TragicBlocks.RadiatedGas, (byte)(flag2 ? 3 : 0), 12, 6, 4.0, 3.0).generate(rand, x / 16, z / 16, world);
        }
        if (TragicConfig.allowVoidPitGen && this.variant == 4 && rand.nextInt(200) >= 5) {
            this.voidPitGen.generate(rand, x / 16, z / 16, world);
        }
        if (rand.nextInt(8) == 0) {
            this.deathglowGen.generate(rand, x / 16, z / 16, world);
        }
    }
}

