/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen.biome;

import java.util.Random;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import tragicneko.tragicmc.TragicBiome;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.miniboss.EntityKragul;
import tragicneko.tragicmc.entity.mob.EntityGragul;
import tragicneko.tragicmc.entity.mob.EntityInkling;
import tragicneko.tragicmc.entity.mob.EntityNorVox;
import tragicneko.tragicmc.worldgen.RuggedTerrainWorldGen;
import tragicneko.tragicmc.worldgen.SurfaceWorldGen;
import tragicneko.tragicmc.worldgen.WorldGenAshenShrubs;
import tragicneko.tragicmc.worldgen.WorldGenAshenTree;

public class BiomeGenAshenHills
extends TragicBiome {
    public final SurfaceWorldGen shieldGen;
    public final RuggedTerrainWorldGen ruggedGen;
    public static final float[][] heights = new float[][]{{0.85f, 0.45f}, {0.45f, 0.25f}, {0.05f, 0.05f}};

    public BiomeGenAshenHills(int par1, byte par2) {
        super(par1, par2);
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 50, 3, 5));
        if (TragicConfig.allowInkling) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityInkling.class, TragicConfig.inklingSC, TragicConfig.inklingGS[0], TragicConfig.inklingGS[1]));
        }
        if (TragicConfig.allowGragul) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityGragul.class, TragicConfig.gragulSC, TragicConfig.gragulGS[0], TragicConfig.gragulGS[1]));
        }
        if (TragicConfig.allowKragul) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityKragul.class, TragicConfig.kragulSC, TragicConfig.kragulGS[0], TragicConfig.kragulGS[1]));
        }
        if (TragicConfig.allowNorVox) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityNorVox.class, TragicConfig.norVoxSC, TragicConfig.norVoxGS[0], TragicConfig.norVoxGS[1]));
        }
        this.field_76765_S = false;
        this.field_76766_R = false;
        this.field_76750_F = 1.6f;
        this.field_76751_G = 0.0f;
        this.field_76749_E = heights[this.variant][0];
        this.field_76748_D = heights[this.variant][1];
        this.field_76753_B = TragicBlocks.DarkStone;
        this.field_76752_A = TragicBlocks.AshenGrass;
        this.field_76760_I.field_76832_z = this.variant == 2 ? 1 : (this.variant == 1 ? 2 : 4);
        this.field_76760_I.field_76803_B = this.variant == 2 ? 3 : 1;
        this.shieldGen = new SurfaceWorldGen(3.0, 4.0, false, 0, TragicBlocks.DeadDirt, 1, TragicBlocks.AshenGrass, true, false);
        this.ruggedGen = new RuggedTerrainWorldGen(TragicBlocks.DeadDirt, 1, TragicBlocks.AshenGrass, 3, 3.0, 2.0, false, 8);
    }

    @Override
    public int getBushesFromBiomeType() {
        return 12;
    }

    @Override
    public int getFlowersFromBiomeType() {
        return this.variant == 2 ? 8 : 2;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (rand.nextInt(16) == 0) {
            return new WorldGenAshenShrubs();
        }
        return new WorldGenAshenTree(false);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return new WorldGenTallGrass(rand.nextInt(16) == 0 ? TragicBlocks.DriedGrass : TragicBlocks.AshenTallGrass, 0);
    }

    public void func_76728_a(World world, Random rand, int x, int z) {
        super.func_76728_a(world, rand, x, z);
        if (this.variant == 2) {
            this.shieldGen.generate(rand, x / 16, z / 16, world);
            this.ruggedGen.generate(rand, x / 16, z / 16, world);
        }
    }
}

