/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.blocks.BlockGenericGrass;
import tragicneko.tragicmc.util.WorldHelper;

public class WorldGenBleachedOakTree
extends WorldGenAbstractTree {
    private boolean isLargeTree;

    public WorldGenBleachedOakTree(boolean flag, boolean flag2) {
        super(flag);
        this.isLargeTree = flag;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int[] coords;
        double scale;
        Block block = world.func_147439_a(x, y, z);
        if (!(block instanceof BlockGenericGrass || block instanceof BlockGrass || block == Blocks.field_150346_d || block == TragicBlocks.DeadDirt || block instanceof BlockBush)) {
            return false;
        }
        double d = scale = this.isLargeTree ? rand.nextDouble() * 4.25 + 1.65 : rand.nextDouble() * 3.25 + 1.15;
        if (scale < 2.0) {
            return false;
        }
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(world, scale * 0.5, x, (double)(y + 1) + scale * 3.0 / 4.0, z);
        int y1 = 0;
        while ((double)y1 < 1.0 + scale * 3.0 / 4.0) {
            block = world.func_147439_a(x, y + y1, z);
            if (block.canBeReplacedByLeaves((IBlockAccess)world, x, y + y1, z)) {
                world.func_147449_b(x, y + y1, z, TragicBlocks.BleachedWood);
            }
            ++y1;
        }
        for (int i = 0; i < list.size(); ++i) {
            coords = list.get(i);
            block = world.func_147439_a(coords[0], coords[1], coords[2]);
            if (!block.canBeReplacedByLeaves((IBlockAccess)world, coords[0], coords[1], coords[2]) || block.func_149688_o() == Material.field_151575_d) continue;
            world.func_147449_b(coords[0], coords[1], coords[2], TragicBlocks.BleachedLeaves);
        }
        if (this.isLargeTree && scale > 3.0) {
            int i;
            double dif = rand.nextDouble() * 3.75 * (double)(rand.nextBoolean() ? -1 : 1);
            list = WorldHelper.getBlocksInSphericalRange(world, scale * 0.5, (double)x + dif, (double)(y + 1) + scale * 3.0 / 4.0, z);
            for (i = 0; i < list.size(); ++i) {
                coords = list.get(i);
                block = world.func_147439_a(coords[0], coords[1], coords[2]);
                if (!block.canBeReplacedByLeaves((IBlockAccess)world, coords[0], coords[1], coords[2]) || block.func_149688_o() == Material.field_151575_d) continue;
                world.func_147449_b(coords[0], coords[1], coords[2], TragicBlocks.BleachedLeaves);
            }
            world.func_147449_b((int)((double)x + dif), (int)((double)(y + 1) + scale * 2.0 / 3.0), z, TragicBlocks.BleachedWood);
            list = WorldHelper.getBlocksInSphericalRange(world, scale * 0.5, (double)x - dif, (double)(y + 1) + scale * 3.0 / 4.0, (double)z - dif);
            for (i = 0; i < list.size(); ++i) {
                coords = list.get(i);
                block = world.func_147439_a(coords[0], coords[1], coords[2]);
                if (!block.canBeReplacedByLeaves((IBlockAccess)world, coords[0], coords[1], coords[2]) || block.func_149688_o() == Material.field_151575_d) continue;
                world.func_147449_b(coords[0], coords[1], coords[2], TragicBlocks.BleachedLeaves);
            }
            world.func_147449_b((int)((double)x - dif), (int)((double)(y + 1) + scale * 2.0 / 3.0), (int)((double)z - dif), TragicBlocks.BleachedWood);
            list = WorldHelper.getBlocksInSphericalRange(world, scale * 0.5, (double)x + dif * 1.5, (double)(y + 1) + scale * 3.0 / 4.0, (double)z - dif * 0.5);
            for (i = 0; i < list.size(); ++i) {
                coords = list.get(i);
                block = world.func_147439_a(coords[0], coords[1], coords[2]);
                if (!block.canBeReplacedByLeaves((IBlockAccess)world, coords[0], coords[1], coords[2]) || block.func_149688_o() == Material.field_151575_d) continue;
                world.func_147449_b(coords[0], coords[1], coords[2], TragicBlocks.BleachedLeaves);
            }
            world.func_147449_b((int)((double)x + dif * 1.5), (int)((double)(y + 1) + scale * 2.0 / 3.0), (int)((double)z - dif * 0.5), TragicBlocks.BleachedWood);
        }
        return true;
    }
}

