/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.IWorldGen;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SurfaceWorldGen2
implements IWorldGen {
    public final byte iterations;
    public final Block block;
    public final byte meta;
    public final byte width;
    public final byte height;

    public SurfaceWorldGen2(byte iterations, Block block, byte meta, byte width, byte height) {
        this.iterations = iterations;
        this.block = block;
        this.meta = meta;
        this.width = width;
        this.height = height;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.allowScatteredSurfaceGen) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_72825_h(Xcoord, Zcoord);
        for (byte i = 0; i < this.iterations; i = (byte)(i + 1)) {
            Xcoord += random.nextInt(this.width) - random.nextInt(this.width);
            Zcoord += random.nextInt(this.width) - random.nextInt(this.width);
            if ((Ycoord += random.nextInt(this.height) - random.nextInt(this.height)) < 0 || Ycoord > 256) break;
            Block block = world.func_147439_a(Xcoord, Ycoord, Zcoord);
            if (!Structure.validBlocks.contains(block) && !block.canBeReplacedByLeaves((IBlockAccess)world, Xcoord, Ycoord, Zcoord) && !block.isAir((IBlockAccess)world, Xcoord, Ycoord, Zcoord) || !World.func_147466_a((IBlockAccess)world, (int)Xcoord, (int)(Ycoord - 1), (int)Zcoord) || block.func_149688_o().func_76224_d()) continue;
            world.func_147465_d(Xcoord, Ycoord, Zcoord, this.block, (int)this.meta, 2);
        }
    }
}

