/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.IWorldGen;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class SurfacePlantWorldGen
implements IWorldGen {
    public final byte iterations;
    public final Block block;
    public final byte meta;
    public final byte width;
    public final byte height;
    public final byte plantHeight;

    public SurfacePlantWorldGen(byte iterations, Block block, byte meta, byte width, byte height, byte plantHeight) {
        this.iterations = iterations;
        this.block = block;
        this.meta = meta;
        this.width = width;
        this.height = height;
        this.plantHeight = plantHeight;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.allowFruitGen) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_72825_h(Xcoord, Zcoord);
        for (byte i = 0; i < this.iterations; i = (byte)(i + 1)) {
            Xcoord += random.nextInt(this.width) - random.nextInt(this.width);
            Zcoord += random.nextInt(this.width) - random.nextInt(this.width);
            Ycoord += random.nextInt(this.height) - random.nextInt(this.height);
            byte pl = (byte)(random.nextInt(this.plantHeight) + 1);
            for (byte y1 = 0; y1 < pl && Ycoord + y1 >= 0 && Ycoord + y1 <= world.func_72940_L(); y1 = (byte)(y1 + 1)) {
                Block block = world.func_147439_a(Xcoord, Ycoord + y1, Zcoord);
                if (!Structure.validBlocks.contains(block) && !block.canBeReplacedByLeaves((IBlockAccess)world, Xcoord, Ycoord + y1, Zcoord) && !block.isAir((IBlockAccess)world, Xcoord, Ycoord + y1, Zcoord) || !this.block.func_149742_c(world, Xcoord, Ycoord + y1, Zcoord)) continue;
                world.func_147465_d(Xcoord, Ycoord + y1, Zcoord, this.block, (int)this.meta, 2);
            }
        }
    }
}

