/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class StructureWorldGen
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K || !world.func_72912_H().func_76089_r() || random.nextInt(500) > TragicConfig.structureOverallRarity || (world.field_73011_w.field_76574_g == TragicConfig.collisionID || world.field_73011_w.field_76574_g == TragicConfig.synapseID) && !TragicConfig.allowDimension) {
            return;
        }
        int x = chunkX * 16 + random.nextInt(16);
        int y = random.nextInt(118) + random.nextInt(118) + 10;
        int z = chunkZ * 16 + random.nextInt(16);
        int top = world.func_72825_h(x, z);
        ArrayList<Structure> cands = new ArrayList<Structure>();
        for (Structure s : Structure.structureList) {
            if (s == null || !s.isValidDimension(world.field_73011_w.field_76574_g) || (!s.isSurfaceStructure() || !s.areCoordsValidForGeneration(world, x, top, z, random)) && !s.areCoordsValidForGeneration(world, x, y, z, random)) continue;
            cands.add(s);
        }
        if (cands.isEmpty()) {
            return;
        }
        Collections.shuffle(cands, random);
        Iterator iterator = cands.iterator();
        while (iterator.hasNext()) {
            Structure s;
            if (!s.func_76484_a(world, random, x, (s = (Structure)((Object)iterator.next())).isSurfaceStructure() ? top : y, z)) continue;
            TragicMC.logInfo(s.getLocalizedName() + " succesfully generated at " + x + ", " + (s.isSurfaceStructure() ? top : y) + ", " + z);
            break;
        }
    }
}

