/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.worldgen.IWorldGen;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class StringWorldGen
implements IWorldGen {
    public final Block block;
    public final byte meta;
    public final byte iterations;

    public StringWorldGen(Block block, byte meta, byte iterations) {
        this.block = block;
        this.meta = meta;
        this.iterations = iterations;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.allowStringLightGen) {
            return;
        }
        int Xcoord = chunkX * 16;
        int Zcoord = chunkZ * 16;
        int Ycoord = world.func_72825_h(Xcoord, Zcoord) + random.nextInt(8) + 4;
        ArrayList<int[]> cands = new ArrayList<int[]>();
        for (byte i = 0; i < this.iterations; i = (byte)(i + 1)) {
            Block ablock;
            int[] cand = new int[]{Xcoord += random.nextInt(2) - random.nextInt(2), Ycoord += random.nextInt(2), Zcoord += random.nextInt(2) - random.nextInt(2)};
            if (cands.contains(cand) || !Structure.validBlocks.contains(ablock = world.func_147439_a(Xcoord, Ycoord, Zcoord)) && !ablock.canBeReplacedByLeaves((IBlockAccess)world, Xcoord, Ycoord, Zcoord) && !ablock.isAir((IBlockAccess)world, Xcoord, Ycoord, Zcoord)) continue;
            cands.add(cand);
        }
        for (int[] coords : cands) {
            world.func_147465_d(coords[0], coords[1], coords[2], this.block, (int)this.meta, 2);
        }
    }
}

