/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;

public class PitWorldGen
implements IWorldGen {
    public final Block block;
    public final byte meta;
    public final byte depth;
    public final byte depthVar;
    public final double radius;
    public final double variation;

    public PitWorldGen(Block block, byte meta, byte depth, byte depthVar, double radius, double variation) {
        this.block = block;
        this.meta = meta;
        this.depth = depth;
        this.depthVar = depthVar;
        this.radius = radius;
        this.variation = variation;
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.allowVoidPitGen) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16);
        int Ycoord = world.func_72825_h(Xcoord, Zcoord) - random.nextInt(10);
        int depth = Ycoord - this.depth - random.nextInt(this.depthVar + 1);
        ArrayList<int[]> cands = new ArrayList<int[]>();
        double size = this.variation * random.nextDouble() + this.radius;
        int pow = 0;
        while (pow + Ycoord >= depth && pow + Ycoord >= 0 && pow + Ycoord <= 256) {
            ArrayList<int[]> list;
            if (size >= 5.5) {
                list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                for (int[] coords : list) {
                    if (!random.nextBoolean() || cands.contains(coords)) continue;
                    cands.add(coords);
                }
            }
            list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
            for (int[] coords : list) {
                if (!random.nextBoolean() || cands.contains(coords)) continue;
                cands.add(coords);
            }
            list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
            for (int[] coords : list) {
                if (!random.nextBoolean() || cands.contains(coords)) continue;
                cands.add(coords);
            }
            if (size >= 3.0 && random.nextInt(4) == 0) {
                size *= 0.987425;
            }
            pow = (byte)(pow - 1);
        }
        for (int[] coords2 : cands) {
            if (coords2[1] > depth + 1) {
                world.func_147468_f(coords2[0], coords2[1], coords2[2]);
                continue;
            }
            world.func_147465_d(coords2[0], coords2[1], coords2[2], this.block, (int)this.meta, 2);
        }
    }
}

