/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.worldgen;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.IWorldGen;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class IsleWorldGen
implements IWorldGen {
    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (!TragicConfig.allowIsleGen) {
            return;
        }
        int Xcoord = chunkX * 16 + random.nextInt(16) - random.nextInt(16);
        int Zcoord = chunkZ * 16 + random.nextInt(16) - random.nextInt(16);
        int Ycoord = world.func_72825_h(Xcoord, Zcoord);
        byte relays = (byte)(1 + random.nextInt(3));
        double regression = 0.86977745;
        double cutoff = 0.48943755;
        ArrayList<int[]> cands = new ArrayList<int[]>();
        for (byte buzza = 0; buzza < relays; buzza = (byte)(buzza + 1)) {
            double size = random.nextDouble() * 4.5 + 2.5;
            Xcoord += random.nextInt(8) - random.nextInt(8);
            Zcoord += random.nextInt(8) - random.nextInt(8);
            int yMax = Ycoord;
            byte r = (byte)(16 + random.nextInt(16) - random.nextInt(8));
            Ycoord += r;
            yMax += r;
            for (int y1 = 0; y1 > -32 && !(size < cutoff); y1 = (int)((byte)(y1 - 1))) {
                size *= regression;
                if (random.nextInt(12) == 0) {
                    Xcoord += random.nextInt(2) - random.nextInt(2);
                    Zcoord += random.nextInt(2) - random.nextInt(2);
                }
                ArrayList<int[]> list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                for (int[] coords2 : list) {
                    Block block = world.func_147439_a(coords2[0], coords2[1], coords2[2]);
                    if (!Structure.validBlocks.contains(block) || cands.contains(coords2)) continue;
                    cands.add(coords2);
                }
            }
            for (int[] coords2 : cands) {
                if (coords2[1] >= yMax) {
                    world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.ErodedStone, 0, 2);
                    continue;
                }
                world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.DarkStone, 0, 2);
            }
            Ycoord = world.func_72825_h(Xcoord, Zcoord);
        }
    }
}

