/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicMC;

public class TragicEntityList {
    public static Map<String, Class> stringToClassMapping = new HashMap<String, Class>();
    public static Map<Class, String> classToStringMapping = new HashMap<Class, String>();
    public static Map<Integer, Class> IDtoClassMapping = new HashMap<Integer, Class>();
    private static Map<Class, Integer> classToIDMapping = new HashMap<Class, Integer>();
    public static Map<String, Integer> stringToIDMapping = new HashMap<String, Integer>();
    public static HashMap entityEggs = new LinkedHashMap();

    public static void addMapping(Class par0Class, String par1Str, int par2) {
        if (stringToClassMapping.containsKey(par1Str)) {
            throw new IllegalArgumentException("ID is already registered: " + par1Str);
        }
        if (IDtoClassMapping.containsKey(par2)) {
            throw new IllegalArgumentException("ID is already registered: " + par2);
        }
        stringToClassMapping.put(par1Str, par0Class);
        classToStringMapping.put(par0Class, par1Str);
        IDtoClassMapping.put(par2, par0Class);
        classToIDMapping.put(par0Class, par2);
        stringToIDMapping.put(par1Str, par2);
    }

    public static void addMapping(Class par0Class, String par1Str, int par2, int par3, int par4) {
        TragicEntityList.addMapping(par0Class, par1Str, par2);
        entityEggs.put(par2, new EntityEggInfo(par2, par3, par4, EnumEggType.NORMAL));
    }

    public static void addMapping(Class par0Class, String par1Str, int par2, int par3, int par4, EnumEggType eggType) {
        TragicEntityList.addMapping(par0Class, par1Str, par2);
        entityEggs.put(par2, new EntityEggInfo(par2, par3, par4, eggType));
    }

    public static Entity createEntityByName(String par0Str, World par1World) {
        Entity entity = null;
        try {
            Class oclass = stringToClassMapping.get(par0Str);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound par0NBTTagCompound, World par1World) {
        Entity entity = null;
        if ("Minecart".equals(par0NBTTagCompound.func_74779_i("id"))) {
            switch (par0NBTTagCompound.func_74762_e("Type")) {
                case 0: {
                    par0NBTTagCompound.func_74778_a("id", "MinecartRideable");
                    break;
                }
                case 1: {
                    par0NBTTagCompound.func_74778_a("id", "MinecartChest");
                    break;
                }
                case 2: {
                    par0NBTTagCompound.func_74778_a("id", "MinecartFurnace");
                }
            }
            par0NBTTagCompound.func_82580_o("Type");
        }
        Class oclass = null;
        try {
            oclass = stringToClassMapping.get(par0NBTTagCompound.func_74779_i("id"));
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            try {
                entity.func_70020_e(par0NBTTagCompound);
            }
            catch (Exception e) {
                TragicMC.logError("An Entity " + par0NBTTagCompound.func_74779_i("id") + "(" + oclass.getName() + ") has thrown an exception during loading, its state cannot be restored. Report this.");
                entity = null;
            }
        } else {
            TragicMC.logWarning("Skipping Entity with id " + par0NBTTagCompound.func_74779_i("id"));
        }
        return entity;
    }

    public static Entity createEntityByID(int par0, World par1World) {
        Entity entity = null;
        try {
            Class oclass = TragicEntityList.getClassFromID(par0);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(par1World);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            TragicMC.logWarning("Skipping Entity with id " + par0);
        }
        return entity;
    }

    public static int getEntityID(Entity par0Entity) {
        Class<?> oclass = par0Entity.getClass();
        return classToIDMapping.containsKey(oclass) ? classToIDMapping.get(oclass) : 0;
    }

    public static Class getClassFromID(int par0) {
        return IDtoClassMapping.get(par0);
    }

    public static String getEntityString(Entity par0Entity) {
        return classToStringMapping.get(par0Entity.getClass());
    }

    public static String getStringFromID(int par0) {
        Class oclass = TragicEntityList.getClassFromID(par0);
        return oclass != null ? classToStringMapping.get(oclass) : null;
    }

    public static void func_151514_a() {
    }

    public static Set func_151515_b() {
        return Collections.unmodifiableSet(stringToIDMapping.keySet());
    }

    public static enum EnumEggType {
        NORMAL,
        PET,
        MINIBOSS,
        BOSS,
        ALPHA;

    }

    public static class EntityEggInfo {
        public final int spawnedID;
        public final int primaryColor;
        public final int secondaryColor;
        public final EnumEggType eggType;

        public EntityEggInfo(int par1, int par2, int par3, EnumEggType eggType) {
            this.spawnedID = par1;
            this.primaryColor = par2;
            this.secondaryColor = par3;
            this.eggType = eggType;
        }
    }
}

