/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.properties;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import tragicneko.tragicmc.entity.EntityPet;

public class PropertyMisc
implements IExtendedEntityProperties {
    public static final String propertyName = "TragicMC.Misc";
    private final EntityLivingBase theEntity;
    public int bleedOutTime = 0;
    public int recoveryTime = 0;
    public int golemTimer = 0;
    public int frozenInputs = 0;
    public boolean isFrozen = false;
    public EntityPet currentPet = null;
    private boolean hasBeenGeared = false;
    private boolean hasBeenBuffed = false;

    public PropertyMisc(EntityLivingBase ent) {
        this.theEntity = ent;
    }

    public static final void register(EntityLivingBase ent) {
        ent.registerExtendedProperties(propertyName, (IExtendedEntityProperties)new PropertyMisc(ent));
    }

    public static final PropertyMisc get(EntityLivingBase ent) {
        return (PropertyMisc)ent.getExtendedProperties(propertyName);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("bleedOut", this.bleedOutTime);
        tag.func_74768_a("recoveryTime", this.recoveryTime);
        tag.func_74757_a("hasBeenGeared", this.hasBeenGeared);
        tag.func_74757_a("hasBeenBuffed", this.hasBeenBuffed);
        tag.func_74757_a("isFrozen", this.isFrozen);
        tag.func_74768_a("frozenInputs", this.frozenInputs);
        compound.func_74782_a(propertyName, (NBTBase)tag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = (NBTTagCompound)compound.func_74781_a(propertyName);
        if (tag != null) {
            this.bleedOutTime = tag.func_74762_e("bleedOut");
            this.recoveryTime = tag.func_74762_e("recoveryTime");
            this.hasBeenGeared = tag.func_74767_n("hasBeenGeared");
            this.hasBeenBuffed = tag.func_74767_n("hasBeenBuffed");
            this.isFrozen = tag.func_74767_n("isFrozen");
            this.frozenInputs = tag.func_74762_e("frozenInputs");
        }
    }

    public void init(Entity entity, World world) {
        PropertyMisc misc;
        if (entity instanceof EntityLivingBase && (misc = PropertyMisc.get((EntityLivingBase)entity)) != null) {
            misc.loadNBTData(new NBTTagCompound());
        }
    }

    public void onUpdate() {
        if (this.getCurrentPet() != null && this.theEntity instanceof EntityPlayer) {
            this.getCurrentPet().owner = (EntityPlayer)this.theEntity;
        }
        if (this.golemTimer > 0) {
            --this.golemTimer;
        }
    }

    public EntityPet getCurrentPet() {
        return this.currentPet;
    }

    public void setCurrentPet(EntityPet pet) {
        this.currentPet = pet;
    }

    public boolean hasBeenGeared() {
        return this.hasBeenGeared;
    }

    public void setGeared() {
        this.hasBeenGeared = true;
    }

    public boolean hasBeenBuffed() {
        return this.hasBeenBuffed;
    }

    public void setBuffed() {
        this.hasBeenBuffed = true;
    }
}

