/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.properties;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.network.MessageDoom;

public class PropertyDoom
implements IExtendedEntityProperties {
    public static final String propertyName = "TragicMC.Doom";
    private final EntityPlayer thePlayer;
    private int doomCooldown;
    private int tick;
    private int cooldownTick;
    private int maxDoom;
    private int currentDoom;
    private boolean hasUpgraded;

    public PropertyDoom(EntityPlayer player) {
        this.thePlayer = player;
        this.doomCooldown = 0;
        this.maxDoom = TragicConfig.maxDoomStart;
        this.currentDoom = 0;
        this.hasUpgraded = false;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(propertyName, (IExtendedEntityProperties)new PropertyDoom(player));
    }

    public static final PropertyDoom get(EntityPlayer player) {
        return (PropertyDoom)player.getExtendedProperties(propertyName);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("doomCooldown", this.doomCooldown);
        properties.func_74768_a("doomAmount", this.currentDoom);
        properties.func_74768_a("maxDoom", this.maxDoom);
        properties.func_74757_a("hasUpgraded", this.hasUpgraded);
        compound.func_74782_a(propertyName, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(propertyName);
        if (properties != null) {
            this.doomCooldown = properties.func_74762_e("doomCooldown");
            this.maxDoom = properties.func_74762_e("maxDoom");
            this.currentDoom = properties.func_74762_e("doomAmount");
            this.hasUpgraded = properties.func_74767_n("hasUpgraded");
        }
        if (this.maxDoom < TragicConfig.maxDoomStart || !this.hasUpgraded && this.maxDoom > TragicConfig.maxDoomStart) {
            this.maxDoom = TragicConfig.maxDoomStart;
        }
    }

    public void init(Entity entity, World world) {
        PropertyDoom doom;
        if (entity instanceof EntityPlayer && (doom = PropertyDoom.get((EntityPlayer)entity)) != null) {
            doom.loadNBTData(new NBTTagCompound());
        }
    }

    public void onUpdate() {
        if (this.getCurrentDoom() < 0) {
            this.setCurrentDoom(0);
        }
        if (this.getCurrentDoom() > this.getMaxDoom()) {
            this.setCurrentDoom(this.getMaxDoom());
        }
        if (this.getCurrentCooldown() < 0) {
            this.setCooldown(0);
        }
        if (this.shouldDecrementCooldown()) {
            --this.doomCooldown;
        } else if (this.shouldRecoverNaturally()) {
            int doom = this.getCurrentDoom();
            int increment = TragicConfig.doomRechargeAmount;
            if (doom >= this.getMaxDoom()) {
                return;
            }
            if (increment + doom >= this.getMaxDoom()) {
                this.fillDoom();
            } else {
                this.currentDoom += increment;
            }
        }
    }

    public boolean shouldDecrementCooldown() {
        if (this.getCurrentCooldown() < 0) {
            this.setCooldown(0);
        }
        if (this.getCurrentCooldown() > 0) {
            ++this.cooldownTick;
            if (this.cooldownTick >= 8) {
                this.cooldownTick = 0;
                return true;
            }
        }
        return false;
    }

    public int getCurrentCooldown() {
        return this.doomCooldown;
    }

    public void setCooldown(int cooldown) {
        this.doomCooldown = TragicConfig.allowCooldown ? cooldown : 0;
    }

    public void increaseCooldown(int cooldown) {
        this.doomCooldown = TragicConfig.allowCooldown ? (this.doomCooldown += cooldown) : 0;
    }

    public int getCurrentDoom() {
        return this.currentDoom;
    }

    public int getMaxDoom() {
        return this.maxDoom;
    }

    public void increaseDoom(int amount) {
        if (amount > 0 && this.getCurrentCooldown() > 0) {
            return;
        }
        if (this.getCurrentDoom() + amount >= this.getMaxDoom()) {
            this.fillDoom();
        } else if (this.getCurrentDoom() + amount <= 0) {
            this.emptyDoom();
        } else {
            this.setCurrentDoom(this.getCurrentDoom() + amount);
        }
    }

    public void increaseConsumptionLevel() {
        this.hasUpgraded = true;
        if (this.getMaxDoom() + TragicConfig.doomConsumeAmount <= TragicConfig.maxDoomAmount) {
            this.setMaxDoom(this.getMaxDoom() + TragicConfig.doomConsumeAmount);
        } else {
            this.setMaxDoom(TragicConfig.maxDoomAmount);
        }
        if (this.thePlayer instanceof EntityPlayerMP) {
            TragicMC.net.sendTo((IMessage)new MessageDoom(this.thePlayer), (EntityPlayerMP)this.thePlayer);
        }
    }

    protected void setCurrentDoom(int amount) {
        if (amount < 0) {
            amount = 0;
        }
        if (amount > this.getMaxDoom()) {
            amount = this.getMaxDoom();
        }
        this.currentDoom = amount;
        if (this.thePlayer instanceof EntityPlayerMP) {
            TragicMC.net.sendTo((IMessage)new MessageDoom(this.thePlayer), (EntityPlayerMP)this.thePlayer);
        }
    }

    protected void setMaxDoom(int amount) {
        if (amount < 0) {
            amount = 0;
        }
        this.maxDoom = amount;
        if (this.thePlayer instanceof EntityPlayerMP) {
            TragicMC.net.sendTo((IMessage)new MessageDoom(this.thePlayer), (EntityPlayerMP)this.thePlayer);
        }
    }

    public void decreaseDoomAmountAndApplyCooldown(int amount, int cooldown) {
        this.increaseCooldown(cooldown);
        this.increaseDoom(-amount);
    }

    public void emptyDoom() {
        this.setCurrentDoom(0);
    }

    public void fillDoom() {
        this.setCurrentDoom(this.getMaxDoom());
    }

    public void partiallyFillDoom(float partial) {
        int partialAmount = (int)(partial * (float)this.getMaxDoom());
        if (this.getCurrentDoom() + partialAmount > this.getMaxDoom()) {
            this.fillDoom();
        } else {
            this.increaseDoom(partialAmount);
        }
    }

    protected boolean shouldRecoverWithDamage() {
        return TragicConfig.allowDoomPainRecharge && this.getCurrentDoom() < this.getMaxDoom();
    }

    protected boolean shouldRecoverNaturally() {
        if (this.getCurrentCooldown() != 0) {
            return false;
        }
        ++this.tick;
        if (TragicConfig.allowNaturalRecharge && this.getCurrentDoom() < this.getMaxDoom() && this.tick >= 100 / TragicConfig.doomRechargeRate) {
            this.tick = 0;
            return true;
        }
        return false;
    }

    public void applyDoomPainRecharge(float source) {
        if (this.shouldRecoverWithDamage()) {
            if ((source = MathHelper.func_76131_a((float)(source / 10.0f), (float)0.0f, (float)6.0f)) < 1.0f) {
                if (TragicMC.rand.nextFloat() < source) {
                    this.increaseDoom(1);
                }
            } else if (source < 2.0f) {
                if (TragicMC.rand.nextFloat() * 2.0f < source) {
                    this.increaseDoom(1);
                }
            } else if (source < 3.0f) {
                this.increaseDoom(2);
            } else if (source < 4.0f) {
                this.increaseDoom(3);
            } else if (source < 5.0f) {
                this.increaseDoom(5);
            } else {
                this.increaseDoom(6);
            }
            if (this.thePlayer instanceof EntityPlayerMP) {
                TragicMC.net.sendTo((IMessage)new MessageDoom(this.thePlayer), (EntityPlayerMP)this.thePlayer);
            }
        }
    }

    public EntityPlayer getPlayer() {
        return this.thePlayer;
    }
}

