/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items.weapons;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.properties.PropertyDoom;
import tragicneko.tragicmc.util.LoreHelper;

public class TragicWeapon
extends ItemSword {
    protected final Doomsday doomsday;
    protected Doomsday doomsday2;
    public Item.ToolMaterial material;
    public float ascensionLevel;

    public TragicWeapon(Item.ToolMaterial material, Doomsday dday) {
        super(material);
        this.doomsday = dday;
        this.func_77637_a(TragicMC.Survival);
        this.material = material;
    }

    public TragicWeapon(Item.ToolMaterial material, Doomsday dday, Doomsday dday2) {
        this(material, dday);
        this.doomsday2 = dday2;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int rarity = stack.func_77942_o() && stack.field_77990_d.func_74764_b("tragicLoreRarity") ? stack.field_77990_d.func_74762_e("tragicLoreRarity") : 0;
        return EnumRarity.values()[rarity];
    }

    public Doomsday getDoomsday() {
        return this.doomsday;
    }

    public Doomsday.EnumDoomType doomsdayType() {
        return this.doomsday.doomsdayType;
    }

    public TragicWeapon setAscensionLevel(float f) {
        this.ascensionLevel = f;
        return this;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        String lore;
        if (TragicConfig.allowRandomWeaponLore && LoreHelper.getRarityFromStack(stack) >= 0 && (lore = LoreHelper.getDescFromStack(stack)) != null) {
            LoreHelper.splitDesc(par2List, lore, 32, LoreHelper.getFormatForRarity(LoreHelper.getRarityFromStack(stack)));
            par2List.add("");
        }
        if (TragicConfig.allowDoomsdays && this.doomsday != null) {
            EnumChatFormatting format;
            if (this.doomsday2 != null) {
                format = this.doomsday2.getDoomsdayType().getFormat();
                par2List.add(format + this.doomsday2.getLocalizedType() + ": " + this.doomsday2.getLocalizedName());
                par2List.add(EnumChatFormatting.GOLD + "Doom Cost: " + this.doomsday2.getScaledDoomRequirement(par2EntityPlayer.field_70170_p));
                par2List.add(EnumChatFormatting.DARK_AQUA + "Cooldown: " + this.doomsday2.getScaledCooldown(par2EntityPlayer.field_70170_p.field_73013_u));
                par2List.add("");
            }
            format = this.doomsday.getDoomsdayType().getFormat();
            par2List.add(format + this.doomsday.getLocalizedType() + ": " + this.doomsday.getLocalizedName());
            par2List.add(EnumChatFormatting.GOLD + "Doom Cost: " + this.doomsday.getScaledDoomRequirement(par2EntityPlayer.field_70170_p));
            par2List.add(EnumChatFormatting.DARK_AQUA + "Cooldown: " + this.doomsday.getScaledCooldown(par2EntityPlayer.field_70170_p.field_73013_u));
            par2List.add("");
        }
        if (this.ascensionLevel > 0.0f) {
            par2List.add(EnumChatFormatting.LIGHT_PURPLE + "Ascension Level: " + this.ascensionLevel);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int numb, boolean flag) {
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        TragicWeapon.updateAsWeapon(stack, world, entity, numb, flag);
    }

    public static void updateAsWeapon(ItemStack stack, World world, Entity entity, int numb, boolean flag) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.field_77990_d.func_74764_b("cooldown")) {
            stack.field_77990_d.func_74768_a("cooldown", 0);
        }
        if (TragicWeapon.getStackCooldown(stack) > 0) {
            TragicWeapon.setStackCooldown(stack, TragicWeapon.getStackCooldown(stack) - 1);
        }
        if (!TragicConfig.allowRandomWeaponLore || stack.func_77973_b() == null) {
            return;
        }
        LoreHelper.LoreEntry entry = LoreHelper.getLoreEntry(stack.func_77973_b().getClass());
        if (entry == null) {
            return;
        }
        LoreHelper.Lore lore = entry.getRandomLore();
        if (lore == null) {
            return;
        }
        if (!stack.field_77990_d.func_74764_b("tragicLoreRarity")) {
            stack.field_77990_d.func_74774_a("tragicLoreRarity", Byte.valueOf((byte)lore.getRarity()).byteValue());
        }
        if (!stack.field_77990_d.func_74764_b("tragicLoreDesc")) {
            stack.field_77990_d.func_74778_a("tragicLoreDesc", lore.getDesc());
        }
        byte rarity = stack.field_77990_d.func_74771_c("tragicLoreRarity");
        lore = entry.getLoreOfRarity(rarity);
        if (!stack.func_77948_v() && lore != null) {
            LoreHelper.EnchantEntry[] enchants = entry.getEnchantmentsForRarity(rarity);
            if (enchants == null) {
                return;
            }
            for (LoreHelper.EnchantEntry e : enchants) {
                if (e == null || e.getEnchantment() == null) continue;
                stack.func_77966_a(e.getEnchantment(), e.getEnchantLevel());
            }
        }
    }

    public static boolean canUseAbility(PropertyDoom doom, int rq) {
        return doom != null && TragicConfig.allowNonDoomsdayAbilities && doom.getCurrentCooldown() == 0 && doom.getCurrentDoom() >= rq;
    }

    public static void setStackCooldown(ItemStack stack, int i) {
        if (!stack.func_77942_o()) {
            return;
        }
        stack.field_77990_d.func_74768_a("cooldown", i);
    }

    public static int getStackCooldown(ItemStack stack) {
        return stack.func_77942_o() && stack.field_77990_d.func_74764_b("cooldown") ? stack.field_77990_d.func_74762_e("cooldown") : 0;
    }

    public Doomsday getSecondaryDoomsday() {
        return this.doomsday2;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase entity2) {
        if (entity instanceof EntityPlayer && !TragicConfig.allowPvP) {
            return false;
        }
        return super.func_77644_a(stack, entity, entity2);
    }
}

