/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items.armor;

import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.util.LoreHelper;

public class TragicArmor
extends ItemArmor {
    public final Doomsday doomsday;
    private IIcon damagedIcon;

    public TragicArmor(ItemArmor.ArmorMaterial material, int armorType, Doomsday dday) {
        super(material, 0, armorType);
        this.doomsday = dday;
        this.func_77637_a(TragicMC.Survival);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        int rarity = stack.func_77942_o() && stack.field_77990_d.func_74764_b("tragicLoreRarity") ? stack.field_77990_d.func_74762_e("tragicLoreRarity") : 0;
        return EnumRarity.values()[rarity];
    }

    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        this.damagedIcon = register.func_94245_a(this.field_111218_cA + "2");
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= this.func_77612_l() * 2 / 3) {
            return this.damagedIcon;
        }
        return this.field_77791_bV;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        String lore;
        if (TragicConfig.allowRandomWeaponLore && LoreHelper.getRarityFromStack(stack) >= 0 && (lore = LoreHelper.getDescFromStack(stack)) != null) {
            LoreHelper.splitDesc(par2List, lore, 32, LoreHelper.getFormatForRarity(LoreHelper.getRarityFromStack(stack)));
            par2List.add("");
        }
        if (TragicConfig.allowDoomsdays && this.doomsday != null) {
            EnumChatFormatting format = this.doomsday.getDoomsdayType().getFormat();
            par2List.add(format + this.doomsday.getLocalizedType() + ": " + this.doomsday.getLocalizedName());
            par2List.add(EnumChatFormatting.GOLD + "Doom Cost: " + this.doomsday.getScaledDoomRequirement(par2EntityPlayer.field_70170_p));
            par2List.add(EnumChatFormatting.DARK_AQUA + "Cooldown: " + this.doomsday.getScaledCooldown(par2EntityPlayer.field_70170_p.field_73013_u));
            par2List.add("");
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int numb, boolean flag) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!TragicConfig.allowRandomWeaponLore) {
            return;
        }
        LoreHelper.LoreEntry entry = LoreHelper.getLoreEntry(stack.func_77973_b().getClass());
        if (entry == null) {
            return;
        }
        LoreHelper.Lore lore = entry.getRandomLore();
        if (lore == null) {
            return;
        }
        if (!stack.field_77990_d.func_74764_b("tragicLoreRarity")) {
            stack.field_77990_d.func_74774_a("tragicLoreRarity", Byte.valueOf((byte)lore.getRarity()).byteValue());
        }
        if (!stack.field_77990_d.func_74764_b("tragicLoreDesc")) {
            stack.field_77990_d.func_74778_a("tragicLoreDesc", lore.getDesc() == null ? "" : lore.getDesc());
        }
        byte rarity = stack.field_77990_d.func_74771_c("tragicLoreRarity");
        lore = entry.getLoreOfRarity(rarity);
        if (!stack.func_77948_v() && lore != null) {
            LoreHelper.EnchantEntry[] enchants = entry.getEnchantmentsForArmor(rarity, this.field_77881_a);
            if (enchants == null) {
                return;
            }
            for (LoreHelper.EnchantEntry e : enchants) {
                if (e == null || e.getEnchantment() == null) continue;
                stack.func_77966_a(e.getEnchantment(), e.getEnchantLevel());
            }
        }
    }
}

