/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items.amulet;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.properties.PropertyAmulets;
import tragicneko.tragicmc.util.AmuletHelper;

public class ItemAmulet
extends Item {
    private IIcon[][] iconArray = new IIcon[4][2];
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_BLACK = 0;
    public static Set<ItemAmulet> cursedAmulets = new HashSet<ItemAmulet>();
    public static Set<ItemAmulet> epicAmulets = new HashSet<ItemAmulet>();
    private final int chainColor;
    private final int amuletColor;
    public final EnumAmuletType amuletType;
    public final String amuletName;

    public ItemAmulet(String name, EnumAmuletType type, int chain, int amulet) {
        this.amuletName = name;
        this.amuletType = type;
        this.chainColor = chain;
        this.amuletColor = amulet;
        this.func_77655_b("tragicmc.amulet" + name);
        this.func_77637_a(TragicMC.Survival);
        this.func_77625_d(1);
        if (type == EnumAmuletType.CURSED) {
            cursedAmulets.add(this);
        } else if (type == EnumAmuletType.EPIC) {
            epicAmulets.add(this);
        }
    }

    public ItemAmulet(String name, EnumAmuletType type) {
        this(name, type, 0xFFFFFF, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        if (this.amuletType == EnumAmuletType.CURSED || this.amuletType == EnumAmuletType.EPIC) {
            return true;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("amuletLevel") && stack.func_77978_p().func_74771_c("amuletLevel") >= 3;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        int i;
        int n = i = stack != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("amuletLevel") ? (int)stack.func_77978_p().func_74771_c("amuletLevel") : ItemAmulet.getDefaultLevels(this.amuletType);
        if (this.amuletType != EnumAmuletType.NORMAL) {
            i = 4;
        }
        return this.iconArray[MathHelper.func_76125_a((int)i, (int)1, (int)4) - 1][pass > 0 ? 1 : 0];
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        if (this.amuletType == EnumAmuletType.CURSED || this.amuletType == EnumAmuletType.EPIC) {
            return EnumRarity.epic;
        }
        byte i = stack.func_77942_o() && stack.func_77978_p().func_74764_b("amuletLevel") ? stack.func_77978_p().func_74771_c("amuletLevel") : ItemAmulet.getDefaultLevels(this.amuletType);
        switch (i) {
            case 1: {
                return EnumRarity.common;
            }
            case 2: {
                return EnumRarity.uncommon;
            }
            case 3: {
                return EnumRarity.rare;
            }
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        byte i = stack.func_77942_o() && stack.func_77978_p().func_74764_b("amuletLevel") ? stack.func_77978_p().func_74771_c("amuletLevel") : ItemAmulet.getDefaultLevels(this.amuletType);
        String specialName = StatCollector.func_74838_a((String)(this.amuletName.toLowerCase() + i + ".special"));
        par2List.add(EnumChatFormatting.RED + specialName);
        String s = "Amulet Level: ";
        String s1 = this.getFormatFromLevel(i) + s + (this.amuletType == EnumAmuletType.EPIC ? "Epic" : (this.amuletType == EnumAmuletType.CURSED ? "Cursed" : Byte.valueOf(i)));
        if (s1 != null) {
            par2List.add(s1);
        }
    }

    public EnumChatFormatting getFormatFromLevel(byte i) {
        if (this.amuletType == EnumAmuletType.CURSED) {
            return EnumChatFormatting.DARK_RED;
        }
        if (this.amuletType == EnumAmuletType.EPIC) {
            return EnumChatFormatting.GOLD;
        }
        return i == 1 ? EnumChatFormatting.AQUA : (i == 2 ? EnumChatFormatting.BLUE : (i == 3 ? EnumChatFormatting.DARK_BLUE : EnumChatFormatting.WHITE));
    }

    public int func_77612_l() {
        return 300;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int par2) {
        if (par2 == 0) {
            return this.amuletColor;
        }
        return this.chainColor;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister regi) {
        for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
            this.iconArray[i][0] = regi.func_94245_a("tragicmc:Amulet" + (i + 1));
            this.iconArray[i][1] = regi.func_94245_a("tragicmc:Amulet" + (i + 1) + "_overlay");
        }
    }

    public byte getAmuletLevel(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("amuletLevel") ? stack.func_77978_p().func_74771_c("amuletLevel") : (byte)0;
    }

    public String getAmuletName() {
        return this.amuletName;
    }

    public static byte getDefaultLevels(EnumAmuletType type) {
        return type == EnumAmuletType.CURSED || type == EnumAmuletType.EPIC ? (byte)3 : 1;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int numb, boolean flag) {
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.func_77978_p().func_74764_b("amuletLevel")) {
            stack.func_77978_p().func_74774_a("amuletLevel", ItemAmulet.getDefaultLevels(this.amuletType));
        }
        if (TragicConfig.allowAmuletModifiers && !stack.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            ItemAmulet.applyModifiersToItemStack(stack);
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        PropertyAmulets amu = PropertyAmulets.get(player);
        for (int i = 0; i < amu.inventory.func_70302_i_(); ++i) {
            if (amu.inventory.func_70301_a(i) != null || amu.getSlotsOpen() == 1 && (i == 1 || i == 2) || amu.getSlotsOpen() == 2 && i == 2) continue;
            if (!world.field_72995_K) {
                amu.inventory.func_70299_a(i, stack.func_77946_l());
            }
            stack.field_77994_a = 0;
            break;
        }
        return stack;
    }

    public static void applyModifiersToItemStack(ItemStack stack) {
        NBTTagCompound tag;
        NBTTagList taglist = new NBTTagList();
        IAttribute atr = AmuletHelper.getRandomAttribute();
        AttributeModifier mod = AmuletHelper.getRandomModifier(atr);
        if (stack == null || !(stack.func_77973_b() instanceof ItemAmulet)) {
            return;
        }
        ItemAmulet amulet = (ItemAmulet)stack.func_77973_b();
        if (field_77697_d.nextInt(100) <= TragicConfig.amuletModChance || amulet.amuletType == EnumAmuletType.CURSED) {
            stack.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)taglist);
            return;
        }
        if (mod != null) {
            tag = AmuletHelper.writeAttributeModifierToNBT(atr.func_111108_a(), mod);
            taglist.func_74742_a((NBTBase)tag);
        }
        atr = AmuletHelper.getRandomAttribute();
        mod = AmuletHelper.getRandomModifier(atr);
        if (field_77697_d.nextInt(100) <= TragicConfig.amuletModChance2) {
            stack.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)taglist);
            return;
        }
        if (mod != null) {
            tag = AmuletHelper.writeAttributeModifierToNBT(atr.func_111108_a(), mod);
            taglist.func_74742_a((NBTBase)tag);
        }
        atr = AmuletHelper.getRandomAttribute();
        mod = AmuletHelper.getRandomModifier(atr);
        if (field_77697_d.nextInt(100) <= TragicConfig.amuletModChance3) {
            stack.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)taglist);
            return;
        }
        if (mod != null) {
            tag = AmuletHelper.writeAttributeModifierToNBT(atr.func_111108_a(), mod);
            taglist.func_74742_a((NBTBase)tag);
        }
        stack.func_77978_p().func_74782_a("AttributeModifiers", (NBTBase)taglist);
    }

    public void onAmuletUpdate(PropertyAmulets amu, EntityPlayer player, World world, byte slot, byte level) {
    }

    protected final void damageAmulet(PropertyAmulets amu, byte slot, byte level) {
        amu.damageStackInSlot(slot, 4 - level);
    }

    public static enum EnumAmuletType {
        NORMAL,
        CURSED,
        EPIC;

    }

    public static class AmuletModifier
    extends SharedMonsterAttributes {
        public static final IAttribute reach = new RangedAttribute("tragicmc.reach", 0.0, -1.7976931348623157E308, Double.MAX_VALUE).func_111117_a("Reach").func_111112_a(true);
        public static final IAttribute jumpHeight = new RangedAttribute("tragicmc.jumpHeight", 1.4, 0.0, Double.MAX_VALUE).func_111117_a("Jump Height").func_111112_a(true);
        public static final IAttribute resistance = new RangedAttribute("tragicmc.resistance", 0.0, -1.7976931348623157E308, Double.MAX_VALUE).func_111117_a("Resistance").func_111112_a(true);
        public static final IAttribute luck = new RangedAttribute("tragicmc.luck", 0.0, -1.7976931348623157E308, Double.MAX_VALUE).func_111117_a("Luck").func_111112_a(true);
    }
}

