/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.items;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenForest;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.entity.EntityDirectedLightning;
import tragicneko.tragicmc.util.WorldHelper;
import tragicneko.tragicmc.worldgen.WorldGenAshenTree;
import tragicneko.tragicmc.worldgen.WorldGenBleachedTree;
import tragicneko.tragicmc.worldgen.WorldGenLargePaintedTree;
import tragicneko.tragicmc.worldgen.WorldGenPaintedTree;
import tragicneko.tragicmc.worldgen.structure.Structure;

public class ItemGenerator
extends Item {
    private String[] subNames = new String[]{"VoidPitGenerator", "SpikeGenerator", "StarCrystalGenerator", "SphereGenerator", "SphereEraser", "LiquidRemover", "TreeGenerator", "LightningSummoner", "ExplosionGenerator", "IsleGenerator", "DirectedLightningSummoner", "PitGenerator"};
    private String[] textureNames = new String[]{"voidPitGenerator", "spikeGenerator", "starCrystalGenerator", "sphereGenerator", "sphereEraser", "liquidRemover", "treeGenerator", "lightningSummoner", "explosionGenerator", "isleGenerator", "directedLightningSummoner", "pitGenerator"};
    private IIcon[] iconArray = new IIcon[this.subNames.length];

    public ItemGenerator() {
        this.func_77637_a(TragicMC.Creative);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("tragicmc.worldGen");
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par2List, boolean par4) {
        par2List.add("Generate some of the WorldGen features!");
        par2List.add("Some of this is really CPU intensive.");
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        Random random = world.field_73012_v;
        int meta = stack.func_77960_j();
        Vec3 vec = WorldHelper.getVecFromEntity((Entity)player, 100.0);
        int Xcoord = MathHelper.func_76128_c((double)vec.field_72450_a);
        int Ycoord = MathHelper.func_76128_c((double)vec.field_72448_b);
        int Zcoord = MathHelper.func_76128_c((double)vec.field_72449_c);
        block0 : switch (meta) {
            case 0: {
                String[] names = TragicConfig.voidPitFilter;
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a(s);
                    if (block == null) continue;
                    filter.add(block);
                }
                if (!TragicConfig.voidPitUsesFilter) {
                    filter.clear();
                }
                double size = TragicConfig.voidPitSize;
                int pow = 0;
                while (pow + Ycoord >= 0 && pow + Ycoord <= 256) {
                    int[] coords;
                    int mapping;
                    ArrayList<int[]> list;
                    if (size >= 5.5) {
                        list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                        for (mapping = 0; mapping < list.size(); ++mapping) {
                            coords = list.get(mapping);
                            if (random.nextInt(2) == 0 || filter.contains(world.func_147439_a(coords[0], coords[1], coords[2]))) continue;
                            world.func_147468_f(coords[0], coords[1], coords[2]);
                        }
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (random.nextInt(2) == 0 || filter.contains(world.func_147439_a(coords[0], coords[1], coords[2]))) continue;
                        world.func_147468_f(coords[0], coords[1], coords[2]);
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (random.nextInt(2) == 0 || filter.contains(world.func_147439_a(coords[0], coords[1], coords[2]))) continue;
                        world.func_147468_f(coords[0], coords[1], coords[2]);
                    }
                    --pow;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Void pit generated with size of " + size));
                break;
            }
            case 3: {
                String[] names = TragicConfig.sphereFilter;
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a(s);
                    if (block == Blocks.field_150350_a) continue;
                    filter.add(block);
                }
                double size = TragicConfig.sphereSize;
                ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord, Zcoord);
                Block ablock = TragicConfig.sphereGenUsesFilter && filter.size() > 0 ? (Block)filter.toArray()[field_77697_d.nextInt(filter.size())] : Block.func_149729_e((int)random.nextInt(4096));
                int attempts = 0;
                if (!TragicConfig.sphereGenUsesFilter) {
                    while (!ablock.func_149662_c() && !(ablock instanceof BlockBreakable) || ablock.hasTileEntity(0) || ablock instanceof BlockFalling) {
                        ablock = Block.func_149729_e((int)random.nextInt(4096));
                        if ((attempts = (int)((byte)(attempts + 1))) <= 40) continue;
                    }
                    if (!ablock.func_149662_c() && !(ablock instanceof BlockBreakable) || ablock.hasTileEntity(0) || ablock instanceof BlockFalling) {
                        ablock = Blocks.field_150335_W;
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    int[] coords = list.get(i);
                    world.func_147449_b(coords[0], coords[1], coords[2], ablock);
                }
                if (list.isEmpty() || ablock == null) break;
                String s = ablock.func_149739_a();
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Sphere generated with size of " + size + " made of " + StatCollector.func_74838_a((String)(s + ".name"))));
                break;
            }
            case 4: {
                String[] names = TragicConfig.eraserFilter;
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a(s);
                    if (block == Blocks.field_150350_a) continue;
                    filter.add(block);
                }
                ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(world, TragicConfig.eraserSize, Xcoord, Ycoord, Zcoord);
                for (int i = 0; i < list.size(); ++i) {
                    int[] coords = list.get(i);
                    if (TragicConfig.eraserUsesFilter && filter.contains(world.func_147439_a(coords[0], coords[1], coords[2]))) continue;
                    world.func_147468_f(coords[0], coords[1], coords[2]);
                }
                if (list.isEmpty()) break;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Spherical area erased."));
                break;
            }
            case 5: {
                ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(world, TragicConfig.eraserSize, Xcoord, Ycoord, Zcoord);
                for (int i = 0; i < list.size(); ++i) {
                    int[] coords = list.get(i);
                    if (!(world.func_147439_a(coords[0], coords[1], coords[2]) instanceof BlockLiquid)) continue;
                    world.func_147468_f(coords[0], coords[1], coords[2]);
                }
                if (list.isEmpty()) break;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Spherical area of liquid removed."));
                break;
            }
            case 6: {
                Object object;
                switch (random.nextInt(14)) {
                    default: {
                        object = new WorldGenForest(true, false);
                        break;
                    }
                    case 0: {
                        object = new WorldGenBigTree(true);
                        break;
                    }
                    case 1: {
                        object = new WorldGenSavannaTree(true);
                        break;
                    }
                    case 2: {
                        object = new WorldGenCanopyTree(true);
                        break;
                    }
                    case 3: {
                        object = new WorldGenMegaJungle(true, 10, 20, 3, 3);
                        break;
                    }
                    case 4: {
                        object = new WorldGenMegaPineTree(false, random.nextBoolean());
                        break;
                    }
                    case 5: {
                        object = new WorldGenTaiga2(true);
                        break;
                    }
                    case 6: {
                        object = new WorldGenTrees(true, 4 + random.nextInt(7), 3, 3, false);
                        break;
                    }
                    case 7: {
                        object = new WorldGenBleachedTree(true, random.nextBoolean());
                        break;
                    }
                    case 8: {
                        object = new WorldGenAshenTree(true);
                        break;
                    }
                    case 9: {
                        object = new WorldGenLargePaintedTree(true, random.nextInt(3) + 4, 10);
                        break;
                    }
                    case 10: {
                        object = new WorldGenPaintedTree(true, random.nextBoolean());
                    }
                }
                for (int y1 = 1; y1 < 4; ++y1) {
                    for (int z1 = -1; z1 < 2; ++z1) {
                        for (int x1 = -1; x1 < 2; ++x1) {
                            world.func_147468_f(Xcoord + x1, Ycoord + y1, Zcoord + z1);
                        }
                    }
                }
                if (object.func_76484_a(world, random, Xcoord, Ycoord, Zcoord)) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Tree generated successfully"));
                    break;
                }
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Tree generation failed."));
                break;
            }
            case 1: {
                String[] names = TragicConfig.spikeFilter;
                HashSet<Block> filter = new HashSet<Block>();
                for (String s : names) {
                    Block block = (Block)Block.field_149771_c.func_82594_a(s);
                    if (block == Blocks.field_150350_a) continue;
                    filter.add(block);
                }
                if (!TragicConfig.spikeGenUsesFilter) {
                    filter.clear();
                }
                double size = TragicConfig.spikeSize;
                Block spike = filter.isEmpty() ? TragicBlocks.DarkStone : (Block)filter.toArray()[field_77697_d.nextInt(filter.size())];
                int blockMeta = TragicConfig.spikeGenUsesFilter && !filter.isEmpty() ? 0 : 14;
                int spikeType = random.nextInt(2);
                boolean flag = false;
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Spike of type " + spikeType + " and size of " + size + " generated."));
                for (int y1 = 0; y1 < 256; ++y1) {
                    if (random.nextBoolean()) {
                        size *= TragicConfig.spikeRegression;
                        if (random.nextInt(3) == 0 && size >= 0.4888233) {
                            Xcoord += random.nextInt(2) - random.nextInt(2);
                            Zcoord += random.nextInt(2) - random.nextInt(2);
                        }
                        if (spikeType == 1 && !flag && y1 >= 35 && y1 <= 70 && random.nextBoolean() && size <= 0.774446314) {
                            size *= 2.86333567;
                            flag = true;
                        }
                    }
                    if (size < TragicConfig.spikeCutoff || Ycoord + y1 > 256) break block0;
                    ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                    for (int j = 0; j < list.size(); ++j) {
                        int[] coords = list.get(j);
                        world.func_147465_d(coords[0], coords[1], coords[2], spike, blockMeta, 2);
                    }
                }
                break;
            }
            case 2: {
                double size = 0.35 * random.nextDouble() + 0.75;
                int blockMeta2 = random.nextInt(16);
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "Star Crystal with size of " + size + " generated."));
                for (int y1 = 0; y1 < 12 && !((size *= 0.91377745) < 0.444443755) && Ycoord + y1 <= 256; ++y1) {
                    ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(world, size, Xcoord, (double)(Ycoord + y1) + size * 0.5, Zcoord);
                    for (int j = 0; j < list.size(); ++j) {
                        int[] coords = list.get(j);
                        world.func_147465_d(coords[0], coords[1], coords[2], TragicBlocks.StarCrystal, blockMeta2, 2);
                    }
                }
                break;
            }
            case 7: {
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)Xcoord, (double)Ycoord, (double)Zcoord));
                player.func_145747_a((IChatComponent)new ChatComponentText("Lightning created."));
                break;
            }
            case 8: {
                float f = (float)TragicConfig.explosionBaseSize + (float)TragicConfig.explosionSizeVariation * field_77697_d.nextFloat();
                world.func_72876_a((Entity)player, (double)Xcoord, (double)Ycoord, (double)Zcoord, f, WorldHelper.getMobGriefing(world));
                player.func_145747_a((IChatComponent)new ChatComponentText("Explosion created with size of " + f));
                break;
            }
            case 9: {
                double regression = 0.88977745;
                double cutoff = 0.48943755;
                ArrayList<int[]> cands = new ArrayList<int[]>();
                double size = random.nextDouble() * 3.5 + 1.5;
                int yMax = Ycoord = world.func_72825_h(Xcoord += random.nextInt(8) - random.nextInt(8), Zcoord += random.nextInt(8) - random.nextInt(8)) + 1 + random.nextInt(18) + 10;
                for (int y1 = 0; y1 > -32 && !(size < cutoff); --y1) {
                    size *= regression;
                    if (random.nextBoolean() && random.nextInt(6) == 0) {
                        Xcoord += random.nextInt(2) - random.nextInt(2);
                        Zcoord += random.nextInt(2) - random.nextInt(2);
                    }
                    ArrayList<int[]> list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + y1, Zcoord);
                    for (int[] coords2 : list) {
                        Block block = world.func_147439_a(coords2[0], coords2[1], coords2[2]);
                        if (!Structure.validBlocks.contains(block) || cands.contains(coords2)) continue;
                        if (yMax < coords2[1]) {
                            yMax = coords2[1];
                        }
                        cands.add(coords2);
                    }
                }
                int rand = random.nextInt(4) + 2;
                for (int[] coords2 : cands) {
                    if (coords2[1] >= yMax) {
                        world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.ErodedStone, 0, 2);
                        continue;
                    }
                    if (coords2[1] >= yMax - rand - random.nextInt(2)) {
                        world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.DeadDirt, 0, 2);
                        continue;
                    }
                    world.func_147465_d(coords2[0], coords2[1], coords2[2], TragicBlocks.DarkStone, 0, 2);
                }
                break;
            }
            case 10: {
                EntityDirectedLightning lightning = new EntityDirectedLightning(world, Xcoord, Ycoord, Zcoord, (Entity)player);
                lightning.func_70107_b(Xcoord, Ycoord, Zcoord);
                world.func_72838_d((Entity)lightning);
                player.func_145747_a((IChatComponent)new ChatComponentText("Directed Lightning created!"));
                break;
            }
            case 11: {
                int depth = Ycoord - 10 - random.nextInt(10);
                double size = 3.0 * random.nextDouble() + 3.0;
                ArrayList<int[]> cands = new ArrayList<int[]>();
                int pow = 0;
                while (pow + Ycoord >= depth && pow + Ycoord >= 0 && pow + Ycoord <= 256) {
                    int[] coords;
                    int mapping;
                    ArrayList<int[]> list;
                    if (size >= 5.5) {
                        list = WorldHelper.getBlocksInCircularRange(world, size * 0.31773, Xcoord, Ycoord + pow, Zcoord);
                        for (mapping = 0; mapping < list.size(); ++mapping) {
                            coords = list.get(mapping);
                            if (!random.nextBoolean() || cands.contains(coords)) continue;
                            cands.add(coords);
                        }
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size * 0.64773, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (!random.nextBoolean() || cands.contains(coords)) continue;
                        cands.add(coords);
                    }
                    list = WorldHelper.getBlocksInCircularRange(world, size, Xcoord, Ycoord + pow, Zcoord);
                    for (mapping = 0; mapping < list.size(); ++mapping) {
                        coords = list.get(mapping);
                        if (!random.nextBoolean() || cands.contains(coords)) continue;
                        cands.add(coords);
                    }
                    if (size >= 3.0 && random.nextInt(4) == 0) {
                        size *= 0.987425;
                    }
                    --pow;
                }
                Block block = random.nextBoolean() ? TragicBlocks.IceSpike : (random.nextBoolean() ? Blocks.field_150356_k : (random.nextBoolean() ? TragicBlocks.RadiatedGas : TragicBlocks.Quicksand));
                int m = block == TragicBlocks.Quicksand && random.nextBoolean() ? 3 : 0;
                for (int[] coords2 : cands) {
                    if (coords2[1] > depth + 1) {
                        world.func_147468_f(coords2[0], coords2[1], coords2[2]);
                        continue;
                    }
                    world.func_147465_d(coords2[0], coords2[1], coords2[2], block, m, 3);
                }
                player.func_145747_a((IChatComponent)new ChatComponentText("Pit generated using " + block.func_149739_a() + " as the bottom."));
            }
        }
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon func_77617_a(int damage) {
        if (damage >= this.iconArray.length) {
            damage = this.iconArray.length - 1;
        }
        return this.iconArray[damage];
    }

    public void func_94581_a(IIconRegister register) {
        for (int i = 0; i < this.subNames.length; ++i) {
            this.iconArray[i] = register.func_94245_a("tragicmc:" + this.subNames[i]);
        }
    }

    public String func_77667_c(ItemStack itemstack) {
        int damage = itemstack.func_77960_j();
        if (damage >= this.subNames.length) {
            damage = this.subNames.length - 1;
        }
        return this.func_77658_a() + "." + this.textureNames[damage];
    }
}

