/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.events;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.network.MessageDoom;
import tragicneko.tragicmc.properties.PropertyDoom;

public class DoomEvents {
    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            PropertyDoom doom = PropertyDoom.get((EntityPlayer)event.entity);
            if (doom == null) {
                PropertyDoom.register((EntityPlayer)event.entity);
            } else {
                doom.loadNBTData(new NBTTagCompound());
            }
            if (event.entity instanceof EntityPlayerMP && doom != null) {
                TragicMC.net.sendTo((IMessage)new MessageDoom((EntityPlayer)event.entity), (EntityPlayerMP)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PropertyDoom doom;
        if (event.entityLiving instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && (doom = PropertyDoom.get((EntityPlayer)event.entityLiving)) != null) {
            doom.onUpdate();
            if (event.entityLiving instanceof EntityPlayerMP) {
                TragicMC.net.sendTo((IMessage)new MessageDoom((EntityPlayer)event.entity), (EntityPlayerMP)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(PlayerEvent.Clone event) {
        if (!event.entity.field_70170_p.field_72995_K && TragicConfig.allowDoom && PropertyDoom.get(event.original) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            PropertyDoom.get(event.original).saveNBTData(tag);
            PropertyDoom.get(event.entityPlayer).loadNBTData(tag);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttack(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer && TragicConfig.allowDoomPainRecharge && !event.entityLiving.field_70170_p.field_72995_K) {
            PropertyDoom properties = PropertyDoom.get((EntityPlayer)event.entityLiving);
            properties.applyDoomPainRecharge(event.ammount);
        }
        if (event.entityLiving instanceof EntityMob && TragicConfig.allowDoomPainRecharge && event.source.func_76346_g() instanceof EntityLivingBase && event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            PropertyDoom properties = PropertyDoom.get(player);
            properties.applyDoomPainRecharge(event.ammount);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(PlayerEvent.Clone event) {
        if (event.entityLiving instanceof EntityPlayerMP && !event.wasDeath) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityLiving;
            TragicMC.net.sendTo((IMessage)new MessageDoom((EntityPlayer)player), player);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.entityLiving instanceof EntityMob && TragicConfig.allowDoomKillRecharge && event.source.func_76346_g() instanceof EntityLivingBase && event.source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76346_g();
            PropertyDoom properties = PropertyDoom.get(player);
            properties.increaseDoom(TragicConfig.doomRechargeAmount);
        }
    }
}

