/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.Calendar;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.miniboss.EntityGreaterStin;
import tragicneko.tragicmc.entity.miniboss.EntityJarra;
import tragicneko.tragicmc.entity.miniboss.EntityKragul;
import tragicneko.tragicmc.entity.miniboss.EntityMagmox;
import tragicneko.tragicmc.entity.miniboss.EntityMegaCryse;
import tragicneko.tragicmc.entity.miniboss.EntityStinKing;
import tragicneko.tragicmc.entity.miniboss.EntityStinQueen;
import tragicneko.tragicmc.entity.miniboss.EntityVoxStellarum;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.projectile.EntityProjectile;
import tragicneko.tragicmc.items.weapons.TragicWeapon;
import tragicneko.tragicmc.util.EntityDropHelper;

public abstract class TragicMob
extends EntityMob {
    protected TragicMiniBoss superiorForm;
    private int supportID = -1;
    private int supportAmp = 1;

    public TragicMob(World par1World) {
        super(par1World);
    }

    protected boolean canCorrupt() {
        return true;
    }

    protected boolean canChange() {
        return this.superiorForm != null && TragicConfig.allowMobTransformation;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)0);
    }

    public int getCorruptionTicks() {
        return this.field_70180_af.func_75679_c(15);
    }

    protected void setCorruptionTicks(int i) {
        this.field_70180_af.func_75692_b(15, (Object)i);
    }

    protected void incrementCorruptionTicks() {
        int pow = this.getCorruptionTicks();
        this.setCorruptionTicks(++pow);
    }

    public boolean isChanging() {
        return this.field_70180_af.func_75683_a(14) == 1;
    }

    public boolean isSupport() {
        return this.field_70180_af.func_75683_a(13) == 1;
    }

    public void setSupport(boolean flag) {
        this.field_70180_af.func_75692_b(13, (Object)(flag ? (byte)1 : 0));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.isChanging()) {
                this.func_70656_aK();
            }
            if (this.isSupport() && this.field_70170_p.field_73013_u == EnumDifficulty.HARD) {
                double d = 0.35;
                double d2 = 0.35;
                for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1);
                    this.field_70170_p.func_72869_a("redstone", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, 0.6, 0.2, 0.6);
                    this.field_70170_p.func_72869_a("redstone", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2);
                    this.field_70170_p.func_72869_a("redstone", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2);
                    this.field_70170_p.func_72869_a("redstone", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N * 1.25, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2, this.field_70146_Z.nextDouble() * d + d2);
                }
            }
            return;
        }
        if (this.isChanging() && this.field_70173_aa > 1) {
            this.change();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.HARD && this.isSupport() && this.field_70173_aa % 30 == 0) {
            if (this.supportID < 0) {
                this.supportID = this.getRandomPotionID();
                this.supportAmp = this.field_70146_Z.nextInt(2);
            }
            if (Potion.field_76425_a[this.supportID] != null) {
                PotionEffect effect = new PotionEffect(this.supportID, 300, this.supportAmp);
                this.func_70690_d(effect);
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0));
                for (Entity e : list) {
                    if (!(e instanceof EntityMob) || !this.func_70685_l(e) || ((EntityMob)e).func_70638_az() == this) continue;
                    ((EntityMob)e).func_70690_d(effect);
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (!TragicConfig.allowMobInfighting && this.func_70638_az() != null && (this.func_70638_az() instanceof TragicMob || this.func_70638_az() instanceof TragicBoss)) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() == null && this.canCorrupt() && TragicConfig.allowCorruption && this.func_82165_m(TragicPotion.Corruption.field_76415_H)) {
            EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
            EntityPlayer result = null;
            if (entityplayer != null && this.func_70685_l((Entity)entityplayer)) {
                result = entityplayer;
            } else {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    if (!this.func_70685_l(entity) || entity == this || entity instanceof EntityWither || entity instanceof EntityDragon || entity instanceof TragicBoss || entity.getClass() == ((Object)((Object)this)).getClass()) continue;
                    if (entity instanceof TragicMob && TragicConfig.allowMobInfighting) {
                        if (this.superiorForm != null && entity != this.superiorForm && entity.getClass() != this.getLesserForm()) {
                            result = entity;
                            break;
                        }
                        if (entity.getClass() == this.getLesserForm() || this.superiorForm != null) continue;
                        result = entity;
                        break;
                    }
                    if (!(entity instanceof EntityAnimal)) continue;
                    result = entity;
                    break;
                }
                this.func_70624_b((EntityLivingBase)result);
            }
        }
        if (TragicConfig.allowCorruption) {
            if (this.func_70644_a(TragicPotion.Corruption)) {
                this.incrementCorruptionTicks();
            } else {
                this.setCorruptionTicks(this.getCorruptionTicks() - 1);
            }
            if (this.canChange() && this.getCorruptionTicks() >= 400 && this.field_70146_Z.nextInt(200) <= TragicConfig.mobTransformationChance && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(4) == 0) {
                this.field_70180_af.func_75692_b(14, (Object)1);
            }
        } else if (this.canChange() && this.field_70173_aa >= 6000 && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(100) <= TragicConfig.mobTransformationChance) {
            this.field_70180_af.func_75692_b(14, (Object)1);
        }
    }

    protected void change() {
        if (this.isChangeAllowed()) {
            TragicMob boss = (TragicMob)((Object)this.getSuperiorForm());
            boss.func_82141_a((Entity)this, true);
            boss.func_82149_j((Entity)this);
            this.field_70170_p.func_72900_e((Entity)this);
            this.field_70170_p.func_72838_d((Entity)boss);
            boss.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, 200, 2));
            boss.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, 200, 2));
            boss.field_70180_af.func_75692_b(14, (Object)0);
            boss.func_85030_a("tragicmc:random.change", 1.0f, 1.0f);
        }
    }

    protected TragicMiniBoss getSuperiorForm() {
        return this.superiorForm;
    }

    protected abstract boolean isChangeAllowed();

    public boolean isCorrupted() {
        return this.getCorruptionTicks() > 0;
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || TragicConfig.allowStun && this.func_70644_a(TragicPotion.Stun)) {
            return false;
        }
        Boolean result = super.func_70652_k(par1Entity);
        if (result.booleanValue() && TragicConfig.allowCorruption && this.canCorrupt() && this.field_70146_Z.nextInt(4) == 0 && this.func_70644_a(TragicPotion.Corruption)) {
            if (par1Entity instanceof TragicMob && ((TragicMob)par1Entity).canCorrupt()) {
                ((TragicMob)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 600, 1));
            } else if (par1Entity instanceof EntityMob && !(par1Entity instanceof TragicMob)) {
                ((EntityMob)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 600, 1));
            } else if (par1Entity instanceof EntityAnimal) {
                ((EntityAnimal)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 400, 1));
            } else if (par1Entity instanceof EntityPlayer && !((EntityPlayer)par1Entity).field_71075_bZ.field_75098_d) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Corruption.field_76415_H, 200, 1));
            }
        }
        return result;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("corruptionTicks")) {
            this.setCorruptionTicks(tag.func_74762_e("corruptionTicks"));
        }
        if (tag.func_74764_b("changeState")) {
            this.field_70180_af.func_75692_b(14, (Object)tag.func_74771_c("changeState"));
        }
        if (tag.func_74764_b("support")) {
            this.setSupport(tag.func_74771_c("support") == 1);
        }
        if (tag.func_74764_b("supportID")) {
            this.supportID = tag.func_74762_e("supportID");
        }
        if (tag.func_74764_b("supportAmp")) {
            this.supportAmp = tag.func_74762_e("supportAmp");
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("corruptionTicks", this.getCorruptionTicks());
        tag.func_74774_a("changeState", this.field_70180_af.func_75683_a(14));
        tag.func_74774_a("support", this.isSupport() ? (byte)1 : 0);
        tag.func_74768_a("supportID", this.supportID);
        tag.func_74768_a("supportAmp", this.supportAmp);
    }

    public boolean getMobGriefing() {
        return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
    }

    public boolean getAllowLoot() {
        return this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    protected void func_70609_aI() {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ == 20) {
            if (!this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.getAllowLoot()) {
                int j;
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            this.func_70656_aK();
        }
    }

    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K) {
            int x = this.getDropAmount() + l;
            int drops = 0;
            for (int i = 0; i < x; ++i) {
                ItemStack drop;
                if (this.field_70146_Z.nextInt(100) <= TragicConfig.commonDropRate + x * 4) {
                    ItemStack itemStack = drop = this.isMobVariant() ? EntityDropHelper.getDropFromVariant(((Object)((Object)this)).getClass(), true) : EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), true);
                    if (drop != null) {
                        this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                    }
                    ++drops;
                }
                if (flag && this.field_70146_Z.nextInt(100) <= TragicConfig.rareDropRate + x) {
                    ItemStack itemStack = drop = this.isMobVariant() ? EntityDropHelper.getDropFromVariant(((Object)((Object)this)).getClass(), false) : EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), false);
                    if (drop != null) {
                        this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                    }
                    ++drops;
                }
                if ((double)drops > (double)x * 2.5) break;
            }
            if (!TragicConfig.allowMobStatueDrops) {
                return;
            }
            int id = 0;
            if (this instanceof EntityJarra) {
                id = 6;
            } else if (this instanceof EntityKragul) {
                id = 7;
            } else if (this instanceof EntityMagmox) {
                id = 8;
            } else if (this instanceof EntityMegaCryse) {
                id = 9;
            } else if (this instanceof EntityStinKing) {
                id = 10;
            } else if (this instanceof EntityStinQueen) {
                id = 11;
            } else if (this instanceof EntityGreaterStin) {
                id = 12;
            } else if (this instanceof EntityVoxStellarum) {
                id = 13;
            }
            if (id != 0 && this.field_70146_Z.nextInt(100) <= TragicConfig.mobStatueDropChance && flag) {
                this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, id)));
            }
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            if (TragicConfig.allowAchievements && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.kill);
                if (this instanceof TragicMiniBoss) {
                    player.func_71029_a((StatBase)TragicAchievements.killMiniBoss);
                }
            }
        }
    }

    public boolean isMobVariant() {
        return false;
    }

    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        int i = (int)(entity.func_110138_aP() * 20.0f);
        if (entity instanceof EntityPlayer) {
            i *= 20;
        }
        this.func_70690_d(new PotionEffect(Potion.field_76420_g.field_76415_H, i, 2));
        this.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, i, 2));
    }

    public Class<? extends TragicMob> getLesserForm() {
        return ((Object)((Object)this)).getClass();
    }

    public boolean func_70686_a(Class par1Class) {
        return super.func_70686_a(par1Class) && par1Class != TragicBoss.class && this instanceof TragicMiniBoss ? par1Class != this.getLesserForm() : true;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.HARD && TragicConfig.allowRandomSupportMob) {
            this.setSupport(this.field_70146_Z.nextInt(100) == 0);
        }
        if (!TragicConfig.allowGroupBuffs) {
            return super.func_110161_a(data);
        }
        if (data == null) {
            if (this.field_70146_Z.nextInt(200) <= TragicConfig.groupBuffChance) {
                int id = this.getRandomPotionID();
                PotionEffect effect = new PotionEffect(id, 99999, this.field_70146_Z.nextInt(2));
                this.func_70690_d(effect);
                return new GroupBuff(effect);
            }
        } else if (data instanceof GroupBuff) {
            this.func_70690_d(((GroupBuff)data).getReducedEffect());
            return super.func_110161_a(data);
        }
        return super.func_110161_a(data);
    }

    private int getRandomPotionID() {
        int id = Potion.field_76420_g.field_76415_H;
        switch (this.field_70146_Z.nextInt(12)) {
            default: {
                break;
            }
            case 1: {
                id = Potion.field_76424_c.field_76415_H;
                break;
            }
            case 2: {
                id = Potion.field_76441_p.field_76415_H;
                break;
            }
            case 3: {
                id = this.func_70668_bt() == EnumCreatureAttribute.UNDEAD ? Potion.field_76436_u.field_76415_H : Potion.field_76428_l.field_76415_H;
                break;
            }
            case 4: {
                id = Potion.field_76426_n.field_76415_H;
                break;
            }
            case 5: {
                id = Potion.field_76429_m.field_76415_H;
                break;
            }
            case 6: {
                id = Potion.field_76430_j.field_76415_H;
                break;
            }
            case 7: {
                id = TragicConfig.allowImmunity ? TragicPotion.Immunity.field_76415_H : Potion.field_76422_e.field_76415_H;
                break;
            }
            case 8: {
                id = TragicConfig.allowClarity ? TragicPotion.Clarity.field_76415_H : Potion.field_76429_m.field_76415_H;
                break;
            }
            case 9: {
                id = TragicConfig.allowResurrection ? TragicPotion.Resurrection.field_76415_H : Potion.field_76422_e.field_76415_H;
                break;
            }
            case 10: {
                id = TragicConfig.allowAquaSuperiority ? TragicPotion.AquaSuperiority.field_76415_H : Potion.field_76430_j.field_76415_H;
            }
        }
        return id;
    }

    public int getDropAmount() {
        return 1;
    }

    protected Entity fireProjectileAtEntity(Entity entity, Entity target, float dispersal) {
        entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        entity.func_70107_b(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f), this.field_70161_v);
        if (entity instanceof EntityProjectile) {
            ((EntityProjectile)entity).shootingEntity = this;
        } else if (entity instanceof EntityFireball) {
            ((EntityFireball)entity).field_70235_a = this;
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.field_70163_u - this.field_70163_u + (double)target.field_70131_O * 0.5 - (double)(this.field_70131_O * 2.0f / 3.0f);
        double d2 = target.field_70161_v - this.field_70161_v;
        float mf = entity instanceof EntityProjectile ? ((EntityProjectile)entity).getMotionFactor() : (entity instanceof EntityWitherSkull && ((EntityWitherSkull)entity).func_82342_d() ? 0.73f : 0.95f);
        float dist = this.func_70032_d((Entity)this.func_70638_az());
        if (this.field_70170_p.field_73013_u.func_151525_a() > 2) {
            d0 += target.field_70159_w * (double)dist / (double)mf;
            d1 += (target.field_70181_x + 0.09) * (double)dist / (double)mf;
            d2 += target.field_70179_y * (double)dist / (double)mf;
        }
        float f = MathHelper.func_76129_c((float)dist) * dispersal;
        double d3 = MathHelper.func_76133_a((double)((d0 += (double)f * this.field_70146_Z.nextGaussian()) * d0 + d1 * d1 + (d2 += (double)f * this.field_70146_Z.nextGaussian()) * d2));
        if (entity instanceof EntityProjectile) {
            ((EntityProjectile)entity).accelerationX = d0 / d3 * 0.1;
            ((EntityProjectile)entity).accelerationY = d1 / d3 * 0.1;
            ((EntityProjectile)entity).accelerationZ = d2 / d3 * 0.1;
        } else if (entity instanceof EntityFireball) {
            ((EntityFireball)entity).field_70232_b = d0 / d3 * 0.1;
            ((EntityFireball)entity).field_70233_c = d1 / d3 * 0.1;
            ((EntityFireball)entity).field_70230_d = d2 / d3 * 0.1;
        }
        this.field_70170_p.func_72838_d(entity);
        return entity;
    }

    public boolean func_70097_a(DamageSource src, float dmg) {
        ItemStack stack;
        if (src.func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)src.func_76346_g()).func_70694_bm() != null && (stack = ((EntityLivingBase)src.func_76346_g()).func_70694_bm()).func_77973_b() instanceof TragicWeapon) {
            dmg += ((TragicWeapon)stack.func_77973_b()).ascensionLevel;
        }
        return super.func_70097_a(src, dmg);
    }

    public String func_70005_c_() {
        String s;
        String string = s = this.isMobVariant() ? this.getVariantName() : null;
        if (s == null) {
            return super.func_70005_c_();
        }
        return StatCollector.func_74838_a((String)("entity." + s + ".name"));
    }

    protected String getVariantName() {
        return EntityList.func_75621_b((Entity)this);
    }

    public boolean isHalloween() {
        Calendar calendar = this.field_70170_p.func_83015_S();
        return calendar.get(2) + 1 == 10 && calendar.get(5) > 29 || calendar.get(2) + 1 == 11 || calendar.get(5) < 3;
    }

    public static class GroupBuff
    implements IEntityLivingData {
        public final PotionEffect effect;

        public GroupBuff(PotionEffect effect) {
            this.effect = effect;
        }

        public PotionEffect getReducedEffect() {
            return new PotionEffect(this.effect.func_76456_a(), this.effect.func_76459_b() * 3 / 4, this.effect.func_76458_c() / 2 * 3);
        }
    }
}

