/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.Calendar;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntityNekoClusterBomb;
import tragicneko.tragicmc.entity.projectile.EntityNekoMiniBomb;
import tragicneko.tragicmc.entity.projectile.EntityNekoRocket;
import tragicneko.tragicmc.entity.projectile.EntityNekoStickyBomb;

public class EntityTragicNeko
extends TragicMob {
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("ef7bc471-3df8-4d0d-8aa6-8f52ae0a6045"), "tragicNekoSpeedDebuff", TragicConfig.modifier[9], 0);

    public EntityTragicNeko(World par1World) {
        super(par1World);
        this.func_70105_a(0.475f, 1.955f);
        this.field_70728_aV = 5;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        if (!this.isProperDate()) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        }
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.65));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        if (!this.isProperDate()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.85, 32.0f));
        }
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        if (!this.isProperDate()) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        }
    }

    @Override
    public boolean canCorrupt() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    private void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    private void incrementFiringTicks() {
        int pow = this.getFiringTicks();
        this.setFiringTicks(++pow);
    }

    public boolean isAboutToFire() {
        return this.getFiringTicks() > 0 && this.getFiringTicks() <= 40;
    }

    public boolean hasFired() {
        return this.getFiringTicks() > 40;
    }

    public boolean canFire() {
        return this.getFiringTicks() >= 80;
    }

    public int getThrowingTicks() {
        return this.field_70180_af.func_75679_c(17);
    }

    private void setThrowingTicks(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    private void decrementThrowingTicks() {
        int pow = this.getThrowingTicks();
        this.setThrowingTicks(--pow);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(18);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    private void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getFlickTime() {
        return this.field_70180_af.func_75679_c(19);
    }

    private void setFlickTime(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    private void decrementFlickTime() {
        int pow = this.getFlickTime();
        this.setFlickTime(--pow);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.tragicNekoStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.tragicNekoStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.tragicNekoStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.tragicNekoStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.tragicNekoStats[4]);
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return (int)TragicConfig.tragicNekoStats[5];
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_70638_az() != null) {
            this.incrementFiringTicks();
        }
        if (this.getThrowingTicks() > 0) {
            this.decrementThrowingTicks();
        }
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.getFlickTime() > 0) {
            this.decrementFlickTime();
        }
        if (this.func_70638_az() != null && !this.isProperDate()) {
            int i;
            if (this.getFlickTime() > 0) {
                this.setFlickTime(0);
            }
            if (this.getFiringTicks() == 40 && this.func_70685_l((Entity)this.func_70638_az())) {
                if (TragicConfig.tragicNekoRockets) {
                    this.doMissleAttack();
                }
            } else if (this.hasFired() && this.field_70146_Z.nextInt(8) == 0 && this.getFiringTicks() % 20 == 0 && this.getAttackTime() == 0) {
                this.throwRandomProjectile();
                this.setThrowingTicks(20);
            }
            int n = i = this.func_110143_aJ() <= this.func_110138_aP() / 2.0f ? 4 : 16;
            if (this.field_70146_Z.nextInt(i) == 0 && this.canFire() && this.field_70173_aa % 10 == 0 && this.getThrowingTicks() == 0 && this.getAttackTime() == 0 && this.func_70032_d((Entity)this.func_70638_az()) >= 2.0f) {
                this.setFiringTicks(0);
            }
        } else {
            if (this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(4) == 0) {
                this.setFlickTime(10);
            }
            this.setFiringTicks(35);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.isAboutToFire() || this.getThrowingTicks() > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K) {
            this.setThrowingTicks(20);
        }
    }

    @Override
    public void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70725_aQ == 20 && this.field_70146_Z.nextInt(4) == 0 && !this.isProperDate() && TragicConfig.tragicNekoDeathBomb) {
            this.field_70170_p.func_72956_a((Entity)this, "creeper.primed", 1.0f, 1.0f);
            int x = this.field_70146_Z.nextInt(10) == 0 ? 1 : this.field_70146_Z.nextInt(3) + 2;
            for (int i = 0; i < x; ++i) {
                EntityNekoClusterBomb bomb = new EntityNekoClusterBomb(this.field_70170_p);
                bomb.field_70163_u = this.field_70163_u + 0.15;
                bomb.field_70165_t = this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                bomb.field_70161_v = this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                bomb.field_70181_x = this.field_70146_Z.nextDouble() + 0.25;
                bomb.field_70179_y = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.125;
                bomb.field_70159_w = (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.125;
                this.field_70170_p.func_72838_d((Entity)bomb);
            }
        }
    }

    private void doMissleAttack() {
        EntityLivingBase entity = this.func_70638_az();
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70121_D.field_72338_b + (double)entity.field_70131_O / 2.0 - this.field_70163_u - 0.65;
        double d2 = entity.field_70161_v - this.field_70161_v;
        EntityNekoRocket rocket = new EntityNekoRocket(this.field_70170_p, (EntityLivingBase)this, d0, d1, d2);
        rocket.shootingEntity = this;
        rocket.target = entity;
        rocket.field_70163_u = this.field_70163_u + 0.65;
        rocket.field_70165_t = this.field_70165_t - Math.sin(this.field_70177_z * (float)Math.PI / 180.0f) * 0.025;
        rocket.field_70161_v = this.field_70161_v - Math.cos(this.field_70177_z * (float)Math.PI / 180.0f) * 0.025;
        this.field_70170_p.func_72838_d((Entity)rocket);
        this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.rocketlaunch", 1.0f, 1.0f);
        this.field_70170_p.func_72956_a((Entity)this, "tragicmc:random.rocketflying", 1.0f, 1.0f);
    }

    private void throwRandomProjectile() {
        EntityThrowable theProjectile = null;
        switch (this.field_70146_Z.nextInt(5)) {
            case 1: 
            case 4: {
                if (!TragicConfig.tragicNekoStickyBombs) break;
                theProjectile = new EntityNekoStickyBomb(this.field_70170_p, (EntityLivingBase)this);
                break;
            }
            case 2: {
                if (!TragicConfig.tragicNekoClusterBombs) break;
                theProjectile = new EntityNekoClusterBomb(this.field_70170_p, (EntityLivingBase)this);
                break;
            }
            default: {
                if (!TragicConfig.tragicNekoClusterBombs) break;
                theProjectile = new EntityNekoMiniBomb(this.field_70170_p, (EntityLivingBase)this);
            }
        }
        if (theProjectile == null) {
            return;
        }
        theProjectile.field_70159_w = (this.func_70638_az().field_70165_t - this.field_70165_t) * 0.335;
        theProjectile.field_70179_y = (this.func_70638_az().field_70161_v - this.field_70161_v) * 0.335;
        theProjectile.field_70181_x = (this.func_70638_az().field_70163_u - this.field_70163_u) * 0.335;
        this.field_70170_p.func_72838_d((Entity)theProjectile);
    }

    public boolean func_70601_bi() {
        if (MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) <= 63) {
            return false;
        }
        return super.func_70601_bi() || this.isProperDate();
    }

    public boolean isProperDate() {
        if (!TragicConfig.tragicNekoCelebration) {
            return false;
        }
        Calendar calendar = this.field_70170_p.func_83015_S();
        return calendar.get(2) + 1 == 8 && calendar.get(5) > 29 || calendar.get(2) + 1 == 9 || calendar.get(5) < 3;
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean result;
        if (par1DamageSource.func_94541_c() || this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getFiringTicks() < 60) {
            this.setFiringTicks(61);
        }
        if (result = super.func_70097_a(par1DamageSource, par2)) {
            this.setAttackTime(10);
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean result;
        if (this.getThrowingTicks() > 0) {
            return false;
        }
        if (this.getFiringTicks() < 60) {
            this.setFiringTicks(61);
        }
        if (result = super.func_70652_k(par1Entity)) {
            this.setAttackTime(10);
        }
        return result;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("throwingTicks")) {
            this.setThrowingTicks(tag.func_74762_e("throwingTicks"));
        }
        if (tag.func_74764_b("flickTime")) {
            this.setFlickTime(tag.func_74762_e("flickTime"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("throwingTicks", this.getThrowingTicks());
        tag.func_74768_a("flickTime", this.getFlickTime());
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.tragicneko.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds && this.field_70146_Z.nextInt(6) == 0 ? "tragicmc:mob.tragicneko.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.tragicneko.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.8f;
    }

    public int func_70627_aG() {
        return 320 + this.field_70146_Z.nextInt(120);
    }

    @Override
    public int getDropAmount() {
        return 3;
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack item;
        if (player.func_71045_bC() != null && this.isProperDate() && ((item = player.func_71045_bC()).func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150335_W))) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                    this.field_70170_p.func_72869_a("heart", this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 1.0, 1.0, 1.0);
                }
            } else {
                ItemStack stack = new ItemStack(Items.field_151152_bP, 1, 0);
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagCompound newTag = new NBTTagCompound();
                newTag.func_74774_a("Flight", (byte)0);
                NBTTagList tagList = new NBTTagList();
                NBTTagCompound explosion = new NBTTagCompound();
                explosion.func_74774_a("Type", (byte)2);
                explosion.func_74774_a("Fade", (byte)1);
                explosion.func_74774_a("Flicker", (byte)1);
                explosion.func_74783_a("Colors", new int[]{0xFF0000, 65280, 2324735});
                explosion.func_74783_a("FadeColors", new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF});
                tagList.func_74742_a((NBTBase)explosion);
                NBTTagCompound explosion2 = new NBTTagCompound();
                explosion2.func_74774_a("Type", (byte)4);
                explosion2.func_74774_a("Trail", (byte)1);
                explosion2.func_74783_a("Colors", new int[]{65280, 0x4488FF, 0x45FF54});
                explosion2.func_74783_a("FadeColors", new int[]{65280, 0x4488FF, 0x45FF54});
                tagList.func_74742_a((NBTBase)explosion2);
                NBTTagCompound explosion3 = new NBTTagCompound();
                explosion3.func_74774_a("Type", (byte)3);
                explosion3.func_74783_a("Colors", new int[]{16711715, 17408, 2324735});
                explosion3.func_74783_a("FadeColors", new int[]{65280, 65280, 65280});
                tagList.func_74742_a((NBTBase)explosion3);
                NBTTagCompound explosion4 = new NBTTagCompound();
                explosion4.func_74774_a("Type", (byte)0);
                explosion4.func_74774_a("Trail", (byte)1);
                explosion4.func_74783_a("Colors", new int[]{0, 0, 0});
                explosion4.func_74783_a("FadeColors", new int[]{0xFF0000, 0xFF0000, 0xFF0000});
                tagList.func_74742_a((NBTBase)explosion4);
                NBTTagCompound explosion5 = new NBTTagCompound();
                explosion5.func_74774_a("Type", (byte)1);
                explosion5.func_74783_a("Colors", new int[]{16711715, 0xFF4400, 16742468});
                explosion5.func_74783_a("FadeColors", new int[]{4628723, 11473646, 4617727});
                tagList.func_74742_a((NBTBase)explosion5);
                NBTTagCompound explosion6 = new NBTTagCompound();
                explosion6.func_74774_a("Type", (byte)0);
                explosion6.func_74783_a("Colors", new int[]{4470527, 2246399, 0x3311FF});
                explosion6.func_74783_a("FadeColors", new int[]{65280, 14079, 255});
                tagList.func_74742_a((NBTBase)explosion6);
                newTag.func_74782_a("Explosions", (NBTBase)tagList);
                tag.func_74782_a("Fireworks", (NBTBase)newTag);
                stack.func_77982_d(tag);
                for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                    this.field_70170_p.func_72838_d((Entity)new EntityFireworkRocket(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), stack));
                }
            }
            if (TragicConfig.allowAchievements && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.tragicNeko);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
            return true;
        }
        return false;
    }
}

