/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.entity.miniboss.EntityGreaterStin;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityStin
extends TragicMob {
    protected EntityAIBase targetPlayer = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true);

    public EntityStin(World par1World) {
        super(par1World);
        this.func_70105_a(0.65f, 0.65f);
        this.field_70138_W = 0.5f;
        this.field_70728_aV = 5;
        this.func_70661_as().func_75504_d(true);
        this.func_70661_as().func_75495_e(false);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.85));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 16.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, 0, true));
        this.field_70715_bh.func_75776_a(3, this.targetPlayer);
    }

    @Override
    public boolean isMobVariant() {
        return !this.isAdult();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70650_aV() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public int getAgeTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    protected void setAgeTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    protected void incrementAgeTicks() {
        int pow = this.getAgeTicks();
        this.setAgeTicks(++pow);
        if (pow == 1) {
            this.growUp();
        }
    }

    public boolean isAdult() {
        boolean flag;
        boolean bl = flag = this.getAgeTicks() > 0;
        if (!flag) {
            this.field_70728_aV = 3;
        }
        return flag;
    }

    public void setChild() {
        this.setAgeTicks(-2400 - this.field_70146_Z.nextInt(1000));
    }

    protected void growUp() {
        this.reapplyEntityAttributes();
        this.func_70691_i(this.func_110138_aP());
        this.func_70105_a(0.87f, 2.65f);
        this.field_70138_W = 1.0f;
        this.field_70715_bh.func_85156_a(this.targetPlayer);
    }

    protected void setCanClimb(boolean flag) {
        this.field_70180_af.func_75692_b(17, (Object)(flag ? 1 : 0));
    }

    protected boolean canClimb() {
        return this.field_70180_af.func_75679_c(17) == 1;
    }

    public boolean func_70617_f_() {
        return this.canClimb() && !this.isAdult();
    }

    public byte getClimbDirection() {
        return this.field_70180_af.func_75683_a(18);
    }

    protected void setClimbDirection(byte b) {
        this.field_70180_af.func_75692_b(18, (Object)b);
    }

    public int getGallopTicks() {
        return this.field_70180_af.func_75679_c(19);
    }

    protected void setGallopTicks(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    public boolean isGalloping() {
        return this.getGallopTicks() > 0;
    }

    protected void decrementGallopTicks() {
        int pow = this.getGallopTicks();
        this.setGallopTicks(--pow);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.reapplyEntityAttributes();
    }

    protected void reapplyEntityAttributes() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.isAdult() ? TragicConfig.stinStats[0] : TragicConfig.stinBabyStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.isAdult() ? TragicConfig.stinStats[1] : TragicConfig.stinBabyStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.isAdult() ? TragicConfig.stinStats[2] : TragicConfig.stinBabyStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(this.isAdult() ? TragicConfig.stinStats[3] : TragicConfig.stinBabyStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.isAdult() ? TragicConfig.stinStats[4] : TragicConfig.stinBabyStats[4]);
    }

    @Override
    public void func_70636_d() {
        if (this.isGalloping() && this.field_70122_E) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.isGalloping()) {
            this.field_70181_x = -0.1;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.isAdult()) {
                this.func_70105_a(0.87f, 2.65f);
                this.field_70138_W = 1.0f;
            } else {
                this.func_70105_a(0.65f, 0.65f);
                this.field_70138_W = 0.5f;
            }
            return;
        }
        if (this.getAgeTicks() <= 700) {
            this.incrementAgeTicks();
        }
        if (this.getGallopTicks() > 0) {
            this.decrementGallopTicks();
        }
        if (this.isAdult() && this.canClimb()) {
            this.setCanClimb(false);
        }
        if (this.field_70715_bh.field_75782_a.contains(this.targetPlayer) && this.isAdult() && this.isChangeAllowed()) {
            this.field_70715_bh.func_85156_a(this.targetPlayer);
        }
        if (this.superiorForm == null && this.isAdult() && this.isChangeAllowed()) {
            this.superiorForm = new EntityGreaterStin(this.field_70170_p);
        }
        if (!this.isAdult()) {
            this.setCanClimb(this.field_70123_F);
            if (this.func_70617_f_()) {
                ArrayList<int[]> list = WorldHelper.getBlocksInCircularRange(this.field_70170_p, this.field_70130_N, this.field_70165_t, this.field_70163_u, this.field_70161_v);
                for (int i = 0; i < list.size(); ++i) {
                    int[] coords = list.get(i);
                    Block block = this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]);
                    if (!block.func_149662_c()) continue;
                    double d0 = Math.abs(this.field_70165_t) - (double)Math.abs(coords[0]);
                    double d2 = Math.abs(this.field_70161_v) - (double)Math.abs(coords[2]);
                    if (d0 >= 0.0 && d2 >= 0.0) {
                        this.setClimbDirection((byte)2);
                        continue;
                    }
                    if (d0 < 0.0 && d2 < 0.0) {
                        this.setClimbDirection((byte)3);
                        continue;
                    }
                    if (d0 >= 0.0 && d2 < 0.0) {
                        this.setClimbDirection((byte)4);
                        continue;
                    }
                    this.setClimbDirection((byte)5);
                }
            } else {
                this.setClimbDirection((byte)0);
            }
        }
        if (this.func_70026_G() && this.field_70173_aa % 5 == 0) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.func_70638_az() != null && !this.isAdult() && this.func_70638_az().field_70163_u + (double)this.field_70138_W > this.field_70163_u && this.func_70032_d((Entity)this.func_70638_az()) <= 16.0f) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 0.23 * 0.200000011920929 + this.field_70159_w * 0.10000000298023223;
            this.field_70179_y = d1 / (double)f2 * 0.23 * 0.200000011920929 + this.field_70179_y * 0.10000000298023223;
            if (this.field_70123_F) {
                this.field_70181_x = 0.15;
            }
        }
        if (this.func_70638_az() == null && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(32) == 0 && !this.isGalloping() && this.isAdult() && this.field_70122_E) {
            this.setGallopTicks(30);
        }
    }

    public int func_70658_aO() {
        return (int)(this.isAdult() ? TragicConfig.stinStats[5] : TragicConfig.stinBabyStats[5]);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        return super.func_70652_k(par1Entity);
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean flag = super.func_70097_a(par1DamageSource, par2);
        if (flag && TragicConfig.stinTeleport) {
            if (this.getGallopTicks() == 0) {
                this.setGallopTicks(15);
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(8.0, 8.0, 8.0));
            for (int i = 0; i < list.size(); ++i) {
                TragicMob mob;
                if (!(list.get(i) instanceof TragicMob) || !((mob = (TragicMob)((Object)list.get(i))) instanceof EntityStin) || mob.func_70638_az() != null) continue;
                mob.func_70784_b((Entity)this.func_70638_az());
            }
            if (this.isAdult() && par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase && !par1DamageSource.func_76352_a() && this.field_70146_Z.nextInt(16) == 0) {
                return this.teleportEnemyAway((EntityLivingBase)par1DamageSource.func_76346_g(), flag);
            }
        }
        return flag;
    }

    protected boolean teleportEnemyAway(EntityLivingBase entity, boolean flag) {
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        for (int y1 = 0; y1 < 24; ++y1) {
            for (int z1 = -8; z1 < 9; ++z1) {
                for (int x1 = -8; x1 < 9; ++x1) {
                    if (!World.func_147466_a((IBlockAccess)this.field_70170_p, (int)((int)this.field_70165_t + x1), (int)((int)this.field_70163_u + y1 - 1), (int)((int)this.field_70161_v + z1)) || !this.field_70146_Z.nextBoolean()) continue;
                    if (entity instanceof EntityPlayerMP) {
                        EntityPlayerMP mp = (EntityPlayerMP)entity;
                        if (mp.field_71075_bZ.field_75098_d) {
                            return flag;
                        }
                        if (!mp.field_71135_a.func_147362_b().func_150724_d() || this.field_70170_p != mp.field_70170_p) continue;
                        if (mp.func_70115_ae()) {
                            mp.func_70078_a(null);
                        }
                        AxisAlignedBB bb = mp.field_70121_D.func_72329_c();
                        bb.func_72317_d(x + (double)x1, y + (double)y1, z + (double)z1);
                        if (!this.field_70170_p.func_72855_b(bb) || !this.field_70170_p.func_72945_a((Entity)mp, bb).isEmpty() || this.field_70170_p.func_72953_d(bb)) continue;
                        mp.field_71135_a.func_147364_a(x + (double)x1, y + (double)y1, z + (double)z1, mp.field_70177_z, mp.field_70125_A);
                        int short1 = 128;
                        for (int l = 0; l < short1; ++l) {
                            double d6 = (double)l / ((double)short1 - 1.0);
                            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            double d7 = x + (x + (double)x1 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            double d8 = y + (y + (double)y1 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                            double d9 = z + (z + (double)z1 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                        }
                        mp.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 0));
                        mp.field_70143_R = 0.0f;
                        this.field_70170_p.func_72956_a((Entity)mp, TragicConfig.allowMobSounds ? "tragicmc:mob.stin.teleport" : "mob.endermen.portal", 0.4f, 0.4f);
                        return flag;
                    }
                    entity.func_70107_b(x + (double)x1, y + (double)y1, z + (double)z1);
                    if (this.field_70170_p.func_72855_b(entity.field_70121_D) && this.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(entity.field_70121_D)) {
                        int short1 = 128;
                        for (int l = 0; l < short1; ++l) {
                            double d6 = (double)l / ((double)short1 - 1.0);
                            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            double d7 = x + (x + (double)x1 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            double d8 = y + (y + (double)y1 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                            double d9 = z + (z + (double)z1 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                        }
                        this.field_70170_p.func_72956_a((Entity)entity, TragicConfig.allowMobSounds ? "tragicmc:mob.stin.teleport" : "mob.endermen.portal", 0.4f, 0.4f);
                        entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
                        return flag;
                    }
                    entity.func_70107_b(x, y, z);
                }
            }
        }
        return flag;
    }

    protected void func_70069_a(float f) {
        super.func_70069_a(f);
        if (!this.isGalloping()) {
            this.setGallopTicks(15);
        }
    }

    public void func_70110_aj() {
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("ageTicks")) {
            this.setAgeTicks(tag.func_74762_e("ageTicks"));
        }
        if (tag.func_74764_b("canClimb")) {
            this.setCanClimb(tag.func_74767_n("canClimb"));
        }
        if (tag.func_74764_b("climbDirection")) {
            this.setClimbDirection(tag.func_74771_c("climbDirection"));
        }
        if (tag.func_74764_b("gallopTicks")) {
            this.setGallopTicks(tag.func_74762_e("gallopTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("ageTicks", this.getAgeTicks());
        tag.func_74757_a("canClimb", this.canClimb());
        tag.func_74774_a("climbDirection", this.getClimbDirection());
        tag.func_74768_a("gallopTicks", this.getGallopTicks());
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K && TragicConfig.allowStinBaby && this.field_70146_Z.nextInt(6) == 0) {
            this.setChild();
        }
        return super.func_110161_a(data);
    }

    @Override
    protected boolean isChangeAllowed() {
        return TragicConfig.allowGreaterStin && this.getAgeTicks() >= 600;
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.stin.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.stin.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.stin.hurt" : null;
    }

    public float func_70647_i() {
        return this.isAdult() ? 1.0f : 1.6f;
    }

    public float func_70599_aP() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a(this.isAdult() || !TragicConfig.allowMobSounds ? "tragicmc:mob.stin.step" : "mob.spider.step", 0.45f, this.isAdult() ? 1.9f : 0.2f);
    }

    public int func_70627_aG() {
        return 60;
    }

    @Override
    public String getVariantName() {
        return "TragicMC.StinBaby";
    }
}

