/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCocoon;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCombat;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.DamageHelper;

public class EntitySeeker
extends TragicMob {
    private int timeSinceTarget;
    private boolean shouldRelocate;
    private EntityOverlordCocoon owner = null;
    private byte relocations;
    private boolean hasDamagedEntity = false;

    public EntitySeeker(World par1World) {
        super(par1World);
        this.func_70105_a(0.625f, 1.225f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 64.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, false, EntityOverlordCombat.selec));
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.seekerStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.seekerStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.seekerStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.seekerStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.seekerStats[4]);
    }

    public int func_70658_aO() {
        return (int)TragicConfig.seekerStats[5];
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Synapse;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    private void setKillTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    public int getKillTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    private void setTargetId(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    public int getTargetId() {
        return this.field_70180_af.func_75679_c(17);
    }

    @Override
    public void func_70636_d() {
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            Entity entity = this.field_70170_p.func_73045_a(this.getTargetId());
            if (entity != null && this.getKillTicks() > 0) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                for (int l = 0; l < 4; ++l) {
                    double d3 = 0.23 * (double)l + this.field_70146_Z.nextDouble() * 0.25;
                    this.field_70170_p.func_72869_a("reddust", this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 0.75, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0);
                    if (this.getKillTicks() < 300) continue;
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 0.75, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0);
                }
                if (this.getKillTicks() >= 300) {
                    for (int i = 0; i < 4; ++i) {
                        this.field_70170_p.func_72869_a("flame", this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u + 0.25 + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 0.0, 0.0, 0.0);
                    }
                }
            }
            return;
        }
        if (this.func_70638_az() != null) {
            this.timeSinceTarget = 0;
            this.setTargetId(this.func_70638_az().func_145782_y());
            if (this.func_70685_l((Entity)this.func_70638_az())) {
                if (this.getKillTicks() < 400) {
                    this.setKillTicks(this.getKillTicks() + 1);
                }
                if (this.getKillTicks() >= 300 && this.func_70638_az().func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), Math.max(this.func_70638_az().func_110138_aP() / 20.0f, 2.0f))) {
                    this.hasDamagedEntity = true;
                }
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
                for (Entity e : list) {
                    if (this.func_70638_az() != null) {
                        if (!(e instanceof EntityLivingBase) || ((EntityLivingBase)e).func_70668_bt() != TragicEntities.Synapse || ((EntityLiving)e).func_70638_az() != null || ((EntityLivingBase)e).func_70668_bt() == TragicEntities.Synapse) continue;
                        ((EntityLiving)e).func_70624_b(this.func_70638_az());
                        continue;
                    }
                    break;
                }
            } else {
                if (this.field_70173_aa % 2 == 0 && this.getKillTicks() > 0) {
                    this.setKillTicks(this.getKillTicks() - 1);
                }
                if (this.getKillTicks() == 0) {
                    this.func_70624_b(null);
                }
            }
            if (this.func_70638_az() == null || (double)this.func_70032_d((Entity)this.func_70638_az()) >= 64.0 || this.func_70638_az().field_70128_L || this.func_70638_az().func_110143_aJ() <= 0.0f || this.field_70170_p.func_73045_a(this.getTargetId()) == null) {
                this.setKillTicks(0);
                this.func_70624_b(null);
            }
        } else {
            if (this.getKillTicks() > 0) {
                this.setKillTicks(this.getKillTicks() - 1);
            }
            ++this.timeSinceTarget;
            if (this.timeSinceTarget >= 200) {
                this.setKillTicks(0);
            }
            this.setTargetId(0);
        }
        if (this.getOwner() != null) {
            if ((double)this.func_70032_d((Entity)this.getOwner()) >= 32.0 || (double)this.func_70032_d((Entity)this.getOwner()) <= 4.0 || !this.func_70685_l((Entity)this.getOwner())) {
                this.shouldRelocate = true;
            }
            if (this.getOwner().field_70128_L) {
                this.setOwner(null);
            }
        }
        if (this.shouldRelocate) {
            this.shouldRelocate = false;
            this.teleportRandomly();
            this.relocations = (byte)(this.relocations + 1);
        }
        if (this.relocations >= 10) {
            if (this.getOwner() == null) {
                this.func_70106_y();
            } else {
                this.func_70107_b(this.getOwner().field_70165_t, this.getOwner().field_70163_u, this.getOwner().field_70161_v);
            }
            this.relocations = 0;
        }
        if (this.field_70173_aa % 20 == 0 && this.func_70638_az() != null && this.getKillTicks() > 0) {
            float f = (float)this.getKillTicks() / 300.0f;
            if (TragicConfig.allowMobSounds) {
                this.func_85030_a("tragicmc:mob.seeker.tone", f, f * 1.9f);
                this.field_70170_p.func_72956_a((Entity)this.func_70638_az(), "tragicmc:mob.seeker.tone", f, f * 1.9f);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource src, float dmg) {
        if (!this.field_70170_p.field_72995_K && src == DamageSource.field_76368_d) {
            this.shouldRelocate = true;
        }
        return super.func_70097_a(src, dmg);
    }

    public void func_70069_a(float par1) {
    }

    public void func_70064_a(double par1, boolean par2) {
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + this.field_70146_Z.nextDouble() * 8.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(8) - 8) + 4.0;
        double d2 = this.field_70161_v + this.field_70146_Z.nextDouble() * 8.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        return true;
    }

    public void setOwner(EntityOverlordCocoon cc) {
        this.owner = cc;
    }

    public EntityOverlordCocoon getOwner() {
        return this.owner;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("owner") && this.field_70170_p.func_73045_a(tag.func_74762_e("owner")) instanceof EntityOverlordCocoon) {
            this.setOwner((EntityOverlordCocoon)this.field_70170_p.func_73045_a(tag.func_74762_e("owner")));
        }
        if (tag.func_74764_b("killTicks")) {
            this.setKillTicks(tag.func_74762_e("killTicks"));
        }
        if (tag.func_74764_b("relocations")) {
            this.relocations = tag.func_74771_c("relocations");
        }
        if (tag.func_74764_b("targetlessTime")) {
            this.timeSinceTarget = tag.func_74762_e("targetlessTime");
        }
        if (tag.func_74764_b("shouldRelocate")) {
            this.shouldRelocate = tag.func_74767_n("shouldRelocate");
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.getOwner() != null) {
            tag.func_74768_a("owner", this.getOwner().func_145782_y());
        }
        tag.func_74768_a("killTicks", this.getKillTicks());
        tag.func_74768_a("targetID", this.getTargetId());
        tag.func_74774_a("relocations", this.relocations);
        tag.func_74768_a("targetlessTime", this.timeSinceTarget);
        tag.func_74757_a("shouldRelocate", this.shouldRelocate);
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (!this.hasDamagedEntity && src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.allowAchievements) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.seeker);
        }
    }
}

