/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.blocks.BlockDarkCobble;
import tragicneko.tragicmc.blocks.BlockGenericGrass;
import tragicneko.tragicmc.blocks.BlockPermafrost;
import tragicneko.tragicmc.dimension.TragicWorldProvider;
import tragicneko.tragicmc.entity.miniboss.EntityJarra;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityRagr
extends TragicMob {
    public static Set crushableBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150337_Q, Blocks.field_150338_P, Blocks.field_150329_H, Blocks.field_150362_t, Blocks.field_150361_u, TragicBlocks.HallowedLeaves, TragicBlocks.AshenLeaves, TragicBlocks.DarkLeaves, TragicBlocks.PaintedLeaves, TragicBlocks.BleachedLeaves, TragicBlocks.AshenTallGrass, TragicBlocks.AshenBush, Blocks.field_150330_I, TragicBlocks.TragicFlower, TragicBlocks.StarlitTallGrass, TragicBlocks.DarkTallGrass, Blocks.field_150431_aC});

    public EntityRagr(World par1World) {
        super(par1World);
        this.func_70105_a(1.335f, 2.675f);
        this.field_70138_W = 1.5f;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityTameable.class, 0, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 0, true));
    }

    @Override
    public boolean isMobVariant() {
        return this.getRagrType() == 1;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    public int getAngerTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    private void setAngerTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    private void incrementAngerTicks() {
        int pow = this.getAngerTicks();
        this.setAngerTicks(++pow);
    }

    private void decrementAngerTicks() {
        int pow = this.getAngerTicks();
        this.setAngerTicks(--pow);
    }

    public byte getRagrType() {
        return this.field_70180_af.func_75683_a(17);
    }

    protected void setRagrType(byte b) {
        this.field_70180_af.func_75692_b(17, (Object)b);
        if (b != 0) {
            this.field_70728_aV = 16;
            this.field_70178_ae = true;
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Beast;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        boolean flag = this.getRagrType() == 0;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(flag ? TragicConfig.ragrStats[0] : TragicConfig.pyragrStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(flag ? TragicConfig.ragrStats[1] : TragicConfig.pyragrStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(flag ? TragicConfig.ragrStats[2] : TragicConfig.pyragrStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(flag ? TragicConfig.ragrStats[3] : TragicConfig.pyragrStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(flag ? TragicConfig.ragrStats[4] : TragicConfig.pyragrStats[4]);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.superiorForm == null && this.getRagrType() == 1) {
            this.superiorForm = new EntityJarra(this.field_70170_p);
        }
        if (this.getRagrType() == 1 && this.field_70173_aa % 5 == 0 && this.field_70170_p.func_72896_J() && this.field_70170_p.func_72937_j((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.getRagrType() == 1 && this.func_70055_a(Material.field_151586_h)) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.func_70638_az() != null) {
            this.incrementAngerTicks();
            if (this.isCorrupted()) {
                this.incrementAngerTicks();
            }
            if (this.field_70122_E && this.field_70146_Z.nextInt(8) == 0) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 1.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
                this.field_70179_y = d1 / (double)f2 * 1.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
                this.func_70664_aZ();
            } else if (this.field_70122_E && this.field_70146_Z.nextBoolean()) {
                double d0 = this.field_70146_Z.nextDouble() * 1.45 - this.field_70146_Z.nextDouble() * 1.45;
                double d1 = this.field_70146_Z.nextDouble() * 1.45 - this.field_70146_Z.nextDouble() * 1.45;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 1.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
                this.field_70179_y = d1 / (double)f2 * 1.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
                this.func_70664_aZ();
            }
        } else {
            if (this.getAngerTicks() > 0) {
                this.decrementAngerTicks();
            }
            if (this.field_70122_E && this.field_70146_Z.nextBoolean()) {
                double d0 = this.field_70146_Z.nextDouble() * 1.45 - this.field_70146_Z.nextDouble() * 1.45;
                double d1 = this.field_70146_Z.nextDouble() * 1.45 - this.field_70146_Z.nextDouble() * 1.45;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 1.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
                this.field_70179_y = d1 / (double)f2 * 1.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
                this.func_70664_aZ();
            }
        }
    }

    protected void func_70664_aZ() {
        if (TragicConfig.allowMobSounds) {
            this.func_85030_a("tragicmc:mob.ragr.jump", this.func_70599_aP(), 0.8f);
        }
        double d = this.field_70181_x = this.getAngerTicks() > 600 ? this.field_70146_Z.nextDouble() * 1.055 + 0.455 : 0.545;
        if (this.func_70644_a(Potion.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(Potion.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z * ((float)Math.PI / 180);
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
    }

    protected void func_70069_a(float par1) {
        boolean flag;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean bl = flag = this.getMobGriefing() && TragicConfig.ragrExplosions;
        if (par1 >= 8.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 3.0f + 2.0f, flag);
        } else if (par1 >= 4.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 2.0f + 1.0f, flag);
        } else if (par1 >= 2.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 2.0f, flag);
        }
        if (!flag || !TragicConfig.ragrBlockCrushing) {
            return;
        }
        int x = (int)this.field_70165_t;
        int y = (int)this.field_70163_u;
        int z = (int)this.field_70161_v;
        par1 = MathHelper.func_76131_a((float)(par1 / 2.0f), (float)1.0f, (float)4.0f);
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, par1, x, y, z);
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = list.get(i);
            x = coords[0];
            Block block = this.field_70170_p.func_147439_a(x, y = coords[1], z = coords[2]);
            if (crushableBlocks.contains(block)) {
                this.field_70170_p.func_147468_f(x, y, z);
                continue;
            }
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150346_d);
                continue;
            }
            if (block == Blocks.field_150348_b) {
                this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150347_e);
                continue;
            }
            if (block == Blocks.field_150417_aV) {
                this.field_70170_p.func_147465_d(x, y, z, Blocks.field_150417_aV, 2, 2);
                continue;
            }
            if (block == Blocks.field_150347_e) {
                this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150351_n);
                continue;
            }
            if (!TragicConfig.allowNonMobBlocks) continue;
            if (block instanceof BlockGenericGrass) {
                this.field_70170_p.func_147449_b(x, y, z, TragicBlocks.DeadDirt);
                continue;
            }
            if (block instanceof BlockPermafrost) {
                this.field_70170_p.func_147465_d(x, y, z, TragicBlocks.Permafrost, 1, 2);
                continue;
            }
            if (block == TragicBlocks.DarkStone) {
                this.field_70170_p.func_147449_b(x, y, z, TragicBlocks.DarkCobblestone);
                continue;
            }
            if (!(block instanceof BlockDarkCobble)) continue;
            this.field_70170_p.func_147449_b(x, y, z, TragicBlocks.DeadDirt);
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    public void func_70110_aj() {
    }

    public int func_70658_aO() {
        return this.func_70027_ad() ? 0 : (int)TragicConfig.ragrStats[5];
    }

    public boolean func_70601_bi() {
        if (MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) <= this.field_70170_p.field_73011_w.func_76557_i() && !(this.field_70170_p.field_73011_w instanceof TragicWorldProvider)) {
            return false;
        }
        return super.func_70601_bi();
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
            if (player.func_71045_bC() != null) {
                if (!(player.func_71045_bC().func_77973_b() instanceof ItemBow)) {
                    player.func_71045_bC().func_77972_a(this.field_70146_Z.nextInt(4) + 1, (EntityLivingBase)player);
                }
            } else {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
            }
        }
        if (par1DamageSource.func_76352_a()) {
            par2 /= 2.0f;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        if (result) {
            if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(4) == 0) {
                switch (this.field_70146_Z.nextInt(3)) {
                    case 0: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(200)));
                        break;
                    }
                    case 1: {
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.field_70146_Z.nextInt(200)));
                        break;
                    }
                    case 2: {
                        if (!TragicConfig.allowSubmission) break;
                        ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(200)));
                    }
                }
            }
            if (!this.field_70122_E) {
                par1Entity.field_70159_w += this.field_70159_w;
                par1Entity.field_70179_y += this.field_70179_y;
                par1Entity.field_70181_x += this.field_70181_x;
            }
            if (this.getRagrType() != 0) {
                par1Entity.func_70015_d(4 + this.field_70146_Z.nextInt(4));
            }
        }
        return result;
    }

    @Override
    protected boolean isChangeAllowed() {
        return this.getRagrType() == 1 && TragicConfig.allowAggro;
    }

    public String func_70639_aQ() {
        return null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.ragr.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.ragr.death" : null;
    }

    public float func_70647_i() {
        return 0.8f;
    }

    public float func_70599_aP() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }

    @Override
    public int getDropAmount() {
        return this.getRagrType() == 0 ? 3 : 5;
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.allowAchievements && this.func_70027_ad() && this.getRagrType() == 0) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.ragr);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("ragrType")) {
            this.setRagrType(tag.func_74771_c("ragrType"));
        }
        if (tag.func_74764_b("angerTicks")) {
            this.setAngerTicks(tag.func_74762_e("angerTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("ragrType", this.getRagrType());
        tag.func_74768_a("angerTicks", this.getAngerTicks());
    }

    @Override
    public String getVariantName() {
        return "TragicMC.Pyragr";
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        BiomeGenBase biome = this.field_70170_p.func_72807_a((int)this.field_70165_t, (int)this.field_70161_v);
        return super.func_110161_a(data);
    }
}

