/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntityPumpkinbomb;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityPumpkinhead
extends TragicMob {
    public EntityPumpkinhead(World par1World) {
        super(par1World);
        this.func_70105_a(0.675f, 2.215f);
        this.field_70728_aV = 5;
        this.func_70661_as().func_75504_d(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.65));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    @Override
    public boolean canCorrupt() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)Float.valueOf(2.0f));
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public float getModValue() {
        return this.field_70180_af.func_111145_d(16);
    }

    private void setModValue(float f) {
        this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(f));
    }

    private void resetModValue() {
        this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(2.0f));
    }

    public int[] getHomeCoordinates() {
        return new int[]{this.field_70180_af.func_75679_c(17), this.field_70180_af.func_75679_c(18), this.field_70180_af.func_75679_c(19)};
    }

    private void setHomeCoordinates(int[] coords) {
        this.field_70180_af.func_75692_b(17, (Object)coords[0]);
        this.field_70180_af.func_75692_b(18, (Object)coords[1]);
        this.field_70180_af.func_75692_b(19, (Object)coords[2]);
        this.func_110171_b(coords[0], coords[1], coords[2], 12);
    }

    public boolean hasHomePumpkin() {
        int[] coords = this.getHomeCoordinates();
        return this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]) == Blocks.field_150423_aK || this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]) == Blocks.field_150428_aP;
    }

    public int getAngerTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setAngerTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void incrementAngerTicks() {
        int pow = this.getAngerTicks();
        this.setAngerTicks(++pow);
    }

    public boolean isAngry() {
        return this.getAngerTicks() > 0;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Natural;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.pumpkinheadStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.pumpkinheadStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.pumpkinheadStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.pumpkinheadStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.pumpkinheadStats[4]);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.hasHomePumpkin() && this.field_70146_Z.nextBoolean()) {
                if (this.field_70146_Z.nextBoolean()) {
                    double d0 = (double)this.getHomeCoordinates()[0] - this.field_70165_t + 0.5;
                    double d1 = (double)this.getHomeCoordinates()[1] - this.field_70163_u - 0.5;
                    double d2 = (double)this.getHomeCoordinates()[2] - this.field_70161_v + 0.5;
                    for (int i = 0; i < 4; ++i) {
                        double d3 = 0.23 * (double)i + this.field_70146_Z.nextDouble() * 0.25;
                        this.field_70170_p.func_72869_a("flame", this.field_70165_t + d0 * d3, this.field_70163_u + d1 * d3 + 1.45, this.field_70161_v + d2 * d3, 0.0, 0.0, 0.0);
                    }
                }
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.field_70163_u, this.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 0.0, this.field_70146_Z.nextDouble() * 0.175, 0.0);
                }
            }
            return;
        }
        if (!this.hasHomePumpkin() && this.field_70173_aa % 120 == 0 && this.isPumpkinNearby()) {
            this.setHomeCoordinates(this.getNearbyPumpkin());
        }
        if (this.func_70027_ad()) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        } else if (this.field_70173_aa % 60 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(3.0f);
        }
        if (this.func_70638_az() != null) {
            this.incrementAngerTicks();
        } else {
            this.setAngerTicks(0);
            this.resetModValue();
        }
        if (!this.hasHomePumpkin()) {
            this.func_110177_bN();
            this.setAngerTicks(0);
            this.resetModValue();
        }
        if (TragicConfig.pumpkinheadHaste) {
            AttributeModifier mod = new AttributeModifier(UUID.fromString("2042ddcd-b29a-474f-acda-00ec1a2b4a2e"), "pumpkinheadHaste", (double)this.getModValue(), 0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(mod);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(mod);
            if (this.getAngerTicks() % 100 == 0 && this.isAngry() && this.hasHomePumpkin()) {
                this.setModValue(this.getModValue() + 2.0f);
            }
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 4.0f && this.hasHomePumpkin() && this.field_70146_Z.nextInt(4) == 0 && this.field_70173_aa % 10 == 0 && TragicConfig.pumpkinheadPumpkinbombs) {
            for (int x = 0; x < 6; x = (int)((byte)(x + 1))) {
                EntityPumpkinbomb bomb = new EntityPumpkinbomb(this.field_70170_p, (EntityLivingBase)this);
                bomb.field_70159_w = bomb.field_70179_y = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                bomb.field_70181_x = this.field_70146_Z.nextDouble() * 1.15;
                bomb.func_70107_b(this.field_70165_t + bomb.field_70159_w * 0.115, this.field_70163_u + 1.5 + bomb.field_70181_x * 0.115, this.field_70161_v + bomb.field_70179_y * 0.115);
                this.field_70170_p.func_72838_d((Entity)bomb);
            }
        }
    }

    public int func_70658_aO() {
        return this.hasHomePumpkin() ? (int)TragicConfig.pumpkinheadStats[5] : MathHelper.func_76128_c((double)(TragicConfig.pumpkinheadStats[5] / 3.0));
    }

    public boolean isPumpkinNearby() {
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 6.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = list.get(i);
            if (this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]) != Blocks.field_150423_aK && this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]) != Blocks.field_150428_aP) continue;
            return true;
        }
        return false;
    }

    public int[] getNearbyPumpkin() {
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 6.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = list.get(i);
            if (this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]) != Blocks.field_150423_aK && this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]) != Blocks.field_150428_aP) continue;
            return coords;
        }
        return null;
    }

    public void createHomePumpkin() {
        if (!TragicConfig.pumpkinheadPumpkinSpawn) {
            return;
        }
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 6.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = list.get(i);
            Block block = this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]);
            if (!block.canBeReplacedByLeaves((IBlockAccess)this.field_70170_p, coords[0], coords[1], coords[2]) || !World.func_147466_a((IBlockAccess)this.field_70170_p, (int)coords[0], (int)(coords[1] - 1), (int)coords[2])) continue;
            this.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150428_aP);
            this.setHomeCoordinates(coords);
            break;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean result = super.func_70097_a(par1DamageSource, par2);
        if (result && par1DamageSource.func_76346_g() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase && this.field_70146_Z.nextBoolean() && !par1DamageSource.func_82725_o()) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(12.0, 12.0, 12.0));
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof EntityPumpkinhead)) continue;
                EntityPumpkinhead mob = (EntityPumpkinhead)((Object)list.get(i));
                if (mob.func_70638_az() == null && this.func_70638_az() != null) {
                    mob.func_70784_b((Entity)this.func_70638_az());
                }
                if (mob.getHomeCoordinates() != this.getHomeCoordinates() || !mob.hasHomePumpkin() || !this.hasHomePumpkin()) continue;
                mob.func_70097_a(DamageSource.field_76376_m, 1.0f);
            }
        }
        return result;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.isPumpkinNearby()) {
            if (this.field_70146_Z.nextInt(32) == 0 && this.getMobGriefing()) {
                this.createHomePumpkin();
            }
        } else {
            this.setHomeCoordinates(this.getNearbyPumpkin());
        }
        return super.func_110161_a(data);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("homeCoords")) {
            this.setHomeCoordinates(tag.func_74759_k("homeCoords"));
        }
        if (tag.func_74764_b("angerTicks")) {
            this.setAngerTicks(tag.func_74762_e("angerTicks"));
        }
        if (tag.func_74764_b("modValue")) {
            this.setModValue(tag.func_74760_g("modValue"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74783_a("homeCoords", this.getHomeCoordinates());
        tag.func_74768_a("angerTicks", this.getAngerTicks());
        tag.func_74776_a("modValue", this.getModValue());
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? (this.isAngry() ? "tragicmc:mob.pumpkinhead.angry" : "tragicmc:mob.pumpkinhead.living") : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.pumpkinhead.hiss" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:mob.pumpkinhead.death" : null;
    }

    public float func_70647_i() {
        return 0.8f;
    }

    public float func_70599_aP() {
        return 0.4f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public int func_70627_aG() {
        return this.isAngry() ? 40 : 320;
    }
}

