/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.mob;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Calendar;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.miniboss.EntityVoxStellarum;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.entity.projectile.EntityStarShard;
import tragicneko.tragicmc.worldgen.biome.BiomeGenStarlitPrarie;

public class EntityNorVox
extends TragicMob {
    protected AttributeModifier mod = new AttributeModifier(UUID.fromString("e20a064f-7022-4c64-9902-181d3ac9eb17"), "norVoxSpeedDebuff", TragicConfig.modifier[7], 0);

    public EntityNorVox(World par1World) {
        super(par1World);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 10;
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    public boolean isMobVariant() {
        return this.getNorVoxType() == 1;
    }

    @Override
    protected boolean canCorrupt() {
        return this.getNorVoxType() == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return this.getNorVoxType() == 0 ? super.func_70070_b(par1) : 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return this.getNorVoxType() == 0 ? super.func_70013_c(par1) : 1.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public int getFiringTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    protected void setFiringTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    protected void decrementFiringTicks() {
        int pow = this.getFiringTicks();
        this.setFiringTicks(--pow);
    }

    public byte getTextureID() {
        return this.field_70180_af.func_75683_a(18);
    }

    protected void setTextureID(byte b) {
        this.field_70180_af.func_75692_b(18, (Object)b);
    }

    public byte getNorVoxType() {
        return this.field_70180_af.func_75683_a(17);
    }

    protected void setNorVoxType(byte b) {
        this.field_70180_af.func_75692_b(17, (Object)b);
        if (b == 0) {
            this.func_70105_a(1.135f, 1.575f);
        } else {
            this.field_70728_aV = 12;
            this.func_70105_a(0.7800687f, 1.0824742f);
        }
    }

    public boolean isFiring() {
        return this.getFiringTicks() > 0;
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(19);
    }

    protected void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    protected void decrementAttackTime() {
        int pow = this.getAttackTime();
        this.setAttackTime(--pow);
    }

    public int getNodTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    protected void setNodTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    protected void decrementNodTicks() {
        int pow = this.getNodTicks();
        this.setNodTicks(--pow);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        boolean flag = this.getNorVoxType() == 0;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(flag ? TragicConfig.norVoxStats[0] : TragicConfig.starVoxStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(flag ? TragicConfig.norVoxStats[1] : TragicConfig.starVoxStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(flag ? TragicConfig.norVoxStats[2] : TragicConfig.starVoxStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(flag ? TragicConfig.norVoxStats[3] : TragicConfig.starVoxStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(flag ? TragicConfig.norVoxStats[4] : TragicConfig.starVoxStats[4]);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_82165_m(Potion.field_82731_v.field_76415_H)) {
            this.func_82170_o(Potion.field_82731_v.field_76415_H);
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.getNorVoxType() == 0) {
                this.func_70105_a(1.135f, 1.575f);
            } else {
                this.func_70105_a(0.7800687f, 1.0824742f);
            }
        } else {
            if (this.superiorForm == null && this.getNorVoxType() == 1) {
                this.superiorForm = new EntityVoxStellarum(this.field_70170_p);
            }
            if (this.isFiring()) {
                this.decrementFiringTicks();
            }
            if (this.getAttackTime() > 0) {
                this.decrementAttackTime();
            }
            if (this.getNodTicks() > 0) {
                this.decrementNodTicks();
            }
            if (this.func_70638_az() == null) {
                this.setFiringTicks(0);
            }
            if (TragicConfig.allowStun && this.func_70644_a(TragicPotion.Stun)) {
                if (this.isFiring()) {
                    this.setFiringTicks(0);
                }
                if (this.getAttackTime() == 0) {
                    this.setAttackTime(10);
                }
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
            if (this.getFiringTicks() >= 60) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
            }
            if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.field_70146_Z.nextInt(64) == 0 && !this.isFiring()) {
                boolean flag;
                boolean bl = !TragicConfig.allowStun ? true : (flag = !this.func_82165_m(TragicPotion.Stun.field_76415_H));
                if (flag) {
                    this.setFiringTicks(120);
                }
            }
            if (this.getFiringTicks() >= 60 && this.field_70173_aa % 20 == 0 && this.func_70638_az() != null) {
                this.shootProjectiles();
            }
            if (this.field_70173_aa % 120 == 0 && this.func_110143_aJ() < this.func_110138_aP() && TragicConfig.norVoxRegeneration) {
                this.func_70691_i(6.0f);
            }
            if (!this.isFiring() && this.func_70638_az() == null && this.field_70173_aa % 60 == 0 && this.field_70146_Z.nextInt(4) == 0) {
                this.setNodTicks(20);
            }
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.68;
        }
    }

    protected void shootProjectiles() {
        if (!TragicConfig.norVoxProjectiles) {
            return;
        }
        if (this.getNorVoxType() == 0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70163_u - this.field_70163_u;
            double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.95f;
            for (int i = 0; i < 2 + this.field_70146_Z.nextInt(2); ++i) {
                EntityWitherSkull skull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                skull.field_70165_t = this.field_70165_t + 0.115 * d0;
                skull.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
                skull.field_70161_v = this.field_70161_v + 0.115 * d2;
                this.field_70170_p.func_72838_d((Entity)skull);
            }
        } else {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70163_u - this.field_70163_u;
            double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.925f;
            for (int i = 0; i < 2; ++i) {
                EntityStarShard shard = new EntityStarShard(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                shard.field_70165_t = this.field_70165_t + 0.115 * d0;
                shard.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
                shard.field_70161_v = this.field_70161_v + 0.115 + d2;
                this.field_70170_p.func_72838_d((Entity)shard);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        boolean result;
        if (this.field_70170_p.field_72995_K || par1DamageSource.func_94541_c() || par1DamageSource == DamageSource.field_82727_n) {
            return false;
        }
        if (par1DamageSource.func_76352_a()) {
            par2 /= 4.0f;
        }
        if (result = super.func_70097_a(par1DamageSource, par2)) {
            this.setAttackTime(10);
            if (this.getNodTicks() > 0) {
                this.setNodTicks(0);
            }
            if (this.isFiring() && par1DamageSource.func_76346_g() != null && this.field_70146_Z.nextInt(4) == 0 && this.getFiringTicks() >= 40) {
                this.setFiringTicks(0);
                if (TragicConfig.allowStun) {
                    this.func_70690_d(new PotionEffect(TragicPotion.Stun.field_76415_H, 60 + this.field_70146_Z.nextInt(40)));
                }
                if (TragicConfig.allowAchievements && par1DamageSource.func_76346_g() instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TragicAchievements.norVox);
                }
            }
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(8) == 0 && TragicConfig.allowSubmission) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(120) + 60, this.field_70146_Z.nextInt(2)));
        }
        return flag;
    }

    public int func_70658_aO() {
        return (int)(this.getNorVoxType() == 0 ? TragicConfig.norVoxStats[5] : TragicConfig.starVoxStats[5]);
    }

    protected void func_70069_a(float par1) {
    }

    public void func_70110_aj() {
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        if (i >= 63) {
            int z;
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            BiomeGenBase spawnBiome = this.field_70170_p.func_72807_a(x, z = MathHelper.func_76128_c((double)this.field_70161_v));
            if (spawnBiome == BiomeGenBase.field_76782_w || spawnBiome == BiomeGenBase.field_76792_x) {
                return this.field_70170_p.func_72957_l(x, i, z) > this.field_70146_Z.nextInt(7) ? false : super.func_70601_bi();
            }
            return false;
        }
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        int l = this.field_70170_p.func_72957_l(j, i, k);
        int b0 = 4;
        Calendar calendar = this.field_70170_p.func_83015_S();
        if (!(calendar.get(2) + 1 == 10 && calendar.get(5) >= 20 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 3)) {
            if (this.field_70146_Z.nextBoolean()) {
                return false;
            }
        } else {
            b0 = 7;
        }
        return l > this.field_70146_Z.nextInt(b0) ? false : super.func_70601_bi();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("norVoxType")) {
            this.setNorVoxType(tag.func_74771_c("norVoxType"));
        }
        if (tag.func_74764_b("firingTicks")) {
            this.setFiringTicks(tag.func_74762_e("firingTicks"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("textureID")) {
            this.setTextureID(tag.func_74771_c("textureID"));
        }
        if (tag.func_74764_b("nodTicks")) {
            this.setNodTicks(tag.func_74762_e("nodTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74774_a("norVoxType", this.getNorVoxType());
        tag.func_74768_a("firingTicks", this.getFiringTicks());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74774_a("textureID", this.getTextureID());
        tag.func_74768_a("nodTicks", this.getNodTicks());
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            BiomeGenBase biome = this.field_70170_p.func_72807_a((int)this.field_70165_t, (int)this.field_70161_v);
            this.setNorVoxType(biome instanceof BiomeGenStarlitPrarie ? (byte)1 : 0);
            this.setTextureID((byte)this.field_70146_Z.nextInt(8));
        }
        return super.func_110161_a(data);
    }

    @Override
    protected boolean isChangeAllowed() {
        return TragicConfig.allowVoxStellarum;
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? (this.getNorVoxType() == 0 ? "tragicmc:mob.norvox.scrape" : "tragicmc:mob.cryse.glass") : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? (this.getNorVoxType() == 0 ? "tragicmc:mob.norvox.hit" : "tragicmc:mob.cryse.hit") : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? (this.getNorVoxType() == 0 ? "tragicmc:mob.norvox.hit" : "tragicmc:mob.cryse.break") : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        if (this.getNorVoxType() == 0 && TragicConfig.allowMobSounds) {
            this.func_85030_a("tragicmc:mob.norvox.scrape", 0.45f, 1.0f);
        }
    }

    @Override
    public int getDropAmount() {
        return 3;
    }

    @Override
    public String getVariantName() {
        return "TragicMC.StarVox";
    }
}

