/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.miniboss;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.miniboss.TragicMiniBoss;
import tragicneko.tragicmc.entity.mob.EntityNorVox;
import tragicneko.tragicmc.entity.projectile.EntityStarShard;

public class EntityVoxStellarum
extends EntityNorVox
implements TragicMiniBoss {
    public EntityVoxStellarum(World par1World) {
        super(par1World);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 22;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.voxStellarumStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.voxStellarumStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.voxStellarumStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.voxStellarumStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.voxStellarumStats[4]);
    }

    @Override
    public boolean isMobVariant() {
        return false;
    }

    public boolean func_90999_ad() {
        return !this.isHealing() && this.func_70027_ad();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    @Override
    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    @Override
    protected void setNorVoxType(byte b) {
        this.field_70180_af.func_75692_b(17, (Object)0);
        this.func_70105_a(2.475f, 2.725f);
    }

    public int getSpinTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setSpinTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementSpinTicks() {
        int pow = this.getSpinTicks();
        this.setSpinTicks(--pow);
    }

    public boolean isSpinning() {
        return this.getSpinTicks() > 0;
    }

    public int getHealTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setHealTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    public boolean isHealing() {
        return this.getHealTicks() > 0;
    }

    private void decrementHealingTicks() {
        int pow = this.getHealTicks();
        this.setHealTicks(--pow);
    }

    public float getRotationSpeed() {
        return (float)Math.cos(0.3366127061571785 * (double)((float)this.getSpinTicks() / 100.0f) + 0.125) * 2.35f;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.func_70105_a(2.475f, 2.525f);
            if (this.isSpinning()) {
                this.field_70170_p.func_72869_a("crit", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.5, (this.field_70146_Z.nextDouble() - 0.6) * 0.1, this.field_70146_Z.nextDouble() * 0.1, (this.field_70146_Z.nextDouble() - 0.6) * 0.1);
            }
        } else {
            if (this.isSpinning()) {
                this.decrementSpinTicks();
                if (this.isFiring()) {
                    this.setFiringTicks(0);
                }
            }
            if (this.isHealing()) {
                this.decrementHealingTicks();
            }
            if (TragicConfig.allowStun && this.func_82165_m(TragicPotion.Stun.field_76415_H) || this.func_70638_az() == null) {
                this.setSpinTicks(0);
            }
            double modifier = Math.sin(0.33661270463935866 * ((double)this.getSpinTicks() / 100.0) - 0.125) * 0.235;
            AttributeModifier mod2 = new AttributeModifier(UUID.fromString("e20a064f-7022-4c64-99A2-181d3ac9eb17"), "voxStellarumSpinning", modifier, 0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(mod2);
            if (this.isSpinning() && this.getSpinTicks() >= 100 && this.getSpinTicks() <= 800) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(mod2);
                this.func_70031_b(true);
            } else {
                this.func_70031_b(false);
            }
            if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && !this.isFiring() && !this.isSpinning() && !this.isHealing() && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(8) == 0 && TragicConfig.voxStellarumHealing) {
                this.setHealTicks(500);
            }
            if (!this.isHealing() && !this.isFiring() && !this.isSpinning() && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(16) == 0 && this.func_70638_az() != null && TragicConfig.voxStellarumSpinAttack) {
                this.setSpinTicks(1000);
            }
            if (this.isHealing() && this.getHealTicks() >= 100) {
                double d = this.field_70181_x = this.field_70122_E ? 0.0 : -0.05;
                if (Math.abs(this.field_70159_w) > 0.25) {
                    this.field_70159_w *= 0.225;
                }
                if (Math.abs(this.field_70179_y) > 0.25) {
                    this.field_70179_y *= 0.225;
                }
                if (this.field_70173_aa % 4 == 0) {
                    this.func_70691_i(1.0f);
                }
                if (this.func_110143_aJ() >= this.func_110138_aP()) {
                    this.setHealTicks(0);
                }
            }
            if (this.isSpinning() && this.func_70638_az() != null && this.field_70173_aa % 2 == 0) {
                EntityLivingBase entity = this.func_70638_az();
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70161_v - this.field_70161_v;
                double d2 = entity.field_70163_u - this.field_70163_u;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                double d3 = 0.5;
                double d4 = this.getSpinTicks() >= 100 && this.getSpinTicks() <= 800 ? 0.22786 : 0.1433467;
                this.field_70159_w = d0 / (double)f2 * d3 * 0.100000011920929 + entity.field_70159_w * d4;
                this.field_70179_y = d1 / (double)f2 * d3 * 0.100000011920929 + entity.field_70179_y * d4;
                if (this.field_70181_x >= 0.25) {
                    this.field_70181_x = -0.15;
                }
                if (this.func_110143_aJ() <= this.func_110138_aP() / 3.0f && this.field_70173_aa % 10 == 0) {
                    this.shootProjectiles();
                }
            }
        }
    }

    @Override
    protected void shootProjectiles() {
        if (!TragicConfig.norVoxProjectiles) {
            return;
        }
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d1 = this.func_70638_az().field_70163_u - this.field_70163_u;
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.625f;
        int blah = this.isSpinning() ? 10 : 4;
        for (int i = 0; i < blah; ++i) {
            if (this.isSpinning()) {
                d0 = this.field_70146_Z.nextInt(16) - this.field_70146_Z.nextInt(16);
                d1 = this.field_70146_Z.nextInt(3) - this.field_70146_Z.nextInt(3);
                d2 = this.field_70146_Z.nextInt(16) - this.field_70146_Z.nextInt(16);
            }
            EntityStarShard shard = new EntityStarShard(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
            shard.field_70165_t = this.field_70165_t + 0.115 * d0;
            shard.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 3.0f / 4.0f);
            shard.field_70161_v = this.field_70161_v + 0.115 * d2;
            this.field_70170_p.func_72838_d((Entity)shard);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isSpinning() && this.getSpinTicks() >= 100 && this.getSpinTicks() <= 800) {
            par2 /= 4.0f;
            if (par1DamageSource.func_76352_a()) {
                par2 = 0.0f;
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.isHealing()) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag && this.isSpinning() && par1Entity instanceof EntityLivingBase && this.getSpinTicks() >= 100 && this.getSpinTicks() <= 800) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(60) + 120));
            par1Entity.field_70159_w += this.field_70159_w;
            par1Entity.field_70179_y += this.field_70179_y;
            par1Entity.field_70181_x += 0.35;
        }
        return flag;
    }

    public void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityLivingBase && this.isSpinning() && this.getSpinTicks() >= 100 && this.getSpinTicks() <= 800 && this.field_70173_aa % 4 == 0) {
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
            entity.field_70159_w *= 2.25;
            entity.field_70181_x *= 2.25;
            entity.field_70179_y *= 2.25;
            this.field_70159_w *= -2.25;
            this.field_70181_x *= 1.25;
            this.field_70179_y *= -2.25;
        }
    }

    @Override
    public int func_70658_aO() {
        return (int)TragicConfig.voxStellarumStats[5];
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.setTextureID((byte)this.field_70146_Z.nextInt(8));
        }
        return super.func_110161_a(data);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("spinTicks")) {
            this.setSpinTicks(tag.func_74762_e("spinTicks"));
        }
        if (tag.func_74764_b("healingTicks")) {
            this.setHealTicks(tag.func_74762_e("healingTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("spinTicks", this.getSpinTicks());
        tag.func_74768_a("healingTicks", this.getHealTicks());
    }

    @Override
    protected boolean isChangeAllowed() {
        return false;
    }

    public Class getLesserForm() {
        return EntityNorVox.class;
    }

    @Override
    public String func_70639_aQ() {
        return "tragicmc:mob.cryse.glass";
    }

    @Override
    public String func_70621_aR() {
        return "tragicmc:mob.cryse.hit";
    }

    @Override
    public String func_70673_aS() {
        return "tragicmc:mob.cryse.break";
    }

    @Override
    public float func_70647_i() {
        return 1.0f;
    }

    @Override
    public float func_70599_aP() {
        return 0.8f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    @Override
    public int func_70627_aG() {
        return super.func_70627_aG();
    }

    @Override
    protected void func_145780_a(int x, int y, int z, Block block) {
    }

    @Override
    public int getDropAmount() {
        return 5;
    }
}

