/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.dimension.TragicWorldProvider;
import tragicneko.tragicmc.entity.mob.TragicMob;
import tragicneko.tragicmc.util.EntityDropHelper;
import tragicneko.tragicmc.util.WorldHelper;

public abstract class TragicBoss
extends EntityMob
implements IBossDisplayData {
    private boolean hasDamagedEntity = false;

    public TragicBoss(World par1World) {
        super(par1World);
        this.field_70728_aV = 100;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70628_a(boolean flag, int l) {
        int i;
        super.func_70628_a(flag, l);
        int x = 3 + l;
        int amt = 0;
        if (TragicConfig.allowExtraBossLoot) {
            int amount = this.field_70146_Z.nextInt(6) + 4 * x;
            for (i = 0; i < amount; ++i) {
                if (this.field_70146_Z.nextBoolean()) {
                    ItemStack luxuryDrop = EntityDropHelper.getLuxuryDropForBoss();
                    if (luxuryDrop != null) {
                        this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, luxuryDrop));
                    }
                    ++amt;
                }
                if (amt >= 6 + x) break;
            }
        }
        int total = 0;
        for (i = 0; i < x + 3; ++i) {
            ItemStack drop;
            if (this.field_70146_Z.nextInt(100) <= TragicConfig.commonDropRate + x * 4) {
                drop = EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), true);
                if (drop != null) {
                    this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                }
                ++total;
            }
            if (flag && this.field_70146_Z.nextInt(25) <= TragicConfig.rareDropRate + x) {
                drop = EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), false);
                if (drop != null) {
                    this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
                }
                ++total;
            }
            if ((double)total >= (double)x * 2.5) break;
        }
        if (flag) {
            ItemStack drop = EntityDropHelper.getDropFromEntity(((Object)((Object)this)).getClass(), false);
            if (drop != null) {
                this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
            }
            if (TragicConfig.allowNonMobItems) {
                drop = new ItemStack(TragicItems.EtherealDistortion);
                this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop));
            }
        }
    }

    public void func_70645_a(DamageSource par1) {
        super.func_70645_a(par1);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, 4.0, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = list.get(i);
            if (this.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]).func_149688_o() != Material.field_151581_o) continue;
            this.field_70170_p.func_147468_f(coords[0], coords[1], coords[2]);
        }
        if (par1.func_76346_g() != null && par1.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par1.func_76346_g();
            if (TragicConfig.allowAchievements && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.killBoss);
            }
            if (!this.hasDamagedEntity && TragicConfig.allowAchievements && player instanceof EntityPlayerMP) {
                player.func_71029_a((StatBase)TragicAchievements.cantTouchThis);
            }
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("hasDamagedEntity")) {
            this.hasDamagedEntity = tag.func_74767_n("hasDamagedEntity");
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("hasDamagedEntity", this.hasDamagedEntity);
    }

    public void func_70636_d() {
        if (TragicConfig.allowCorruption && this.func_70644_a(TragicPotion.Corruption)) {
            this.func_82170_o(TragicPotion.Corruption.field_76415_H);
        }
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && (this.func_70638_az() instanceof TragicMob || this.func_70638_az() instanceof TragicBoss)) {
            this.func_70624_b(null);
        }
        if (this.field_70170_p.field_73013_u == EnumDifficulty.EASY && !TragicConfig.allowEasyBosses || this.field_70163_u <= -30.0 || this.field_70163_u > 280.0) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && TragicConfig.bossesDenyFlight) {
            List list = this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            for (EntityPlayerMP mp : list) {
                if (!mp.field_71075_bZ.field_75098_d) {
                    mp.field_71075_bZ.field_75101_c = false;
                    mp.field_71075_bZ.field_75100_b = false;
                }
                if (!TragicConfig.allowFlight || !mp.func_70644_a(TragicPotion.Flight)) continue;
                mp.func_82170_o(TragicPotion.Flight.field_76415_H);
            }
        }
    }

    public boolean func_70601_bi() {
        if (this.field_70146_Z.nextInt(10) != 0) {
            return false;
        }
        if (this.field_70163_u <= 63.0) {
            switch (this.field_70170_p.field_73011_w.field_76574_g) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.field_70146_Z.nextInt(4) == 0 ? false : super.func_70601_bi();
                }
                case -1: {
                    return false;
                }
            }
            if (this.field_70170_p.field_73011_w instanceof TragicWorldProvider) {
                return super.func_70601_bi();
            }
            return false;
        }
        return super.func_70601_bi();
    }

    public boolean func_70652_k(Entity par1Entity) {
        if (TragicConfig.allowStun && this.func_70644_a(TragicPotion.Stun)) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (flag) {
            this.hasDamagedEntity = true;
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (par1DamageSource.func_76346_g() != null) {
            if (par1DamageSource.func_76346_g() instanceof EntityPlayer && par2 >= (float)TragicConfig.bossDamageCap) {
                boolean flag;
                EntityPlayer player = (EntityPlayer)par1DamageSource.func_76346_g();
                boolean bl = player.func_71045_bC() == null ? false : (flag = player.func_71045_bC().func_77973_b() == TragicItems.BowOfJustice || player.func_71045_bC().func_77973_b() == TragicItems.SwordOfJustice);
                if (!player.field_71075_bZ.field_75098_d || !flag) {
                    par2 = MathHelper.func_76131_a((float)par2, (float)0.0f, (float)TragicConfig.bossDamageCap);
                }
            }
            if (this.field_70146_Z.nextBoolean() && this.func_70638_az() != null && par1DamageSource.func_76346_g() instanceof EntityLivingBase && this.func_70638_az() != par1DamageSource.func_76346_g()) {
                this.func_70624_b((EntityLivingBase)par1DamageSource.func_76346_g());
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean getMobGriefing() {
        return this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
    }

    public boolean getAllowLoot() {
        return this.field_70170_p.func_82736_K().func_82766_b("doMobLoot");
    }

    public boolean isEntityInRange(Entity entity, float min, float max) {
        float f = this.func_70032_d(entity);
        return f >= min && f <= max;
    }

    public int getIntegerInRange(int min, int max) {
        int cand = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)min, (int)max);
        return this.field_70146_Z.nextBoolean() ? cand : -cand;
    }

    public int getPlayersNearby() {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0)).size();
    }

    public int getPlayersNearby(int min, int max) {
        return MathHelper.func_76125_a((int)this.getPlayersNearby(), (int)min, (int)max);
    }

    public int getPlayersNearby(double range) {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(range, range, range)).size();
    }

    public int getPlayersNearby(double range, int min, int max) {
        return MathHelper.func_76125_a((int)this.getPlayersNearby(range), (int)min, (int)max);
    }

    public void healByFactor(float factor) {
        int i = this.getPlayersNearby();
        this.func_70691_i(factor * (float)i);
    }

    public void healByFactorRanged(float factor, float min, float max) {
        int i = this.getPlayersNearby();
        float f = MathHelper.func_76131_a((float)(factor * (float)i), (float)min, (float)max);
        this.func_70691_i(f);
    }

    public int getHighestSolidBlock(int posX, int posY, int posZ) {
        while (this.field_70170_p.func_147439_a(posX, posY, posZ).func_149688_o() == Material.field_151579_a && posY > 0) {
            --posY;
        }
        return posY;
    }

    public boolean isHalloween() {
        Calendar calendar = this.field_70170_p.func_83015_S();
        return calendar.get(2) + 1 == 10 && calendar.get(5) > 29 || calendar.get(2) + 1 == 11 || calendar.get(5) < 3;
    }
}

