/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicMC;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.alpha.EntityOverlordCore;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.projectile.EntityTimeBomb;
import tragicneko.tragicmc.util.DamageHelper;

public class EntityTimeController
extends TragicBoss {
    private static AttributeModifier mod = new AttributeModifier(UUID.fromString("c6334c3a-6cf4-4755-8fe5-d1b713c1f375"), "timeControllerSpeedBuff", TragicConfig.modifier[2], 0);
    private HashMap<Integer, double[]> tracker;
    private float storedDamage;
    private int ticksSinceFlux;

    public EntityTimeController(World par1World) {
        super(par1World);
        this.func_70105_a(1.245f, 3.05f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 70;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 16.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 64.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70178_ae = true;
        this.tracker = new HashMap();
        this.storedDamage = 0.0f;
    }

    private boolean addToTracker(Entity entity) {
        if (this.tracker.containsKey(entity.func_145782_y()) || entity.field_70128_L) {
            return false;
        }
        try {
            this.tracker.put(entity.func_145782_y(), new double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A});
        }
        catch (Exception e) {
            TragicMC.logError("There was an error adding an entity to the Time Controller's tracker.", e);
            return false;
        }
        return true;
    }

    private void addEntitiesToTracker(List<Entity> list) {
        Iterator<Entity> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addToTracker(iterator.next());
        }
    }

    private void doQuantumLeap() {
        if (this.tracker.isEmpty() || !TragicConfig.timeControllerQuantumLeap) {
            return;
        }
        for (int id : this.tracker.keySet()) {
            Entity entity = this.field_70170_p.func_73045_a(id);
            if (entity == null || entity instanceof EntityTimeController) continue;
            double[] values = this.tracker.get(id);
            entity.func_70012_b(values[0], values[1], values[2], (float)values[3], (float)values[4]);
            entity.func_85030_a("mob.endermen.portal", 0.4f, 1.0f);
            if (entity instanceof EntityLivingBase && this.field_70146_Z.nextBoolean()) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 120));
            }
            if (!(entity instanceof EntityPlayerMP) || !TragicConfig.allowAchievements) continue;
            ((EntityPlayerMP)entity).func_71029_a((StatBase)TragicAchievements.rewind);
        }
        this.tracker = new HashMap();
        if (TragicConfig.timeControllerTimeAltering) {
            this.field_70170_p.func_72877_b(this.field_70170_p.func_72820_D() - 250L);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
    }

    public int getLeapTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    private void setLeapTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    private void decrementLeapTicks() {
        int pow = this.getLeapTicks();
        this.setLeapTicks(--pow);
    }

    public int getFluxTicks() {
        return this.field_70180_af.func_75679_c(17);
    }

    private void setFluxTicks(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    private void decrementFluxTicks() {
        int pow = this.getFluxTicks();
        this.setFluxTicks(--pow);
    }

    public int getPurgeTicks() {
        return this.field_70180_af.func_75679_c(18);
    }

    private void setPurgeTicks(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    private void decrementPurgeTicks() {
        int pow = this.getPurgeTicks();
        this.setPurgeTicks(--pow);
    }

    public int getSpazTicks() {
        return this.field_70180_af.func_75679_c(19);
    }

    private void setSpazTicks(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    private void decrementSpazTicks() {
        int pow = this.getSpazTicks();
        this.setSpazTicks(--pow);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.timeControllerStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.timeControllerStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.timeControllerStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.timeControllerStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.timeControllerStats[4]);
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.allowAchievements) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.timeController);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.allowMobStatueDrops && this.field_70146_Z.nextInt(100) <= TragicConfig.mobStatueDropChance && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 3)));
        }
    }

    @Override
    public void func_70636_d() {
        int z;
        int y;
        int x;
        int i;
        this.field_70143_R = 0.0f;
        if (this.getLeapTicks() > 0 || this.getFluxTicks() > 0 || this.getSpazTicks() > 0) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        for (i = 0; i < Potion.field_76425_a.length; ++i) {
            if (Potion.field_76425_a[i] == null || !this.func_82165_m(i)) continue;
            this.func_82170_o(i);
        }
        super.func_70636_d();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.68;
        }
        if (this.getLeapTicks() == 140) {
            this.addEntitiesToTracker(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(32.0, 32.0, 32.0)));
        }
        if (this.getLeapTicks() == 1) {
            this.doQuantumLeap();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.getFluxTicks() > 10) {
                for (i = 0; i < 32; ++i) {
                    double d7 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                    double d8 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                    double d9 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                    double d0 = d7 + this.field_70165_t;
                    double d1 = d8 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    double d2 = d9 + this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d3 = 0.5;
                    double d4 = d0 / (double)f2 * d3 * 0.100000011920929 + d7 * 0.10000000298023223;
                    double d5 = d1 / (double)f2 * d3 * 0.100000011920929 + d8 * 0.10000000298023223;
                    double d6 = d2 / (double)f2 * d3 * 0.100000011920929 + d9 * 0.10000000298023223;
                    this.field_70170_p.func_72869_a("portal", d0, d1, d2, d4 * 15.5, d5 * 15.5, d6 * 15.5);
                }
                if (this.field_70146_Z.nextInt(64) == 0) {
                    for (int l = 0; l < 6; ++l) {
                        this.field_70170_p.func_72869_a("instantSpell", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.155, this.field_70163_u + 0.115 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.155, (double)(0.155f * this.field_70146_Z.nextFloat()), (double)(0.155f * this.field_70146_Z.nextFloat()), (double)(0.155f * this.field_70146_Z.nextFloat()));
                    }
                }
                this.pullEntities();
            } else if (this.getFluxTicks() == 5) {
                for (i = 0; i < 32; ++i) {
                    this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.255, this.field_70163_u + (double)this.field_70131_O / 2.0 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.255, (double)this.field_70146_Z.nextFloat(), (double)(0.155f * this.field_70146_Z.nextFloat()), (double)this.field_70146_Z.nextFloat());
                }
            }
            if (this.getLeapTicks() > 0) {
                for (i = 0; i < 4; ++i) {
                    this.field_70170_p.func_72869_a("portal", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.255, this.field_70163_u + (double)this.field_70131_O / 2.0 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.255, (double)this.field_70146_Z.nextFloat(), (double)(0.155f * this.field_70146_Z.nextFloat()), (double)this.field_70146_Z.nextFloat());
                }
            }
            if (this.field_70146_Z.nextInt(4) == 0 && this.getLeapTicks() == 0 && this.getFluxTicks() == 0) {
                this.field_70170_p.func_72869_a("happyVillager", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.255, this.field_70163_u + (double)this.field_70131_O / 2.0 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 2.255, (double)this.field_70146_Z.nextFloat(), (double)(0.155f * this.field_70146_Z.nextFloat()), (double)this.field_70146_Z.nextFloat());
            }
            return;
        }
        ++this.ticksSinceFlux;
        if (this.field_70173_aa % 5 == 0 && this.func_110143_aJ() < this.func_110138_aP() && this.getFluxTicks() == 0 && TragicConfig.timeControllerRegeneration) {
            this.func_70691_i(1.0f);
        }
        if (this.getLeapTicks() > 0) {
            this.decrementLeapTicks();
            if (TragicConfig.allowLeadFoot) {
                this.weighDownEntities();
            }
        }
        if (this.getFluxTicks() > 0) {
            if (this.getLeapTicks() > 0) {
                this.setLeapTicks(0);
            }
            this.decrementFluxTicks();
            if (TragicConfig.timeControllerFlux) {
                this.pullEntities();
            }
            if (TragicConfig.timeControllerTimeAltering) {
                this.field_70170_p.func_72877_b((long)(this.field_70146_Z.nextInt(48) * 500));
            }
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(mod);
        if (this.getPurgeTicks() > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(mod);
            this.decrementPurgeTicks();
        }
        if (this.getSpazTicks() > 0) {
            this.decrementSpazTicks();
        }
        if (this.getFluxTicks() == 2 && TragicConfig.timeControllerFlux) {
            this.damageNearbyEntities();
        }
        if (this.field_70146_Z.nextInt(1028) == 0 && this.getLeapTicks() == 0 && this.getFluxTicks() == 0 && this.getPurgeTicks() == 0 && this.getSpazTicks() == 0 && TragicConfig.timeControllerQuantumLeap) {
            this.setLeapTicks(180);
            if (TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.timecontroller.leap", 1.9f, 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(128) == 0 && this.ticksSinceFlux > 600 && this.getFluxTicks() == 0 && this.getLeapTicks() == 0 && this.getPurgeTicks() == 0 && this.getSpazTicks() == 0 && this.func_70638_az() != null && this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 12.0f) && TragicConfig.timeControllerFlux) {
            this.storedDamage = 0.0f;
            this.setFluxTicks(250);
            if (TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.timecontroller.flux", 1.9f, 1.0f);
            }
        }
        if (this.field_70146_Z.nextInt(64) == 0 && this.getPurgeTicks() == 0 && this.getLeapTicks() == 0 && this.getFluxTicks() == 0 && this.getSpazTicks() == 0 && this.func_70638_az() != null && this.isEntityInRange((Entity)this.func_70638_az(), 4.0f, 16.0f) && TragicConfig.timeControllerPurge) {
            this.setPurgeTicks(100 + this.field_70146_Z.nextInt(80));
        }
        if (this.getPurgeTicks() > 0 && this.field_70173_aa % 20 == 0 && TragicConfig.timeControllerPurge) {
            this.damageNearbyEntities();
        }
        if (this.getPurgeTicks() > 0) {
            this.func_70031_b(true);
            if (this.getPurgeTicks() % 10 == 0 && TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:mob.harvester.hover", 1.0f, 1.9f);
            }
        } else {
            this.func_70031_b(false);
        }
        if (this.getSpazTicks() > 0 && this.field_70173_aa % 5 == 0 && TragicConfig.timeControllerSpaz) {
            this.spazOut();
        }
        if (TragicConfig.timeControllerLuminescence && TragicConfig.allowMobIllumination && EntityOverlordCore.replaceableBlocks.contains(this.field_70170_p.func_147439_a(x = (int)(this.field_70165_t + (double)this.field_70146_Z.nextInt(2) - (double)this.field_70146_Z.nextInt(2)), y = (int)(this.field_70163_u + (double)this.field_70146_Z.nextInt(2) - (double)this.field_70146_Z.nextInt(2)), z = (int)(this.field_70161_v + (double)this.field_70146_Z.nextInt(2) - (double)this.field_70146_Z.nextInt(2))))) {
            this.field_70170_p.func_147449_b(x, y, z, TragicBlocks.Luminescence);
        }
    }

    private void weighDownEntities() {
        double d0 = 16.0;
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(d0, d0, d0));
        for (EntityLivingBase entity : list) {
            if (!entity.func_70685_l((Entity)this) || entity == this) continue;
            entity.func_70690_d(new PotionEffect(TragicPotion.LeadFoot.field_76415_H, 60));
        }
    }

    private void createTimeBombs() {
        if (!TragicConfig.timeControllerTimeBombs) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            int y1 = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)6, (int)10);
            int x1 = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)-14, (int)14);
            int z1 = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)-14, (int)14);
            double x = this.field_70165_t + (double)x1;
            double y = this.field_70163_u + (double)y1;
            double z = this.field_70161_v + (double)z1;
            EntityTimeBomb bomb = new EntityTimeBomb(this.field_70170_p, (EntityLivingBase)this, 0.0, -0.5, 0.0);
            bomb.func_70107_b(x, y, z);
            bomb.field_70179_y = 0.0;
            bomb.field_70159_w = 0.0;
            bomb.field_70181_x = -0.1;
            if (!this.field_70170_p.func_72855_b(bomb.field_70121_D) || !this.field_70170_p.func_72945_a((Entity)bomb, bomb.field_70121_D).isEmpty() || this.field_70170_p.func_72953_d(bomb.field_70121_D)) continue;
            this.field_70170_p.func_72838_d((Entity)bomb);
        }
    }

    private void spazOut() {
        if (!TragicConfig.timeControllerSpaz) {
            return;
        }
        double d0 = 16.0;
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(d0, d0, d0));
        for (EntityLivingBase entity : list) {
            if (!entity.func_70685_l((Entity)this) || entity == this || !this.field_70146_Z.nextBoolean()) continue;
            this.teleportEnemyAway(entity, true);
        }
        this.createTimeBombs();
        this.teleportRandomly();
    }

    private void damageNearbyEntities() {
        boolean flag2 = this.getPurgeTicks() > 0;
        double d0 = flag2 ? 4.0 : 16.0;
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(d0, d0, d0));
        for (EntityLivingBase entity : list) {
            if (!this.func_70685_l((Entity)entity) || entity == this) continue;
            if (!flag2) {
                boolean flag = !(entity instanceof EntityPlayer) || entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d;
                if (!flag) continue;
                entity.func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), this.storedDamage / (float)list.size());
                continue;
            }
            entity.func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), 1.0f);
        }
        if (!flag2) {
            this.storedDamage = 0.0f;
            this.ticksSinceFlux = 0;
        }
    }

    public void pullEntities() {
        double d0 = 16.0;
        List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(d0, d0, d0));
        for (EntityLivingBase entity : list) {
            double d4;
            float f2;
            double d3;
            double d2;
            double d1;
            if (!entity.func_70685_l((Entity)this) || entity == this) continue;
            if (entity instanceof EntityPlayer) {
                if (((EntityPlayer)entity).field_71075_bZ.field_75098_d || this.field_70173_aa % 4 != 0) continue;
                d1 = entity.field_70165_t - this.field_70165_t;
                d2 = entity.field_70161_v - this.field_70161_v;
                d3 = entity.field_70163_u - this.field_70163_u;
                f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
                d4 = 0.25;
                entity.field_70159_w = -d1 / (double)f2 * d4 * 0.200000011920929 + entity.field_70159_w * 0.3000000029802322;
                entity.field_70179_y = -d2 / (double)f2 * d4 * 0.200000011920929 + entity.field_70179_y * 0.3000000029802322;
                entity.field_70181_x = -d3 / (double)f2 * d4 * 0.100000011920929 + entity.field_70181_x * 0.3000000029802322;
                entity.func_70091_d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                continue;
            }
            d1 = entity.field_70165_t - this.field_70165_t;
            d2 = entity.field_70161_v - this.field_70161_v;
            d3 = entity.field_70163_u - this.field_70163_u;
            f2 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3));
            d4 = 0.5;
            entity.field_70159_w = -d1 / (double)f2 * d4 * 0.200000011920929 + entity.field_70159_w * 0.3000000029802322;
            entity.field_70179_y = -d2 / (double)f2 * d4 * 0.200000011920929 + entity.field_70179_y * 0.3000000029802322;
            entity.field_70181_x = -d3 / (double)f2 * d4 * 0.100000011920929 + entity.field_70181_x * 0.3000000029802322;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getPurgeTicks() > 0 && par1DamageSource.func_76352_a()) {
            return false;
        }
        if (this.getFluxTicks() > 0) {
            this.storedDamage += par2;
            return super.func_70097_a(par1DamageSource, 0.0f);
        }
        boolean result = super.func_70097_a(par1DamageSource, par2);
        if (result && this.getFluxTicks() == 0 && this.getLeapTicks() == 0 && this.getPurgeTicks() == 0 && this.field_70146_Z.nextInt(16) == 0 && this.func_110143_aJ() <= this.func_110138_aP() / 3.0f && this.getSpazTicks() == 0) {
            this.setSpazTicks(120);
            if (TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.timecontroller.error", 1.9f, 1.0f);
            }
        }
        return result;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || this.getFluxTicks() > 0 || this.getLeapTicks() > 0 || this.getSpazTicks() > 0) {
            return false;
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean result = par1Entity.func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), (f - 2.0f) * this.field_70146_Z.nextFloat() + 2.0f);
        if (result && this.getPurgeTicks() > 0) {
            par1Entity.field_70159_w *= 4.875;
            par1Entity.field_70179_y *= 4.875;
        }
        return result;
    }

    public int func_70658_aO() {
        return (int)TragicConfig.timeControllerStats[5];
    }

    public void func_82167_n(Entity entity) {
        super.func_82167_n(entity);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70173_aa % 10 == 0 && entity instanceof EntityLivingBase && this.getFluxTicks() > 0) {
            entity.func_70097_a(DamageHelper.causeModMagicDamageToEntity((EntityLivingBase)this), 1.0f);
        }
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(48) - 24);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 16.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - par1Entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e()), (double)(this.field_70161_v - par1Entity.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("happyVillager", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    protected boolean teleportEnemyAway(EntityLivingBase entity, boolean flag) {
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        for (int y1 = 0; y1 < 18; ++y1) {
            for (int z1 = -6; z1 < 7; ++z1) {
                for (int x1 = -6; x1 < 7; ++x1) {
                    if (!World.func_147466_a((IBlockAccess)this.field_70170_p, (int)((int)this.field_70165_t + x1), (int)((int)this.field_70163_u + y1 - 1), (int)((int)this.field_70161_v + z1)) || !this.field_70146_Z.nextBoolean()) continue;
                    if (entity instanceof EntityPlayerMP) {
                        EntityPlayerMP mp = (EntityPlayerMP)entity;
                        if (mp.field_71075_bZ.field_75098_d) {
                            return flag;
                        }
                        if (!mp.field_71135_a.func_147362_b().func_150724_d() || this.field_70170_p != mp.field_70170_p) continue;
                        if (mp.func_70115_ae()) {
                            mp.func_70078_a(null);
                        }
                        AxisAlignedBB bb = mp.field_70121_D.func_72329_c();
                        bb.func_72317_d(x + (double)x1, y + (double)y1, z + (double)z1);
                        if (!this.field_70170_p.func_72855_b(bb) || !this.field_70170_p.func_72945_a((Entity)mp, bb).isEmpty() || this.field_70170_p.func_72953_d(bb)) continue;
                        mp.field_71135_a.func_147364_a(x + (double)x1, y + (double)y1, z + (double)z1, mp.field_70177_z, mp.field_70125_A);
                        int short1 = 128;
                        for (int l = 0; l < short1; ++l) {
                            double d6 = (double)l / ((double)short1 - 1.0);
                            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            double d7 = x + (x + (double)x1 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            double d8 = y + (y + (double)y1 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                            double d9 = z + (z + (double)z1 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                        }
                        mp.field_70143_R = 0.0f;
                        this.field_70170_p.func_72956_a((Entity)mp, "mob.endermen.portal", 0.4f, 0.4f);
                        return flag;
                    }
                    entity.func_70107_b(x + (double)x1, y + (double)y1, z + (double)z1);
                    if (this.field_70170_p.func_72855_b(entity.field_70121_D) && this.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(entity.field_70121_D)) {
                        int short1 = 128;
                        for (int l = 0; l < short1; ++l) {
                            double d6 = (double)l / ((double)short1 - 1.0);
                            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            double d7 = x + (x + (double)x1 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            double d8 = y + (y + (double)y1 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                            double d9 = z + (z + (double)z1 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                        }
                        this.field_70170_p.func_72956_a((Entity)entity, "mob.endermen.portal", 0.4f, 0.4f);
                        return flag;
                    }
                    entity.func_70107_b(x, y, z);
                }
            }
        }
        return flag;
    }

    protected void func_70069_a(float par1) {
    }

    public void func_70690_d(PotionEffect effect) {
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("leapTicks")) {
            this.setLeapTicks(tag.func_74762_e("leapTicks"));
        }
        if (tag.func_74764_b("fluxTicks")) {
            this.setFluxTicks(tag.func_74762_e("fluxTicks"));
        }
        if (tag.func_74764_b("storedDamage")) {
            this.storedDamage = tag.func_74760_g("storedDamage");
        }
        if (tag.func_74764_b("fluxBuffer")) {
            this.ticksSinceFlux = tag.func_74762_e("fluxBuffer");
        }
        if (tag.func_74764_b("purgeTicks")) {
            this.setPurgeTicks(tag.func_74762_e("purgeTicks"));
        }
        if (tag.func_74764_b("spazTicks")) {
            this.setSpazTicks(tag.func_74762_e("spazTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("leapTicks", this.getLeapTicks());
        tag.func_74768_a("fluxTicks", this.getFluxTicks());
        tag.func_74776_a("storedDamage", this.storedDamage);
        tag.func_74768_a("fluxBuffer", this.ticksSinceFlux);
        tag.func_74768_a("purgeTicks", this.getPurgeTicks());
        tag.func_74768_a("spazTicks", this.getSpazTicks());
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.timecontroller.living" : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.timecontroller.hurt" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.timecontroller.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return 120;
    }
}

