/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.EntityAIWatchTarget;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.mob.EntityRagr;
import tragicneko.tragicmc.entity.projectile.EntityDarkMortor;
import tragicneko.tragicmc.entity.projectile.EntityIcicle;
import tragicneko.tragicmc.entity.projectile.EntityLargePumpkinbomb;
import tragicneko.tragicmc.entity.projectile.EntitySolarBomb;
import tragicneko.tragicmc.events.AmuletEvents;
import tragicneko.tragicmc.properties.PropertyDoom;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityClaymation
extends TragicBoss {
    private double[][] formValues = new double[][]{{TragicConfig.claymationStats[0], TragicConfig.claymationStats[1], TragicConfig.claymationStats[2], TragicConfig.claymationStats[3], TragicConfig.claymationStats[4]}, {TragicConfig.minotaurStats[0], TragicConfig.minotaurStats[1], TragicConfig.minotaurStats[2], TragicConfig.minotaurStats[3], TragicConfig.minotaurStats[4]}, {TragicConfig.apisStats[0], TragicConfig.apisStats[1], TragicConfig.apisStats[2], TragicConfig.apisStats[3], TragicConfig.apisStats[4]}, {TragicConfig.stinKingStats[0], TragicConfig.stinKingStats[1], TragicConfig.stinKingStats[2], TragicConfig.stinKingStats[3], TragicConfig.stinKingStats[4]}, {TragicConfig.norVoxStats[0], TragicConfig.norVoxStats[1], TragicConfig.norVoxStats[2], TragicConfig.norVoxStats[3], TragicConfig.norVoxStats[4]}, {TragicConfig.jabbaStats[0], TragicConfig.jabbaStats[1], TragicConfig.jabbaStats[2], TragicConfig.jabbaStats[3], TragicConfig.jabbaStats[4]}, {TragicConfig.ragrStats[0], TragicConfig.ragrStats[1], TragicConfig.ragrStats[2], TragicConfig.ragrStats[3], TragicConfig.ragrStats[4]}, {TragicConfig.skultarStats[0], TragicConfig.skultarStats[1], TragicConfig.skultarStats[2], TragicConfig.skultarStats[3], TragicConfig.skultarStats[4]}, {TragicConfig.kitsunakumaStats[0], TragicConfig.kitsunakumaStats[1], TragicConfig.kitsunakumaStats[2], TragicConfig.kitsunakumaStats[3], TragicConfig.kitsunakumaStats[4]}, {100.0, 0.25, 12.0, 32.0, 0.5}};
    private float[][] formSizes = new float[][]{{1.375f, 2.575f}, {0.725f, 2.575f}, {1.385f, 3.325f}, {1.7835f, 5.15f}, {1.135f, 1.575f}, {0.825f, 0.725f}, {1.335f, 2.675f}, {0.7f, 2.1f}, {0.745f, 1.745f}, {1.4f, 2.9f}};
    private int formTicks;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("8b42b35e-f870-40ca-ae74-95a38879bed0"), "claymationUtilitySpeedDebuff", TragicConfig.modifier[0], 0);

    public EntityClaymation(World par1World) {
        super(par1World);
        this.func_70105_a(1.375f, 2.575f);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchTarget((EntityLiving)this, 32.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70178_ae = true;
        this.field_70138_W = 1.5f;
        this.formTicks = 0;
        this.field_70728_aV = 50;
    }

    public boolean func_90999_ad() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.claymationStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.claymationStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.claymationStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.claymationStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.claymationStats[4]);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        float f = this.field_70170_p.field_73013_u == EnumDifficulty.HARD ? 200.0f : 150.0f;
        this.field_70180_af.func_75682_a(16, (Object)Float.valueOf(f));
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    private void updateHealth(float f) {
        this.field_70180_af.func_75692_b(16, (Object)Float.valueOf(f));
    }

    public float getActualHealth() {
        return this.field_70180_af.func_111145_d(16);
    }

    private void setEntityForm(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
        this.formTicks = 0;
        this.setFormAttributes();
        this.setFormSize();
        this.resetUtilityIntegers();
    }

    private void setFormAttributes() {
        int i = this.getEntityForm();
        double health = this.formValues[i][0];
        double speed = this.formValues[i][1];
        double attack = this.formValues[i][2];
        double follow = this.formValues[i][3];
        double knockback = this.formValues[i][4];
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(health);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(speed);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(attack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(follow);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(knockback);
        if (i == 0) {
            this.func_70606_j(this.getActualHealth());
            this.updateHealth(this.func_110143_aJ());
        } else {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    private void setFormSize() {
        int i = this.getEntityForm();
        float width = this.formSizes[i][0];
        float height = this.formSizes[i][1];
        this.func_70105_a(width, height);
    }

    public int getEntityForm() {
        return this.field_70180_af.func_75679_c(17);
    }

    private void resetUtilityIntegers() {
        this.field_70180_af.func_75692_b(18, (Object)0);
        this.field_70180_af.func_75692_b(19, (Object)0);
        this.field_70180_af.func_75692_b(20, (Object)0);
    }

    @Override
    public void func_70636_d() {
        if (this.getActualHealth() > 0.0f) {
            this.field_70725_aQ = 0;
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextBoolean()) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_72869_a("dripLava", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.556, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.1, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.556, 0.0, (double)(this.field_70146_Z.nextFloat() * -1.2556f), 0.0);
                }
            }
            this.setFormSize();
            return;
        }
        ++this.formTicks;
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.formTicks >= 150 && this.getEntityForm() == 0 && TragicConfig.claymationTransformation) {
            this.updateHealth(this.func_110143_aJ());
            if (this.func_70638_az() != null) {
                this.setEntityForm(this.field_70146_Z.nextInt(9) + 1);
            } else {
                this.field_70180_af.func_75692_b(18, (Object)50);
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(12.0f);
                    this.updateHealth(this.func_110143_aJ());
                }
            }
        } else if (this.formTicks >= 600 && this.getEntityForm() != 0) {
            if (this.func_70638_az() != null) {
                this.setEntityForm(this.field_70146_Z.nextInt(9) + 1);
            } else {
                this.setEntityForm(0);
            }
        }
        if (this.func_70638_az() != null) {
            this.updateAsForm();
        } else {
            this.resetUtilityIntegers();
        }
    }

    private void updateAsForm() {
        switch (this.getEntityForm()) {
            default: {
                this.updateAsClaymation();
                break;
            }
            case 1: {
                this.updateAsMinotaur();
                break;
            }
            case 2: {
                this.updateAsApis();
                break;
            }
            case 3: {
                this.updateAsStinKing();
                break;
            }
            case 4: {
                this.updateAsNorVox();
                break;
            }
            case 5: {
                this.updateAsJabba();
                break;
            }
            case 6: {
                this.updateAsRagr();
                break;
            }
            case 7: {
                this.updateAsSkultar();
                break;
            }
            case 8: {
                this.updateAsKitsunakuma();
                break;
            }
            case 9: {
                this.updateAsIronGolem();
            }
        }
    }

    private void updateAsClaymation() {
        if (this.getUtilityInt() > 0) {
            this.decrementUtilityInt();
        }
        if (this.getUtilityInt2() > 0) {
            this.decrementUtilityInt2();
        }
        if (this.getUtilityInt3() > 0) {
            this.decrementUtilityInt3();
        }
        if (this.isEntityInRange((Entity)this.func_70638_az(), 2.0f, 8.0f) && this.field_70122_E && this.field_70146_Z.nextInt(32) == 0 && this.func_70685_l((Entity)this.func_70638_az())) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            double d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            this.field_70159_w = d0 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70159_w * 0.40000000298023225;
            this.field_70179_y = d1 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70179_y * 0.40000000298023225;
            this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
            this.setUtilityInt(10);
            this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
        this.reflectPotionEffects();
        this.updateHealth(this.func_110143_aJ());
    }

    private void reflectPotionEffects() {
        if (!TragicConfig.claymationPotionReflection) {
            return;
        }
        PotionEffect[] effects = new PotionEffect[16];
        int a = 0;
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            Potion potion;
            if (Potion.field_76425_a[i] == null || !this.func_70644_a(potion = Potion.field_76425_a[i]) || !AmuletEvents.badPotions.contains(potion) || a >= effects.length) continue;
            PotionEffect temp = this.func_70660_b(potion);
            effects[a++] = new PotionEffect(potion.field_76415_H, temp.func_76459_b() * 2, temp.func_76458_c() * 2);
            this.func_82170_o(i);
        }
        EntityLivingBase entity = this.func_70638_az();
        for (PotionEffect effect : effects) {
            if (effect == null) continue;
            entity.func_70690_d(effect);
        }
    }

    private void updateAsMinotaur() {
        if (this.getUtilityInt() > 0) {
            this.decrementUtilityInt();
            this.func_70031_b(true);
        } else {
            this.func_70031_b(false);
        }
        if (this.isEntityInRange((Entity)this.func_70638_az(), 2.0f, 8.0f) && this.field_70122_E && this.field_70146_Z.nextInt(16) == 0 && this.getUtilityInt() == 0 && this.func_70685_l((Entity)this.func_70638_az())) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            double d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            this.field_70159_w = d0 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70159_w * 0.40000000298023225;
            this.field_70179_y = d1 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70179_y * 0.40000000298023225;
            this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
            this.setUtilityInt(20);
            this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
    }

    private void updateAsApis() {
        float f2;
        double d1;
        double d0;
        if (this.getUtilityInt2() > 0) {
            this.decrementUtilityInt2();
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
            if (this.getUtilityInt() > 0) {
                this.setUtilityInt(0);
            }
            if (this.getUtilityInt3() > 0) {
                this.setUtilityInt3(0);
            }
            this.func_70031_b(true);
        } else {
            this.func_70031_b(false);
        }
        if (this.getUtilityInt() > 0) {
            this.decrementUtilityInt();
        }
        if (this.getUtilityInt3() > 0) {
            this.decrementUtilityInt3();
        }
        if (this.isEntityInRange((Entity)this.func_70638_az(), 2.0f, 8.0f) && this.field_70122_E && this.field_70146_Z.nextInt(32) == 0 && this.getUtilityInt() == 0 && this.getUtilityInt2() == 0 && this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 0.5f, false);
            }
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            double d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            this.field_70159_w = d0 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70159_w * 0.40000000298023225;
            this.field_70179_y = d1 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70179_y * 0.40000000298023225;
            this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
            this.setUtilityInt(10);
            this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        } else if (this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 12.0f) && this.field_70122_E && this.field_70146_Z.nextInt(48) == 0 && this.getUtilityInt() == 0 && this.getUtilityInt2() == 0) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat(), false);
            }
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            double d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            this.field_70159_w = d0 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70159_w * 0.40000000298023225;
            this.field_70179_y = d1 / (double)f2 * 2.5 * 0.700000011920929 + this.field_70179_y * 0.40000000298023225;
            this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
            this.setUtilityInt(10);
            this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        } else if (this.func_70032_d((Entity)this.func_70638_az()) >= 12.0f && this.field_70122_E && this.field_70146_Z.nextInt(48) == 0 && this.getUtilityInt() == 0 && this.getUtilityInt2() == 0) {
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() + 0.5f, false);
            }
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f22 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f22 * 3.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
            this.field_70179_y = d1 / (double)f22 * 3.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
            this.field_70181_x = 0.45;
            this.setUtilityInt(10);
            this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        } else if (this.field_70122_E && this.field_70146_Z.nextInt(48) == 0 && this.getUtilityInt() == 0 && this.getUtilityInt2() == 0 && this.func_70032_d((Entity)this.func_70638_az()) <= 6.0f) {
            this.setUtilityInt2(40);
        }
        if (this.getUtilityInt2() == 1) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f - this.func_70032_d(entity));
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 1.225f + 4.0f, this.getMobGriefing());
        }
        if (this.func_70032_d((Entity)this.func_70638_az()) >= 12.0f && this.field_70146_Z.nextInt(8) == 0 && this.getUtilityInt() == 0) {
            double d02 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d12 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.95f;
            switch (this.field_70146_Z.nextInt(6)) {
                case 0: {
                    EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d02 + this.field_70146_Z.nextGaussian() * (double)f1, d12, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                    fireball.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                    this.field_70170_p.func_72838_d((Entity)fireball);
                    break;
                }
                case 1: {
                    EntitySolarBomb solarBomb = new EntitySolarBomb(this.field_70170_p, (EntityLivingBase)this, d02 + this.field_70146_Z.nextGaussian() * (double)f1, d12, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                    solarBomb.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                    this.field_70170_p.func_72838_d((Entity)solarBomb);
                    break;
                }
                case 2: {
                    EntitySolarBomb solarBomb2 = new EntitySolarBomb(this.field_70170_p, (EntityLivingBase)this, d02 + this.field_70146_Z.nextGaussian() * (double)f1, d12, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                    solarBomb2.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                    this.field_70170_p.func_72838_d((Entity)solarBomb2);
                    break;
                }
                default: {
                    for (int i = 0; i < 3; ++i) {
                        EntitySmallFireball fireball2 = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d02 + this.field_70146_Z.nextGaussian() * (double)f1, d12, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                        fireball2.field_70163_u = this.field_70163_u + (double)this.field_70131_O;
                        this.field_70170_p.func_72838_d((Entity)fireball2);
                    }
                }
            }
        }
    }

    private void updateAsStinKing() {
        if (this.getUtilityInt2() > 0) {
            this.func_70031_b(true);
            if (this.getUtilityInt() > 0) {
                this.setUtilityInt(0);
            }
            this.decrementUtilityInt2();
            if (this.func_70638_az().field_70163_u >= this.field_70163_u + 4.5) {
                this.setUtilityInt2(0);
            }
        } else {
            this.func_70031_b(false);
        }
        if (this.getUtilityInt2() == 0 && this.getUtilityInt() == 0 && this.isEntityInRange((Entity)this.func_70638_az(), 3.0f, 12.0f) && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(12) == 0 && this.func_70638_az().field_70122_E && this.field_70122_E) {
            this.setUtilityInt2(200);
        }
        if (this.getUtilityInt2() > 0) {
            if (this.getUtilityInt2() <= 170) {
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) * 30.0f;
                if (this.field_70123_F && f >= 2.0f) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, f / 2.0f * this.field_70146_Z.nextFloat() + f / 2.0f, this.getMobGriefing());
                    this.setUtilityInt2(0);
                } else {
                    double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                    double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                    this.field_70159_w += d0 / (double)f2 * 0.13 * 0.1100000011920929 + this.field_70159_w * 0.1000000298023224;
                    this.field_70179_y += d1 / (double)f2 * 0.13 * 0.1100000011920929 + this.field_70179_y * 0.1000000298023224;
                    this.field_70181_x = -0.1;
                }
            } else {
                this.field_70181_x = -0.1;
            }
        }
        if (this.getUtilityInt3() > 0) {
            this.decrementUtilityInt3();
            if (this.getUtilityInt2() > 0) {
                this.setUtilityInt2(0);
            }
            if (this.getUtilityInt() > 0) {
                this.setUtilityInt(0);
            }
        }
        if (this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(256) == 0 && TragicConfig.allowFear) {
            this.func_70638_az().func_70690_d(new PotionEffect(TragicPotion.Fear.field_76415_H, 60 + this.field_70146_Z.nextInt(160), this.field_70146_Z.nextInt(4)));
        }
        if (this.getUtilityInt2() == 0 && this.getUtilityInt3() == 0 && this.func_70032_d((Entity)this.func_70638_az()) >= 6.0f && this.field_70146_Z.nextInt(12) == 0 && this.field_70173_aa % 10 == 0) {
            this.setUtilityInt3(80);
        }
        if (this.getUtilityInt3() > 0 && this.getUtilityInt3() % 10 == 0) {
            this.doMortorFire();
        }
    }

    private void doMortorFire() {
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5);
        double d1 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5);
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.875f;
        EntityDarkMortor mortor = new EntityDarkMortor(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
        mortor.field_70163_u = this.field_70163_u + (double)this.field_70131_O + 0.5;
        mortor.field_70165_t += d0 * 0.04335;
        mortor.field_70161_v += d2 * 0.04335;
        mortor.field_70181_x += 0.66 * (double)f1;
        this.field_70170_p.func_72838_d((Entity)mortor);
    }

    private void updateAsNorVox() {
        if (this.getUtilityInt() > 0) {
            this.decrementUtilityInt();
        }
        if (this.getUtilityInt2() > 0) {
            this.decrementUtilityInt2();
        }
        if (this.getUtilityInt() >= 60) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
        if (this.field_70173_aa % 20 == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 1.0f && this.field_70146_Z.nextInt(8) == 0 && this.getUtilityInt() == 0) {
            this.setUtilityInt(120);
        }
        if (this.getUtilityInt() >= 60 && this.field_70173_aa % 20 == 0 && this.func_70638_az() != null) {
            this.shootVoxProjectiles();
        }
        if (this.field_70173_aa % 120 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(6.0f);
        }
    }

    private void shootVoxProjectiles() {
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d1 = this.func_70638_az().field_70163_u - this.field_70163_u;
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.95f;
        for (int i = 0; i < 2 + this.field_70146_Z.nextInt(2); ++i) {
            EntityWitherSkull skull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
            skull.field_70165_t = this.field_70165_t + 0.115 * d0;
            skull.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
            skull.field_70161_v = this.field_70161_v + 0.115 * d2;
            this.field_70170_p.func_72838_d((Entity)skull);
        }
    }

    private void updateAsJabba() {
        EntityPlayer player;
        if (this.getUtilityInt2() > 0) {
            this.decrementUtilityInt2();
        }
        this.incrementUtilityInt();
        if (this.getUtilityInt() >= 400) {
            if (this.field_70173_aa % 100 == 0) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.5f * this.field_70146_Z.nextFloat(), false);
            }
            if (this.field_70173_aa % 40 == 0) {
                this.shootJabbaProjectiles();
            }
            if (this.getUtilityInt2() == 0) {
                this.setUtilityInt2(10);
            }
        }
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 5.0f);
        }
        if (this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(3) == 0 && (player = this.field_70170_p.func_72856_b((Entity)this, 10.0)) != null && TragicConfig.allowDoom && this.func_70685_l((Entity)player)) {
            PropertyDoom doom = PropertyDoom.get(player);
            int i = this.field_70170_p.field_73013_u.func_151525_a();
            if (doom != null) {
                doom.increaseDoom(-((this.field_70146_Z.nextInt(3) + 1) * i));
            }
        }
    }

    private void shootJabbaProjectiles() {
        EntityLivingBase entity = this.func_70638_az();
        double d0 = entity.field_70165_t - this.field_70165_t;
        double d1 = entity.field_70121_D.field_72338_b + (double)(entity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
        double d2 = entity.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)entity)) * 0.5f;
        for (int i = 0; i < 5; ++i) {
            EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
            entitysmallfireball.field_70163_u = this.field_70163_u + 0.5;
            this.field_70170_p.func_72838_d((Entity)entitysmallfireball);
            if (this.getUtilityInt() < 50) continue;
            this.setUtilityInt(this.getUtilityInt() - 50);
        }
    }

    private void updateAsRagr() {
        this.incrementUtilityInt();
        if (this.field_70122_E && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(32) == 0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 1.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
            this.field_70179_y = d1 / (double)f2 * 1.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
            this.field_70181_x = 0.745;
        } else if (this.getUtilityInt() >= 600) {
            if (this.getUtilityInt() % 50 == 0 && this.field_70122_E) {
                double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                double d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
                float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
                this.field_70159_w = d0 / (double)f2 * 1.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
                this.field_70179_y = d1 / (double)f2 * 1.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
                this.field_70181_x = this.field_70146_Z.nextDouble() * 1.055 + 0.445;
            }
            if (this.getUtilityInt() >= 800) {
                this.setUtilityInt(400);
            }
        } else if (this.field_70122_E && this.field_70146_Z.nextBoolean()) {
            double d0 = this.field_70146_Z.nextDouble() * 1.45 - this.field_70146_Z.nextDouble() * 1.45;
            double d1 = this.field_70146_Z.nextDouble() * 1.45 - this.field_70146_Z.nextDouble() * 1.45;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            this.field_70159_w = d0 / (double)f2 * 1.5 * (double)0.8f + this.field_70159_w * 0.6000000029802323;
            this.field_70179_y = d1 / (double)f2 * 1.5 * (double)0.8f + this.field_70179_y * 0.6000000029802323;
            this.field_70181_x = 0.545;
        }
    }

    private void fallAsRagr(float par1) {
        boolean flag = this.getMobGriefing();
        if (par1 >= 8.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 3.0f + 2.0f, flag);
        } else if (par1 >= 4.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 2.0f + 1.0f, flag);
        } else if (par1 >= 2.0f) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextFloat() * 2.0f, flag);
        }
        if (!flag) {
            return;
        }
        int x = (int)this.field_70165_t;
        int y = (int)this.field_70163_u;
        int z = (int)this.field_70161_v;
        par1 = MathHelper.func_76131_a((float)(par1 / 2.0f), (float)1.0f, (float)4.0f);
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(this.field_70170_p, par1, x, y, z);
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = list.get(i);
            x = coords[0];
            Block block = this.field_70170_p.func_147439_a(x, y = coords[1], z = coords[2]);
            if (EntityRagr.crushableBlocks.contains(block)) {
                this.field_70170_p.func_147468_f(x, y, z);
                continue;
            }
            if (block == Blocks.field_150349_c) {
                this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150346_d);
                continue;
            }
            if (block == Blocks.field_150348_b) {
                this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150347_e);
                continue;
            }
            if (block == Blocks.field_150417_aV) {
                this.field_70170_p.func_147465_d(x, y, z, Blocks.field_150417_aV, 2, 2);
                continue;
            }
            if (block != Blocks.field_150347_e) continue;
            this.field_70170_p.func_147449_b(x, y, z, Blocks.field_150351_n);
        }
    }

    private void updateAsSkultar() {
        int x;
        float f2;
        double d2;
        double d1;
        int z;
        if (this.field_70146_Z.nextInt(524) == 0 && this.getUtilityInt() <= 0 && this.func_70638_az() != null || this.getUtilityInt3() >= 100 && this.func_70638_az() != null) {
            this.setUtilityInt(5);
        }
        if (this.getUtilityInt2() > 0) {
            this.decrementUtilityInt2();
        }
        if (this.field_70173_aa % 60 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(6.0f);
        }
        if (this.func_70638_az().func_110143_aJ() <= this.func_70638_az().func_110138_aP() / 4.0f) {
            this.setUtilityInt(5);
        }
        int n = z = this.func_110143_aJ() <= this.func_110138_aP() / 2.0f ? 2 : 1;
        if (this.func_70685_l((Entity)this.func_70638_az()) && this.field_70146_Z.nextInt(96 / z) == 0) {
            EntityLivingBase entity = this.func_70638_az();
            if (this.field_70146_Z.nextInt(72) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
            }
            if (this.field_70146_Z.nextInt(256) == 0) {
                entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
            }
            if (this.field_70146_Z.nextInt(128) == 0 && TragicConfig.allowInhibit) {
                entity.func_70690_d(new PotionEffect(TragicPotion.Inhibit.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
            }
            if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.allowCripple) {
                entity.func_70690_d(new PotionEffect(TragicPotion.Cripple.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
            }
            if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.allowDisorientation) {
                entity.func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
            }
            if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.allowMalnourish) {
                entity.func_70690_d(new PotionEffect(TragicPotion.Malnourish.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
            }
        }
        if (this.isEntityInRange((Entity)this.func_70638_az(), 2.0f, 6.0f) && this.field_70122_E && this.field_70146_Z.nextInt(16) == 0 && this.getUtilityInt2() == 0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            if (this.getUtilityInt() > 0) {
                this.field_70159_w = d0 / (double)f2 * 2.45 * (double)0.8f + this.field_70159_w * 0.8000000029802322;
                this.field_70179_y = d1 / (double)f2 * 2.45 * (double)0.8f + this.field_70179_y * 0.8000000029802322;
                this.field_70181_x = d2 / (double)f2 * 2.45 * (double)0.8f + this.field_70181_x * 0.8000000029802322;
            } else {
                this.field_70159_w = -d0 / (double)f2 * 2.45 * (double)0.8f + this.field_70159_w * 0.8000000029802322;
                this.field_70179_y = -d1 / (double)f2 * 2.45 * (double)0.8f + this.field_70179_y * 0.8000000029802322;
                this.field_70181_x = d2 / (double)f2 * 2.45 * (double)0.8f + this.field_70181_x * 0.8000000029802322;
            }
        } else if (this.func_70638_az() != null && this.isEntityInRange((Entity)this.func_70638_az(), 1.0f, 12.0f) && this.getUtilityInt2() == 0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            if (this.getUtilityInt() <= 0) {
                this.field_70159_w = -d0 / (double)f2 * 1.25 * 0.200000011920929 + this.field_70159_w * 0.10000000298023223;
                this.field_70179_y = -d1 / (double)f2 * 1.25 * 0.200000011920929 + this.field_70179_y * 0.10000000298023223;
                this.field_70181_x = d2 / (double)f2 * 1.25 * 0.200000011920929 + this.field_70181_x * 0.10000000298023223;
            }
        }
        int n2 = x = this.func_110143_aJ() <= this.func_110138_aP() / 2.0f ? 4 : 2;
        if (this.func_70032_d((Entity)this.func_70638_az()) > 4.0f && this.field_70146_Z.nextInt(64 / x) == 0 && this.func_70685_l((Entity)this.func_70638_az()) && this.getUtilityInt2() == 0) {
            double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            double d12 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d22 = this.func_70638_az().field_70161_v - this.field_70161_v;
            if (this.getUtilityInt() > 0) {
                EntityLargePumpkinbomb bomb = new EntityLargePumpkinbomb(this.field_70170_p, (EntityLivingBase)this);
                bomb.field_70163_u = this.field_70163_u + (double)this.field_70131_O * 2.0 / 3.0;
                this.field_70170_p.func_72838_d((Entity)bomb);
            } else {
                EntityWitherSkull skull = new EntityWitherSkull(this.field_70170_p, (EntityLivingBase)this, d0, d12, d22);
                skull.field_70163_u = this.field_70163_u + (double)this.field_70131_O * 2.0 / 3.0;
                this.field_70170_p.func_72838_d((Entity)skull);
            }
            if (this.field_70146_Z.nextInt(4) == 0 && this.getUtilityInt() < 10) {
                this.incrementUtilityInt();
            }
        }
        if (this.func_70032_d((Entity)this.func_70638_az()) <= 3.0f && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getUtilityInt2() == 0 && this.getUtilityInt() > 0 && this.field_70146_Z.nextInt(32) == 0) {
            this.setUtilityInt2(20);
        }
        if (this.func_70032_d((Entity)this.func_70638_az()) <= 3.0f && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.getUtilityInt2() == 1) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(4.0, 4.0, 4.0));
            for (int i = 0; i < list.size(); ++i) {
                boolean flag;
                EntityLivingBase target;
                if (!(list.get(i) instanceof EntityLivingBase) || !(this.func_70032_d((Entity)(target = (EntityLivingBase)list.get(i))) <= 3.0f) || !(flag = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), target instanceof EntityPlayer ? 10.0f : 20.0f))) continue;
                target.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, this.field_70146_Z.nextInt(160) + 120, 3));
                target.field_70159_w *= 2.25;
                target.field_70179_y *= 2.25;
            }
        }
    }

    private void updateAsKitsunakuma() {
        boolean flag;
        float f1;
        double d2;
        double d1;
        double d0;
        if (this.getUtilityInt2() > 0) {
            this.decrementUtilityInt2();
        }
        if (this.getUtilityInt() > 0) {
            this.decrementUtilityInt();
        }
        if (this.getUtilityInt3() > 0) {
            this.decrementUtilityInt3();
        }
        if (this.getUtilityInt2() == 1) {
            this.teleportRandomly();
        }
        if (this.getUtilityInt2() == 5 && this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) <= 5.0f) {
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        }
        if (this.getUtilityInt() > 0) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
        if (this.getUtilityInt() > 0 && (this.func_70032_d((Entity)this.func_70638_az()) < 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f)) {
            this.setUtilityInt(0);
        } else if (this.field_70122_E && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && this.field_70146_Z.nextInt(32) == 0) {
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70161_v - this.field_70161_v;
            d2 = this.func_70638_az().field_70163_u - this.field_70163_u;
            float f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            this.field_70159_w = d0 / (double)f2 * 1.05 * 0.500000011920929 + this.field_70159_w * 0.40000000298023225;
            this.field_70179_y = d1 / (double)f2 * 1.05 * 0.500000011920929 + this.field_70179_y * 0.40000000298023225;
            this.field_70181_x = d1 / (double)f2 * 1.1 * 0.200000011920929 + this.field_70181_x * (double)0.2f;
        }
        if (this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.field_70146_Z.nextInt(48) == 0) {
                EntityLivingBase entity = this.func_70638_az();
                if (this.field_70146_Z.nextInt(72) == 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                }
                if (this.field_70146_Z.nextInt(72) == 0 && TragicConfig.allowDisorientation) {
                    entity.func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, 300 + this.field_70146_Z.nextInt(320), this.field_70146_Z.nextInt(3)));
                }
                if (this.field_70146_Z.nextInt(72) == 0) {
                    entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300 + this.field_70146_Z.nextInt(320), 0));
                }
                if (this.field_70173_aa % 120 == 0 && this.field_70146_Z.nextInt(16) == 0) {
                    this.teleportRandomly();
                }
            }
            if (this.getUtilityInt3() % 20 == 0 && this.getUtilityInt3() > 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f) {
                d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
                d1 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
                f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.175f;
                for (int i = 0; i < 3; ++i) {
                    EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
                    fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
                    this.field_70170_p.func_72838_d((Entity)fireball);
                }
            }
        } else if (this.field_70146_Z.nextInt(56) == 0 || this.getUtilityInt3() > 0 && this.getUtilityInt3() % 20 == 0 && this.func_70032_d((Entity)this.func_70638_az()) > 4.0f || this.func_70032_d((Entity)this.func_70638_az()) >= 14.0f && this.field_70146_Z.nextInt(4) == 0) {
            this.teleportToEntity((Entity)this.func_70638_az());
        }
        if (this.isEntityInRange((Entity)this.func_70638_az(), 6.0f, 16.0f) && this.field_70146_Z.nextInt(4) == 0 && this.getUtilityInt() == 0 && this.func_70685_l((Entity)this.func_70638_az()) && this.field_70173_aa % 5 == 0) {
            this.setUtilityInt(40);
        }
        if (this.isEntityInRange((Entity)this.func_70638_az(), 4.0f, 16.0f) && this.func_70685_l((Entity)this.func_70638_az()) && this.getUtilityInt() > 0 && this.getUtilityInt() % 25 == 0) {
            d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
            d1 = this.func_70638_az().field_70121_D.field_72338_b + (double)(this.func_70638_az().field_70131_O / 3.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
            f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.375f;
            EntityLargeFireball fireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
            fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O * 2.0f / 3.0f);
            this.field_70170_p.func_72838_d((Entity)fireball);
        }
        if (this.func_70032_d((Entity)this.func_70638_az()) >= 12.0f && this.field_70146_Z.nextInt(36) == 0 && this.getUtilityInt() == 0 && !(flag = this.teleportToEntity((Entity)this.func_70638_az()))) {
            this.teleportRandomly();
        }
    }

    protected boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(48) - 24);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 24.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity par1Entity) {
        Vec3 vec3 = Vec3.func_72443_a((double)(this.field_70165_t - par1Entity.field_70165_t), (double)(this.field_70121_D.field_72338_b + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u + (double)par1Entity.func_70047_e()), (double)(this.field_70161_v - par1Entity.field_70161_v));
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double par1, double par3, double par5) {
        int k;
        int j;
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        boolean flag = false;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (this.field_70170_p.func_72899_e(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)this.field_70161_v))) {
            boolean flag1 = false;
            while (!flag1 && j > 0) {
                Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
                if (block.func_149688_o().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --j;
            }
            if (flag1) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D)) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_72869_a("flame", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.field_70170_p.func_72908_a(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.func_85030_a(this.func_70639_aQ() == null ? "mob.endermen.portal" : this.func_70639_aQ(), 1.0f, 1.0f);
        return true;
    }

    private void updateAsIronGolem() {
    }

    public int getUtilityInt() {
        return this.field_70180_af.func_75679_c(18);
    }

    private void setUtilityInt(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    private void decrementUtilityInt() {
        int pow = this.getUtilityInt();
        this.setUtilityInt(--pow);
    }

    private void incrementUtilityInt() {
        int pow = this.getUtilityInt();
        this.setUtilityInt(++pow);
    }

    public int getUtilityInt2() {
        return this.field_70180_af.func_75679_c(19);
    }

    private void setUtilityInt2(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    private void decrementUtilityInt2() {
        int pow = this.getUtilityInt2();
        this.setUtilityInt2(--pow);
    }

    public int getUtilityInt3() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setUtilityInt3(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementUtilityInt3() {
        int pow = this.getUtilityInt3();
        this.setUtilityInt3(--pow);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.getActualHealth() <= 0.0f) {
            this.setEntityForm(0);
        }
        if (this.getEntityForm() == 0 && source.func_76352_a() && source.func_76364_f() != null && !(source.func_76364_f() instanceof EntitySnowball) && !(source.func_76364_f() instanceof EntityIcicle)) {
            return false;
        }
        if (this.getEntityForm() != 0) {
            switch (this.getEntityForm()) {
                default: {
                    break;
                }
                case 1: {
                    damage = this.getMinotaurAttackResponse(source, damage);
                    break;
                }
                case 2: {
                    damage = this.getApisAttackResponse(source, damage);
                    break;
                }
                case 3: {
                    damage = this.getStinKingAttackResponse(source, damage);
                    break;
                }
                case 4: {
                    damage = this.getNorVoxAttackResponse(source, damage);
                    break;
                }
                case 5: {
                    damage = this.getJabbaAttackResponse(source, damage);
                    break;
                }
                case 6: {
                    damage = this.getRagrAttackResponse(source, damage);
                    break;
                }
                case 7: {
                    damage = this.getSkultarAttackResponse(source, damage);
                    break;
                }
                case 8: {
                    damage = this.getKitsunakumaAttackResponse(source, damage);
                    break;
                }
                case 9: {
                    damage = this.getIronGolemAttackResponse(source, damage);
                }
            }
            if (this.func_110143_aJ() - MathHelper.func_76131_a((float)(damage - (float)this.func_70658_aO()), (float)0.0f, (float)TragicConfig.bossDamageCap) <= 0.0f) {
                if ((this.getEntityForm() == 2 || this.getEntityForm() == 8 || this.getEntityForm() == 7) && TragicConfig.allowAchievements && source.func_76346_g() instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)source.func_76346_g()).func_71029_a((StatBase)TragicAchievements.claymation2in1);
                }
                this.setEntityForm(0);
                return true;
            }
        } else if (this.getUtilityInt2() == 0) {
            this.setUtilityInt2(10);
        }
        return super.func_70097_a(source, damage);
    }

    private float getMinotaurAttackResponse(DamageSource source, float damage) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && !source.func_76352_a() && !source.func_82725_o()) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (player.func_71045_bC() != null) {
                if (!(player.func_71045_bC().func_77973_b() instanceof ItemBow)) {
                    player.func_71045_bC().func_77972_a(this.field_70146_Z.nextInt(2) + 1, (EntityLivingBase)player);
                }
            } else {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 0.5f);
            }
        }
        if (!(source.func_76352_a() || source.func_94541_c() || source.func_82725_o())) {
            damage *= 0.65f;
        }
        if (this.getUtilityInt() > 0) {
            damage *= 0.45f;
        }
        return damage;
    }

    private float getApisAttackResponse(DamageSource source, float damage) {
        if (source.func_94541_c()) {
            return 0.0f;
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (player.func_71045_bC() != null) {
                if (!(player.func_71045_bC().func_77973_b() instanceof ItemBow)) {
                    player.func_71045_bC().func_77972_a(this.field_70146_Z.nextInt(2) + 1, (EntityLivingBase)player);
                }
            } else if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
                player.func_70015_d(this.field_70146_Z.nextInt(8) + 4);
            } else {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f);
            }
        }
        if (!source.func_76352_a()) {
            damage *= 0.425f;
        }
        if (this.getUtilityInt3() == 0 && this.getUtilityInt() == 0 && this.getUtilityInt2() == 0) {
            this.setUtilityInt3(10);
        }
        return damage;
    }

    private float getStinKingAttackResponse(DamageSource source, float damage) {
        if (this.field_70146_Z.nextInt(32) == 0) {
            return 0.0f;
        }
        if (this.getUtilityInt() == 0) {
            this.setUtilityInt(15);
        }
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityLivingBase && !source.func_76352_a() && this.field_70146_Z.nextInt(16) == 0) {
            this.teleportEnemyAway((EntityLivingBase)source.func_76346_g(), true);
            return 0.0f;
        }
        if (this.getUtilityInt2() > 170) {
            this.setUtilityInt2(0);
        }
        if (this.getUtilityInt2() > 0 && this.getUtilityInt2() <= 170) {
            damage /= 2.0f;
        }
        return damage;
    }

    private boolean teleportEnemyAway(EntityLivingBase entity, boolean flag) {
        double x = entity.field_70165_t;
        double y = entity.field_70163_u;
        double z = entity.field_70161_v;
        for (int y1 = 0; y1 < 24; ++y1) {
            for (int z1 = -8; z1 < 9; ++z1) {
                for (int x1 = -8; x1 < 9; ++x1) {
                    if (!World.func_147466_a((IBlockAccess)this.field_70170_p, (int)((int)this.field_70165_t + x1), (int)((int)this.field_70163_u + y1 - 1), (int)((int)this.field_70161_v + z1)) || !this.field_70146_Z.nextBoolean()) continue;
                    if (entity instanceof EntityPlayerMP) {
                        EntityPlayerMP mp = (EntityPlayerMP)entity;
                        if (mp.field_71075_bZ.field_75098_d) {
                            return flag;
                        }
                        if (!mp.field_71135_a.func_147362_b().func_150724_d() || this.field_70170_p != mp.field_70170_p) continue;
                        if (mp.func_70115_ae()) {
                            mp.func_70078_a(null);
                        }
                        AxisAlignedBB bb = mp.field_70121_D.func_72329_c();
                        bb.func_72317_d(x + (double)x1, y + (double)y1, z + (double)z1);
                        if (!this.field_70170_p.func_72855_b(bb) || !this.field_70170_p.func_72945_a((Entity)mp, bb).isEmpty() || this.field_70170_p.func_72953_d(bb)) continue;
                        mp.field_71135_a.func_147364_a(x + (double)x1, y + (double)y1, z + (double)z1, mp.field_70177_z, mp.field_70125_A);
                        int short1 = 128;
                        for (int l = 0; l < short1; ++l) {
                            double d6 = (double)l / ((double)short1 - 1.0);
                            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            double d7 = x + (x + (double)x1 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            double d8 = y + (y + (double)y1 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                            double d9 = z + (z + (double)z1 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                        }
                        mp.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200, 0));
                        mp.field_70143_R = 0.0f;
                        this.field_70170_p.func_72956_a((Entity)mp, "mob.endermen.portal", 0.4f, 0.4f);
                        return flag;
                    }
                    entity.func_70107_b(x + (double)x1, y + (double)y1, z + (double)z1);
                    if (this.field_70170_p.func_72855_b(entity.field_70121_D) && this.field_70170_p.func_72945_a((Entity)entity, entity.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(entity.field_70121_D)) {
                        int short1 = 128;
                        for (int l = 0; l < short1; ++l) {
                            double d6 = (double)l / ((double)short1 - 1.0);
                            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                            double d7 = x + (x + (double)x1 - x) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            double d8 = y + (y + (double)y1 - y) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
                            double d9 = z + (z + (double)z1 - z) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
                            this.field_70170_p.func_72869_a("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
                        }
                        this.field_70170_p.func_72956_a((Entity)entity, "mob.endermen.portal", 0.4f, 0.4f);
                        entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
                        return flag;
                    }
                    entity.func_70107_b(x, y, z);
                }
            }
        }
        return flag;
    }

    private float getNorVoxAttackResponse(DamageSource source, float damage) {
        if (source.func_94541_c() || source == DamageSource.field_82727_n) {
            return 0.0f;
        }
        if (source.func_76352_a()) {
            damage /= 4.0f;
        }
        this.setUtilityInt2(10);
        if (source.func_76346_g() != null && this.field_70146_Z.nextInt(8) == 0 && this.getUtilityInt() >= 40) {
            this.setUtilityInt(0);
        }
        return damage;
    }

    private float getJabbaAttackResponse(DamageSource source, float damage) {
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            damage /= 2.0f;
        }
        if (this.field_70146_Z.nextInt(8) == 0 && this.field_70170_p.field_73013_u == EnumDifficulty.HARD && source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer && !source.func_76352_a() && !source.func_82725_o() && !source.func_76347_k()) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (player.func_71045_bC() != null && !player.field_71075_bZ.field_75098_d && this.field_70146_Z.nextBoolean()) {
                player.func_71040_bB(true);
            } else if (this.field_70146_Z.nextInt(4) == 0) {
                player.func_70015_d(4 + this.field_70146_Z.nextInt(3));
            }
            if (!player.field_70122_E) {
                this.setUtilityInt(this.getUtilityInt() + 25);
            }
        }
        if (source == DamageSource.field_76369_e) {
            this.setUtilityInt(this.getUtilityInt() + 50);
        }
        if (this.getUtilityInt2() == 0) {
            this.setUtilityInt2(5);
        }
        return damage;
    }

    private float getRagrAttackResponse(DamageSource source, float damage) {
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            if (player.func_71045_bC() != null) {
                if (!(player.func_71045_bC().func_77973_b() instanceof ItemBow)) {
                    player.func_71045_bC().func_77972_a(this.field_70146_Z.nextInt(4) + 1, (EntityLivingBase)player);
                }
            } else {
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 1.0f);
            }
        }
        if (source.func_76352_a()) {
            damage /= 2.0f;
        }
        return damage;
    }

    private float getSkultarAttackResponse(DamageSource source, float damage) {
        this.trackHitType(source.func_76355_l());
        this.setUtilityInt3(0);
        return damage;
    }

    private void trackHitType(String damageType) {
        String hitType = null;
        boolean flag = false;
        if (damageType.equals("arrow")) {
            hitType = "projectile";
        } else if (damageType.equals("fireball")) {
            hitType = "projectile";
        } else if (damageType.equals("indirectMagic")) {
            hitType = "normal";
        } else if (damageType.equals("player")) {
            hitType = "normal";
            flag = true;
        } else if (damageType.equals("generic")) {
            hitType = "normal";
        } else if (damageType.equals("mob")) {
            hitType = "normal";
        }
        if (hitType == null) {
            return;
        }
        if (hitType == "projectile" && this.getUtilityInt() < 10) {
            this.incrementUtilityInt();
            if (flag && this.getUtilityInt() < 10) {
                this.incrementUtilityInt();
            }
        } else if (this.getUtilityInt() > -10) {
            this.decrementUtilityInt();
            if (flag && this.getUtilityInt() > -10) {
                this.decrementUtilityInt();
            }
        }
    }

    private float getKitsunakumaAttackResponse(DamageSource source, float damage) {
        if (this.getUtilityInt3() > 0) {
            return 0.0f;
        }
        boolean flag = false;
        if (source.func_76346_g() != null && source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            boolean bl = flag = player.func_71045_bC() != null && (player.func_71045_bC().func_77973_b() == TragicItems.SwordOfJustice || player.func_71045_bC().func_77973_b() == TragicItems.BowOfJustice);
        }
        if (!source.func_76355_l().equals("fireball") && !flag) {
            return 0.0f;
        }
        if (this.getUtilityInt3() == 0 && !flag) {
            this.setUtilityInt3(100);
        }
        float f = flag ? Float.MAX_VALUE : (damage = (float)(this.getUtilityInt() > 0 && this.getUtilityInt() % 20 >= 15 ? 20 : 10));
        if (!flag && source.func_76346_g() != null) {
            this.teleportToEntity(source.func_76346_g());
        }
        return damage;
    }

    private float getIronGolemAttackResponse(DamageSource source, float damage) {
        return damage;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        boolean flag = super.func_70652_k(par1Entity);
        if (!flag) {
            return flag;
        }
        if (this.getEntityForm() != 0) {
            switch (this.getEntityForm()) {
                default: {
                    break;
                }
                case 1: {
                    this.attackEntityAsMinotaur(par1Entity);
                    break;
                }
                case 2: {
                    this.attackEntityAsApis(par1Entity);
                    break;
                }
                case 3: {
                    this.attackEntityAsStinKing(par1Entity);
                    break;
                }
                case 4: {
                    this.attackEntityAsNorVox(par1Entity);
                    break;
                }
                case 5: {
                    this.attackEntityAsJabba(par1Entity);
                    break;
                }
                case 6: {
                    this.attackEntityAsRagr(par1Entity);
                    break;
                }
                case 7: {
                    this.attackEntityAsSkultar(par1Entity);
                    break;
                }
                case 8: {
                    this.attackEntityAsKitsunakuma(par1Entity);
                    break;
                }
                case 9: {
                    this.attackEntityAsIronGolem(par1Entity);
                    break;
                }
            }
        } else {
            if (this.field_70146_Z.nextInt(4) == 0) {
                par1Entity.func_70015_d(8 + this.field_70146_Z.nextInt(4));
            }
            if (this.getUtilityInt3() == 0) {
                this.setUtilityInt3(10);
            }
        }
        return flag;
    }

    private void attackEntityAsMinotaur(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(8) == 0) {
            switch (this.field_70146_Z.nextInt(3)) {
                default: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(200)));
                    break;
                }
                case 1: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.field_70146_Z.nextInt(200)));
                    break;
                }
                case 2: {
                    if (!TragicConfig.allowSubmission) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(200)));
                }
            }
        }
        if (this.getUtilityInt() > 0) {
            par1Entity.field_70159_w *= 1.2000000059604645;
            par1Entity.field_70179_y *= 1.2;
            par1Entity.field_70181_x += 0.3;
        }
    }

    private void attackEntityAsApis(Entity par1Entity) {
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            par1Entity.func_70015_d(8 + this.field_70146_Z.nextInt(12));
        }
        if (this.getUtilityInt() > 0) {
            par1Entity.field_70159_w *= 2.2000000059604643;
            par1Entity.field_70179_y *= 2.2;
            par1Entity.field_70181_x += 0.56;
        } else if (this.getUtilityInt3() == 0) {
            this.setUtilityInt3(10);
        }
    }

    private void attackEntityAsStinKing(Entity par1Entity) {
        if (this.getUtilityInt2() > 0 && this.getUtilityInt2() <= 170) {
            if (this.field_70146_Z.nextBoolean() && par1Entity instanceof EntityLivingBase) {
                ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 300, 0));
                if (TragicConfig.allowSubmission) {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, 300, 1 + this.field_70146_Z.nextInt(3)));
                }
            }
            par1Entity.field_70181_x += 1.222543;
            par1Entity.field_70159_w *= 1.65;
            par1Entity.field_70179_y *= 1.65;
        }
    }

    private void attackEntityAsNorVox(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(8) == 0 && TragicConfig.allowSubmission) {
            ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(120) + 60, this.field_70146_Z.nextInt(2)));
        }
    }

    private void attackEntityAsJabba(Entity par1Entity) {
        int i = MathHelper.func_76125_a((int)this.field_70170_p.field_73013_u.func_151525_a(), (int)1, (int)3);
        if (this.field_70146_Z.nextInt(MathHelper.func_76143_f((double)(9 / i))) == 0) {
            EntityPlayer player;
            if (this.field_70146_Z.nextInt(8) == 0) {
                par1Entity.func_70015_d(2 * i);
            }
            if (par1Entity instanceof EntityPlayer && i >= 3 && this.field_70146_Z.nextBoolean() && (player = (EntityPlayer)par1Entity).func_71045_bC() != null && !player.field_71075_bZ.field_75098_d) {
                player.func_71040_bB(true);
            }
        }
        this.setUtilityInt(this.getUtilityInt() + 10);
        if (this.getUtilityInt2() == 0) {
            this.setUtilityInt2(10);
        }
    }

    private void attackEntityAsRagr(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(4) == 0) {
            switch (this.field_70146_Z.nextInt(3)) {
                case 0: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(200)));
                    break;
                }
                case 1: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.field_70146_Z.nextInt(200)));
                    break;
                }
                case 2: {
                    if (!TragicConfig.allowSubmission) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(200)));
                }
            }
        }
        if (!this.field_70122_E) {
            par1Entity.field_70159_w *= 1.8000000059604646;
            par1Entity.field_70179_y *= 1.8;
            par1Entity.field_70181_x += 0.6;
        }
    }

    private void attackEntityAsSkultar(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextInt(8) == 0) {
            switch (this.field_70146_Z.nextInt(8)) {
                case 0: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 1: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 2: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 3: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 4: {
                    if (!TragicConfig.allowDisorientation) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 5: {
                    if (!TragicConfig.allowFear) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Fear.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                default: {
                    if (!TragicConfig.allowSubmission) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Submission.field_76415_H, this.field_70146_Z.nextInt(200) + 320, this.field_70146_Z.nextInt(2) + 1));
                }
            }
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            par1Entity.func_70015_d(4 + this.field_70146_Z.nextInt(12));
        }
        par1Entity.field_70159_w *= 1.4;
        par1Entity.field_70179_y *= 1.4;
        par1Entity.field_70181_x += 0.3;
        if (this.getUtilityInt2() == 0) {
            this.setUtilityInt2(10);
        }
    }

    private void attackEntityAsKitsunakuma(Entity par1Entity) {
        if (this.getUtilityInt() > 0) {
            this.setUtilityInt(0);
        }
        if (this.getUtilityInt2() == 0) {
            this.setUtilityInt2(10);
        }
        if (par1Entity instanceof EntityLivingBase && this.field_70146_Z.nextBoolean()) {
            switch (this.field_70146_Z.nextInt(8)) {
                default: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 1: {
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                    break;
                }
                case 2: {
                    if (!TragicConfig.allowDisorientation) break;
                    ((EntityLivingBase)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Disorientation.field_76415_H, this.field_70146_Z.nextInt(200) + 320));
                }
            }
        }
        if (this.field_70146_Z.nextInt(4) == 0) {
            par1Entity.func_70015_d(4 + this.field_70146_Z.nextInt(8));
        }
    }

    private void attackEntityAsIronGolem(Entity par1Entity) {
        par1Entity.field_70181_x += (double)0.4f;
        if (this.getUtilityInt() == 0) {
            this.setUtilityInt(10);
        }
    }

    public int func_70658_aO() {
        return this.getEntityForm() == 0 ? (int)TragicConfig.claymationStats[5] : MathHelper.func_76128_c((double)(TragicConfig.claymationStats[5] / 2.0));
    }

    protected void func_70069_a(float par1) {
        if (this.getEntityForm() == 6) {
            this.fallAsRagr(par1);
        }
    }

    public void func_70110_aj() {
    }

    @Override
    public int func_70641_bl() {
        return 1;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("clayForm")) {
            this.setEntityForm(tag.func_74762_e("clayForm"));
        }
        if (tag.func_74764_b("actualHealth")) {
            float f = tag.func_74760_g("actualHealth");
            if (this.getEntityForm() == 0) {
                this.func_70606_j(f);
            }
            this.updateHealth(f);
        }
        if (tag.func_74764_b("utility")) {
            this.setUtilityInt(tag.func_74762_e("utility"));
        }
        if (tag.func_74764_b("utility2")) {
            this.setUtilityInt2(tag.func_74762_e("utility2"));
        }
        if (tag.func_74764_b("utility3")) {
            this.setUtilityInt3(tag.func_74762_e("utility3"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74776_a("actualHealth", this.getActualHealth());
        tag.func_74768_a("clayForm", this.getEntityForm());
        tag.func_74768_a("utility", this.getUtilityInt());
        tag.func_74768_a("utility2", this.getUtilityInt2());
        tag.func_74768_a("utility3", this.getUtilityInt3());
    }

    @Override
    public void func_70645_a(DamageSource src) {
        super.func_70645_a(src);
        if (src.func_76346_g() instanceof EntityPlayerMP && TragicConfig.allowAchievements) {
            ((EntityPlayerMP)src.func_76346_g()).func_71029_a((StatBase)TragicAchievements.claymation);
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.allowMobStatueDrops && this.field_70146_Z.nextInt(100) <= TragicConfig.mobStatueDropChance && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 15)));
        }
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? (this.getEntityForm() == 0 ? "tragicmc:boss.claymation.line" : "tragicmc:boss.claymation.sop") : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.claymation.sop" : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.claymation.sop" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 1.0f;
    }

    public int func_70627_aG() {
        return 120;
    }
}

