/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.boss;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.boss.EntityAegarCrystal;
import tragicneko.tragicmc.entity.boss.EntityPart;
import tragicneko.tragicmc.entity.boss.IMultiPart;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.projectile.EntityCrystalMortor;
import tragicneko.tragicmc.util.DamageHelper;

public class EntityAegar
extends TragicBoss
implements IMultiPart {
    public EntityPart[] aegarParts;
    public EntityPart aegarBody;
    public EntityAegarCrystal aegarCrystal;
    public EntityPart aegarClaw;
    public EntityPart aegarCannon;
    public EntityPart aegarHead;
    private AttributeModifier mod = new AttributeModifier(UUID.fromString("8771eb81-724e-4d6b-91a4-d7e2cd17f82c"), "aegarSpeedBuff", TragicConfig.modifier[4], 0);

    public EntityAegar(World par1World) {
        super(par1World);
        EntityPart[] entityPartArray = new EntityPart[5];
        entityPartArray[0] = this.aegarBody = new EntityPart(this, "body", 1.0f, 1.0f);
        this.aegarCrystal = new EntityAegarCrystal(this);
        entityPartArray[1] = this.aegarCrystal;
        entityPartArray[2] = this.aegarClaw = new EntityPart(this, "claw", 1.5f, 1.5f);
        entityPartArray[3] = this.aegarCannon = new EntityPart(this, "cannon", 1.5f, 1.5f);
        entityPartArray[4] = this.aegarHead = new EntityPart(this, "head", 1.0f, 1.0f);
        this.aegarParts = entityPartArray;
        this.func_70105_a(2.1398249f, 3.592125f);
        this.field_70138_W = 2.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 32.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 1.0, 32.0f));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGolem.class, 0, true));
        this.field_70178_ae = true;
        this.field_70728_aV = 36;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Synapse;
    }

    @Override
    public boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.aegarStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.aegarStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.aegarStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.aegarStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.aegarStats[4]);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(24, (Object)0);
    }

    public boolean getHypermode() {
        return this.field_70180_af.func_75679_c(16) == 1;
    }

    private void setHypermode(boolean flag) {
        this.field_70180_af.func_75692_b(16, (Object)(flag ? 1 : 0));
    }

    public int getStunTicks() {
        return this.field_70180_af.func_75679_c(17);
    }

    private void setStunTicks(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    private void decrementStunTicks() {
        this.setStunTicks(this.getStunTicks() - 1);
    }

    public int getShockwaveTicks() {
        return this.field_70180_af.func_75679_c(18);
    }

    private void setShockwaveTicks(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    private void decrementShockwaveTicks() {
        this.setShockwaveTicks(this.getShockwaveTicks() - 1);
    }

    public int getAttackTime() {
        return this.field_70180_af.func_75679_c(19);
    }

    private void setAttackTime(int i) {
        this.field_70180_af.func_75692_b(19, (Object)i);
    }

    private void decrementAttackTime() {
        this.setAttackTime(this.getAttackTime() - 1);
    }

    public int getHurtTime() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setHurtTime(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementHurtTime() {
        this.setHurtTime(this.getHurtTime() - 1);
    }

    public int getLaserTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void setLaserTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    private void decrementLaserTicks() {
        this.setLaserTicks(this.getLaserTicks() - 1);
    }

    public int getMortorTicks() {
        return this.field_70180_af.func_75679_c(22);
    }

    private void setMortorTicks(int i) {
        this.field_70180_af.func_75692_b(22, (Object)i);
    }

    private void decrementMortorTicks() {
        this.setMortorTicks(this.getMortorTicks() - 1);
    }

    public int getAutoTicks() {
        return this.field_70180_af.func_75679_c(23);
    }

    private void setAutoTicks(int i) {
        this.field_70180_af.func_75692_b(23, (Object)i);
    }

    private void decrementAutoTicks() {
        this.setAutoTicks(this.getAutoTicks() - 1);
    }

    public int getTargetID() {
        return this.field_70180_af.func_75679_c(24);
    }

    private void setTargetID(int i) {
        this.field_70180_af.func_75692_b(24, (Object)i);
    }

    private boolean canUseAbility() {
        return this.getStunTicks() == 0 && this.getShockwaveTicks() == 0 && this.getLaserTicks() == 0 && this.getMortorTicks() == 0 && this.getAutoTicks() == 0;
    }

    @Override
    public void func_70636_d() {
        if (this.getStunTicks() > 0) {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = -0.1;
            if (this.getShockwaveTicks() > 0) {
                this.setShockwaveTicks(0);
            }
            if (this.getHurtTime() > 0) {
                this.setHurtTime(0);
            }
            if (this.getAttackTime() > 0) {
                this.setAttackTime(0);
            }
            if (this.getLaserTicks() > 0) {
                this.setLaserTicks(0);
            }
            if (this.getMortorTicks() > 0) {
                this.setMortorTicks(0);
            }
        }
        if (this.getLaserTicks() > 0 || this.getShockwaveTicks() > 0 || this.getMortorTicks() > 20) {
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70636_d();
        float f1 = this.field_70177_z * (float)Math.PI / 180.0f;
        float f2 = MathHelper.func_76126_a((float)f1);
        float f3 = MathHelper.func_76134_b((float)f1);
        this.aegarHead.field_70130_N = 0.35f;
        this.aegarHead.field_70131_O = 0.75f;
        this.aegarCrystal.field_70131_O = 0.65f;
        this.aegarCrystal.field_70130_N = 0.45f;
        this.aegarBody.field_70130_N = 0.45f;
        this.aegarBody.field_70131_O = 0.45f;
        this.aegarClaw.field_70130_N = 0.55f;
        this.aegarCannon.field_70130_N = 0.55f;
        this.aegarCannon.field_70131_O = 1.25f;
        this.aegarClaw.field_70131_O = 1.25f;
        this.aegarHead.func_70012_b(this.field_70165_t + (double)f2 * 0.025, this.field_70163_u + 3.25, this.field_70161_v + (double)f3 * 0.025, 0.0f, 0.0f);
        this.aegarCrystal.func_70012_b(this.field_70165_t + (double)f2 * 0.025, this.field_70163_u + 2.55, this.field_70161_v + (double)f3 * 0.025, 0.0f, 0.0f);
        this.aegarBody.func_70012_b(this.field_70165_t + (double)f2 * 0.025, this.field_70163_u + 1.25, this.field_70161_v + (double)f3 * 0.025, 0.0f, 0.0f);
        this.aegarCannon.func_70012_b(this.field_70165_t + (double)f3 * 0.875, this.field_70163_u + 1.2, this.field_70161_v + (double)f2 * 0.875, 0.0f, 0.0f);
        this.aegarClaw.func_70012_b(this.field_70165_t - (double)f3 * 0.875, this.field_70163_u + 1.2, this.field_70161_v - (double)f2 * 0.875, 0.0f, 0.0f);
        for (EntityPart aegarPart : this.aegarParts) {
            if (aegarPart.func_70027_ad()) {
                aegarPart.func_70066_B();
            }
            aegarPart.func_70071_h_();
        }
        if (this.field_70170_p.field_72995_K) {
            Entity entity;
            int i;
            String s = this.getHypermode() ? "reddust" : "happyVillager";
            this.aegarCrystal.field_70170_p.func_72869_a(s, this.aegarCrystal.field_70165_t + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), this.aegarCrystal.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.aegarCrystal.field_70131_O, this.aegarCrystal.field_70161_v + this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble(), 0.0, 0.0, 0.0);
            if (this.field_70146_Z.nextBoolean()) {
                this.field_70170_p.func_72869_a(s, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + 0.15, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 4; ++i) {
                this.field_70170_p.func_72869_a("mobSpellAmbient", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.55, this.field_70163_u + 0.25 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.55, 0.0, 0.0, 0.0);
            }
            if (this.getHurtTime() >= 8) {
                for (i = 0; i < 12; ++i) {
                    this.field_70170_p.func_72869_a(s, this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + 0.15, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
                }
            }
            if (this.getMortorTicks() > 20) {
                for (i = 0; i < 32; ++i) {
                    double d7 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                    double d8 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                    double d9 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                    double d0 = d7 + this.field_70165_t;
                    double d1 = d8 + this.field_70163_u + (double)this.aegarCannon.field_70131_O / 2.0;
                    double d2 = d9 + this.field_70161_v;
                    float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    double d3 = 0.75;
                    double d4 = d0 / (double)f4 * d3 * 0.100000011920929 + d7 * 0.10000000298023223;
                    double d5 = d1 / (double)f4 * d3 * 0.100000011920929 + d8 * 0.10000000298023223;
                    double d6 = d2 / (double)f4 * d3 * 0.100000011920929 + d9 * 0.10000000298023223;
                    this.field_70170_p.func_72869_a("reddust", d0, d1, d2, d4 * 2.5, d5 * 2.5, d6 * 2.5);
                }
            }
            if (this.getLaserTicks() > 20 || this.getAutoTicks() > 20) {
                for (i = 0; i < 3; ++i) {
                    this.field_70170_p.func_72869_a("flame", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.55, this.field_70163_u + 2.25 + this.field_70146_Z.nextDouble(), this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 0.55, 0.0, 0.0, 0.0);
                }
            }
            if ((this.getLaserTicks() == 5 || this.getAutoTicks() > 0 && this.getAutoTicks() % 5 == 0) && (entity = this.field_70170_p.func_73045_a(this.getTargetID())) != null) {
                double d0 = entity.field_70165_t - this.aegarCannon.field_70165_t;
                double d1 = entity.field_70163_u - this.aegarCannon.field_70163_u;
                double d2 = entity.field_70161_v - this.aegarCannon.field_70161_v;
                for (int l = 0; l < 4; ++l) {
                    double d3 = 0.23 * (double)l + this.field_70146_Z.nextDouble() * 0.25;
                    this.field_70170_p.func_72869_a("flame", this.aegarCannon.field_70165_t + d0 * d3, this.aegarCannon.field_70163_u + d1 * d3 + 1.25, this.aegarCannon.field_70161_v + d2 * d3, 0.0, 0.0, 0.0);
                }
            }
            if (this.getShockwaveTicks() > 7) {
                for (int i2 = 0; i2 < 12; ++i2) {
                    this.field_70170_p.func_72869_a("smoke", this.field_70165_t + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.25, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble()) * 1.25, 0.0, this.field_70146_Z.nextDouble() * 2.0 + 1.0, 0.0);
                }
            }
            return;
        }
        if (this.getStunTicks() > 0) {
            this.decrementStunTicks();
        }
        if (this.getShockwaveTicks() > 0) {
            this.decrementShockwaveTicks();
        }
        if (this.getHurtTime() > 0) {
            this.decrementHurtTime();
        }
        if (this.getAttackTime() > 0) {
            this.decrementAttackTime();
        }
        if (this.getLaserTicks() > 0) {
            this.decrementLaserTicks();
        }
        if (this.getMortorTicks() > 0) {
            this.decrementMortorTicks();
        }
        if (this.getAutoTicks() > 0) {
            this.decrementAutoTicks();
        }
        if (this.aegarCrystal.getHealth() <= 0.0f && !this.getHypermode()) {
            this.onCrystalDestruction();
        }
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.mod);
        if (this.getHypermode()) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.mod);
        }
        if (this.func_70638_az() == null) {
            if (this.getShockwaveTicks() > 0) {
                this.setShockwaveTicks(0);
            }
            if (this.getLaserTicks() > 0) {
                this.setLaserTicks(0);
            }
            if (this.getMortorTicks() > 0) {
                this.setMortorTicks(0);
            }
            if (this.getAutoTicks() > 0) {
                this.setAutoTicks(0);
            }
            this.setTargetID(0);
        } else {
            this.setTargetID(this.func_70638_az().func_145782_y());
            if (this.canUseAbility() && this.func_70032_d((Entity)this.func_70638_az()) >= 8.0f && this.field_70146_Z.nextInt(64) == 0 && TragicConfig.aegarLasers) {
                this.setLaserTicks(40);
            }
            if (this.canUseAbility() && this.func_70032_d((Entity)this.func_70638_az()) >= 4.0f && this.field_70146_Z.nextInt(128) == 0 && this.getHypermode() && TragicConfig.aegarLasers) {
                this.setAutoTicks(100 + this.field_70146_Z.nextInt(80));
            }
            if (this.getLaserTicks() == 5 && this.func_70685_l((Entity)this.func_70638_az()) || this.getAutoTicks() > 20 && this.getAutoTicks() % 5 == 0 && this.func_70685_l((Entity)this.func_70638_az())) {
                this.fireLaser();
            }
            if (this.getLaserTicks() > 0 && !this.func_70685_l((Entity)this.func_70638_az())) {
                this.setLaserTicks(0);
            }
            if (this.canUseAbility() && this.func_70032_d((Entity)this.func_70638_az()) <= 6.0f && this.field_70146_Z.nextInt(this.getHypermode() ? 48 : 128) == 0 && this.field_70122_E && TragicConfig.aegarShockwave) {
                if (TragicConfig.allowMobSounds) {
                    this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.shockwave", 1.0f, 1.0f);
                }
                this.setShockwaveTicks(60);
            }
            if (this.getShockwaveTicks() == 5) {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0f + 2.0f * this.field_70146_Z.nextFloat(), this.getMobGriefing());
                this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(6.0, 6.0, 6.0)));
            }
            if (this.canUseAbility() && this.func_70032_d((Entity)this.func_70638_az()) > 12.0f && this.getHypermode() && this.field_70146_Z.nextInt(128) == 0 && TragicConfig.aegarMortors) {
                this.setMortorTicks(100);
            }
            if (this.getMortorTicks() > 20 && this.getMortorTicks() % 20 == 0) {
                this.createCrystalMortors();
            }
        }
    }

    private void createCrystalMortors() {
        if (!TragicConfig.aegarMortors) {
            return;
        }
        double d0 = this.func_70638_az().field_70165_t - this.field_70165_t;
        double d1 = this.field_70146_Z.nextInt(4);
        double d2 = this.func_70638_az().field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d((Entity)this.func_70638_az())) * 0.975f;
        EntityCrystalMortor mortor = new EntityCrystalMortor(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
        mortor.field_70163_u = this.field_70163_u + (double)this.field_70131_O + 0.5;
        mortor.field_70165_t += d0 * 0.04335;
        mortor.field_70161_v += d2 * 0.04335;
        mortor.field_70181_x += 0.36 * (double)f1;
        this.field_70170_p.func_72838_d((Entity)mortor);
        if (TragicConfig.allowMobSounds) {
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.trill", 0.6f, 1.0f);
        }
    }

    private void fireLaser() {
        if (!TragicConfig.aegarLasers) {
            return;
        }
        if (TragicConfig.allowMobSounds) {
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.laser", 1.0f, 1.0f);
            this.field_70170_p.func_72956_a((Entity)this.func_70638_az(), "tragicmc:boss.aegar.laser", 1.0f, 1.0f);
        }
        this.func_70638_az().func_70097_a(DamageHelper.causeArmorPiercingDamageToEntity((EntityLivingBase)this), 1.0f + this.field_70146_Z.nextFloat());
    }

    private void onCrystalDestruction() {
        if (TragicConfig.aegarHypermode) {
            this.setHypermode(true);
        }
        super.func_70097_a(DamageSource.field_76376_m, 75.0f);
        this.setStunTicks(120);
        if (this.getShockwaveTicks() > 0) {
            this.setShockwaveTicks(0);
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(0);
        }
        if (this.getAttackTime() > 0) {
            this.setAttackTime(0);
        }
        if (this.getLaserTicks() > 0) {
            this.setLaserTicks(0);
        }
        if (this.getMortorTicks() > 0) {
            this.setMortorTicks(0);
        }
    }

    public int func_70658_aO() {
        return (int)TragicConfig.aegarStats[5];
    }

    protected void func_70069_a(float par1) {
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public void func_70015_d(int i) {
    }

    public void func_70077_a(EntityLightningBolt bolt) {
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() != null && !(source.func_76346_g() instanceof EntityPlayer)) {
            return this.attackEntityFromPart(this.getDefaultPart(), source, damage);
        }
        return false;
    }

    public Entity[] func_70021_al() {
        return this.aegarParts;
    }

    @Override
    public boolean attackEntityFromPart(EntityPart entity, DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K || source.func_76347_k() || source == DamageSource.field_76369_e) {
            return false;
        }
        if (this.getHurtTime() == 0) {
            this.setHurtTime(10);
        }
        if (source.func_76357_e()) {
            super.func_70097_a(source, damage);
            return true;
        }
        if (this.aegarCrystal.getHealth() <= 0.0f) {
            damage *= 1.15f;
        } else if (entity == this.aegarCrystal) {
            if (TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.aegar.harshhurt", 0.6f, 1.0f);
            }
            damage *= 1.35f;
        } else {
            damage *= 0.95f;
        }
        if (source.func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)source.func_76346_g()).func_70668_bt() != TragicEntities.Synapse) {
            super.func_70097_a(source, damage);
        }
        return true;
    }

    @Override
    public boolean func_70652_k(Entity par1Entity) {
        if (this.field_70170_p.field_72995_K || this.getAttackTime() != 0 || this.getStunTicks() > 0 || this.func_70032_d(par1Entity) > 3.0f || this.getShockwaveTicks() > 0 || this.getLaserTicks() > 0) {
            return false;
        }
        boolean result = super.func_70652_k(par1Entity);
        if (result) {
            this.setAttackTime(20);
            par1Entity.field_70159_w *= 2.35;
            par1Entity.field_70179_y *= 2.35;
            if (par1Entity instanceof EntityPlayer && TragicConfig.allowHacked && this.field_70146_Z.nextInt(6) == 0) {
                ((EntityPlayer)par1Entity).func_70690_d(new PotionEffect(TragicPotion.Hacked.field_76415_H, 120, 0));
            }
        }
        return result;
    }

    private void attackEntitiesInList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).func_70668_bt() == TragicEntities.Synapse) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 16.0f);
            if (entity instanceof EntityPlayer && TragicConfig.allowHacked && this.field_70146_Z.nextInt(6) == 0) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(TragicPotion.Hacked.field_76415_H, 120, 0));
            }
            entity.field_70159_w *= 3.225;
            entity.field_70179_y *= 3.225;
            entity.field_70181_x += 0.225;
        }
    }

    protected void func_70623_bb() {
    }

    @Override
    public EntityPart getDefaultPart() {
        return this.aegarBody;
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("hypermode")) {
            this.setHypermode(tag.func_74767_n("hypermode"));
        }
        if (tag.func_74764_b("stunTicks")) {
            this.setStunTicks(tag.func_74762_e("stunTicks"));
        }
        if (tag.func_74764_b("shockwaveTicks")) {
            this.setShockwaveTicks(tag.func_74762_e("shockwaveTicks"));
        }
        if (tag.func_74764_b("attackTime")) {
            this.setAttackTime(tag.func_74762_e("attackTime"));
        }
        if (tag.func_74764_b("hurtTime")) {
            this.setHurtTime(tag.func_74762_e("hurtTime"));
        }
        if (tag.func_74764_b("laserTicks")) {
            this.setLaserTicks(tag.func_74762_e("laserTicks"));
        }
        if (tag.func_74764_b("mortorTicks")) {
            this.setMortorTicks(tag.func_74762_e("mortorTicks"));
        }
        if (tag.func_74764_b("autoTicks")) {
            this.setAutoTicks(tag.func_74762_e("autoTicks"));
        }
        if (tag.func_74764_b("crystalHealth")) {
            this.aegarCrystal.setHealth(tag.func_74760_g("crystalHealth"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("hypermode", this.getHypermode());
        tag.func_74768_a("stunTicks", this.getStunTicks());
        tag.func_74768_a("shockwaveTicks", this.getShockwaveTicks());
        tag.func_74768_a("attackTime", this.getAttackTime());
        tag.func_74768_a("hurtTime", this.getHurtTime());
        tag.func_74768_a("laserTicks", this.getLaserTicks());
        tag.func_74768_a("mortorTicks", this.getMortorTicks());
        tag.func_74768_a("autoTicks", this.getAutoTicks());
        tag.func_74776_a("crystalHealth", this.aegarCrystal.getHealth());
    }

    public String func_70639_aQ() {
        return TragicConfig.allowMobSounds ? (this.getHypermode() ? "tragicmc:boss.aegar.hyperwah" : "tragicmc:boss.aegar.wah") : null;
    }

    public String func_70621_aR() {
        return TragicConfig.allowMobSounds ? (this.getHypermode() ? "tragicmc:boss.aegar.harshhurt" : "tragicmc:boss.aegar.hurt") : super.func_70621_aR();
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.aegar.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 0.6f + this.field_70146_Z.nextFloat() * 0.2f;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
    }

    public int func_70627_aG() {
        return 160;
    }

    @Override
    public void func_70645_a(DamageSource par1) {
        super.func_70645_a(par1);
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (par1.func_76346_g() instanceof EntityPlayerMP && TragicConfig.allowAchievements && !this.getHypermode()) {
            ((EntityPlayerMP)par1.func_76346_g()).func_71029_a((StatBase)TragicAchievements.aegar);
        }
    }

    @Override
    public void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (flag) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.SynapseLink)));
        }
    }
}

