/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.entity.alpha;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import tragicneko.tragicmc.TragicAchievements;
import tragicneko.tragicmc.TragicBlocks;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.TragicEntities;
import tragicneko.tragicmc.TragicItems;
import tragicneko.tragicmc.TragicPotion;
import tragicneko.tragicmc.entity.boss.TragicBoss;
import tragicneko.tragicmc.entity.mob.EntityNanoSwarm;
import tragicneko.tragicmc.entity.projectile.EntityOverlordMortor;
import tragicneko.tragicmc.util.WorldHelper;

public class EntityOverlordCore
extends TragicBoss {
    public double targetX;
    public double targetY;
    public double targetZ;
    public boolean forceNewTarget;
    public boolean slowed;
    private Entity target;
    private int hoverBuffer;
    private int aggregate;
    private int courseChangeCooldown;
    public static final Set ignoredBlocks = Sets.newHashSet((Object[])new Block[]{TragicBlocks.OverlordBarrier, Blocks.field_150350_a, TragicBlocks.Luminescence, TragicBlocks.DigitalSea, TragicBlocks.Conduit, TragicBlocks.WitheringGas, TragicBlocks.CorruptedGas});
    public static final Set replaceableBlocks = Sets.newHashSet((Object[])new Block[]{Blocks.field_150350_a, TragicBlocks.Luminescence});

    public EntityOverlordCore(World par1World) {
        super(par1World);
        this.func_70105_a(4.2f, 3.8f);
        this.targetY = 50.0;
        this.field_70145_X = true;
        this.field_70158_ak = true;
        this.field_70728_aV = 100;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return TragicEntities.Synapse;
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_82150_aj() {
        return this.getTransformationTicks() > 60 ? true : super.func_82150_aj();
    }

    public void func_70050_g(int i) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(TragicConfig.overlordCoreStats[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(TragicConfig.overlordCoreStats[1]);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(TragicConfig.overlordCoreStats[2]);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(TragicConfig.overlordCoreStats[3]);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(TragicConfig.overlordCoreStats[4]);
    }

    public int func_70658_aO() {
        return (int)TragicConfig.overlordCoreStats[5];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
    }

    public int getHoverTicks() {
        return this.field_70180_af.func_75679_c(16);
    }

    private void setHoverTicks(int i) {
        this.field_70180_af.func_75692_b(16, (Object)i);
    }

    private void decrementHoverTicks() {
        this.setHoverTicks(this.getHoverTicks() - 1);
    }

    public int getVulnerableTicks() {
        return this.field_70180_af.func_75679_c(17);
    }

    private void setVulnerableTicks(int i) {
        this.field_70180_af.func_75692_b(17, (Object)i);
    }

    private void decrementVulnerableTicks() {
        this.setVulnerableTicks(this.getVulnerableTicks() - 1);
    }

    public int getHurtTicks() {
        return this.field_70180_af.func_75679_c(18);
    }

    private void setHurtTicks(int i) {
        this.field_70180_af.func_75692_b(18, (Object)i);
    }

    private void decrementHurtTicks() {
        this.setHurtTicks(this.getHurtTicks() - 1);
    }

    public boolean isNearTarget() {
        return this.field_70180_af.func_75679_c(19) == 0;
    }

    private void setNearTarget(boolean flag) {
        this.field_70180_af.func_75692_b(19, (Object)(flag ? 0 : 1));
    }

    public int getDropTicks() {
        return this.field_70180_af.func_75679_c(20);
    }

    private void setDropTicks(int i) {
        this.field_70180_af.func_75692_b(20, (Object)i);
    }

    private void decrementDropTicks() {
        this.setDropTicks(this.getDropTicks() - 1);
    }

    private void setTransformationTicks(int i) {
        this.field_70180_af.func_75692_b(21, (Object)i);
    }

    public int getTransformationTicks() {
        return this.field_70180_af.func_75679_c(21);
    }

    private void decrementTransformationTicks() {
        this.setTransformationTicks(this.getTransformationTicks() - 1);
    }

    @Override
    public void func_70636_d() {
        int z;
        int y;
        int x;
        double d3;
        this.func_70671_ap().func_75649_a();
        if (this.getTransformationTicks() > 0) {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        if (this.field_70170_p.field_72995_K) {
            double z2;
            double y2;
            double x2;
            double dr3;
            double dr2;
            double dr;
            int i;
            double d2;
            double d1;
            double d0;
            if (this.field_70716_bi > 0) {
                double d10 = this.field_70165_t + (this.field_70709_bj - this.field_70165_t) / (double)this.field_70716_bi;
                d0 = this.field_70163_u + (this.field_70710_bk - this.field_70163_u) / (double)this.field_70716_bi;
                d1 = this.field_70161_v + (this.field_110152_bk - this.field_70161_v) / (double)this.field_70716_bi;
                d2 = MathHelper.func_76138_g((double)(this.field_70712_bm - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d2 / (double)this.field_70716_bi);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.field_70705_bn - (double)this.field_70125_A) / (double)this.field_70716_bi);
                --this.field_70716_bi;
                this.func_70107_b(d10, d0, d1);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            if (this.field_70725_aQ > 0) {
                for (int i2 = 0; i2 < 16; ++i2) {
                    double dr4 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    double dr22 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    double dr32 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    double x3 = dr4 * 12.25 + this.field_70165_t;
                    double y3 = dr22 * 12.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                    double z3 = dr32 * 12.25 + this.field_70161_v;
                    this.field_70170_p.func_72869_a("reddust", x3, y3, z3, 0.0, 0.0, 0.0);
                }
                return;
            }
            int t = this.getTransformationTicks();
            if (t > 0) {
                double z4;
                double y4;
                double x4;
                double dr33;
                double dr23;
                double dr5;
                float f = 0.33f;
                float f1 = 0.88f;
                float f2 = 0.94f;
                if (t <= 60) {
                    int i3;
                    for (i3 = 0; i3 < 12; ++i3) {
                        dr5 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                        dr23 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                        dr33 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                        x4 = dr5 * 2.25 + this.field_70165_t;
                        y4 = dr23 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                        z4 = dr33 * 2.25 + this.field_70161_v;
                        this.field_70170_p.func_72869_a("reddust", x4, y4, z4, (double)f, (double)f1, (double)f2);
                    }
                    if (t >= 56) {
                        for (i3 = 0; i3 < 24; ++i3) {
                            dr5 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            dr23 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            dr33 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            x4 = dr5 * 6.25 + this.field_70165_t;
                            y4 = dr23 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                            z4 = dr33 * 6.25 + this.field_70161_v;
                            this.field_70170_p.func_72869_a("reddust", x4, y4, z4, (double)f, (double)f1, (double)f2);
                        }
                    }
                    if (t <= 10) {
                        for (i3 = 0; i3 < 24; ++i3) {
                            dr5 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            dr23 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            dr33 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            x4 = dr5 * 6.25 + this.field_70165_t;
                            y4 = dr23 * 3.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                            z4 = dr33 * 6.25 + this.field_70161_v;
                            this.field_70170_p.func_72869_a("reddust", x4, y4, z4, (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat());
                        }
                    }
                    if (t > 55) {
                        for (i3 = 0; i3 < 4; ++i3) {
                            dr5 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            dr23 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            dr33 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                            x4 = dr5 * 4.25 + this.field_70165_t;
                            y4 = dr23 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                            z4 = dr33 * 4.25 + this.field_70161_v;
                            this.field_70170_p.func_72869_a("hugeexplosion", x4, y4, z4, (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat(), (double)this.field_70146_Z.nextFloat());
                        }
                    }
                } else {
                    int i4;
                    float r = ((float)t - 60.0f) / 60.0f;
                    float r2 = 0.33f - r * 0.22f;
                    float r3 = 0.88f - r * 0.77f;
                    float r4 = 0.94f - r * 0.83f;
                    for (i4 = 0; i4 < 32; ++i4) {
                        dr5 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                        dr23 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                        dr33 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                        x4 = dr5 * 2.25 + this.field_70165_t;
                        y4 = dr23 * 2.25 + this.field_70163_u + (double)this.field_70146_Z.nextInt(6);
                        z4 = dr33 * 2.25 + this.field_70161_v;
                        this.field_70170_p.func_72869_a("reddust", x4, y4, z4, (double)r2, (double)r3, (double)r4);
                    }
                    if (t >= 80) {
                        for (i4 = 0; i4 < 32; ++i4) {
                            double d7 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                            double d8 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                            double d9 = this.field_70146_Z.nextDouble() * 10.0 - this.field_70146_Z.nextDouble() * 10.0;
                            d0 = d7 + this.field_70165_t;
                            d1 = d8 + this.field_70163_u + (double)this.field_70146_Z.nextInt(4);
                            d2 = d9 + this.field_70161_v;
                            f2 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                            double d32 = 0.5;
                            double d4 = d0 / (double)f2 * d32 * 0.100000011920929 + d7 * 0.10000000298023223;
                            double d5 = d1 / (double)f2 * d32 * 0.100000011920929 + d8 * 0.10000000298023223;
                            double d6 = d2 / (double)f2 * d32 * 0.100000011920929 + d9 * 0.10000000298023223;
                            this.field_70170_p.func_72869_a("portal", d0, d1, d2, d4 * 15.5, d5 * 15.5, d6 * 15.5);
                        }
                    }
                }
                boolean flag2 = t <= 60 && t >= 20;
                for (int i5 = 0; i5 < 16; ++i5) {
                    dr5 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr23 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    dr33 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                    x4 = dr5 * 3.25 + this.field_70165_t;
                    y4 = dr23 * 3.25 + this.field_70163_u + (double)this.field_70146_Z.nextInt(6);
                    z4 = dr33 * 3.25 + this.field_70161_v;
                    this.field_70170_p.func_72869_a("reddust", x4, y4, z4, flag2 ? 0.0 : (double)0.99f, flag2 ? 0.0 : (double)0.99f, flag2 ? 0.0 : (double)0.99f);
                }
                return;
            }
            int j = this.getHoverTicks() > 0 ? 24 : 12;
            boolean flag = this.getVulnerableTicks() > 0;
            float f = flag ? 0.0f : 0.33f;
            float f1 = flag ? 0.0f : 0.88f;
            float f2 = flag ? 0.0f : 0.94f;
            for (i = 0; i < j; ++i) {
                dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                x2 = dr * 2.25 + this.field_70165_t;
                y2 = dr2 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                z2 = dr3 * 2.25 + this.field_70161_v;
                this.field_70170_p.func_72869_a("reddust", x2, y2, z2, (double)f, (double)f1, (double)f2);
            }
            for (i = 0; i < 6 && this.getHoverTicks() == 0; ++i) {
                dr = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                dr2 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                dr3 = this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble();
                x2 = dr * 2.25 + this.field_70165_t;
                y2 = dr2 * 2.25 + this.field_70163_u + (double)this.field_70131_O / 2.0;
                z2 = dr3 * 2.25 + this.field_70161_v;
                this.field_70170_p.func_72869_a("reddust", x2 + dr3 * 2.25, y2 + dr2 * 2.25, z2 + dr * 2.25, (double)0.1f, (double)0.1f, (double)0.1f);
            }
            return;
        }
        if (this.field_70170_p.field_73013_u.func_151525_a() == 0) {
            this.func_70106_y();
        }
        if (this.field_70725_aQ > 0) {
            return;
        }
        if (this.getTransformationTicks() > 0) {
            this.decrementTransformationTicks();
            this.setHoverTicks(0);
            this.setVulnerableTicks(0);
            this.setHurtTicks(0);
            this.setNearTarget(false);
            this.setDropTicks(0);
            if (this.getTransformationTicks() == 199 && TragicConfig.allowMobSounds) {
                this.func_85030_a("tragicmc:boss.overlordcore.appearance", 1.0f, 1.0f);
            }
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 12.0, 16.0));
            for (Entity e : list) {
                this.func_70108_f(e);
            }
            return;
        }
        if (this.getVulnerableTicks() > 0 && this.target != null) {
            this.forceNewTarget = true;
        }
        if (this.getVulnerableTicks() % 20 == 0 && this.getVulnerableTicks() > 0 && TragicConfig.allowMobSounds) {
            this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcocoon.wah", 1.4f, 1.8f);
        }
        if (this.target != null) {
            this.targetX = this.target.field_70165_t;
            this.targetZ = this.target.field_70161_v;
            d3 = this.targetX - this.field_70165_t;
            double d5 = this.targetZ - this.field_70161_v;
            double d7 = Math.sqrt(d3 * d3 + d5 * d5);
            double d8 = (double)0.4f + d7 / 80.0 - 1.0;
            if (d8 > 10.0) {
                d8 = 10.0;
            }
            this.targetY = this.target.field_70121_D.field_72338_b + d8;
        } else {
            this.targetX += this.field_70146_Z.nextGaussian() * 2.0;
            this.targetZ += this.field_70146_Z.nextGaussian() * 2.0;
        }
        if (this.isNearTarget()) {
            this.setNearTarget(false);
        }
        if (this.target != null && (double)this.func_70032_d(this.target) <= 5.0) {
            this.setNearTarget(true);
            if (this.field_70146_Z.nextInt(16) == 0 && this.getHoverTicks() == 0 && this.hoverBuffer == 0 && this.getVulnerableTicks() == 0 && (double)this.func_70032_d(this.target) <= 10.0 && this.getDropTicks() == 0) {
                this.setDropTicks(120 + this.field_70146_Z.nextInt(60));
                this.func_70078_a(this.target);
            }
        }
        double d0 = this.targetX - this.field_70165_t;
        double d1 = this.targetY - this.field_70163_u;
        double d2 = this.targetZ - this.field_70161_v;
        d3 = d0 * d0 + d1 * d1 + d2 * d2;
        double d4 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        if (this.forceNewTarget || d3 < 100.0 || d3 > 22500.0 || this.field_70123_F || this.field_70124_G) {
            this.setNewTarget();
        }
        if (this.target != null) {
            float f = 8.0f;
            if (this.func_70685_l(this.target) && (double)this.func_70032_d(this.target) > d4) {
                f = 24.0f;
            }
            this.targetX = this.target.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * f);
            this.targetY = this.target.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * f);
            this.targetZ = this.target.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * f);
            if (this.getDropTicks() == 0 && this.getVulnerableTicks() == 0 && (this.field_70146_Z.nextInt(512) == 0 && this.hoverBuffer == 0 || this.aggregate >= 10 && this.hoverBuffer == 0 && this.field_70146_Z.nextInt(10) == 0 && (double)this.func_70032_d(this.target) <= d4 && this.func_70685_l(this.target))) {
                this.setHoverTicks(300 + this.field_70146_Z.nextInt(120));
            }
        } else {
            this.targetX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.targetY = (double)(this.field_70170_p.func_72940_L() / 4) + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.targetZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 3;
            d3 = MathHelper.func_76133_a((double)d3);
            double d5 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
            this.field_70159_w += d0 / d3 * d5 * 0.5;
            this.field_70181_x += d1 / d3 * d5 * 0.5;
            this.field_70179_y += d2 / d3 * d5 * 0.5;
        }
        if (this.target != null) {
            double d5 = this.target.field_70165_t - this.field_70165_t;
            double d7 = this.target.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
        }
        double m = this.field_70159_w;
        double m2 = this.field_70181_x;
        double m3 = this.field_70179_y;
        if (this.slowed) {
            m *= 0.900000011920929;
            m2 *= 0.900000011920929;
            m3 *= 0.900000011920929;
        }
        if (this.getVulnerableTicks() > 0 && !this.slowed) {
            m *= 0.455;
            m2 *= 0.455;
            m3 *= 0.455;
        }
        this.func_70091_d(m, m2, m3);
        if (this.hoverBuffer > 0) {
            --this.hoverBuffer;
        }
        if (this.getHoverTicks() > 0) {
            this.decrementHoverTicks();
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            if (this.target == null || (double)this.func_70032_d(this.target) > d4 || !this.func_70685_l(this.target)) {
                this.setHoverTicks(0);
                this.hoverBuffer = 100;
            }
            if (this.target != null && this.getHoverTicks() > 60 && this.getHoverTicks() % 10 == 0) {
                this.createMortors();
            }
            if (this.field_70173_aa % 10 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.healByFactorRanged(5.0f, 5.0f, 30.0f);
            }
            if (this.getHoverTicks() == 0) {
                this.hoverBuffer = 200;
            }
            this.aggregate = 0;
            if (this.field_70173_aa % 20 == 0 && TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcore.vulnerable", 1.8f, 1.0f);
            }
        }
        if (this.getDropTicks() > 0) {
            this.decrementDropTicks();
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.1f;
            if (this.field_70154_o != null && this.getDropTicks() > 10) {
                if (this.getDropTicks() % 10 == 0) {
                    this.field_70154_o.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)TragicConfig.overlordCoreStats[2] / 2.0f);
                    this.func_70691_i(1.0f);
                }
                this.field_70154_o.field_70181_x = 0.2;
                this.field_70154_o.field_70133_I = true;
                this.field_70154_o.field_70143_R = 0.0f;
            }
            if (this.getDropTicks() <= 10) {
                this.func_70078_a(null);
            }
            if (this.getDropTicks() > 80 && this.field_70154_o == null) {
                this.func_70078_a(null);
                this.setDropTicks(0);
                ++this.aggregate;
            }
            if (this.getDropTicks() == 0) {
                this.hoverBuffer = 200;
            }
        } else if (this.field_70154_o != null) {
            this.func_70078_a(null);
        }
        if (this.getVulnerableTicks() > 0) {
            this.decrementVulnerableTicks();
            if (this.getVulnerableTicks() % 10 == 0 && TragicConfig.allowMobSounds) {
                this.field_70170_p.func_72956_a((Entity)this, "tragicmc:boss.overlordcocoon.wah", 1.4f, 1.5f);
            }
        }
        if (this.getHurtTicks() > 0) {
            this.decrementHurtTicks();
        }
        if (this.getHurtTicks() == 0 && this.getHoverTicks() == 0 && this.getDropTicks() == 0 && this.getTransformationTicks() == 0 && this.hoverBuffer >= 100) {
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0)));
        }
        this.slowed = this.destroyBlocksInAABB(this.field_70121_D);
        if (this.func_110143_aJ() <= this.func_110138_aP() / 4.0f && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextBoolean() && this.field_70170_p.func_72872_a(EntityNanoSwarm.class, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0)).size() < 16) {
            EntityNanoSwarm swarm = new EntityNanoSwarm(this.field_70170_p);
            swarm.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)swarm);
        }
        if (this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && this.field_70173_aa % 10 == 0 && this.field_70146_Z.nextInt(16) == 0 && this.getVulnerableTicks() > 0) {
            this.createMortors();
        }
        if (replaceableBlocks.contains(this.field_70170_p.func_147439_a(x = (int)(this.field_70165_t + (double)this.field_70146_Z.nextInt(2) - (double)this.field_70146_Z.nextInt(2)), y = (int)(this.field_70163_u + (double)this.field_70146_Z.nextInt(2) - (double)this.field_70146_Z.nextInt(2)), z = (int)(this.field_70161_v + (double)this.field_70146_Z.nextInt(2) - (double)this.field_70146_Z.nextInt(2))))) {
            this.field_70170_p.func_147449_b(x, y, z, TragicBlocks.Luminescence);
        }
        this.field_70159_w *= 0.98;
        this.field_70181_x *= 0.98;
        this.field_70179_y *= 0.98;
        if (TragicConfig.allowMobSounds && this.field_70173_aa % 20 == 0) {
            this.func_85030_a("tragicmc:boss.overlordcore.heartbeat", 0.3f, 1.0f);
        }
    }

    private boolean destroyBlocksInAABB(AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76128_c((double)bb.field_72338_b);
        int k = MathHelper.func_76128_c((double)bb.field_72339_c);
        int l = MathHelper.func_76128_c((double)bb.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)bb.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)bb.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = this.field_70170_p.func_147439_a(k1, l1, i2);
                    float f = block.func_149712_f(this.field_70170_p, k1, l1, i2);
                    if (!block.func_149688_o().func_76230_c()) continue;
                    if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing") && !ignoredBlocks.contains(block) && f > 0.0f && f < 16.0f) {
                        flag1 = this.field_70170_p.func_147468_f(k1, l1, i2) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    private void attackEntitiesInList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            if (!(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).func_70668_bt() == TragicEntities.Synapse || entity.equals((Object)this.field_70154_o)) continue;
            entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.getVulnerableTicks() > 0 ? (float)MathHelper.func_76123_f((float)(f / 2.0f)) : f);
        }
    }

    private void setNewTarget() {
        double d0;
        boolean retry;
        this.forceNewTarget = false;
        boolean bl = retry = !this.field_70170_p.field_73010_i.isEmpty() && this.getVulnerableTicks() == 0;
        if (retry) {
            Entity ent = (Entity)this.field_70170_p.field_73010_i.get(this.field_70146_Z.nextInt(this.field_70170_p.field_73010_i.size()));
            if (ent instanceof EntityPlayer && !((EntityPlayer)ent).field_71075_bZ.field_75098_d) {
                this.target = ent;
                retry = false;
            }
            if (retry) {
                d0 = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(d0, d0, d0));
                for (Entity e : list) {
                    if (!(e instanceof EntityLivingBase) || ((EntityLivingBase)e).func_70668_bt() == TragicEntities.Synapse || e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) continue;
                    this.target = e;
                    retry = false;
                    break;
                }
            }
        }
        if (retry) {
            double d2;
            double d1;
            boolean flag = false;
            do {
                this.targetX = 0.0;
                this.targetY = 50.0f + this.field_70146_Z.nextFloat() * 50.0f;
                this.targetZ = 0.0;
                this.targetX += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
                this.targetZ += (double)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f);
            } while (!(flag = (d0 = this.field_70165_t - this.targetX) * d0 + (d1 = this.field_70163_u - this.targetY) * d1 + (d2 = this.field_70161_v - this.targetZ) * d2 > 100.0));
            this.target = null;
        }
    }

    private void createMortors() {
        if (this.target == null || this.func_110143_aJ() <= 0.0f) {
            return;
        }
        double d0 = this.target.field_70165_t - this.field_70165_t;
        double d1 = this.field_70146_Z.nextInt(4);
        double d2 = this.target.field_70161_v - this.field_70161_v;
        float f1 = MathHelper.func_76129_c((float)this.func_70032_d(this.target)) * 0.975f;
        EntityOverlordMortor mortor = new EntityOverlordMortor(this.field_70170_p, (EntityLivingBase)this, d0 + this.field_70146_Z.nextGaussian() * (double)f1, d1, d2 + this.field_70146_Z.nextGaussian() * (double)f1);
        mortor.field_70163_u += this.field_70146_Z.nextDouble() * (double)this.field_70131_O + d1 * 0.04335;
        mortor.field_70165_t += d0 * 0.04335;
        mortor.field_70161_v += d2 * 0.04335;
        mortor.field_70181_x += (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat());
        mortor.field_70159_w += (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat());
        mortor.field_70179_y += (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat());
        this.field_70170_p.func_72838_d((Entity)mortor);
    }

    protected void func_70623_bb() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70069_a(float f) {
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("targetX")) {
            this.targetX = tag.func_74769_h("targetX");
        }
        if (tag.func_74764_b("targetY")) {
            this.targetY = tag.func_74769_h("targetY");
        }
        if (tag.func_74764_b("targetZ")) {
            this.targetZ = tag.func_74769_h("targetZ");
        }
        if (tag.func_74764_b("hoverTicks")) {
            this.setHoverTicks(tag.func_74762_e("hoverTicks"));
        }
        if (tag.func_74764_b("hoverBuffer")) {
            this.hoverBuffer = tag.func_74762_e("hoverBuffer");
        }
        if (tag.func_74764_b("aggregate")) {
            this.aggregate = tag.func_74762_e("aggregate");
        }
        if (tag.func_74764_b("hurtTicks")) {
            this.setHurtTicks(tag.func_74762_e("hurtTicks"));
        }
        if (tag.func_74764_b("vulnerableTicks")) {
            this.setVulnerableTicks(tag.func_74762_e("vulnerableTicks"));
        }
        if (tag.func_74764_b("dropTicks")) {
            this.setDropTicks(tag.func_74762_e("dropTicks"));
        }
        if (tag.func_74764_b("transformationTicks")) {
            this.setTransformationTicks(tag.func_74762_e("transformationTicks"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74780_a("targetX", this.targetX);
        tag.func_74780_a("targetY", this.targetY);
        tag.func_74780_a("targetZ", this.targetZ);
        tag.func_74768_a("hoverTicks", this.getHoverTicks());
        tag.func_74768_a("hoverBuffer", this.hoverBuffer);
        tag.func_74768_a("aggregate", this.aggregate);
        tag.func_74768_a("hurtTicks", this.getHurtTicks());
        tag.func_74768_a("vulnerableTicks", this.getVulnerableTicks());
        tag.func_74768_a("dropTicks", this.getDropTicks());
        tag.func_74768_a("transformationTicks", this.getTransformationTicks());
    }

    @Override
    public boolean func_70097_a(DamageSource src, float dmg) {
        if (this.getTransformationTicks() > 0) {
            return false;
        }
        if (src.func_76346_g() instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            boolean flag;
            EntityLivingBase entity = (EntityLivingBase)src.func_76346_g();
            boolean bl = flag = TragicConfig.allowDivinity && entity.func_70644_a(TragicPotion.Divinity);
            if (flag || !TragicConfig.allowDivinity && entity.func_70668_bt() != TragicEntities.Synapse || this.getVulnerableTicks() > 0 && entity.func_70668_bt() != TragicEntities.Synapse || entity.func_70694_bm() != null && entity.func_70694_bm().func_77973_b() == TragicItems.SwordOfJustice || src.func_76357_e()) {
                if (this.field_70146_Z.nextBoolean() && this.field_70170_p.func_72872_a(EntityNanoSwarm.class, this.field_70121_D.func_72314_b(64.0, 64.0, 64.0)).size() < 16) {
                    EntityNanoSwarm swarm = new EntityNanoSwarm(this.field_70170_p);
                    swarm.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.field_70170_p.func_72838_d((Entity)swarm);
                }
                if (this.getHoverTicks() > 0) {
                    this.setHoverTicks(0);
                    this.forceNewTarget = true;
                    this.hoverBuffer = 100;
                }
                if (this.getDropTicks() > 0) {
                    this.setDropTicks(0);
                    this.forceNewTarget = true;
                    this.hoverBuffer = 100;
                }
                if (flag && this.getVulnerableTicks() == 0) {
                    this.setVulnerableTicks(120 + this.field_70146_Z.nextInt(40));
                    if (TragicConfig.allowMobSounds) {
                        this.func_85030_a("tragicmc:boss.overlordcore.expose", 1.0f, 1.0f);
                    }
                }
                if (this.getHurtTicks() == 0) {
                    this.setHurtTicks(40);
                }
                if (this.field_70154_o != null) {
                    this.func_70078_a(null);
                }
                return super.func_70097_a(src, dmg);
            }
            if (TragicConfig.allowMobSounds) {
                this.func_85030_a("tragicmc:boss.overlordcore.negate", 1.0f, 1.0f);
            }
            ++this.aggregate;
            if (this.aggregate >= 10) {
                this.forceNewTarget = true;
                if (this.getDropTicks() > 0) {
                    this.setDropTicks(0);
                }
            }
            if (this.field_70146_Z.nextInt(4) == 0 && this.target != entity && entity.func_70668_bt() != TragicEntities.Synapse) {
                this.target = entity;
            }
        }
        return true;
    }

    @Override
    public void func_70645_a(DamageSource par1DamageSource) {
        ArrayList<int[]> list;
        if (!this.field_70170_p.field_72995_K) {
            list = WorldHelper.getBlocksInCircularRange(this.field_70170_p, 2.5, (double)((int)this.field_70165_t) + 0.5, (double)((int)this.field_70163_u) - 0.5, (double)((int)this.field_70161_v) + 0.5);
            for (int[] nArray : list) {
                if (!replaceableBlocks.contains(this.field_70170_p.func_147439_a(nArray[0], nArray[1], nArray[2]))) continue;
                this.field_70170_p.func_147465_d(nArray[0], nArray[1], nArray[2], !TragicConfig.allowNonMobBlocks ? Blocks.field_150343_Z : TragicBlocks.CelledBlock, 0, 2);
            }
        }
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityPlayerMP) {
            ((EntityPlayerMP)par1DamageSource.func_76346_g()).func_71029_a((StatBase)TragicAchievements.overlord4);
        }
        if (!(list = this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.field_70121_D.func_72314_b(24.0, 24.0, 24.0))).isEmpty()) {
            for (EntityPlayerMP entityPlayerMP : list) {
                entityPlayerMP.func_71029_a((StatBase)TragicAchievements.overlord4);
            }
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int l) {
        super.func_70628_a(flag, l);
        if (!this.field_70170_p.field_72995_K && TragicConfig.allowMobStatueDrops && this.field_70146_Z.nextInt(100) <= TragicConfig.mobStatueDropChance) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.MobStatue, 1, 17)));
        }
        if (!this.field_70170_p.field_72995_K && this.getAllowLoot()) {
            this.capturedDrops.add(new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(TragicItems.Sentinel)));
        }
    }

    public void setStartTransform() {
        this.setTransformationTicks(200);
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        this.setStartTransform();
        return super.func_110161_a(data);
    }

    public void func_70690_d(PotionEffect pe) {
    }

    protected void func_70609_aI() {
        int ji;
        ++this.field_70725_aQ;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
        for (Entity e : list) {
            if (!(e instanceof EntityLivingBase) || ((EntityLivingBase)e).func_70668_bt() != TragicEntities.Synapse) continue;
            e.func_70106_y();
        }
        if (this.field_70725_aQ >= 300) {
            if (!this.field_70170_p.field_72995_K && (this.field_70718_bc > 0 || this.func_70684_aJ()) && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                int j;
                for (int i = this.func_70693_a(this.field_70717_bb); i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            this.func_70106_y();
            for (int ji2 = 0; ji2 < 20; ++ji2) {
                this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.1, 0.1, 0.1);
            }
            for (int j = 0; j < 120; ++j) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 3.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 3.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0);
            }
        }
        for (int j = 0; j < 40; ++j) {
            this.field_70170_p.func_72869_a("reddust", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 5.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 5.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
        for (ji = 0; ji < 40; ++ji) {
            this.field_70170_p.func_72869_a("reddust", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 5.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 5.0f) - (double)this.field_70130_N, 0.1, 0.1, 0.1);
        }
        if (this.field_70725_aQ % 5 == 0) {
            for (ji = 0; ji < 20; ++ji) {
                this.field_70170_p.func_72869_a("largeexplode", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O * 2.0f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.1, 0.1, 0.1);
            }
        }
    }

    public int getDistanceToGround() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int i = 0;
        while (y - i > 0) {
            if (this.field_70170_p.func_147439_a(x, y - i, z).func_149688_o().func_76230_c()) {
                return i;
            }
            ++i;
        }
        return y;
    }

    public String func_70639_aQ() {
        return this.getTransformationTicks() > 0 ? null : (this.getVulnerableTicks() > 0 ? null : "tragicmc:boss.overlordcore.living");
    }

    public String func_70621_aR() {
        return this.getTransformationTicks() > 0 || this.getVulnerableTicks() == 0 ? null : "tragicmc:boss.overlordcore.hit";
    }

    public String func_70673_aS() {
        return TragicConfig.allowMobSounds ? "tragicmc:boss.overlordcore.death" : null;
    }

    public float func_70647_i() {
        return 1.0f;
    }

    public float func_70599_aP() {
        return 1.8f;
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
    }

    public int func_70627_aG() {
        return super.func_70627_aG();
    }
}

