/*
 * Decompiled with CFR 0.152.
 */
package tragicneko.tragicmc.doomsday;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import tragicneko.tragicmc.TragicConfig;
import tragicneko.tragicmc.doomsday.Doomsday;
import tragicneko.tragicmc.doomsday.DoomsdayEffect;
import tragicneko.tragicmc.properties.PropertyDoom;
import tragicneko.tragicmc.util.WorldHelper;

public class DoomsdayNatureDrain
extends Doomsday
implements Doomsday.IExtendedDoomsday {
    public DoomsdayNatureDrain(int id) {
        super(id, Doomsday.EnumDoomType.WORLDSHAPER);
    }

    @Override
    public void doInitialEffects(DoomsdayEffect effect, PropertyDoom doom, EntityPlayer player, boolean crucMoment) {
        super.doInitialEffects(effect, doom, player, crucMoment);
        double radius = crucMoment ? 10.0 : 5.0;
        ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(player.field_70170_p, radius, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        boolean griefCheck = TragicConfig.griefConfig[0];
        float plantCount = 0.0f;
        for (int i = 0; i < list.size(); ++i) {
            int[] coords = (int[])list.get(i);
            Block block = player.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]);
            if (block instanceof BlockReed || block instanceof BlockSapling || block instanceof BlockFlower || block instanceof BlockDoublePlant || block instanceof BlockMushroom || block instanceof BlockCrops || block instanceof BlockStem || block instanceof BlockLeaves || block instanceof BlockTallGrass) {
                if (griefCheck) {
                    if (block instanceof BlockLeaves) {
                        player.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150351_n);
                    } else {
                        player.field_70170_p.func_147468_f(coords[0], coords[1], coords[2]);
                    }
                }
                plantCount = (float)((double)plantCount + 0.2);
            } else if (block instanceof BlockGrass) {
                if (griefCheck) {
                    player.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150346_d);
                }
                plantCount = (float)((double)plantCount + 0.1);
            }
            if (!(block instanceof BlockFarmland)) continue;
            if (griefCheck) {
                player.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150346_d);
            }
            plantCount = (float)((double)plantCount + 0.15);
        }
        if (crucMoment) {
            plantCount *= 1.5f;
        }
        if (plantCount > 40.0f) {
            plantCount = 40.0f;
        }
        effect.utilityInt = MathHelper.func_76143_f((double)plantCount);
    }

    @Override
    public void useDoomsday(DoomsdayEffect effect, PropertyDoom doom, EntityPlayer player, boolean crucMoment) {
        if (effect.utilityInt > 0) {
            float i = (float)rand.nextInt(effect.utilityInt / 2 + 1) + 0.5f;
            if (crucMoment) {
                i = (float)((double)i * 1.5);
                DoomsdayNatureDrain.addCrucialMessage(player);
            }
            if (i > (float)effect.utilityInt) {
                i = effect.utilityInt;
            }
            effect.utilityInt = (int)((float)effect.utilityInt - i);
            player.func_70691_i(i);
            player.field_70170_p.func_72956_a((Entity)player, "mob.blaze.breath", 0.4f, 1.6f);
        } else {
            double radius = crucMoment ? 10.0 : 5.0;
            ArrayList<int[]> list = WorldHelper.getBlocksInSphericalRange(player.field_70170_p, radius, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            boolean griefCheck = TragicConfig.griefConfig[0];
            float plantCount = 0.0f;
            for (int i = 0; i < list.size(); ++i) {
                int[] coords = (int[])list.get(i);
                Block block = player.field_70170_p.func_147439_a(coords[0], coords[1], coords[2]);
                if (block instanceof BlockReed || block instanceof BlockSapling || block instanceof BlockFlower || block instanceof BlockDoublePlant || block instanceof BlockMushroom || block instanceof BlockCrops || block instanceof BlockStem || block instanceof BlockLeaves || block instanceof BlockTallGrass) {
                    if (griefCheck) {
                        if (block instanceof BlockLeaves) {
                            player.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150351_n);
                        } else {
                            player.field_70170_p.func_147468_f(coords[0], coords[1], coords[2]);
                        }
                    }
                    plantCount = (float)((double)plantCount + 0.2);
                } else if (block instanceof BlockGrass) {
                    if (griefCheck) {
                        player.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150346_d);
                    }
                    plantCount = (float)((double)plantCount + 0.1);
                }
                if (!(block instanceof BlockFarmland)) continue;
                if (griefCheck) {
                    player.field_70170_p.func_147449_b(coords[0], coords[1], coords[2], Blocks.field_150346_d);
                }
                plantCount = (float)((double)plantCount + 0.15);
            }
            if (crucMoment) {
                plantCount *= 1.5f;
            }
            if (plantCount > 40.0f) {
                plantCount = 40.0f;
            }
            effect.utilityInt = MathHelper.func_76143_f((double)plantCount);
            if (plantCount == 0.0f) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "No plantlife in range to drain!"));
            }
        }
    }

    @Override
    public void doBacklashEffect(PropertyDoom doom, EntityPlayer player) {
        float f = rand.nextFloat() * 10.0f;
        player.func_71020_j(f);
    }

    @Override
    public Doomsday getCombination() {
        return Doomsday.RealityAlter;
    }

    @Override
    public int getWaitTime() {
        return 20;
    }

    @Override
    public int getMaxIterations() {
        return 30;
    }
}

